/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.system;

import happy.coding.io.Logs;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.imageio.ImageIO;

public class Systems {
    private static String desktopPath = null;
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String USER_NAME = System.getProperty("user.name");
    public static final String USER_DIRECTORY = System.getProperty("user.home");
    public static final String WORKING_DIRECTORY = System.getProperty("user.dir");
    public static final String OPERATING_SYSTEM = System.getProperty("os.name");
    private static OS os = null;

    public static String getDesktop() {
        if (desktopPath == null) {
            desktopPath = String.valueOf(USER_DIRECTORY) + FILE_SEPARATOR + "Desktop" + FILE_SEPARATOR;
        }
        return desktopPath;
    }

    public static String getIP() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return String.valueOf(ip.getHostName()) + "@" + ip.getHostAddress();
    }

    public static OS getOs() {
        if (os == null) {
            OS[] oSArray = OS.values();
            int n = oSArray.length;
            int n2 = 0;
            while (n2 < n) {
                OS m = oSArray[n2];
                if (OPERATING_SYSTEM.toLowerCase().contains(m.name().toLowerCase())) {
                    os = m;
                    break;
                }
                ++n2;
            }
        }
        return os;
    }

    public static void pause() {
        try {
            Logs.debug("System paused, press [enter] to continue ...");
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void captureScreen() throws Exception {
        Systems.captureScreen("screenshot.png");
    }

    public static void captureScreen(String fileName) throws Exception {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenRectangle = new Rectangle(screenSize);
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(screenRectangle);
        File file = new File(fileName);
        ImageIO.write((RenderedImage)image, "png", file);
        Logs.debug("A screenshot is captured to: {}", (Object)file.getPath());
    }

    public static enum OS {
        Windows,
        Linux,
        Mac;

    }
}

