/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.math;

import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.math.Randoms;
import happy.coding.math.Sortee;
import happy.coding.system.Separator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class Sortor {
    public static <T> void insertion(List<? extends Comparable<T>> data) {
        int N = data.size();
        int i = 1;
        while (i < N) {
            int j = i;
            while (j >= 1) {
                if (data.get(j).compareTo(data.get(j - 1)) >= 0) break;
                Sortor.swap(data, j - 1, j);
                --j;
            }
            ++i;
        }
    }

    public static <T> void selection(List<? extends Comparable<T>> data) {
        int N = data.size();
        int i = 0;
        while (i < N - 1) {
            Comparable<Comparable<T>> min = data.get(i);
            int index = i;
            int j = i + 1;
            while (j < N) {
                if (min.compareTo(data.get(j)) > 0) {
                    min = data.get(j);
                    index = j;
                }
                ++j;
            }
            if (index > i) {
                Sortor.swap(data, i, index);
            }
            ++i;
        }
    }

    public static <T> void bubble(List<? extends Comparable<T>> data) {
        boolean swap;
        int N = data.size();
        int count = 0;
        do {
            int i = 0;
            swap = false;
            Comparable<Comparable<T>> t0 = data.get(i);
            int j = 1;
            while (j < N - count) {
                Comparable<T> t1 = data.get(j);
                if (t0.compareTo(t1) > 0) {
                    Sortor.swap(data, i, j);
                    swap = true;
                }
                i = j++;
                t0 = data.get(i);
            }
            ++count;
        } while (swap);
    }

    public static <T> void shell(List<? extends Comparable<T>> d) {
        List<Comparable<T>> data = d;
        int N = data.size();
        int[] gaps = new int[]{701, 301, 132, 57, 23, 10, 4, 1};
        int k = 0;
        while (k < gaps.length) {
            int i = gaps[k];
            while (i < N) {
                Comparable<T> temp = data.get(i);
                int j = 0;
                j = i;
                while (j >= gaps[k] && data.get(j - gaps[k]).compareTo(temp) > 0) {
                    data.set(j, data.get(j - gaps[k]));
                    j -= gaps[k];
                }
                data.set(j, temp);
                ++i;
            }
            ++k;
        }
    }

    public static <T> void comb(List<? extends Comparable<T>> d) {
        int gap;
        int N = d.size();
        double factor = 1.24733;
        while ((gap = (int)((double)N / factor)) >= 1) {
            factor *= factor;
            int i = 0;
            while (i + gap < N) {
                Comparable<T> t1;
                Comparable<Comparable<T>> t0 = d.get(i);
                if (t0.compareTo(t1 = d.get(i + gap)) > 0) {
                    Sortor.swap(d, i, i + gap);
                }
                ++i;
            }
        }
    }

    public static <T> List<? extends Comparable<T>> merge(List<? extends Comparable<T>> d) {
        int N = d.size();
        if (N <= 1) {
            return d;
        }
        List<Object> left = new ArrayList();
        List<Comparable<T>> right = new ArrayList<Comparable<T>>();
        int mid = N / 2;
        int i = 0;
        while (i < N) {
            if (i < mid) {
                left.add(d.get(i));
            } else {
                right.add(d.get(i));
            }
            ++i;
        }
        left = Sortor.merge(left);
        right = Sortor.merge(right);
        return Sortor.combine(left, right);
    }

    private static <T> List<? extends Comparable<T>> combine(List<? extends Comparable<T>> left, List<? extends Comparable<T>> right) {
        ArrayList<Comparable<T>> result = new ArrayList<Comparable<T>>();
        while (left.size() > 0 || right.size() > 0) {
            if (left.size() > 0 && right.size() > 0) {
                if (left.get(0).compareTo(right.get(0)) < 0) {
                    result.add(left.get(0));
                    left.remove(0);
                    continue;
                }
                result.add(right.get(0));
                right.remove(0);
                continue;
            }
            if (left.size() > 0) {
                result.add(left.get(0));
                left.remove(0);
                continue;
            }
            if (right.size() <= 0) continue;
            result.add(right.get(0));
            right.remove(0);
        }
        return result;
    }

    public static <T> void quick(List<? extends Comparable<T>> d) {
    }

    public static <T> void swap(List<Comparable<T>> data, int i, int j) {
        Comparable<T> swap = data.get(i);
        data.set(i, data.get(j));
        data.set(j, swap);
    }

    public static void kLargest(double[] array1, int[] array2, int first, int last, int k) {
        int firstIndex = first;
        int lastIndex = last;
        while (lastIndex > k * 10) {
            int pivotIndex = Sortor.partition(array1, array2, firstIndex, lastIndex, false);
            if (pivotIndex < k) {
                firstIndex = pivotIndex + 1;
                continue;
            }
            if (pivotIndex < k * 10) {
                lastIndex = pivotIndex;
                break;
            }
            lastIndex = pivotIndex;
        }
        Sortor.quickSort(array1, array2, first, lastIndex, false);
    }

    public static void kSmallest(double[] array1, int[] array2, int first, int last, int k) {
        int firstIndex = first;
        int lastIndex = last;
        while (lastIndex > k * 10) {
            int pivotIndex = Sortor.partition(array1, array2, firstIndex, lastIndex, true);
            if (pivotIndex < k) {
                firstIndex = pivotIndex + 1;
                continue;
            }
            if (pivotIndex < k * 10) {
                lastIndex = pivotIndex;
                break;
            }
            lastIndex = pivotIndex;
        }
        Sortor.quickSort(array1, array2, first, lastIndex, true);
    }

    public static void quickSort(int[] array, int first, int last, boolean increasingOrder) {
        if (first < last) {
            int pivotIndex = Sortor.partition(array, first, last, increasingOrder);
            Sortor.quickSort(array, first, pivotIndex - 1, increasingOrder);
            Sortor.quickSort(array, pivotIndex + 1, last, increasingOrder);
        }
    }

    public static void quickSort(double[] array1, int[] array2, int first, int last, boolean increasingOrder) {
        if (first < last) {
            int pivotIndex = Sortor.partition(array1, array2, first, last, increasingOrder);
            Sortor.quickSort(array1, array2, first, pivotIndex - 1, increasingOrder);
            Sortor.quickSort(array1, array2, pivotIndex + 1, last, increasingOrder);
        }
    }

    public static void quickSort(int[] array1, int[] array2, int first, int last, boolean increasingOrder) {
        if (first < last) {
            int pivotIndex = Sortor.partition(array1, array2, first, last, increasingOrder);
            Sortor.quickSort(array1, array2, first, pivotIndex - 1, increasingOrder);
            Sortor.quickSort(array1, array2, pivotIndex + 1, last, increasingOrder);
        }
    }

    public static void quickSort(int[] array1, double[] array2, int first, int last, boolean increasingOrder) {
        if (first < last) {
            int pivotIndex = Sortor.partition(array1, array2, first, last, increasingOrder);
            Sortor.quickSort(array1, array2, first, pivotIndex - 1, increasingOrder);
            Sortor.quickSort(array1, array2, pivotIndex + 1, last, increasingOrder);
        }
    }

    private static int partition(int[] array, int first, int last, boolean increasingOrder) {
        int tmpInt;
        int pivot = array[first];
        int lastS1 = first;
        int firstUnknown = first + 1;
        while (firstUnknown <= last) {
            if (increasingOrder) {
                if (array[firstUnknown] < pivot) {
                    tmpInt = array[firstUnknown];
                    array[firstUnknown] = array[++lastS1];
                    array[lastS1] = tmpInt;
                }
            } else if (array[firstUnknown] > pivot) {
                tmpInt = array[firstUnknown];
                array[firstUnknown] = array[++lastS1];
                array[lastS1] = tmpInt;
            }
            ++firstUnknown;
        }
        tmpInt = array[first];
        array[first] = array[lastS1];
        array[lastS1] = tmpInt;
        return lastS1;
    }

    private static int partition(double[] array1, int[] array2, int first, int last, boolean increasingOrder) {
        int tmpInt;
        double tmpDouble;
        double pivot = array1[first];
        int lastS1 = first;
        int firstUnknown = first + 1;
        while (firstUnknown <= last) {
            if (increasingOrder) {
                if (array1[firstUnknown] < pivot) {
                    tmpDouble = array1[firstUnknown];
                    array1[firstUnknown] = array1[++lastS1];
                    array1[lastS1] = tmpDouble;
                    tmpInt = array2[firstUnknown];
                    array2[firstUnknown] = array2[lastS1];
                    array2[lastS1] = tmpInt;
                }
            } else if (array1[firstUnknown] > pivot) {
                tmpDouble = array1[firstUnknown];
                array1[firstUnknown] = array1[++lastS1];
                array1[lastS1] = tmpDouble;
                tmpInt = array2[firstUnknown];
                array2[firstUnknown] = array2[lastS1];
                array2[lastS1] = tmpInt;
            }
            ++firstUnknown;
        }
        tmpDouble = array1[first];
        array1[first] = array1[lastS1];
        array1[lastS1] = tmpDouble;
        tmpInt = array2[first];
        array2[first] = array2[lastS1];
        array2[lastS1] = tmpInt;
        return lastS1;
    }

    private static int partition(int[] array1, int[] array2, int first, int last, boolean increasingOrder) {
        int tmpInt;
        int tmp1;
        int pivot = array1[first];
        int lastS1 = first;
        int firstUnknown = first + 1;
        while (firstUnknown <= last) {
            if (increasingOrder) {
                if (array1[firstUnknown] < pivot) {
                    tmp1 = array1[firstUnknown];
                    array1[firstUnknown] = array1[++lastS1];
                    array1[lastS1] = tmp1;
                    tmpInt = array2[firstUnknown];
                    array2[firstUnknown] = array2[lastS1];
                    array2[lastS1] = tmpInt;
                }
            } else if (array1[firstUnknown] > pivot) {
                tmp1 = array1[firstUnknown];
                array1[firstUnknown] = array1[++lastS1];
                array1[lastS1] = tmp1;
                tmpInt = array2[firstUnknown];
                array2[firstUnknown] = array2[lastS1];
                array2[lastS1] = tmpInt;
            }
            ++firstUnknown;
        }
        tmp1 = array1[first];
        array1[first] = array1[lastS1];
        array1[lastS1] = tmp1;
        tmpInt = array2[first];
        array2[first] = array2[lastS1];
        array2[lastS1] = tmpInt;
        return lastS1;
    }

    private static int partition(int[] array1, double[] array2, int first, int last, boolean increasingOrder) {
        double tmp2;
        int tmp1;
        int pivot = array1[first];
        int lastS1 = first;
        int firstUnknown = first + 1;
        while (firstUnknown <= last) {
            if (increasingOrder) {
                if (array1[firstUnknown] < pivot) {
                    tmp1 = array1[firstUnknown];
                    array1[firstUnknown] = array1[++lastS1];
                    array1[lastS1] = tmp1;
                    tmp2 = array2[firstUnknown];
                    array2[firstUnknown] = array2[lastS1];
                    array2[lastS1] = tmp2;
                }
            } else if (array1[firstUnknown] > pivot) {
                tmp1 = array1[firstUnknown];
                array1[firstUnknown] = array1[++lastS1];
                array1[lastS1] = tmp1;
                tmp2 = array2[firstUnknown];
                array2[firstUnknown] = array2[lastS1];
                array2[lastS1] = tmp2;
            }
            ++firstUnknown;
        }
        tmp1 = array1[first];
        array1[first] = array1[lastS1];
        array1[lastS1] = tmp1;
        tmp2 = array2[first];
        array2[first] = array2[lastS1];
        array2[lastS1] = tmp2;
        return lastS1;
    }

    @Test
    public void example() {
        ArrayList<Sortee> data = new ArrayList<Sortee>();
        int N = 10;
        int i = 0;
        while (i < N) {
            data.add(new Sortee(Randoms.random()));
            ++i;
        }
        Strings.setSeparator(Separator.comma);
        Logs.debug("Before   : " + Strings.toString(data));
        List<Comparable<Sortee>> raw = this.prepareData(data);
        Sortor.insertion(raw);
        Logs.debug("Insertion: " + Strings.toString(raw));
        raw = this.prepareData(data);
        Sortor.selection(raw);
        Logs.debug("Selection: " + Strings.toString(raw));
        raw = this.prepareData(data);
        Sortor.bubble(raw);
        Logs.debug("Bubble   : " + Strings.toString(raw));
        raw = this.prepareData(data);
        Sortor.shell(raw);
        Logs.debug("Shell    : " + Strings.toString(raw));
        raw = this.prepareData(data);
        Sortor.comb(raw);
        Logs.debug("Comb     : " + Strings.toString(raw));
        raw = this.prepareData(data);
        raw = Sortor.merge(raw);
        Logs.debug("Merge    : " + Strings.toString(raw));
    }

    private List<Sortee> prepareData(List<Sortee> data) {
        ArrayList<Sortee> raw = new ArrayList<Sortee>();
        raw.addAll(data);
        return raw;
    }
}

