/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.math;

import happy.coding.io.Logs;
import org.junit.Test;

public class Maths {
    public static final double golden_ratio = 0.5 * (Math.sqrt(5.0) + 1.0);
    public static final double zero = 1.0E-6;

    public static boolean isEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public static boolean isNumber(String string) {
        return string.matches("^\\d+$");
    }

    public static boolean isNumeric(String string) {
        return string.matches("^[-+]?\\d+(\\.\\d+)?$");
    }

    public static boolean isNumberWith2Decimals(String string) {
        return string.matches("^\\d+\\.\\d{2}$");
    }

    public static boolean isInt(double data) {
        return Maths.isEqual(data, Math.floor(data)) && !Double.isInfinite(data);
    }

    public static int factorial(int n) {
        if (n < 0) {
            return 0;
        }
        if (n == 0 || n == 1) {
            return 1;
        }
        return n * Maths.factorial(n - 1);
    }

    public static double ln(double n) {
        return Math.log(n);
    }

    public static double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public static double logSum(double log_a, double log_b) {
        double v = log_a < log_b ? log_b + Math.log(1.0 + Math.exp(log_a - log_b)) : log_a + Math.log(1.0 + Math.exp(log_b - log_a));
        return v;
    }

    public static double logistic(double x) {
        return Maths.g(x);
    }

    public static double g(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static double gd(double x) {
        return Maths.g(x) * Maths.g(-x);
    }

    public static double normalize(double x, double min, double max) {
        if (max > min) {
            return (x - min) / (max - min);
        }
        if (Maths.isEqual(min, max)) {
            return x / max;
        }
        return x;
    }

    public static int fabonacci(int n) {
        assert (n > 0);
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        return Maths.fabonacci(n - 1) + Maths.fabonacci(n - 2);
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return Maths.gcd(b, a % b);
    }

    public static int lcm(int a, int b) {
        if (a > 0 && b > 0) {
            return (int)((0.0 + (double)(a * b)) / (double)Maths.gcd(a, b));
        }
        return 0;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (!Maths.isEqual(b, 0.0)) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    @Test
    public void e_numbers() {
        Logs.debug("Golden ratio = " + golden_ratio);
        Logs.debug("gcd(54, 24) = " + Maths.gcd(24, 54) + ", expected = 6");
        Logs.debug("lcm(4, 6) = " + Maths.lcm(4, 6) + ", expected = 12");
        Logs.debug("lcm(21, 6) = " + Maths.lcm(21, 6) + ", expected = 42");
        String line = "Fabonacci sequence: ";
        int i = 1;
        while (i < 16) {
            line = String.valueOf(line) + Maths.fabonacci(i) + " ";
            ++i;
        }
        Logs.debug(line);
        Logs.debug(Maths.factorial(35));
    }

    @Test
    public void e_log() {
        Logs.debug("ln(2) = " + Maths.ln(2.0));
        Logs.debug("ln(e) = " + Maths.ln(Math.E));
        Logs.debug("log(2) = " + Math.log(2.0));
        Logs.debug("log(e) = " + Math.log(Math.E));
        Logs.debug("log10(100) = " + Math.log10(100.0));
    }
}

