/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io.table;

import happy.coding.io.table.SeparatorPolicy;
import happy.coding.io.table.TextTableRenderer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TablePrinter {
    protected TableModel tableModel;
    protected List<SeparatorPolicy> separatorPolicies = new ArrayList<SeparatorPolicy>();
    protected boolean addRowNumbering;
    protected RowSorter<?> rowSorter;
    protected boolean headless;

    public TablePrinter(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public TablePrinter(TableModel tableModel, boolean addNumbering) {
        this.tableModel = tableModel;
        this.addRowNumbering = addNumbering;
    }

    public TablePrinter(String[] columnNames, Object[][] data) {
        this.tableModel = new DefaultTableModel(data, columnNames);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setAddRowNumbering(boolean addNumbering) {
        this.addRowNumbering = addNumbering;
    }

    public void addSeparatorPolicy(SeparatorPolicy separatorPolicy) {
        this.separatorPolicies.add(separatorPolicy);
        separatorPolicy.setTableModel(this.tableModel);
    }

    public void setSort(int column) {
        this.setSort(column, SortOrder.ASCENDING);
    }

    public void setSort(int column, SortOrder sortOrder) {
        this.rowSorter = new TableRowSorter<TableModel>(this.tableModel);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(column, sortOrder));
        this.rowSorter.setSortKeys(sortKeys);
    }

    public void printTable() {
        this.printTable(System.out, 0);
    }

    public void printTable(PrintStream ps, int indent) {
        TextTableRenderer renderer = new TextTableRenderer(this);
        renderer.render(ps, indent);
    }

    protected Object getValueAt(int row, int column) {
        int rowIndex = row;
        if (this.rowSorter != null) {
            rowIndex = this.rowSorter.convertRowIndexToModel(row);
        }
        return this.tableModel.getValueAt(rowIndex, column);
    }

    protected boolean hasSeparatorAt(int row) {
        for (SeparatorPolicy separatorPolicy : this.separatorPolicies) {
            if (!separatorPolicy.hasSeparatorAt(row)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        Object[][] data = new Object[][]{{"Kathy", "Smith", "Snowboarding", 5, false}, {"John", "Doe", "Rowing", 3, true}, {"Sue", "Black", "Knitting", 2, false}, {"Jane", "White", "Speed reading", 20, true}, {"Joe", "Brown", "Pool", 10, false}};
        TablePrinter printer = new TablePrinter(columnNames, data);
        printer.setAddRowNumbering(true);
        printer.setSort(1);
        printer.printTable();
    }
}

