/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io.net;

import happy.coding.io.FileIO;
import happy.coding.io.Logs;
import happy.coding.io.net.URLReader;
import happy.coding.math.Randoms;
import happy.coding.system.Systems;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WebCrawler
implements Runnable {
    protected static Map<String, Integer> proxy = null;
    protected static List<String> hosts = null;
    protected static long sleep = 8000L;
    protected static boolean use_proxy = false;
    protected String dir = Systems.getDesktop();
    protected String url;
    protected String thread_id;

    public WebCrawler(String feed, int id) throws Exception {
        this.url = feed;
        this.thread_id = "[Thread " + id + "]";
        this.load_proxy();
    }

    public abstract void run_thread() throws Exception;

    @Override
    public void run() {
        Logs.debug(String.valueOf(this.thread_id) + " is started with link: " + this.url);
        try {
            this.run_thread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logs.debug(String.valueOf(this.thread_id) + " is finished with link: " + this.url);
    }

    protected String read_url(String url) throws Exception {
        if (use_proxy) {
            return this.read_url_w_proxy(url);
        }
        Thread.sleep(sleep);
        int max_trails = 200;
        int count = 0;
        while (true) {
            ++count;
            try {
                String html = URLReader.read(url);
                if (html.contains("<html") && !html.contains("</html>")) continue;
                return html;
            }
            catch (IOException ce) {
                if (count > max_trails) {
                    return null;
                }
                Logs.debug("Try again [times: " + count + "]: " + ce.getMessage());
                continue;
            }
            break;
        }
    }

    private String read_url_w_proxy(String url) throws Exception {
        Thread.sleep(sleep);
        int max_trails = proxy.size();
        int index = Randoms.uniform(hosts.size());
        String host = hosts.get(index);
        int port = proxy.get(host);
        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        int count = 0;
        while (true) {
            ++count;
            try {
                String html = URLReader.read(url, p);
                if (!html.contains("</html>")) continue;
                return html;
            }
            catch (IOException ce) {
                if (count > max_trails) {
                    return null;
                }
                Logs.debug("Connect to another proxy [times: " + count + "]: " + ce.getMessage());
                index = Randoms.uniform(hosts.size());
                host = hosts.get(index);
                port = proxy.get(host);
                p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
                continue;
            }
            break;
        }
    }

    protected void load_proxy() throws Exception {
        proxy = new HashMap<String, Integer>();
        String path = FileIO.getResource("proxy.txt");
        List<String> lines = FileIO.readAsList(path);
        for (String line : lines) {
            String[] data = line.split(":");
            String host = data[0];
            int port = Integer.parseInt(data[1]);
            proxy.put(host, port);
        }
        hosts = new ArrayList<String>(proxy.keySet());
    }
}

