/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io;

import happy.coding.io.FileIO;
import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.math.Randoms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class Lists {
    public static int initSize(int capacity) {
        return (int)Math.ceil((double)capacity / 0.7);
    }

    public static <E> int initSize(Collection<E> collection) {
        return Lists.initSize(collection.size());
    }

    public static void shaffle(int[] data) {
        int N = data.length;
        if (N <= 1) {
            return;
        }
        int i = 0;
        while (i < N) {
            int j = Randoms.uniform(i, N);
            int swap = data[i];
            data[i] = data[j];
            data[j] = swap;
            ++i;
        }
    }

    public static void shaffle(double[] data) {
        int N = data.length;
        if (N <= 1) {
            return;
        }
        int i = 0;
        while (i < N) {
            int j = Randoms.uniform(i, N);
            double swap = data[i];
            data[i] = data[j];
            data[j] = swap;
            ++i;
        }
    }

    public static <T> void shaffle(List<T> data) {
        int N = data.size();
        if (N <= 1) {
            return;
        }
        int i = 0;
        while (i < N) {
            int j = Randoms.uniform(i, N);
            T swap = data.get(i);
            data.set(i, data.get(j));
            data.set(j, swap);
            ++i;
        }
    }

    public static <T> List<T> subset(List<T> data, int n) {
        ArrayList<T> ts = new ArrayList<T>();
        int i = 0;
        while (i < data.size()) {
            ts.add(data.get(i));
            if (ts.size() >= n) break;
            ++i;
        }
        return ts;
    }

    public static <T> List<T> intersect(List<T> list1, List<T> list2) {
        ArrayList<T> ts = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            ts.add(t);
        }
        return ts;
    }

    public static <T> int overlapSize(List<T> list1, List<T> list2) {
        int res = 0;
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            ++res;
        }
        return res;
    }

    public static <T> List<T> except(List<T> list1, List<T> list2) {
        ArrayList<T> ts = new ArrayList<T>();
        for (T t : list1) {
            if (list2.contains(t)) continue;
            ts.add(t);
        }
        return ts;
    }

    public static <T> int exceptSize(List<T> list1, List<T> list2) {
        int res = 0;
        for (T t : list1) {
            if (list2.contains(t)) continue;
            ++res;
        }
        return res;
    }

    public static <T> boolean isEmpty(List<T> ts) {
        return ts == null || ts.size() < 1;
    }

    @Test
    public void e_shaffle() {
        int N = 10;
        int[] data = Randoms.ints(10, N);
        Logs.debug("Before: " + Strings.toString(data));
        Lists.shaffle(data);
        Logs.debug("After : " + Strings.toString(data));
        double[] d = Randoms.doubles(N);
        Logs.debug("Before: " + Strings.toString(d));
        Lists.shaffle(d);
        Logs.debug("After : " + Strings.toString(d));
    }

    public static double[] toArray(Collection<? extends Number> data) {
        if (data == null || data.size() < 1) {
            return null;
        }
        double[] da = new double[data.size()];
        int i = 0;
        for (Number number : data) {
            da[i++] = number.doubleValue();
        }
        return da;
    }

    public static List<Double> toList(double[] data) {
        if (data == null || data.length < 1) {
            return null;
        }
        ArrayList<Double> da = new ArrayList<Double>();
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            da.add(d);
            ++n2;
        }
        return da;
    }

    public static <K, T> List<T> toList(K[] data, FileIO.Converter<K, T> c) throws Exception {
        if (data == null || data.length < 1) {
            return null;
        }
        ArrayList<T> da = new ArrayList<T>();
        K[] KArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            K d = KArray[n2];
            da.add(c.transform(d));
            ++n2;
        }
        return da;
    }

    public static List<Integer> toList(int[] data) {
        ArrayList<Integer> da = new ArrayList<Integer>();
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Integer d = nArray[n2];
            da.add(d);
            ++n2;
        }
        return da;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortMap(Map<K, V> data, boolean inverse) {
        ArrayList<Map.Entry<K, V>> pairs = new ArrayList<Map.Entry<K, V>>(data.entrySet());
        Lists.sortList(pairs, inverse);
        return pairs;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortMap(Map<K, V> data) {
        return Lists.sortMap(data, false);
    }

    public static <K, V extends Comparable<? super V>> void sortList(List<Map.Entry<K, V>> data, final boolean inverse) {
        Collections.sort(data, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                int res = ((Comparable)a.getValue()).compareTo(b.getValue());
                return inverse ? -res : res;
            }
        });
    }

    public static <K, V extends Comparable<? super V>> void sortList(List<Map.Entry<K, V>> data) {
        Lists.sortList(data, false);
    }
}

