/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io;

import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.io.net.Gmailer;
import happy.coding.io.net.URLReader;
import happy.coding.system.Dates;
import happy.coding.system.Systems;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileIO {
    public static final long ONE_KB = 1024L;
    public static final long ONE_K = 1000L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_M = 1000000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_G = 1000000000L;
    public static final String desktop = Systems.getDesktop();
    public static final String comma = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";

    private FileIO() {
    }

    public static String formatBytes(long size) {
        String display = size / 0x40000000L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1.073741824E9)) + " GB" : (size / 0x100000L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1048576.0)) + " MB" : (size / 1024L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1024.0)) + " KB" : String.valueOf(String.valueOf(size)) + " bytes"));
        return display;
    }

    public static String formatSize(long size) {
        String display = size / 1000000000L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1.0E9)) + " G" : (size / 1000000L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1000000.0)) + " M" : (size / 1000L > 0L ? String.valueOf(String.format("%.2f", ((double)size + 0.0) / 1000.0)) + " K" : String.valueOf(size)));
        return display;
    }

    public static String getResource(String filePath) {
        if (FileIO.exist(filePath)) {
            return filePath;
        }
        String path = String.valueOf(FileIO.makeDirPath("src", "main", "resources")) + filePath;
        if (FileIO.exist(path)) {
            return path;
        }
        URL is = Class.class.getResource(filePath);
        if (is != null) {
            return is.getFile();
        }
        is = Class.class.getResource(path);
        if (is != null) {
            return is.getFile();
        }
        return null;
    }

    public static BufferedReader getReader(String path) throws FileNotFoundException {
        return FileIO.getReader(new File(FileIO.getResource(path)));
    }

    public static BufferedReader getReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedWriter getWriter(String path) throws Exception {
        return FileIO.getWriter(new File(path));
    }

    public static BufferedWriter getWriter(File file) throws Exception {
        return new BufferedWriter(new FileWriter(file));
    }

    public static String getCurrentFolder() {
        return Paths.get("", new String[0]).toAbsolutePath().getFileName().toString();
    }

    public static String getCurrentPath() {
        return Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    public static String makeDirPath(String dirPath) {
        switch (Systems.getOs()) {
            case Windows: {
                dirPath = dirPath.replace('/', '\\');
                break;
            }
            default: {
                dirPath = dirPath.replace('\\', '/');
            }
        }
        if (!dirPath.endsWith(Systems.FILE_SEPARATOR)) {
            dirPath = String.valueOf(dirPath) + Systems.FILE_SEPARATOR;
        }
        return dirPath;
    }

    public static String makeDirPath(String ... dirs) {
        String dirPath = "";
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            dirPath = String.valueOf(dirPath) + FileIO.makeDirPath(dir);
            ++n2;
        }
        return dirPath;
    }

    public static String makeDirectory(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return FileIO.makeDirPath(dir.getPath());
    }

    public static String makeDirectory(String ... dirs) {
        String dirPath = FileIO.makeDirPath(dirs);
        return FileIO.makeDirectory(dirPath);
    }

    public static void writeString(String filePath, String content) throws Exception {
        FileIO.writeString(filePath, content, false);
    }

    public static void writeString(String filePath, String content, boolean append) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        if (content.endsWith("\n")) {
            bw.write(content);
        } else {
            bw.write(String.valueOf(content) + "\n");
        }
        bw.close();
    }

    public static <T> void writeList(String filePath, Collection<T> objs) throws Exception {
        FileIO.writeList(filePath, objs, null, false);
    }

    public static <T> void writeList(String filePath, Collection<T> objs, boolean append) throws Exception {
        FileIO.writeList(filePath, objs, null, append);
    }

    public static synchronized <T> void writeListSyn(String filePath, List<T> objs) throws Exception {
        FileIO.writeList(filePath, objs, null, false);
    }

    public static <T> void writeList(String filePath, Collection<T> ts, Converter<T, String> lw, boolean append) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        StringBuilder contents = new StringBuilder();
        int count = 0;
        for (T t : ts) {
            contents.append((Object)(lw != null ? lw.transform(t) : t));
            contents.append("\n");
            if (++count < 1000) continue;
            bw.write(contents.toString());
            count = 0;
            contents = new StringBuilder();
        }
        if (contents.capacity() > 0) {
            bw.write(contents.toString());
        }
        bw.close();
    }

    public static <T> void writeVector(String filePath, List<T> objs) throws Exception {
        FileIO.writeVector(filePath, objs, null, false);
    }

    public static <T> void writeVector(String filePath, List<T> ts, Converter<T, String> wh, boolean append) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (T t : ts) {
            sb.append(wh.transform(t));
            if (++i >= ts.size()) continue;
            sb.append(", ");
        }
        bw.write(String.valueOf(sb.toString()) + "\n");
        bw.close();
    }

    public static void notifyMe(String algo, String mailTo, boolean isNotify) throws Exception {
        String destPath = FileIO.makeDirectory("Results");
        String dest = String.valueOf(destPath) + algo + "@" + Dates.now() + ".txt";
        FileIO.copyFile("results.txt", dest);
        if (isNotify) {
            Gmailer notifier = new Gmailer();
            notifier.getProps().setProperty("mail.to", mailTo);
            notifier.getProps().setProperty("mail.subject", String.valueOf(FileIO.getCurrentFolder()) + "." + algo + "@" + Systems.getIP());
            notifier.send("Program [" + algo + "] has been finished !", dest);
        }
    }

    public static void notifyMe(String algo, boolean isNotify) throws Exception {
        FileIO.notifyMe(algo, "gguo1@e.ntu.edu.sg", isNotify);
    }

    public static <T, E> void writeMap(String filePath, Map<T, E> objs) throws Exception {
        FileIO.writeMap(filePath, objs, false);
    }

    public static <T, E> void writeMap(String filePath, Map<T, E> map, boolean append) throws Exception {
        FileIO.writeMap(filePath, map, null, append);
    }

    public static <T, E> void writeMap(String filePath, Map<T, E> map, MapWriter<T, E> mw, boolean append) throws Exception {
        String content = Strings.toString(map, mw);
        FileIO.writeString(filePath, content, append);
    }

    public static String readAsString(String filePath, String ... keywords) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        block0: while ((line = br.readLine()) != null) {
            if (keywords != null && keywords.length > 0) {
                String[] stringArray = keywords;
                int n = keywords.length;
                int n2 = 0;
                while (n2 < n) {
                    String keyword = stringArray[n2];
                    if (line.contains(keyword)) {
                        sb.append(String.valueOf(line) + "\r\n");
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            sb.append(String.valueOf(line) + "\r\n");
        }
        br.close();
        return sb.toString();
    }

    public static String readAsString(String filePath, int ... lines) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        int count = 0;
        int num = 0;
        while ((line = br.readLine()) != null) {
            if (++count == lines[num]) {
                ++num;
                sb.append(String.valueOf(line) + "\r\n");
            }
            if (num >= lines.length) break;
        }
        br.close();
        return sb.toString();
    }

    public static String readAsString(String path) throws Exception {
        if (path.startsWith("http://") || path.contains("www.")) {
            return URLReader.read(path);
        }
        return FileIO.readAsString(path, new String[0]);
    }

    public static List<String> readAsList(String filePath) throws FileNotFoundException, Exception {
        return FileIO.readAsList(filePath, null);
    }

    public static <T> List<T> readAsList(String filePath, Converter<String, T> rh) throws FileNotFoundException, Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        ArrayList<String> contents = new ArrayList<String>();
        String t = null;
        String line = null;
        while ((line = br.readLine()) != null) {
            t = rh == null ? line : rh.transform(line);
            if (t == null) continue;
            contents.add(t);
        }
        br.close();
        return contents;
    }

    public static Set<String> readAsSet(String filePath) throws FileNotFoundException, Exception {
        return FileIO.readAsSet(filePath, null);
    }

    public static <T> Set<T> readAsSet(String filePath, Converter<String, T> rh) throws FileNotFoundException, Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashSet<String> contents = new HashSet<String>();
        String line = null;
        String t = null;
        while ((line = br.readLine()) != null) {
            t = rh == null ? line : rh.transform(line);
            if (t == null) continue;
            contents.add(t);
        }
        br.close();
        return contents;
    }

    public static Map<String, String> readAsMap(String filePath) throws FileNotFoundException, Exception {
        return FileIO.readAsMap(filePath, ",");
    }

    public static Map<String, String> readAsMap(String filePath, String seperator) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<String, String> contents = new HashMap<String, String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] data = line.split(seperator);
            if (data.length <= 1) continue;
            contents.put(data[0], data[1]);
        }
        br.close();
        return contents;
    }

    public static <T, E> Map<T, E> readAsMap(String filePath, Converter<String, Object[]> rh) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<Object, Object> contents = new HashMap<Object, Object>();
        String line = null;
        while ((line = br.readLine()) != null) {
            Object[] obs = rh.transform(line);
            contents.put(obs[0], obs[1]);
        }
        br.close();
        return contents;
    }

    public static Map<String, Double> readAsIDMap(String filePath) throws Exception {
        return FileIO.readAsIDMap(filePath, ",");
    }

    public static Map<String, Double> readAsIDMap(String filePath, String sep) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<String, Double> contents = new HashMap<String, Double>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] data = line.split(sep);
            if (data.length <= 1) continue;
            contents.put(data[0], new Double(data[1]));
        }
        br.close();
        return contents;
    }

    public static void serialize(Object obj, String filePath) throws Exception {
        FileOutputStream fos = new FileOutputStream(filePath);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        fos.close();
    }

    public static Object deserialize(String filePath) throws Exception {
        FileInputStream fis = new FileInputStream(filePath);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object obj = ois.readObject();
        ois.close();
        fis.close();
        return obj;
    }

    public static void renameFiles(String dirPath, String regex, String replacement) throws Exception {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            throw new Exception(String.valueOf(dirPath) + " is not a directory");
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileIO.renameFile(file, regex, replacement);
                ++n2;
            }
        }
    }

    public static void renameFile(File file, String regex, String replacement) {
        String filename = file.getName();
        filename = filename.replaceAll(regex, replacement);
        String path = FileIO.makeDirPath(file.getPath());
        file.renameTo(new File(String.valueOf(path) + filename));
    }

    public static void copyFile(String source, String target) throws Exception {
        FileIO.copyFile(new File(source), new File(target));
    }

    public static void copyFile(File source, File target) throws Exception {
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target);
        FileChannel inChannel = fis.getChannel();
        FileChannel outChannel = fos.getChannel();
        int maxCount = 67076096;
        long size = inChannel.size();
        long position = 0L;
        while (position < size) {
            position += inChannel.transferTo(position, maxCount, outChannel);
        }
        inChannel.close();
        outChannel.close();
        fis.close();
        fos.close();
    }

    public static void deleteFile(String source) throws Exception {
        new File(source).delete();
    }

    public static void deleteDirectory(String dirPath) throws Exception {
        FileIO.deleteDirectory(new File(dirPath));
    }

    public static void deleteDirectory(File dir) throws Exception {
        FileIO.cleanDirectory(dir);
        dir.delete();
    }

    public static void cleanDirectory(String dirPath) throws Exception {
        FileIO.cleanDirectory(new File(dirPath));
    }

    public static void cleanDirectory(File dir) throws Exception {
        File[] fs;
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new Exception("The path '" + dir.getPath() + "' is not a directory. ");
        }
        File[] fileArray = fs = dir.listFiles();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                FileIO.deleteDirectory(f.getPath());
            } else {
                f.delete();
            }
            ++n2;
        }
    }

    public static void moveFile(String source, String target) throws Exception {
        FileIO.copyFile(source, target);
        FileIO.deleteFile(source);
    }

    public static void moveDirectory(String sourceDir, String targetDir) throws Exception {
        FileIO.copyDirectory(sourceDir, targetDir);
        FileIO.deleteDirectory(sourceDir);
    }

    public static void copyDirectory(String sourceDir, String targetDir) throws Exception {
        File sDir = new File(sourceDir);
        File tDir = new File(targetDir);
        if (sDir.isDirectory()) {
            File[] files;
            if (!tDir.exists()) {
                tDir.mkdirs();
            }
            File[] fileArray = files = sDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileIO.copyDirectory(f.getPath(), tDir + Systems.FILE_SEPARATOR + f.getName() + Systems.FILE_SEPARATOR);
                } else {
                    FileIO.copyFile(f, new File(String.valueOf(tDir.getPath()) + Systems.FILE_SEPARATOR + f.getName()));
                }
                ++n2;
            }
        }
    }

    public static void empty(String filePath) throws Exception {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
    }

    public static boolean exist(String filePath) {
        return new File(filePath).exists();
    }

    public static File[] listFiles(String dirPath) {
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            return dir.listFiles();
        }
        return new File[]{dir};
    }

    public static void zipFolder(String dirPath, String filePath) throws Exception {
        File outFile = new File(filePath);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        byte[] buffer = new byte[1024];
        CRC32 crc = new CRC32();
        File[] fileArray = FileIO.listFiles(dirPath);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            int bytesRead;
            File file = fileArray[n2];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            crc.reset();
            while ((bytesRead = bis.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
            }
            bis.close();
            bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(file.getName());
            entry.setMethod(0);
            entry.setCompressedSize(file.length());
            entry.setSize(file.length());
            entry.setCrc(crc.getValue());
            zos.putNextEntry(entry);
            while ((bytesRead = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            bis.close();
            ++n2;
        }
        zos.close();
        Logs.debug("A zip-file is created to: {}", (Object)outFile.getPath());
    }

    public static void main(String[] args) throws Exception {
        FileIO.zipFolder(String.valueOf(desktop) + "papers", "desktop.zip");
    }

    public static interface Converter<K, T> {
        public T transform(K var1) throws Exception;
    }

    public static interface MapWriter<K, V> {
        public String processEntry(K var1, V var2);
    }
}

