/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDao {
    protected static String DRIVER = null;
    protected static String URL = null;
    protected static Connection conn = null;
    protected static Statement stmt = null;
    protected static String database;
    protected static Logger logger;

    static {
        logger = LoggerFactory.getLogger(GenericDao.class);
    }

    public GenericDao() {
        this.getConn();
    }

    protected void createTables(String ... sqls) throws Exception {
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            this.createTable(sql);
            ++n2;
        }
    }

    protected void createTables() throws Exception {
    }

    protected void createTable(String sql) throws Exception {
        logger.debug(sql);
        stmt.execute(sql);
    }

    protected void dropTables(String ... tables) throws Exception {
        String[] stringArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String tableId = stringArray[n2];
            this.dropTable(tableId);
            ++n2;
        }
    }

    protected void dropTable(String tableId) throws Exception {
        String sql = "DROP TABLE " + tableId;
        logger.debug(sql);
        stmt.execute(sql);
    }

    protected void clearTables(String ... tables) throws Exception {
        String[] stringArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String tableId = stringArray[n2];
            this.clearTable(tableId);
            ++n2;
        }
    }

    protected void clearTable(String tableId) throws Exception {
        String sql = "DELETE FROM " + tableId;
        logger.debug("Clear table: {}", (Object)sql);
        stmt.execute(sql);
    }

    protected void closeConn() throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
    }

    protected void getConn() {
        try {
            Class.forName(DRIVER).newInstance();
            String sql = String.valueOf(URL) + database + ";create=true";
            conn = DriverManager.getConnection(sql);
            stmt = conn.createStatement();
            logger.debug("Get connection: {}", (Object)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

