/*
 * Decompiled with CFR 0.152.
 */
package carskit.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Measures
extends happy.coding.math.Measures {
    public static <T> List<T> getTopNList(List<T> rankedList, int n) {
        n = n > rankedList.size() ? rankedList.size() : n;
        ArrayList<T> newList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            newList.add(rankedList.get(i));
        }
        return newList;
    }

    public static <T> double nDCGAt(List<T> rankedList, List<T> groundTruth, int n) {
        return Measures.nDCG(Measures.getTopNList(rankedList, n), groundTruth);
    }

    public static <T> Map<Integer, Double> nDCGAt(List<T> rankedList, List<T> groundTruth, List<Integer> ns) {
        HashMap<Integer, Double> ndcg_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            ndcg_at_n.put(n, Measures.nDCGAt(rankedList, groundTruth, n));
        }
        return ndcg_at_n;
    }

    public static <T> double AUCAt(List<T> rankedList, List<T> groundTruth, int numDropped, int n) {
        return Measures.AUC(Measures.getTopNList(rankedList, n), groundTruth, numDropped);
    }

    public static <T> Map<Integer, Double> AUCAt(List<T> rankedList, List<T> groundTruth, int numDropped, List<Integer> ns) {
        HashMap<Integer, Double> AUC_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            AUC_at_n.put(n, Measures.AUCAt(rankedList, groundTruth, numDropped, n));
        }
        return AUC_at_n;
    }

    public static <T> double APAt(List<T> rankedList, List<T> groundTruth, int n) {
        return Measures.AP(Measures.getTopNList(rankedList, n), groundTruth);
    }

    public static <T> Map<Integer, Double> APAt(List<T> rankedList, List<T> groundTruth, List<Integer> ns) {
        HashMap<Integer, Double> AP_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            AP_at_n.put(n, Measures.APAt(rankedList, groundTruth, n));
        }
        return AP_at_n;
    }

    public static <T> double RRAt(List<T> rankedList, List<T> groundTruth, int n) {
        return Measures.RR(Measures.getTopNList(rankedList, n), groundTruth);
    }

    public static <T> Map<Integer, Double> RRAt(List<T> rankedList, List<T> groundTruth, List<Integer> ns) {
        HashMap<Integer, Double> rr_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            rr_at_n.put(n, Measures.RRAt(rankedList, groundTruth, n));
        }
        return rr_at_n;
    }
}

