/*
 * Decompiled with CFR 0.152.
 */
package carskit.data.structure;

import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import librec.data.SparseVector;

public class SparseMatrix
extends librec.data.SparseMatrix {
    double rating_global = 0.0;

    public SparseMatrix(int rows, int cols, Table<Integer, Integer, Double> dataTable, Multimap<Integer, Integer> colMap) {
        super(rows, cols, dataTable, colMap);
    }

    public SparseMatrix(int rows, int cols, Table<Integer, Integer, Double> dataTable) {
        super(rows, cols, dataTable);
    }

    public SparseMatrix(librec.data.SparseMatrix mat) {
        super(mat);
    }

    public double getGlobalAvg() {
        if (this.rating_global == 0.0) {
            this.rating_global = this.sum() / (double)this.size();
        }
        return this.rating_global;
    }

    public double getAverage(Collection<Integer> uiList) {
        double rate = 0.0;
        double counter = 0.0;
        for (int uiid : uiList) {
            SparseVector sv = this.row(uiid);
            if (sv.size() <= 0) continue;
            rate += sv.sum();
            counter += (double)sv.size();
        }
        rate = counter > 0.0 ? (rate /= counter) : 0.0;
        return rate;
    }
}

