/*
 * Decompiled with CFR 0.152.
 */
package carskit.data.processor;

import carskit.main.CARSKit;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import happy.coding.io.FileIO;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.math.Stats;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseTensor;
import librec.data.SparseVector;
import org.apache.commons.math3.stat.inference.TTest;

public class DataDAO {
    private String dataName;
    private String dataDir;
    private String dataPath;
    private carskit.data.structure.SparseMatrix rateMatrix;
    private SparseTensor rateTensor;
    private double MaxRate = -1.0;
    private double MinRate = -1.0;
    private boolean isHeadline = true;
    private boolean fullStat = false;
    private carskit.data.structure.SparseMatrix rateMatrix_UI;
    private carskit.data.structure.SparseMatrix rateMatrix_UC;
    private carskit.data.structure.SparseMatrix rateMatrix_IC;
    private double density_unique_ui;
    private double density_unique_uc;
    private double density_unique_ic;
    private HashMap<Integer, Double> rates_c;
    private HashMap<Integer, Double> rates_c_count;
    private HashMap<Integer, Double> rates_u_count;
    private HashMap<Integer, Double> rates_i_count;
    private Collection<Double> ratingDist_ui;
    private Collection<Double> ratingDist_uc;
    private Collection<Double> ratingDist_ic;
    private List<Double> ratingScale;
    private Multiset<Double> scaleDist;
    private int numRatings;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;
    private BiMap<String, Integer> ctxIds;
    private BiMap<String, Integer> uiIds;
    private BiMap<String, Integer> dimIds;
    private BiMap<String, Integer> condIds;
    private BiMap<Integer, String> idUsers;
    private BiMap<Integer, String> idItems;
    private BiMap<Integer, String> idCtx;
    private BiMap<Integer, String> idUIs;
    private BiMap<Integer, String> idDims;
    private BiMap<Integer, String> idConds;
    private Multimap<Integer, Integer> uRatedList;
    private Multimap<Integer, Integer> iRatedList;
    private Multimap<Integer, Integer> dimConditionsList;
    private Multimap<Integer, Integer> condContextsList;
    private HashMap<Integer, Integer> uiUserIds;
    private HashMap<Integer, Integer> uiItemIds;
    private HashMap<Integer, Integer> condDimensionMap;
    private HashMap<Integer, ArrayList<Integer>> dimensionConditionsList;
    private HashMap<Integer, ArrayList<Integer>> contextConditionsList;
    private ArrayList<Integer> EmptyContextConditions;

    public DataDAO(String path, BiMap<String, Integer> userIds, BiMap<String, Integer> itemIds, BiMap<String, Integer> ctxIds, BiMap<String, Integer> uiIds, BiMap<String, Integer> dimIds, BiMap<String, Integer> condIds, Multimap<Integer, Integer> uRatedList, Multimap<Integer, Integer> iRatedList, Multimap<Integer, Integer> dimConditionsList, HashMap<Integer, Integer> condDimensionMap, Multimap<Integer, Integer> condContextsList, HashMap<Integer, ArrayList<Integer>> contextConditionsList, HashMap<Integer, Integer> uiUserIds, HashMap<Integer, Integer> uiItemIds) {
        this.dataPath = path;
        this.userIds = userIds == null ? HashBiMap.create() : (HashBiMap)userIds;
        this.itemIds = itemIds == null ? HashBiMap.create() : (HashBiMap)itemIds;
        this.ctxIds = ctxIds == null ? HashBiMap.create() : (HashBiMap)ctxIds;
        this.uiIds = uiIds == null ? HashBiMap.create() : (HashBiMap)uiIds;
        this.dimIds = dimIds == null ? HashBiMap.create() : (HashBiMap)dimIds;
        this.condIds = condIds == null ? HashBiMap.create() : (HashBiMap)condIds;
        this.uRatedList = uRatedList == null ? HashMultimap.create() : (HashMultimap)uRatedList;
        this.iRatedList = iRatedList == null ? HashMultimap.create() : (HashMultimap)iRatedList;
        this.dimConditionsList = dimConditionsList == null ? HashMultimap.create() : (HashMultimap)dimConditionsList;
        this.condContextsList = condContextsList == null ? HashMultimap.create() : (HashMultimap)condContextsList;
        this.contextConditionsList = contextConditionsList == null ? new HashMap() : contextConditionsList;
        this.uiUserIds = uiUserIds == null ? new HashMap() : uiUserIds;
        this.uiItemIds = uiItemIds == null ? new HashMap() : uiItemIds;
        this.condDimensionMap = condDimensionMap == null ? new HashMap() : condDimensionMap;
        this.scaleDist = HashMultiset.create();
    }

    public DataDAO(String path) {
        this(path, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public carskit.data.structure.SparseMatrix readData(double binThold) throws Exception {
        if (CARSKit.isMeasuresOnly) {
            Logs.debug(String.format("Dataset: %s", Strings.last(this.dataPath, 38)));
        } else {
            Logs.info(String.format("Dataset: %s", Strings.last(this.dataPath, 38)));
        }
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        HashBasedTable<Integer, Integer, Double> dataTable_ui = null;
        HashBasedTable<Integer, Integer, Double> dataTable_uc = null;
        HashBasedTable<Integer, Integer, Double> dataTable_ic = null;
        HashBasedTable<Integer, Integer, Double> dataTable_ui_counter = null;
        HashBasedTable<Integer, Integer, Double> dataTable_uc_counter = null;
        HashBasedTable<Integer, Integer, Double> dataTable_ic_counter = null;
        HashMultimap<Integer, Integer> colMap_ui = null;
        HashMultimap<Integer, Integer> colMap_uc = null;
        HashMultimap<Integer, Integer> colMap_ic = null;
        if (this.fullStat) {
            dataTable_ui = HashBasedTable.create();
            dataTable_uc = HashBasedTable.create();
            dataTable_ic = HashBasedTable.create();
            dataTable_ui_counter = HashBasedTable.create();
            dataTable_uc_counter = HashBasedTable.create();
            dataTable_ic_counter = HashBasedTable.create();
            colMap_ui = HashMultimap.create();
            colMap_uc = HashMultimap.create();
            colMap_ic = HashMultimap.create();
        }
        this.EmptyContextConditions = new ArrayList();
        Logs.info("DataPath: " + this.dataPath);
        BufferedReader br = FileIO.getReader(this.dataPath);
        String line = br.readLine();
        String[] data = line.trim().split("[\t,]+");
        for (int i = 3; i < data.length; ++i) {
            String context = data[i].trim();
            String[] cs = context.split(":");
            String dim = cs[0].trim();
            int dimc = this.dimIds.containsKey(dim) ? ((Integer)this.dimIds.get(dim)).intValue() : this.dimIds.size();
            this.dimIds.put(dim, dimc);
            this.condIds.put(context, i - 3);
            this.dimConditionsList.put(dimc, i - 3);
            this.condDimensionMap.put(i - 3, dimc);
            if (!context.endsWith(":na")) continue;
            this.EmptyContextConditions.add(i - 3);
        }
        this.rates_c = new HashMap();
        this.rates_c_count = new HashMap();
        this.rates_u_count = new HashMap();
        this.rates_i_count = new HashMap();
        while ((line = br.readLine()) != null) {
            String useritem;
            data = line.trim().split(",", -1);
            String user = data[0];
            String item = data[1];
            Double rate = Double.valueOf(data[2]);
            this.scaleDist.add(rate);
            int row = this.userIds.containsKey(user) ? ((Integer)this.userIds.get(user)).intValue() : this.userIds.size();
            this.userIds.put(user, row);
            int col = this.itemIds.containsKey(item) ? ((Integer)this.itemIds.get(item)).intValue() : this.itemIds.size();
            this.itemIds.put(item, col);
            if (this.fullStat) {
                if (dataTable_ui.contains(row, col)) {
                    dataTable_ui.put(row, col, rate + (Double)dataTable_ui.get(row, col));
                    dataTable_ui_counter.put(row, col, 1.0 + (Double)dataTable_ui_counter.get(row, col));
                } else {
                    dataTable_ui.put(row, col, rate);
                    dataTable_ui_counter.put(row, col, 1.0);
                    colMap_ui.put(col, row);
                }
                if (this.rates_u_count.containsKey(row)) {
                    this.rates_u_count.put(row, 1.0 + this.rates_u_count.get(row));
                } else {
                    this.rates_u_count.put(row, 1.0);
                }
                if (this.rates_i_count.containsKey(col)) {
                    this.rates_i_count.put(col, 1.0 + this.rates_i_count.get(col));
                } else {
                    this.rates_i_count.put(col, 1.0);
                }
            }
            int uic = this.uiIds.containsKey(useritem = row + "," + col) ? ((Integer)this.uiIds.get(useritem)).intValue() : this.uiIds.size();
            this.uiIds.put(useritem, uic);
            this.uRatedList.put(row, uic);
            this.iRatedList.put(col, uic);
            this.uiUserIds.put(uic, row);
            this.uiItemIds.put(uic, col);
            StringBuilder sb_ctx = new StringBuilder();
            ArrayList<Integer> condList = new ArrayList<Integer>();
            for (int i = 3; i < data.length; ++i) {
                int value;
                if (data[i].trim().equals("")) {
                    Logs.error(line + "; " + data[i]);
                }
                if ((value = Integer.valueOf(data[i].trim()).intValue()) != 1) continue;
                if (sb_ctx.length() > 0) {
                    sb_ctx.append(",");
                }
                sb_ctx.append(i - 3);
                condList.add(i - 3);
                if (!this.fullStat || this.EmptyContextConditions.contains(i - 3)) continue;
                if (dataTable_uc.contains(row, i - 3)) {
                    dataTable_uc.put(row, i - 3, rate + (Double)dataTable_uc.get(row, i - 3));
                    dataTable_uc_counter.put(row, i - 3, 1.0 + (Double)dataTable_uc_counter.get(row, i - 3));
                } else {
                    dataTable_uc.put(row, i - 3, rate);
                    dataTable_uc_counter.put(row, i - 3, 1.0);
                    colMap_uc.put(i - 3, row);
                }
                if (dataTable_ic.contains(col, i - 3)) {
                    dataTable_ic.put(col, i - 3, rate + (Double)dataTable_ic.get(col, i - 3));
                    dataTable_ic_counter.put(col, i - 3, 1.0 + (Double)dataTable_ic_counter.get(col, i - 3));
                } else {
                    dataTable_ic.put(col, i - 3, rate);
                    dataTable_ic_counter.put(col, i - 3, 1.0);
                    colMap_ic.put(i - 3, col);
                }
                if (this.rates_c.containsKey(i - 3)) {
                    this.rates_c.put(i - 3, rate + this.rates_c.get(i - 3));
                    this.rates_c_count.put(i - 3, 1.0 + this.rates_c_count.get(i - 3));
                    continue;
                }
                this.rates_c.put(i - 3, rate);
                this.rates_c_count.put(i - 3, 1.0);
            }
            String ctx = sb_ctx.toString();
            int cc = this.ctxIds.containsKey(ctx) ? ((Integer)this.ctxIds.get(ctx)).intValue() : this.ctxIds.size();
            this.ctxIds.put(ctx, cc);
            this.contextConditionsList.put(cc, condList);
            for (Integer cond : condList) {
                this.condContextsList.put(cond, cc);
            }
            dataTable.put(uic, cc, rate);
            colMap.put(cc, uic);
        }
        br.close();
        this.numRatings = this.scaleDist.size();
        this.ratingScale = new ArrayList<Double>(this.scaleDist.elementSet());
        Collections.sort(this.ratingScale);
        this.rateMatrix = new carskit.data.structure.SparseMatrix(this.numUserItems(), this.numContexts(), (Table<Integer, Integer, Double>)dataTable, (Multimap<Integer, Integer>)colMap);
        if (this.fullStat) {
            Iterator i$;
            this.density_unique_ui = 0.0;
            this.density_unique_uc = 0.0;
            this.density_unique_ic = 0.0;
            Iterator i$2 = dataTable_ui.rowKeySet().iterator();
            while (i$2.hasNext()) {
                int row = (Integer)i$2.next();
                i$ = dataTable_ui.columnKeySet().iterator();
                while (i$.hasNext()) {
                    int col = (Integer)i$.next();
                    if (!dataTable_ui.contains(row, col)) continue;
                    double counter = (Double)dataTable_ui_counter.get(row, col);
                    if (counter > 1.0) {
                        this.density_unique_ui += 1.0;
                    }
                    dataTable_ui.put(row, col, (Double)dataTable_ui.get(row, col) / counter);
                }
            }
            this.rateMatrix_UI = new carskit.data.structure.SparseMatrix(this.numUsers(), this.numItems(), (Table<Integer, Integer, Double>)dataTable_ui, (Multimap<Integer, Integer>)colMap_ui);
            i$2 = dataTable_uc.rowKeySet().iterator();
            while (i$2.hasNext()) {
                int row = (Integer)i$2.next();
                i$ = dataTable_uc.columnKeySet().iterator();
                while (i$.hasNext()) {
                    int col = (Integer)i$.next();
                    if (!dataTable_uc.contains(row, col)) continue;
                    double counter = (Double)dataTable_uc_counter.get(row, col);
                    if (counter > 1.0) {
                        this.density_unique_uc += 1.0;
                    }
                    dataTable_uc.put(row, col, (Double)dataTable_uc.get(row, col) / counter);
                }
            }
            this.rateMatrix_UC = new carskit.data.structure.SparseMatrix(this.numUsers(), this.numConditions(), (Table<Integer, Integer, Double>)dataTable_uc, (Multimap<Integer, Integer>)colMap_uc);
            i$2 = dataTable_ic.rowKeySet().iterator();
            while (i$2.hasNext()) {
                int row = (Integer)i$2.next();
                i$ = dataTable_ic.columnKeySet().iterator();
                while (i$.hasNext()) {
                    int col = (Integer)i$.next();
                    if (!dataTable_ic.contains(row, col)) continue;
                    double counter = (Double)dataTable_ic_counter.get(row, col);
                    if (counter > 1.0) {
                        this.density_unique_ic += 1.0;
                    }
                    dataTable_ic.put(row, col, (Double)dataTable_ic.get(row, col) / counter);
                }
            }
            this.rateMatrix_IC = new carskit.data.structure.SparseMatrix(this.numItems(), this.numConditions(), (Table<Integer, Integer, Double>)dataTable_ic, (Multimap<Integer, Integer>)colMap_ic);
            this.ratingDist_ui = dataTable_ui_counter.values();
            this.ratingDist_uc = dataTable_uc_counter.values();
            this.ratingDist_ic = dataTable_ic_counter.values();
        }
        dataTable = null;
        dataTable_ui = null;
        dataTable_ui_counter = null;
        dataTable_uc = null;
        dataTable_uc_counter = null;
        dataTable_ic = null;
        dataTable_ic_counter = null;
        Logs.info("Rating data set has been successfully loaded.");
        return this.rateMatrix;
    }

    public HashMap<Integer, ArrayList<Integer>> getDimensionConditionsList() {
        return this.dimensionConditionsList;
    }

    public SparseTensor toSparseTensor(carskit.data.structure.SparseMatrix sm) {
        int numDims = 2 + this.numContextDims();
        int[] dims = new int[numDims];
        List[] ndLists = new List[numDims];
        Set[] ndSets = new Set[numDims];
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int d = 0; d < numDims; ++d) {
            ndLists[d] = new ArrayList();
            ndSets[d] = new HashSet();
        }
        this.dimensionConditionsList = new HashMap();
        for (MatrixEntry me : sm) {
            int rowid = me.row();
            int ctxid = me.column();
            double rate = me.get();
            int uid = this.getUserIdFromUI(rowid);
            int iid = this.getItemIdFromUI(rowid);
            vals.add(rate);
            ndLists[0].add(uid);
            ndSets[0].add(uid);
            ndLists[1].add(iid);
            ndSets[1].add(iid);
            Collection listOfConditions = this.contextConditionsList.get(ctxid);
            Iterator i$ = listOfConditions.iterator();
            while (i$.hasNext()) {
                ArrayList<Object> list;
                int condId = (Integer)i$.next();
                int dimId = this.condDimensionMap.get(condId);
                int index_condId = -1;
                if (this.dimensionConditionsList.containsKey(dimId)) {
                    list = this.dimensionConditionsList.get(dimId);
                    index_condId = list.indexOf(condId);
                    if (index_condId == -1) {
                        list.add(condId);
                    }
                    index_condId = list.size() - 1;
                    this.dimensionConditionsList.put(dimId, list);
                } else {
                    list = new ArrayList<Integer>();
                    list.add(condId);
                    this.dimensionConditionsList.put(dimId, list);
                    index_condId = 0;
                }
                ndLists[2 + dimId].add(index_condId);
                ndSets[2 + dimId].add(index_condId);
            }
        }
        for (int d = 0; d < numDims; ++d) {
            dims[d] = ndSets[d].size();
        }
        SparseTensor st = new SparseTensor(dims, ndLists, vals);
        st.setUserDimension(0);
        st.setItemDimension(1);
        return st;
    }

    public void LoadAsTensor() {
        this.rateTensor = this.toSparseTensor(this.rateMatrix);
    }

    public void setFullStat(boolean full) {
        this.fullStat = full;
    }

    public void printSpecs() throws Exception {
        if (this.rateMatrix == null) {
            this.readData(-1.0);
        }
        ArrayList<String> sps = new ArrayList<String>();
        int users = this.numUsers();
        int items = this.numItems();
        int numRates = this.rateMatrix.size();
        int dims = this.numContextDims();
        int conds = this.numConditions();
        int numctx = this.numContexts();
        int cdims = 1;
        StringBuilder condcount = new StringBuilder();
        StringBuilder sdims = new StringBuilder();
        for (int dim : this.dimConditionsList.keySet()) {
            String sdim = this.getContextDimensionId(dim);
            int counter = this.dimConditionsList.get(dim).size();
            if (condcount.length() > 0) {
                condcount.append(", ");
            }
            condcount.append(sdim + ": " + counter);
            cdims *= counter;
            if (sdims.length() > 0) {
                sdims.append(", ");
            }
            sdims.append(sdim);
        }
        sps.add(String.format("Dataset: %s", this.dataPath));
        sps.add("");
        sps.add("Statistics of U-I-C Matrix:");
        sps.add("User amount: " + users);
        sps.add("Item amount: " + items);
        sps.add("Rate amount: " + this.numRatings());
        sps.add("Context dimensions: " + dims + " (" + sdims.toString() + ")");
        sps.add("Context conditions: " + conds + " (" + condcount.toString() + ")");
        sps.add("Context situations: " + numctx);
        sps.add(String.format("Data density: %.4f%%", ((double)numRates + 0.0) / (double)users / (double)items / (double)cdims * 100.0));
        sps.add("Scale distribution: " + this.scaleDist.toString());
        double[] data = this.rateMatrix.getData();
        float mean = (float)(Stats.sum(data) / (double)numRates);
        float std = (float)Stats.sd(data);
        float mode = (float)Stats.mode(data);
        float median = (float)Stats.median(data);
        sps.add(String.format("Average value of all ratings: %f", Float.valueOf(mean)));
        sps.add(String.format("Standard deviation of all ratings: %f", Float.valueOf(std)));
        sps.add(String.format("Mode of all rating values: %f", Float.valueOf(mode)));
        sps.add(String.format("Median of all rating values: %f", Float.valueOf(median)));
        if (this.fullStat) {
            SparseVector svc;
            SparseVector sv;
            sps.add("");
            Collection<Double> ratingDist_c = this.rates_c_count.values();
            Collection<Double> ratingDist_u = this.rates_u_count.values();
            Collection<Double> ratingDist_i = this.rates_i_count.values();
            sps.add("Distribution of rate counts per user: mean = " + Stats.mean(ratingDist_u) + ", median = " + Stats.median(ratingDist_u) + ", sd = " + Stats.sd(ratingDist_u));
            sps.add("Distribution of rate counts per item: mean = " + Stats.mean(ratingDist_i) + ", median = " + Stats.median(ratingDist_i) + ", sd = " + Stats.sd(ratingDist_i));
            sps.add("Distribution of rate counts per context condition: mean = " + Stats.mean(ratingDist_c) + ", median = " + Stats.median(ratingDist_c) + ", sd = " + Stats.sd(ratingDist_c));
            sps.add("");
            sps.add("Average rating in each context condition: (Average, Counts)");
            Lists.sortMap(this.rates_c, false);
            for (int c : this.rates_c.keySet()) {
                sps.add(this.getContextConditionId(c) + " - " + String.format("%.6f", this.rates_c.get(c) / this.rates_c_count.get(c)) + ", " + this.rates_c_count.get(c).intValue());
            }
            data = this.rateMatrix_UI.getData();
            double numRates_M = data.length;
            sps.add("");
            sps.add("Statistics of UI Matrix:");
            sps.add("User amount: " + users);
            sps.add("Item amount: " + items);
            sps.add("Rate amount: " + numRates_M);
            sps.add(String.format("Data density: %.4f%%", (numRates_M + 0.0) / (double)users / (double)items * 100.0));
            sps.add(String.format("Data density (unique pairs): %.4f%%", this.density_unique_ui / numRates_M * 100.0));
            mean = (float)(Stats.sum(data) / numRates_M);
            std = (float)Stats.sd(data);
            mode = (float)Stats.mode(data);
            median = (float)Stats.median(data);
            sps.add(String.format("Average value of all ratings: %f", Float.valueOf(mean)));
            sps.add(String.format("Standard deviation of all ratings: %f", Float.valueOf(std)));
            sps.add(String.format("Mode of all rating values: %f", Float.valueOf(mode)));
            sps.add(String.format("Median of all rating values: %f", Float.valueOf(median)));
            sps.add("Distribution of rate counts per UI pair: mean = " + Stats.mean(this.ratingDist_ui) + ", median = " + Stats.median(this.ratingDist_ui) + ", sd = " + Stats.sd(this.ratingDist_ui));
            data = this.rateMatrix_UC.getData();
            numRates_M = data.length;
            sps.add("");
            sps.add("Statistics of UC Matrix:");
            sps.add("User amount: " + users);
            sps.add("Condition amount: " + conds);
            sps.add("Rate amount: " + numRates_M);
            sps.add(String.format("Data density: %.4f%%", (numRates_M + 0.0) / (double)users / (double)this.numConditions() * 100.0));
            sps.add(String.format("Data density (unique pairs): %.4f%%", this.density_unique_uc / numRates_M * 100.0));
            mean = (float)(Stats.sum(data) / numRates_M);
            std = (float)Stats.sd(data);
            mode = (float)Stats.mode(data);
            median = (float)Stats.median(data);
            sps.add(String.format("Average value of all ratings: %f", Float.valueOf(mean)));
            sps.add(String.format("Standard deviation of all ratings: %f", Float.valueOf(std)));
            sps.add(String.format("Mode of all rating values: %f", Float.valueOf(mode)));
            sps.add(String.format("Median of all rating values: %f", Float.valueOf(median)));
            sps.add("Distribution of rate counts per UC pair: mean = " + Stats.mean(this.ratingDist_uc) + ", median = " + Stats.median(this.ratingDist_uc) + ", sd = " + Stats.sd(this.ratingDist_uc));
            data = this.rateMatrix_IC.getData();
            numRates_M = data.length;
            sps.add("");
            sps.add("Statistics of IC Matrix:");
            sps.add("Item amount: " + items);
            sps.add("Condition amount: " + conds);
            sps.add("Rate amount: " + numRates_M);
            sps.add(String.format("Data density: %.4f%%", (numRates_M + 0.0) / (double)items / (double)this.numConditions() * 100.0));
            sps.add(String.format("Data density (unique pairs): %.4f%%", this.density_unique_ic / numRates_M * 100.0));
            mean = (float)(Stats.sum(data) / numRates_M);
            std = (float)Stats.sd(data);
            mode = (float)Stats.mode(data);
            median = (float)Stats.median(data);
            sps.add(String.format("Average value of all ratings: %f", Float.valueOf(mean)));
            sps.add(String.format("Standard deviation of all ratings: %f", Float.valueOf(std)));
            sps.add(String.format("Mode of all rating values: %f", Float.valueOf(mode)));
            sps.add(String.format("Median of all rating values: %f", Float.valueOf(median)));
            sps.add("Distribution of rate counts per IC pair: mean = " + Stats.mean(this.ratingDist_ic) + ", median = " + Stats.median(this.ratingDist_ic) + ", sd = " + Stats.sd(this.ratingDist_ic));
            sps.add("");
            ArrayList<Double> urates = new ArrayList<Double>();
            ArrayList<Double> urates_c = new ArrayList<Double>();
            ArrayList<Double> irates = new ArrayList<Double>();
            ArrayList<Double> irates_c = new ArrayList<Double>();
            for (int u : this.rateMatrix_UI.rows()) {
                if (!this.rateMatrix_UC.rows().contains(u)) continue;
                sv = this.rateMatrix_UI.row(u);
                svc = this.rateMatrix_UC.row(u);
                if (sv.size() == 0 || svc.size() == 0) continue;
                urates.add(sv.mean());
                urates_c.add(svc.mean());
            }
            for (int i : this.rateMatrix_UI.columns()) {
                if (!this.rateMatrix_IC.rows().contains(i)) continue;
                sv = this.rateMatrix_UI.column(i);
                svc = this.rateMatrix_IC.row(i);
                if (sv.size() == 0 || svc.size() == 0) continue;
                irates.add(sv.mean());
                irates_c.add(svc.mean());
            }
            TTest tt = new TTest();
            sps.add("Paired t-test on user's average rating between UI and UC matrix: absolute mean diff = " + Math.abs(Stats.mean(urates) - Stats.mean(urates_c)) + ", p-value = " + tt.pairedTTest(Doubles.toArray(urates), Doubles.toArray(urates_c)));
            sps.add("Paired t-test on item's average rating between UI and IC matrix: absolute mean diff = " + Math.abs(Stats.mean(irates) - Stats.mean(irates_c)) + ", p-value = " + tt.pairedTTest(Doubles.toArray(irates), Doubles.toArray(irates_c)));
        }
        Logs.info(Strings.toSection(sps));
    }

    public int numUserItems() {
        return this.uiIds.size();
    }

    public int numContexts() {
        return this.ctxIds.size();
    }

    public int numUsers() {
        return this.userIds.size();
    }

    public int numItems() {
        return this.itemIds.size();
    }

    public int numRatings() {
        return this.numRatings;
    }

    public int numContextDims() {
        return this.dimIds.size();
    }

    public int numConditions() {
        return this.condIds.size();
    }

    public int getUserId(String rawId) {
        return (Integer)this.userIds.get(rawId);
    }

    public String getUserId(int innerId) {
        if (this.idUsers == null) {
            this.idUsers = this.userIds.inverse();
        }
        return (String)this.idUsers.get(innerId);
    }

    public int getItemId(String rawId) {
        return (Integer)this.itemIds.get(rawId);
    }

    public String getItemId(int innerId) {
        if (this.idItems == null) {
            this.idItems = this.itemIds.inverse();
        }
        return (String)this.idItems.get(innerId);
    }

    public int getUserItemId(String rawId) {
        if (this.uiIds.containsKey(rawId)) {
            return (Integer)this.uiIds.get(rawId);
        }
        return -1;
    }

    public int getUserItemId(String rawUserId, String rawItemId) {
        int inn_uid = this.getUserId(rawUserId);
        int inn_iid = this.getItemId(rawItemId);
        return this.getUserItemId(inn_uid + "," + inn_iid);
    }

    public Collection<Integer> getUserRatedList(int innerId) {
        return this.uRatedList.get(innerId);
    }

    public Collection<Integer> getItemRatedList(int innerId) {
        return this.iRatedList.get(innerId);
    }

    public String getUserItemId(int innerId) {
        if (this.idUIs == null) {
            this.idUIs = this.uiIds.inverse();
        }
        return (String)this.idUIs.get(innerId);
    }

    public int getDimensionByConditionId(int innerId) {
        return this.condDimensionMap.get(innerId);
    }

    public Collection<Integer> getConditionByDimensionId(int innerId) {
        return this.dimConditionsList.get(innerId);
    }

    public int getContextDimensionId(String rawId) {
        return (Integer)this.dimIds.get(rawId);
    }

    public String getContextDimensionId(int innerId) {
        if (this.idDims == null) {
            this.idDims = this.dimIds.inverse();
        }
        return (String)this.idDims.get(innerId);
    }

    public int getContextConditionId(String rawId) {
        return (Integer)this.condIds.get(rawId);
    }

    public String getContextConditionId(int innerId) {
        if (this.idConds == null) {
            this.idConds = this.condIds.inverse();
        }
        return (String)this.idConds.get(innerId);
    }

    public int getContextId(String rawId) {
        if (rawId.contains(":")) {
            String[] ccs = rawId.toLowerCase().split(",");
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (int i = 0; i < ccs.length; ++i) {
                set.add(this.getContextConditionId(ccs[i].trim()));
            }
            StringBuilder sb = new StringBuilder();
            Iterator itor = set.iterator();
            while (itor.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(itor.next());
            }
            return this.getContextId(sb.toString());
        }
        int id = (Integer)this.ctxIds.get(rawId);
        return id;
    }

    public String getContextId(int innerId) {
        if (this.idCtx == null) {
            this.idCtx = this.ctxIds.inverse();
        }
        return (String)this.idCtx.get(innerId);
    }

    public String getContextSituationFromInnerId(int innerId) {
        String id = this.getContextId(innerId);
        String[] ids = id.split(",");
        StringBuilder rawcontext = new StringBuilder();
        for (String index : ids) {
            if (rawcontext.length() > 0) {
                rawcontext.append(";");
            }
            rawcontext.append(this.getContextConditionId(Integer.valueOf(index)));
        }
        return rawcontext.toString();
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public carskit.data.structure.SparseMatrix getRateMatrix() {
        return this.rateMatrix;
    }

    public List<Double> getRatingScale() {
        return this.ratingScale;
    }

    public BiMap<String, Integer> getUserIds() {
        return this.userIds;
    }

    public BiMap<String, Integer> getItemIds() {
        return this.itemIds;
    }

    public BiMap<String, Integer> getUserItemIds() {
        return this.uiIds;
    }

    public BiMap<String, Integer> getContextIds() {
        return this.ctxIds;
    }

    public BiMap<String, Integer> getContextDimensionIds() {
        return this.dimIds;
    }

    public BiMap<String, Integer> getContextConditionIds() {
        return this.condIds;
    }

    public Multimap<Integer, Integer> getURatedList() {
        return this.uRatedList;
    }

    public Multimap<Integer, Integer> getIRatedList() {
        return this.iRatedList;
    }

    public Multimap<Integer, Integer> getDimConditionsList() {
        return this.dimConditionsList;
    }

    public HashMap<Integer, Integer> getConditionDimensionMap() {
        return this.condDimensionMap;
    }

    public Multimap<Integer, Integer> getConditionContextsList() {
        return this.condContextsList;
    }

    public HashMap<Integer, ArrayList<Integer>> getContextConditionsList() {
        return this.contextConditionsList;
    }

    public ArrayList<Integer> getEmptyContextConditions() {
        return this.EmptyContextConditions;
    }

    public int getUserIdFromUI(int uiid) {
        return this.uiUserIds.get(uiid);
    }

    public int getItemIdFromUI(int uiid) {
        return this.uiItemIds.get(uiid);
    }

    public HashMap<Integer, Integer> getUiUserIds() {
        return this.uiUserIds;
    }

    public HashMap<Integer, Integer> getUiItemIds() {
        return this.uiItemIds;
    }

    public double getRatingMax() {
        if (this.MaxRate == -1.0) {
            this.MaxRate = Collections.max(this.getRatingScale());
        }
        return this.MaxRate;
    }

    public double getRatingMin() {
        if (this.MaxRate == -1.0) {
            this.MinRate = Collections.min(this.getRatingScale());
        }
        return this.MinRate;
    }

    public String getDataName() {
        if (this.dataName == null) {
            this.dataName = this.dataPath.substring(this.dataPath.lastIndexOf(File.separator) + 1, this.dataPath.lastIndexOf("."));
        }
        return this.dataName;
    }

    public String getDataDirectory() {
        if (this.dataDir == null) {
            int pos = this.dataPath.lastIndexOf(File.separator);
            this.dataDir = pos > 0 ? this.dataPath.substring(0, pos + 1) : "." + File.separator;
        }
        return this.dataDir;
    }

    public HashMap<Integer, HashMultimap<Integer, Integer>> getUserCtxList(carskit.data.structure.SparseMatrix sm) {
        HashMap<Integer, HashMultimap<Integer, Integer>> uciList = new HashMap<Integer, HashMultimap<Integer, Integer>>();
        for (int uiid : sm.rows()) {
            int[] ctx;
            int uid = this.getUserIdFromUI(uiid);
            SparseVector sv = sm.row(uiid);
            if (sv.getCount() <= 0) continue;
            for (int c : ctx = sv.getIndex()) {
                int itemid = this.getItemIdFromUI(uiid);
                if (uciList.containsKey(uid)) {
                    uciList.get(uid).put((Object)c, (Object)itemid);
                    continue;
                }
                HashMultimap cis = HashMultimap.create();
                cis.put((Object)c, (Object)itemid);
                uciList.put(uid, cis);
            }
        }
        return uciList;
    }

    public HashMap<Integer, HashMultimap<Integer, Integer>> getUserCtxList(carskit.data.structure.SparseMatrix sm, double rateThreshold) {
        HashMap<Integer, HashMultimap<Integer, Integer>> uciList = new HashMap<Integer, HashMultimap<Integer, Integer>>();
        for (int uiid : sm.rows()) {
            int[] ctx;
            int uid = this.getUserIdFromUI(uiid);
            SparseVector sv = sm.row(uiid);
            if (sv.getCount() <= 0) continue;
            for (int c : ctx = sv.getIndex()) {
                if (!(sv.get(c) > rateThreshold)) continue;
                int itemid = this.getItemIdFromUI(uiid);
                if (uciList.containsKey(uid)) {
                    uciList.get(uid).put((Object)c, (Object)itemid);
                    continue;
                }
                HashMultimap cis = HashMultimap.create();
                cis.put((Object)c, (Object)itemid);
                uciList.put(uid, cis);
            }
        }
        return uciList;
    }

    public HashMap<Integer, HashMultimap<Integer, Integer>> getCtxUserList(carskit.data.structure.SparseMatrix sm) {
        HashMap<Integer, HashMultimap<Integer, Integer>> cuiList = new HashMap<Integer, HashMultimap<Integer, Integer>>();
        for (int c : sm.columns()) {
            int[] uis;
            SparseVector sv = sm.column(c);
            if (sv.getCount() <= 0) continue;
            for (int uiid : uis = sv.getIndex()) {
                int uid = this.getUserIdFromUI(uiid);
                int itemid = this.getItemIdFromUI(uiid);
                if (cuiList.containsKey(c)) {
                    cuiList.get(c).put((Object)uid, (Object)itemid);
                    continue;
                }
                HashMultimap uiss = HashMultimap.create();
                uiss.put((Object)uid, (Object)itemid);
                cuiList.put(c, uiss);
            }
        }
        return cuiList;
    }

    public HashMap<Integer, HashMultimap<Integer, Integer>> getCtxUserList(carskit.data.structure.SparseMatrix sm, double rateThreshold) {
        HashMap<Integer, HashMultimap<Integer, Integer>> cuiList = new HashMap<Integer, HashMultimap<Integer, Integer>>();
        for (int c : sm.columns()) {
            int[] uis;
            SparseVector sv = sm.column(c);
            if (sv.getCount() <= 0) continue;
            for (int uiid : uis = sv.getIndex()) {
                if (!(sv.get(uiid) > rateThreshold)) continue;
                int uid = this.getUserIdFromUI(uiid);
                int itemid = this.getItemIdFromUI(uiid);
                if (cuiList.containsKey(c)) {
                    cuiList.get(c).put((Object)uid, (Object)itemid);
                    continue;
                }
                HashMultimap uiss = HashMultimap.create();
                uiss.put((Object)uid, (Object)itemid);
                cuiList.put(c, uiss);
            }
        }
        return cuiList;
    }

    public Set<Integer> getRatedItemsList(carskit.data.structure.SparseMatrix sm, int uid) {
        HashSet<Integer> list = new HashSet<Integer>();
        Collection<Integer> uiids = this.uRatedList.get(uid);
        for (Integer ui : uiids) {
            if (sm.row(ui).getCount() <= 0) continue;
            list.add(this.getItemIdFromUI(ui));
        }
        return list;
    }

    public Set<Integer> getItemList(carskit.data.structure.SparseMatrix sm) {
        HashSet<Integer> items = new HashSet<Integer>();
        for (int uiid : sm.rows()) {
            items.add(this.getItemIdFromUI(uiid));
        }
        return items;
    }

    public Set<Integer> getUserList(carskit.data.structure.SparseMatrix sm) {
        HashSet<Integer> users = new HashSet<Integer>();
        for (int uiid : sm.rows()) {
            users.add(this.getUserIdFromUI(uiid));
        }
        return users;
    }

    public boolean isHeadline() {
        return this.isHeadline;
    }

    public void setHeadline(boolean isHeadline) {
        this.isHeadline = isHeadline;
    }

    public SparseTensor getRateTensor() {
        return this.rateTensor;
    }

    public SparseMatrix toTraditionalSparseMatrix(carskit.data.structure.SparseMatrix sm) {
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        for (int uiid : sm.rows()) {
            int uid = this.getUserIdFromUI(uiid);
            int iid = this.getItemIdFromUI(uiid);
            SparseVector sv = sm.row(uiid);
            if (sv.getCount() <= 0) continue;
            dataTable.put(uid, iid, sv.mean());
            colMap.put(iid, uid);
        }
        return new SparseMatrix(this.numUsers(), this.numItems(), dataTable, colMap);
    }

    public int getRatingCountByItem(carskit.data.structure.SparseMatrix sm, int itemid) {
        int total = 0;
        for (int ui : this.iRatedList.get(itemid)) {
            total += sm.getColumns(ui).size();
        }
        return total;
    }

    public double getUserContextAvg(carskit.data.structure.SparseMatrix sm, int userId, int contextId) {
        Collection<Integer> uiids = this.uRatedList.get(userId);
        String sctx = (String)this.idCtx.get(contextId);
        String[] conditions = sctx.split(",");
        double[] sums = new double[conditions.length];
        double[] counters = new double[conditions.length];
        for (Integer ui : uiids) {
            List<Integer> ctx = sm.getColumns(ui);
            for (Integer c : ctx) {
                for (int i = 0; i < conditions.length; ++i) {
                    Collection<Integer> ccs = this.condContextsList.get(Integer.valueOf(conditions[i]));
                    if (!ccs.contains(c)) continue;
                    int n = i;
                    sums[n] = sums[n] + sm.get(ui, c);
                    int n2 = i;
                    counters[n2] = counters[n2] + 1.0;
                }
            }
        }
        double avg = 0.0;
        double counter = 0.0;
        for (int i = 0; i < sums.length; ++i) {
            if (!(counters[i] > 0.0)) continue;
            avg += sums[i] / counters[i];
            counter += 1.0;
        }
        if (counter > 0.0) {
            return avg /= counter;
        }
        return 0.0;
    }

    public double getItemContextAvg(carskit.data.structure.SparseMatrix sm, int itemId, int contextId) {
        Collection<Integer> uiids = this.iRatedList.get(itemId);
        String sctx = (String)this.idCtx.get(contextId);
        String[] conditions = sctx.split(",");
        double[] sums = new double[conditions.length];
        double[] counters = new double[conditions.length];
        for (Integer ui : uiids) {
            List<Integer> ctx = sm.getColumns(ui);
            for (Integer c : ctx) {
                for (int i = 0; i < conditions.length; ++i) {
                    Collection<Integer> ccs = this.condContextsList.get(Integer.valueOf(conditions[i]));
                    if (!ccs.contains(c)) continue;
                    int n = i;
                    sums[n] = sums[n] + sm.get(ui, c);
                    int n2 = i;
                    counters[n2] = counters[n2] + 1.0;
                }
            }
        }
        double avg = 0.0;
        double counter = 0.0;
        for (int i = 0; i < sums.length; ++i) {
            if (!(counters[i] > 0.0)) continue;
            avg += sums[i] / counters[i];
            counter += 1.0;
        }
        if (counter > 0.0) {
            return avg /= counter;
        }
        return 0.0;
    }

    public double getContextAvg(carskit.data.structure.SparseMatrix sm, int contextId) {
        String sctx = (String)this.idCtx.get(contextId);
        String[] conditions = sctx.split(",");
        double[] sums = new double[conditions.length];
        double[] counters = new double[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            int cond = Integer.valueOf(conditions[i]);
            Collection<Integer> ctx = this.condContextsList.get(cond);
            for (Integer c : ctx) {
                SparseVector sv = sm.column(c);
                if (sv.size() == 0) continue;
                int n = i;
                sums[n] = sums[n] + sv.sum();
                int n2 = i;
                counters[n2] = counters[n2] + (double)sv.size();
            }
        }
        double avg = 0.0;
        double counter = 0.0;
        for (int i = 0; i < sums.length; ++i) {
            if (!(counters[i] > 0.0)) continue;
            avg += sums[i] / counters[i];
            counter += 1.0;
        }
        if (counter > 0.0) {
            return avg /= counter;
        }
        return 0.0;
    }
}

