/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.transformation.prefiltering;

import carskit.data.structure.SparseMatrix;
import carskit.eval.Measures;
import carskit.generic.ContextRecommender;
import carskit.generic.Recommender;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import happy.coding.io.FileIO;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.math.Stats;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.VectorEntry;

public class SPF
extends ContextRecommender {
    protected double th;
    protected int itembased;
    protected double mean;
    protected double beta;
    protected HashMap<Integer, Double> bu;
    protected HashMap<Integer, Double> bi;
    protected DenseMatrix C;
    protected DenseMatrix E;
    protected int f;
    protected int t;
    protected double r;
    protected double l;

    public SPF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        DenseVector eBias;
        SparseMatrix sm;
        SparseVector sv;
        int i;
        this.isCARSRecommender = false;
        this.algoName = "SPF";
        this.th = algoOptions.getDouble("-th");
        this.itembased = algoOptions.getInt("-i");
        this.beta = algoOptions.getDouble("-b");
        this.f = algoOptions.getInt("-f", 10);
        this.t = algoOptions.getInt("-t", 90);
        this.r = algoOptions.getDouble("-r", 0.01);
        this.l = algoOptions.getDouble("-l", 0.01);
        this.mean = this.globalMean;
        this.bu = new HashMap();
        this.bi = new HashMap();
        if (this.train == null) {
            this.train = rateDao.toTraditionalSparseMatrix(trainMatrix);
        }
        for (i = 0; i < this.numUsers; ++i) {
            sv = this.train.row(i);
            double avgu = sv.getCount() > 0 ? sv.mean() : this.globalMean;
            this.bu.put(i, avgu - this.mean);
        }
        for (i = 0; i < this.numItems; ++i) {
            sv = this.train.column(i);
            double avgi = sv.getCount() > 0 ? sv.mean() : this.globalMean;
            this.bi.put(i, avgi - this.mean);
        }
        DenseVector cBias = new DenseVector(numConditions);
        if (this.itembased == 1) {
            sm = this.getCIMatrix();
            eBias = new DenseVector(this.numItems);
        } else {
            sm = this.getCUMatrix();
            eBias = new DenseVector(this.numUsers);
        }
        cBias.init(initMean, initStd);
        eBias.init(initMean, initStd);
        this.C = new DenseMatrix(sm.numRows(), this.f);
        this.E = new DenseMatrix(sm.numColumns(), this.f);
        if (this.initByNorm) {
            this.C.init(initMean, initStd);
            this.E.init(initMean, initStd);
        } else {
            this.C.init();
            this.E.init();
        }
        this.trainMF(sm, cBias, eBias, this.C, this.E, this.f, this.t, this.l, this.r, this.r, this.r);
    }

    protected void trainMF(SparseMatrix train, DenseVector cBias, DenseVector eBias, DenseMatrix C, DenseMatrix E, int numFactors, int numIters, double lRate, double regB, double regU, double regI) {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : train) {
                int c = me.row();
                int j = me.column();
                double rcj = me.get();
                double pred = this.globalMean + cBias.get(c) + eBias.get(j) + DenseMatrix.rowMult(C, c, E, j);
                double ecj = rcj - pred;
                this.loss += ecj * ecj;
                double bc = cBias.get(c);
                double sgd = ecj - regB * bc;
                cBias.add(c, lRate * sgd);
                this.loss += regB * bc * bc;
                double bj = eBias.get(j);
                sgd = ecj - regB * bj;
                eBias.add(j, lRate * sgd);
                this.loss += regB * bj * bj;
                for (int f = 0; f < numFactors; ++f) {
                    double pcf = C.get(c, f);
                    double qjf = E.get(j, f);
                    double delta_c = ecj * qjf - regU * pcf;
                    double delta_j = ecj * pcf - regI * qjf;
                    C.add(c, f, lRate * delta_c);
                    E.add(j, f, lRate * delta_j);
                    this.loss += regU * pcf * pcf + regI * qjf * qjf;
                }
            }
            this.loss *= 0.5;
        }
    }

    protected SparseMatrix getCUMatrix() {
        int u;
        HashBasedTable<Integer, Integer, Double> dataTable_cu = HashBasedTable.create();
        HashBasedTable<Integer, Integer, Double> dataTable_cu_count = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            int ui = matrixEntry.row();
            u = rateDao.getUserIdFromUI(ui);
            int j = rateDao.getItemIdFromUI(ui);
            int ctx = matrixEntry.column();
            Collection cs = rateDao.getContextConditionsList().get(ctx);
            double rujc = matrixEntry.get();
            double bui = this.mean + this.bu.get(u) + this.bi.get(j);
            Iterator i$ = cs.iterator();
            while (i$.hasNext()) {
                int c = (Integer)i$.next();
                if (dataTable_cu.contains(c, u)) {
                    dataTable_cu.put(c, u, (Double)dataTable_cu.get(c, u) + rujc - bui);
                    dataTable_cu_count.put(c, u, (Double)dataTable_cu_count.get(c, u) + 1.0);
                    continue;
                }
                dataTable_cu.put(c, u, rujc - bui);
                dataTable_cu_count.put(c, u, 1.0);
            }
        }
        for (Table.Cell cell : dataTable_cu.cellSet()) {
            int c = (Integer)cell.getRowKey();
            u = (Integer)cell.getColumnKey();
            dataTable_cu.put(c, u, (Double)cell.getValue() / (this.beta + (Double)dataTable_cu_count.get(c, u)));
            colMap.put(u, c);
        }
        return new SparseMatrix(numConditions, this.numUsers, (Table<Integer, Integer, Double>)dataTable_cu, (Multimap<Integer, Integer>)colMap);
    }

    protected SparseMatrix getCIMatrix() {
        HashBasedTable<Integer, Integer, Double> dataTable_ci = HashBasedTable.create();
        HashBasedTable<Integer, Integer, Double> dataTable_ci_count = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            int ui = matrixEntry.row();
            int u = rateDao.getUserIdFromUI(ui);
            int j = rateDao.getItemIdFromUI(ui);
            int ctx = matrixEntry.column();
            Collection cs = rateDao.getContextConditionsList().get(ctx);
            double rujc = matrixEntry.get();
            double bui = this.mean + this.bu.get(u) + this.bi.get(j);
            Iterator i$ = cs.iterator();
            while (i$.hasNext()) {
                int c = (Integer)i$.next();
                if (dataTable_ci.contains(c, j)) {
                    dataTable_ci.put(c, j, (Double)dataTable_ci.get(c, j) + rujc - bui);
                    dataTable_ci_count.put(c, j, (Double)dataTable_ci_count.get(c, j) + 1.0);
                    continue;
                }
                dataTable_ci.put(c, j, rujc - bui);
                dataTable_ci_count.put(c, j, 1.0);
            }
        }
        for (Table.Cell cell : dataTable_ci.cellSet()) {
            int c = (Integer)cell.getRowKey();
            int j = (Integer)cell.getColumnKey();
            dataTable_ci.put(c, j, (Double)cell.getValue() / (this.beta + (Double)dataTable_ci_count.get(c, j)));
            colMap.put(j, c);
        }
        return new SparseMatrix(numConditions, this.numItems, (Table<Integer, Integer, Double>)dataTable_ci, (Multimap<Integer, Integer>)colMap);
    }

    protected DenseVector getContextVector(int ctx) {
        Collection css = rateDao.getContextConditionsList().get(ctx);
        DenseVector v_ctx = new DenseVector(this.C.numColumns());
        Iterator i$ = css.iterator();
        while (i$.hasNext()) {
            int index_cs = (Integer)i$.next();
            v_ctx = v_ctx.add(this.C.row(index_cs));
        }
        for (int i = 0; i < this.C.numColumns(); ++i) {
            v_ctx.set(i, v_ctx.get(i) / (double)css.size());
        }
        return v_ctx;
    }

    protected double cosineSimilarity(DenseVector v1, DenseVector v2) {
        int size = v1.getData().length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int i = 0; i < size; ++i) {
            sum1 += v1.get(i) * v2.get(i);
            sum2 += v1.get(i) * v1.get(i);
            sum3 += v2.get(i) * v2.get(i);
        }
        return sum1 / (Math.sqrt(sum2) * Math.sqrt(sum3));
    }

    protected SparseMatrix getUIMatrix(int ctx) {
        DenseVector vc_target = this.getContextVector(ctx);
        HashBasedTable<Integer, Integer, Double> dataTable_ui = HashBasedTable.create();
        HashBasedTable<Integer, Integer, Double> dataTable_ui_count = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        for (MatrixEntry me : this.trainMatrix) {
            int ui = me.row();
            int u = rateDao.getUserIdFromUI(ui);
            int j = rateDao.getItemIdFromUI(ui);
            int c = me.column();
            DenseVector vc_current = this.getContextVector(c);
            double sim = this.cosineSimilarity(vc_target, vc_current);
            if (sim >= this.th) {
                double rujc = me.get();
                if (dataTable_ui.contains(u, j)) {
                    dataTable_ui.put(u, j, (Double)dataTable_ui.get(u, j));
                    dataTable_ui_count.put(u, j, (Double)dataTable_ui_count.get(u, j) + 1.0);
                } else {
                    dataTable_ui.put(u, j, rujc);
                    dataTable_ui_count.put(u, j, 1.0);
                }
            }
            for (Table.Cell cell : dataTable_ui.cellSet()) {
                int uu = (Integer)cell.getRowKey();
                int jj = (Integer)cell.getColumnKey();
                dataTable_ui.put(uu, jj, (Double)cell.getValue() / (Double)dataTable_ui_count.get(uu, jj));
                colMap.put(jj, uu);
            }
        }
        return new SparseMatrix(this.numUsers, this.numItems, (Table<Integer, Integer, Double>)dataTable_ui, (Multimap<Integer, Integer>)colMap);
    }

    @Override
    protected Map<Recommender.Measure, Double> evalRankings() throws Exception {
        int numTopNRanks;
        HashMap<Integer, HashMultimap<Integer, Integer>> cuiList = rateDao.getCtxUserList(this.testMatrix, binThold);
        HashMap<Integer, HashMultimap<Integer, Integer>> cuiList_train = rateDao.getCtxUserList(this.trainMatrix);
        int capacity = cuiList.keySet().size();
        ArrayList<Double> ds5 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> ds10 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> dsN = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> precs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> precs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> precsN = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls5 = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls10 = new ArrayList<Double>(capacity);
        ArrayList<Double> recallsN = new ArrayList<Double>(capacity);
        ArrayList<Double> aps5 = new ArrayList<Double>(capacity);
        ArrayList<Double> aps10 = new ArrayList<Double>(capacity);
        ArrayList<Double> apsN = new ArrayList<Double>(capacity);
        ArrayList<Double> rrs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> rrs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> rrsN = new ArrayList<Double>(capacity);
        ArrayList<Double> aucs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> aucs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> aucsN = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgsN = new ArrayList<Double>(capacity);
        Set<Integer> candItems = rateDao.getItemList(this.trainMatrix);
        ArrayList<String> preds = null;
        String toFile = null;
        int n = numTopNRanks = numRecs < 0 ? 10 : numRecs;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("# userId: recommendations in (itemId, ranking score) pairs, where a correct recommendation is denoted by symbol *.");
            toFile = workingPath + String.format("%s-top-%d-items%s.txt", this.algoName, numTopNRanks, this.foldInfo);
            FileIO.deleteFile(toFile);
        }
        if (verbose) {
            Logs.debug("{}{} has candidate items: {}", this.algoName, this.foldInfo, candItems.size());
        }
        if (numIgnore > 0) {
            ArrayList itemDegs = new ArrayList();
            for (Integer j : candItems) {
                itemDegs.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(j, rateDao.getRatingCountByItem(this.trainMatrix, j)));
            }
            Lists.sortList(itemDegs, true);
            int k = 0;
            for (Map.Entry entry : itemDegs) {
                candItems.remove(entry.getKey());
                if (++k < numIgnore) continue;
                break;
            }
        }
        for (int ctx : cuiList.keySet()) {
            Multimap uis = cuiList.get(ctx);
            int n2 = uis.keySet().size();
            ArrayList<Double> c_ds5 = new ArrayList<Double>(isDiverseUsed ? n2 : 0);
            ArrayList<Double> c_ds10 = new ArrayList<Double>(isDiverseUsed ? n2 : 0);
            ArrayList<Double> c_dsN = new ArrayList<Double>(isDiverseUsed ? n2 : 0);
            ArrayList<Double> c_precs5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_precs10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_precsN = new ArrayList<Double>(n2);
            ArrayList<Double> c_recalls5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_recalls10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_recallsN = new ArrayList<Double>(n2);
            ArrayList<Double> c_aps5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_aps10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_apsN = new ArrayList<Double>(n2);
            ArrayList<Double> c_rrs5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_rrs10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_rrsN = new ArrayList<Double>(n2);
            ArrayList<Double> c_aucs5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_aucs10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_aucsN = new ArrayList<Double>(n2);
            ArrayList<Double> c_ndcgs5 = new ArrayList<Double>(n2);
            ArrayList<Double> c_ndcgs10 = new ArrayList<Double>(n2);
            ArrayList<Double> c_ndcgsN = new ArrayList<Double>(n2);
            HashMultimap uList_train = cuiList_train.containsKey(ctx) ? cuiList_train.get(ctx) : HashMultimap.create();
            SparseMatrix UIM = this.getUIMatrix(ctx);
            this.userBias = new DenseVector(this.numUsers);
            this.itemBias = new DenseVector(this.numItems);
            this.userBias.init(initMean, initStd);
            this.itemBias.init(initMean, initStd);
            this.trainMF(UIM, this.userBias, this.itemBias, this.P, this.Q, numFactors, numIters, this.lRate, regB, regU, regI);
            Iterator i$ = uis.keySet().iterator();
            while (i$.hasNext()) {
                int u = (Integer)i$.next();
                if (verbose && (u + 1) % 100 == 0) {
                    Logs.debug("{}{} evaluates progress: {} / {}", this.algoName, this.foldInfo, u + 1, capacity);
                }
                int numCands = candItems.size();
                Collection posItems = uis.get(u);
                ArrayList<Integer> correctItems = new ArrayList<Integer>();
                for (Integer j : posItems) {
                    if (!candItems.contains(j)) continue;
                    correctItems.add(j);
                }
                if (correctItems.size() == 0) continue;
                Set ratedItems = uList_train.containsKey(u) ? uList_train.get((Object)u) : new HashSet();
                ArrayList itemScores = new ArrayList(Lists.initSize(candItems));
                for (Integer j : candItems) {
                    if (!ratedItems.contains(j)) {
                        double rank = this.ranking(u, j, ctx);
                        if (Double.isNaN(rank) || !(rank > (double)binThold)) continue;
                        itemScores.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(j, rank));
                        continue;
                    }
                    --numCands;
                }
                if (itemScores.size() == 0) continue;
                Lists.sortList(itemScores, true);
                ArrayList recomd = numRecs <= 0 || itemScores.size() <= numRecs ? itemScores : itemScores.subList(0, numRecs);
                ArrayList<Integer> rankedItems = new ArrayList<Integer>();
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (Map.Entry entry : recomd) {
                    Integer item = (Integer)entry.getKey();
                    rankedItems.add(item);
                    if (!this.isResultsOut || count >= numTopNRanks) continue;
                    sb.append("(").append(rateDao.getItemId(item));
                    if (posItems.contains(item)) {
                        sb.append("*");
                    }
                    sb.append(", ").append(((Double)entry.getValue()).floatValue()).append(")");
                    if (++count >= numTopNRanks) break;
                    if (count >= numTopNRanks) continue;
                    sb.append(", ");
                }
                int numDropped = numCands - rankedItems.size();
                double d = Measures.AUC(rankedItems, correctItems, numDropped);
                double AP = Measures.AP(rankedItems, correctItems);
                double nDCG = Measures.nDCG(rankedItems, correctItems);
                double RR = Measures.RR(rankedItems, correctItems);
                List<Integer> cutoffs = Arrays.asList(5, 10, numRecs);
                Map<Integer, Double> precs = Measures.PrecAt(rankedItems, correctItems, cutoffs);
                Map<Integer, Double> recalls = Measures.RecallAt(rankedItems, correctItems, cutoffs);
                Map<Integer, Double> aucs = Measures.AUCAt(rankedItems, correctItems, numDropped, cutoffs);
                Map<Integer, Double> aps = Measures.APAt(rankedItems, correctItems, cutoffs);
                Map<Integer, Double> ndcgs = Measures.nDCGAt(rankedItems, correctItems, cutoffs);
                Map<Integer, Double> rrs = Measures.RRAt(rankedItems, correctItems, cutoffs);
                c_precs5.add(precs.get(5));
                c_precs10.add(precs.get(10));
                c_precsN.add(precs.get(numRecs));
                c_recalls5.add(recalls.get(5));
                c_recalls10.add(recalls.get(10));
                c_recallsN.add(recalls.get(numRecs));
                c_aucs5.add(aucs.get(5));
                c_aps5.add(aps.get(5));
                c_rrs5.add(rrs.get(5));
                c_ndcgs5.add(ndcgs.get(5));
                c_aucs10.add(aucs.get(10));
                c_aps10.add(aps.get(10));
                c_rrs10.add(rrs.get(10));
                c_ndcgs10.add(ndcgs.get(10));
                c_aucsN.add(aucs.get(numRecs));
                c_apsN.add(aps.get(numRecs));
                c_rrsN.add(rrs.get(numRecs));
                c_ndcgsN.add(ndcgs.get(numRecs));
                if (isDiverseUsed) {
                    double d5 = this.diverseAt(rankedItems, 5);
                    double d10 = this.diverseAt(rankedItems, 10);
                    double dN = this.diverseAt(rankedItems, numRecs);
                    c_ds5.add(d5);
                    c_ds10.add(d10);
                    c_dsN.add(dN);
                }
                if (!this.isResultsOut) continue;
                preds.add(rateDao.getUserId(u) + ", " + rateDao.getContextSituationFromInnerId(ctx) + ": " + sb.toString());
                if (preds.size() < 1000) continue;
                FileIO.writeList(toFile, preds, true);
                preds.clear();
            }
            ds5.add(isDiverseUsed ? Stats.mean(c_ds5) : 0.0);
            ds10.add(isDiverseUsed ? Stats.mean(c_ds10) : 0.0);
            dsN.add(isDiverseUsed ? Stats.mean(c_dsN) : 0.0);
            precs5.add(Stats.mean(c_precs5));
            precs10.add(Stats.mean(c_precs10));
            precsN.add(Stats.mean(c_precsN));
            recalls5.add(Stats.mean(c_recalls5));
            recalls10.add(Stats.mean(c_recalls10));
            recallsN.add(Stats.mean(c_recallsN));
            aucs5.add(Stats.mean(c_aucs5));
            ndcgs5.add(Stats.mean(c_ndcgs5));
            aps5.add(Stats.mean(c_aps5));
            rrs5.add(Stats.mean(c_rrs5));
            aucs10.add(Stats.mean(c_aucs10));
            ndcgs10.add(Stats.mean(c_ndcgs10));
            aps10.add(Stats.mean(c_aps10));
            rrs10.add(Stats.mean(c_rrs10));
            aucsN.add(Stats.mean(c_aucsN));
            ndcgsN.add(Stats.mean(c_ndcgsN));
            apsN.add(Stats.mean(c_apsN));
            rrsN.add(Stats.mean(c_rrsN));
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen item recommendations to {}", this.algoName, this.foldInfo, toFile);
        }
        HashMap<Recommender.Measure, Double> measures = new HashMap<Recommender.Measure, Double>();
        measures.put(Recommender.Measure.D5, isDiverseUsed ? Stats.mean(ds5) : 0.0);
        measures.put(Recommender.Measure.D10, isDiverseUsed ? Stats.mean(ds10) : 0.0);
        measures.put(Recommender.Measure.DN, isDiverseUsed ? Stats.mean(dsN) : 0.0);
        measures.put(Recommender.Measure.Pre5, Stats.mean(precs5));
        measures.put(Recommender.Measure.Pre10, Stats.mean(precs10));
        measures.put(Recommender.Measure.PreN, Stats.mean(precsN));
        measures.put(Recommender.Measure.Rec5, Stats.mean(recalls5));
        measures.put(Recommender.Measure.Rec10, Stats.mean(recalls10));
        measures.put(Recommender.Measure.RecN, Stats.mean(recallsN));
        measures.put(Recommender.Measure.AUC5, Stats.mean(aucs5));
        measures.put(Recommender.Measure.NDCG5, Stats.mean(ndcgs5));
        measures.put(Recommender.Measure.MAP5, Stats.mean(aps5));
        measures.put(Recommender.Measure.MRR5, Stats.mean(rrs5));
        measures.put(Recommender.Measure.AUC10, Stats.mean(aucs10));
        measures.put(Recommender.Measure.NDCG10, Stats.mean(ndcgs10));
        measures.put(Recommender.Measure.MAP10, Stats.mean(aps10));
        measures.put(Recommender.Measure.MRR10, Stats.mean(rrs10));
        measures.put(Recommender.Measure.AUCN, Stats.mean(aucsN));
        measures.put(Recommender.Measure.NDCGN, Stats.mean(ndcgsN));
        measures.put(Recommender.Measure.MAPN, Stats.mean(apsN));
        measures.put(Recommender.Measure.MRRN, Stats.mean(rrsN));
        return measures;
    }

    @Override
    protected Map<Recommender.Measure, Double> evalRatings() throws Exception {
        ArrayList<String> preds = null;
        String toFile = null;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("userId\titemId\tcontexts\trating\tprediction");
            toFile = workingPath + this.algoName + "-rating-predictions" + this.foldInfo + ".txt";
            FileIO.deleteFile(toFile);
        }
        double sum_maes = 0.0;
        double sum_mses = 0.0;
        double sum_r_maes = 0.0;
        double sum_r_rmses = 0.0;
        double sum_perps = 0.0;
        int numCount = 0;
        boolean numPEs = false;
        Iterator<Integer> i$ = this.testMatrix.columns().iterator();
        while (i$.hasNext()) {
            int col;
            int ctx = col = i$.next().intValue();
            SparseMatrix UIM = this.getUIMatrix(ctx);
            this.userBias = new DenseVector(this.numUsers);
            this.itemBias = new DenseVector(this.numItems);
            this.userBias.init(initMean, initStd);
            this.itemBias.init(initMean, initStd);
            this.trainMF(UIM, this.userBias, this.itemBias, this.P, this.Q, numFactors, numIters, this.lRate, regB, regU, regI);
            for (VectorEntry en : this.testMatrix.column(ctx)) {
                int j;
                int ui = en.index();
                double rate = en.get();
                int u = rateDao.getUserIdFromUI(ui);
                double pred = this.predict(u, j = rateDao.getItemIdFromUI(ui), ctx, true);
                if (Double.isNaN(pred)) continue;
                double perp = this.perplexity(u, j, pred);
                sum_perps += perp;
                double rPred = (double)Math.round(pred / minRate) * minRate;
                double err = Math.abs(rate - pred);
                double r_err = Math.abs(rate - rPred);
                sum_maes += err;
                sum_mses += err * err;
                sum_r_maes += r_err;
                sum_r_rmses += r_err * r_err;
                ++numCount;
                if (!this.isResultsOut) continue;
                preds.add(rateDao.getUserId(u) + "\t" + rateDao.getItemId(j) + "\t" + rateDao.getContextSituationFromInnerId(ctx) + "\t" + rate + "\t" + (float)pred);
                if (preds.size() < 1000) continue;
                FileIO.writeList(toFile, preds, true);
                preds.clear();
            }
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen rating predictions to {}", this.algoName, this.foldInfo, toFile);
        }
        double mae = sum_maes / (double)numCount;
        double rmse = Math.sqrt(sum_mses / (double)numCount);
        double r_mae = sum_r_maes / (double)numCount;
        double r_rmse = Math.sqrt(sum_r_rmses / (double)numCount);
        HashMap<Recommender.Measure, Double> measures = new HashMap<Recommender.Measure, Double>();
        measures.put(Recommender.Measure.MAE, mae);
        measures.put(Recommender.Measure.NMAE, mae / (maxRate - minRate));
        measures.put(Recommender.Measure.RMSE, rmse);
        measures.put(Recommender.Measure.rMAE, r_mae);
        measures.put(Recommender.Measure.rRMSE, r_rmse);
        measures.put(Recommender.Measure.MPE, ((double)numPEs + 0.0) / (double)numCount);
        if (sum_perps > 0.0) {
            measures.put(Recommender.Measure.Perplexity, Math.exp(sum_perps / (double)numCount));
        }
        return measures;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.globalMean + this.userBias.get(u) + this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{"numFactors: " + numFactors, "numIter: " + numIters, "lrate: " + initLRate, "maxlrate: " + maxLRate, "regB: " + regB, "regU: " + regU, "regI: " + regI, "regC: " + regC, "knn: " + knn, "-i: " + this.itembased, "-b: " + this.beta, "-th: " + this.th, "isBoldDriver: " + isBoldDriver});
    }
}

