/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.dependent.sim;

import carskit.alg.cars.adaptation.dependent.CSLIM;
import carskit.data.setting.Configuration;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

@Configuration(value="binThold, knn, regLw2, regLw1, similarity, iters, rc")
public class GCSLIM_ICS
extends CSLIM {
    private DenseMatrix W;
    private Multimap<Integer, Integer> itemNNs;
    private List<Integer> allItems;

    public GCSLIM_ICS(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.isCARSRecommender = false;
        this.algoName = "GCSLIM_ICS";
        this.regLw1 = algoOptions.getFloat("-lw1");
        this.regLw2 = algoOptions.getFloat("-lw2");
        knn = algoOptions.getInt("-k");
    }

    @Override
    protected void initModel() throws Exception {
        int j;
        super.initModel();
        this.ccMatrix_ICS = new SymmMatrix(numConditions);
        for (int i = 0; i < numConditions; ++i) {
            for (j = 0; j < numConditions; ++j) {
                this.ccMatrix_ICS.set(i, j, 1.0);
            }
        }
        this.W = new DenseMatrix(this.numItems, this.numItems);
        this.W.init();
        this.userCache = this.train.rowCache(cacheSpec);
        if (knn > 0) {
            SymmMatrix itemCorrs = this.buildCorrs(false);
            this.itemNNs = HashMultimap.create();
            for (j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
                Map<Integer, Double> nns = itemCorrs.row(j).toMap();
                if (knn > 0 && knn < nns.size()) {
                    List<Map.Entry<Integer, Double>> sorted = Lists.sortMap(nns, true);
                    List<Map.Entry<Integer, Double>> subset = sorted.subList(0, knn);
                    nns.clear();
                    for (Map.Entry<Integer, Double> kv : subset) {
                        nns.put(kv.getKey(), kv.getValue());
                    }
                }
                for (Map.Entry<Integer, Double> en : nns.entrySet()) {
                    this.itemNNs.put(j, en.getKey());
                }
            }
        } else {
            this.allItems = this.train.columns();
            for (int j2 = 0; j2 < this.numItems; ++j2) {
                this.W.set(j2, j2, 0.0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int index2;
                Iterator i$;
                int ui = me.row();
                int u = rateDao.getUserIdFromUI(ui);
                int j = rateDao.getItemIdFromUI(ui);
                int c = me.column();
                double rujc = me.get();
                HashBasedTable toBeUpdated_sim_factor = HashBasedTable.create();
                HashBasedTable toBeUpdated_w_factor = HashBasedTable.create();
                List<Integer> conditions = this.getConditions(c);
                List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
                SparseVector Ru = (SparseVector)this.userCache.get(u);
                double pred = 0.0;
                Iterator i$2 = nns.iterator();
                while (i$2.hasNext()) {
                    int k = (Integer)i$2.next();
                    if (!Ru.contains(k) || k == j) continue;
                    String key = u + "," + k;
                    int uiid = rateDao.getUserItemId(key);
                    List<Integer> ctxid = this.trainMatrix.getColumns(uiid);
                    Random r = new Random();
                    int index = r.nextInt(ctxid.size());
                    int ctx = ctxid.get(index);
                    List<Integer> conditions_from = this.getConditions(ctx);
                    double ruk = this.trainMatrix.get(uiid, ctx);
                    double acc = ruk * this.W.get(k, j);
                    double simc = 1.0;
                    for (int i = 0; i < conditions.size(); ++i) {
                        int index1 = conditions.get(i);
                        int index22 = conditions_from.get(i);
                        double sim = 1.0;
                        if (index1 != index22) {
                            sim = this.ccMatrix_ICS.get(index1, index22);
                            double update_factor = acc / sim;
                            if (toBeUpdated_sim_factor.contains(index1, index22)) {
                                update_factor += ((Double)toBeUpdated_sim_factor.get(index1, index22)).doubleValue();
                            }
                            toBeUpdated_sim_factor.put((Object)index1, (Object)index22, (Object)update_factor);
                            simc *= sim;
                        }
                        this.loss += (double)regC * sim * sim;
                    }
                    Iterator i$3 = toBeUpdated_sim_factor.rowKeySet().iterator();
                    while (i$3.hasNext()) {
                        int row = (Integer)i$3.next();
                        Iterator i$4 = toBeUpdated_sim_factor.row((Object)row).keySet().iterator();
                        while (i$4.hasNext()) {
                            int col = (Integer)i$4.next();
                            toBeUpdated_sim_factor.put((Object)row, (Object)col, (Object)(simc * (Double)toBeUpdated_sim_factor.get(row, col)));
                        }
                    }
                    toBeUpdated_w_factor.put((Object)k, (Object)j, (Object)(ruk * simc));
                    pred += acc * simc;
                }
                double rating = pred;
                double eujc = rujc - pred;
                this.loss += eujc * eujc;
                if (toBeUpdated_sim_factor.size() > 0) {
                    i$ = toBeUpdated_sim_factor.rowKeySet().iterator();
                    while (i$.hasNext()) {
                        int index1 = (Integer)i$.next();
                        Iterator i$5 = toBeUpdated_sim_factor.row((Object)index1).keySet().iterator();
                        while (i$5.hasNext()) {
                            index2 = (Integer)i$5.next();
                            double update = this.ccMatrix_ICS.get(index1, index2);
                            update += this.lRate * (eujc * (Double)toBeUpdated_sim_factor.get(index1, index2) - (double)regC * update);
                            this.ccMatrix_ICS.set(index1, index2, update);
                        }
                    }
                }
                if (toBeUpdated_w_factor.size() <= 0) continue;
                i$ = toBeUpdated_w_factor.rowKeySet().iterator();
                while (i$.hasNext()) {
                    int index1 = (Integer)i$.next();
                    Iterator i$6 = toBeUpdated_w_factor.row((Object)index1).keySet().iterator();
                    while (i$6.hasNext()) {
                        index2 = (Integer)i$6.next();
                        double update = this.W.get(index1, index2);
                        this.loss += (double)this.regLw2 * update * update + (double)this.regLw1 * update;
                        double delta_w = eujc * (Double)toBeUpdated_w_factor.get(index1, index2) - (double)this.regLw2 * update - (double)this.regLw1;
                        this.W.set(index1, index2, update += this.lRate * delta_w);
                    }
                }
            }
        }
    }

    protected double predict(int u, int j, int c, boolean exclude, int excluded_item) throws Exception {
        List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
        SparseVector Ru = (SparseVector)this.userCache.get(u);
        List<Integer> conditions = this.getConditions(c);
        double pred = 0.0;
        Iterator i$ = nns.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (!Ru.contains(k) || exclude && k == excluded_item) continue;
            String key = u + "," + k;
            int uiid = rateDao.getUserItemId(key);
            List<Integer> ctxid = this.trainMatrix.getColumns(uiid);
            Random r = new Random();
            int index = r.nextInt(ctxid.size());
            int ctx = ctxid.get(index);
            List<Integer> conditions_from = this.getConditions(ctx);
            double ruk = this.trainMatrix.get(uiid, ctx);
            double sim = 1.0;
            for (int i = 0; i < conditions.size(); ++i) {
                sim *= this.ccMatrix_ICS.get(conditions.get(i), conditions_from.get(i));
            }
            pred += ruk * this.W.get(k, j) * sim;
        }
        return pred;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, true, j);
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.last_loss - this.loss;
        this.last_loss = this.loss;
        if (verbose) {
            Logs.debug("{}{} iter {}: loss = {}, delta_loss = {}", this.algoName, this.foldInfo, iter, this.loss, delta_loss);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }
}

