/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.dependent.sim;

import carskit.alg.cars.adaptation.dependent.CSLIM;
import carskit.data.setting.Configuration;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

@Configuration(value="binThold, knn, regLw2, regLw1, similarity, iters, rc")
public class CSLIM_LCS
extends CSLIM {
    private DenseMatrix W;
    private Multimap<Integer, Integer> itemNNs;
    private List<Integer> allItems;

    public CSLIM_LCS(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.isCARSRecommender = false;
        this.algoName = "CSLIM_LCS";
        this.regLw1 = algoOptions.getFloat("-lw1");
        this.regLw2 = algoOptions.getFloat("-lw2");
        knn = algoOptions.getInt("-k");
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.cfMatrix_LCS = new DenseMatrix(numConditions, numFactors);
        this.cfMatrix_LCS.init();
        this.W = new DenseMatrix(this.numItems, this.numItems);
        this.W.init();
        this.userCache = this.train.rowCache(cacheSpec);
        if (knn > 0) {
            SymmMatrix itemCorrs = this.buildCorrs(false);
            this.itemNNs = HashMultimap.create();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
                Map<Integer, Double> nns = itemCorrs.row(j).toMap();
                if (knn > 0 && knn < nns.size()) {
                    List<Map.Entry<Integer, Double>> sorted = Lists.sortMap(nns, true);
                    List<Map.Entry<Integer, Double>> subset = sorted.subList(0, knn);
                    nns.clear();
                    for (Map.Entry<Integer, Double> kv : subset) {
                        nns.put(kv.getKey(), kv.getValue());
                    }
                }
                for (Map.Entry<Integer, Double> en : nns.entrySet()) {
                    this.itemNNs.put(j, en.getKey());
                }
            }
        } else {
            this.allItems = this.train.columns();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                Iterator<Object> i$;
                int ui = me.row();
                int u = rateDao.getUserIdFromUI(ui);
                int j = rateDao.getItemIdFromUI(ui);
                int c = me.column();
                double rujc = me.get();
                HashBasedTable toBeUpdated = HashBasedTable.create();
                List<Integer> conditions = this.getConditions(c);
                double simc = 1.0;
                for (int i = 0; i < conditions.size(); ++i) {
                    int index1 = conditions.get(i);
                    int index2 = (Integer)EmptyContextConditions.get(i);
                    double sim = 1.0;
                    if (index1 != index2) {
                        sim = DenseMatrix.rowMult(this.cfMatrix_LCS, index1, this.cfMatrix_LCS, index2);
                        sim = sim > 1.0 ? 1.0 - this.lowbound : sim;
                        sim = sim < -1.0 ? -1.0 + this.lowbound : sim;
                        toBeUpdated.put((Object)index1, (Object)index2, (Object)sim);
                        simc *= sim;
                    }
                    this.loss += (double)regC * sim * sim;
                }
                List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
                SparseVector Ru = (SparseVector)this.userCache.get(u);
                double pred = 0.0;
                Iterator i$2 = nns.iterator();
                while (i$2.hasNext()) {
                    int k = (Integer)i$2.next();
                    if (!Ru.contains(k) || k == j) continue;
                    double ruk = Ru.get(k);
                    pred += ruk * this.W.get(k, j);
                }
                double rating = pred;
                double eujc = rujc - (pred *= simc);
                this.loss += eujc * eujc;
                if (toBeUpdated.size() > 0) {
                    Iterator i$3 = toBeUpdated.rowKeySet().iterator();
                    while (i$3.hasNext()) {
                        int index1 = (Integer)i$3.next();
                        i$ = toBeUpdated.row((Object)index1).keySet().iterator();
                        while (i$.hasNext()) {
                            int index2 = (Integer)i$.next();
                            for (int f = 0; f < numFactors; ++f) {
                                double c1f = this.cfMatrix_LCS.get(index1, f);
                                double c2f = this.cfMatrix_LCS.get(index2, f);
                                double sim = (Double)toBeUpdated.get(index1, index2);
                                double delta_c1 = eujc * rating * simc * c2f / sim - (double)regC * c1f;
                                double delta_c2 = eujc * rating * simc * c1f / sim - (double)regC * c2f;
                                this.cfMatrix_LCS.add(index1, f, this.lRate * delta_c1);
                                this.cfMatrix_LCS.add(index2, f, this.lRate * delta_c2);
                                this.loss += (double)regC * c1f * c1f + (double)regC * c2f * c2f;
                            }
                        }
                    }
                }
                double sum_w = 0.0;
                i$ = nns.iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    double update = this.W.get(k, j);
                    sum_w += update;
                    this.loss += (double)this.regLw2 * update * update + (double)this.regLw1 * update;
                    double delta_w = eujc * Ru.get(k) * simc - (double)this.regLw2 * update - (double)this.regLw1;
                    this.W.set(k, j, update += this.lRate * delta_w);
                }
            }
        }
    }

    protected double predict(int u, int j, int c, boolean exclude, int excluded_item) throws Exception {
        List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
        SparseVector Ru = (SparseVector)this.userCache.get(u);
        List<Integer> conditions = this.getConditions(c);
        double sim = 1.0;
        for (int i = 0; i < conditions.size(); ++i) {
            double[] dv1 = this.cfMatrix_LCS.row(conditions.get(i)).getData();
            double[] dv2 = this.cfMatrix_LCS.row((Integer)EmptyContextConditions.get(i)).getData();
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int h = 0; h < dv1.length; ++h) {
                sum1 += dv1[h] * dv1[h];
                sum2 += dv2[h] * dv2[h];
            }
            sum1 = Math.sqrt(sum1);
            sum2 = Math.sqrt(sum2);
            sim *= DenseMatrix.rowMult(this.cfMatrix_LCS, conditions.get(i), this.cfMatrix_LCS, (Integer)EmptyContextConditions.get(i)) / (sum1 * sum2);
        }
        double pred = 0.0;
        Iterator i$ = nns.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (!Ru.contains(k) || exclude && k == excluded_item) continue;
            double ruk = Ru.get(k);
            pred += ruk * this.W.get(k, j);
        }
        return pred *= sim;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, true, j);
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.last_loss - this.loss;
        this.last_loss = this.loss;
        if (verbose) {
            Logs.debug("{}{} iter {}: loss = {}, delta_loss = {}", this.algoName, this.foldInfo, iter, this.loss, delta_loss);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }
}

