/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.dependent.sim;

import carskit.alg.cars.adaptation.dependent.CSLIM;
import carskit.data.setting.Configuration;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

@Configuration(value="binThold, knn, regLw2, regLw1, similarity, iters, rc")
public class CSLIM_ICS
extends CSLIM {
    private DenseMatrix W;
    private Multimap<Integer, Integer> itemNNs;
    private List<Integer> allItems;

    public CSLIM_ICS(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.isCARSRecommender = false;
        this.algoName = "CSLIM_ICS";
        this.regLw1 = algoOptions.getFloat("-lw1");
        this.regLw2 = algoOptions.getFloat("-lw2");
        knn = algoOptions.getInt("-k");
    }

    @Override
    protected void initModel() throws Exception {
        int j;
        super.initModel();
        this.ccMatrix_ICS = new SymmMatrix(numConditions);
        for (int i = 0; i < numConditions; ++i) {
            for (j = 0; j < numConditions; ++j) {
                this.ccMatrix_ICS.set(i, j, 1.0);
            }
        }
        this.W = new DenseMatrix(this.numItems, this.numItems);
        this.W.init();
        this.userCache = this.train.rowCache(cacheSpec);
        if (knn > 0) {
            SymmMatrix itemCorrs = this.buildCorrs(false);
            this.itemNNs = HashMultimap.create();
            for (j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
                Map<Integer, Double> nns = itemCorrs.row(j).toMap();
                if (knn > 0 && knn < nns.size()) {
                    List<Map.Entry<Integer, Double>> sorted = Lists.sortMap(nns, true);
                    List<Map.Entry<Integer, Double>> subset = sorted.subList(0, knn);
                    nns.clear();
                    for (Map.Entry<Integer, Double> kv : subset) {
                        nns.put(kv.getKey(), kv.getValue());
                    }
                }
                for (Map.Entry<Integer, Double> en : nns.entrySet()) {
                    this.itemNNs.put(j, en.getKey());
                }
            }
        } else {
            this.allItems = this.train.columns();
            for (int j2 = 0; j2 < this.numItems; ++j2) {
                this.W.set(j2, j2, 0.0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                Iterator i$;
                int ui = me.row();
                int u = rateDao.getUserIdFromUI(ui);
                int j = rateDao.getItemIdFromUI(ui);
                int c = me.column();
                double rujc = me.get();
                HashBasedTable toBeUpdated = HashBasedTable.create();
                List<Integer> conditions = this.getConditions(c);
                double simc = 1.0;
                for (int i = 0; i < conditions.size(); ++i) {
                    int index1 = conditions.get(i);
                    int index2 = (Integer)EmptyContextConditions.get(i);
                    double sim = 1.0;
                    if (index1 != index2) {
                        sim = this.ccMatrix_ICS.get(index1, index2);
                        toBeUpdated.put((Object)index1, (Object)index2, (Object)sim);
                        simc *= sim;
                    }
                    this.loss += (double)regC * sim * sim;
                }
                List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
                SparseVector Ru = (SparseVector)this.userCache.get(u);
                double pred = 0.0;
                Iterator i$2 = nns.iterator();
                while (i$2.hasNext()) {
                    int k = (Integer)i$2.next();
                    if (!Ru.contains(k) || k == j) continue;
                    double ruk = Ru.get(k);
                    pred += ruk * this.W.get(k, j);
                }
                double rating = pred;
                double eujc = rujc - (pred *= simc);
                this.loss += eujc * eujc;
                if (toBeUpdated.size() > 0) {
                    i$ = toBeUpdated.rowKeySet().iterator();
                    while (i$.hasNext()) {
                        int index1 = (Integer)i$.next();
                        Iterator i$3 = toBeUpdated.row((Object)index1).keySet().iterator();
                        while (i$3.hasNext()) {
                            int index2 = (Integer)i$3.next();
                            double update = (Double)toBeUpdated.get(index1, index2);
                            update += this.lRate * (eujc * rating * simc / update - (double)regC * update);
                            this.ccMatrix_ICS.set(index1, index2, update);
                        }
                    }
                }
                i$ = nns.iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    double update = this.W.get(k, j);
                    this.loss += (double)this.regLw2 * update * update + (double)this.regLw1 * update;
                    double delta_w = eujc * Ru.get(k) * simc - (double)this.regLw2 * update - (double)this.regLw1;
                    this.W.set(k, j, update += this.lRate * delta_w);
                }
            }
        }
    }

    protected double predict(int u, int j, int c, boolean exclude, int excluded_item) throws Exception {
        List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
        SparseVector Ru = (SparseVector)this.userCache.get(u);
        List<Integer> conditions = this.getConditions(c);
        double sim = 1.0;
        for (int i = 0; i < conditions.size(); ++i) {
            sim *= this.ccMatrix_ICS.get(conditions.get(i), (Integer)EmptyContextConditions.get(i));
        }
        double pred = 0.0;
        Iterator i$ = nns.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (!Ru.contains(k) || exclude && k == excluded_item) continue;
            double ruk = Ru.get(k);
            pred += ruk * this.W.get(k, j);
        }
        return pred *= sim;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, true, j);
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.last_loss - this.loss;
        this.last_loss = this.loss;
        if (verbose) {
            Logs.debug("{}{} iter {}: loss = {}, delta_loss = {}", this.algoName, this.foldInfo, iter, this.loss, delta_loss);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }
}

