/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.dependent.dev;

import carskit.alg.cars.adaptation.dependent.CSLIM;
import carskit.data.setting.Configuration;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

@Configuration(value="binThold, knn, regLw2, regLw1, regLc2, regLc1, similarity, iters, rc")
public class GCSLIM_CC
extends CSLIM {
    private DenseMatrix W;
    private Multimap<Integer, Integer> itemNNs;
    private List<Integer> allItems;

    public GCSLIM_CC(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.isCARSRecommender = false;
        this.algoName = "GCSLIM_CC";
        this.regLw1 = algoOptions.getFloat("-lw1");
        this.regLw2 = algoOptions.getFloat("-lw2");
        this.regLc1 = algoOptions.getFloat("-lc1");
        this.regLc2 = algoOptions.getFloat("-lc2");
        knn = algoOptions.getInt("-k");
        this.als = algoOptions.getInt("-als");
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.ccDev = new DenseMatrix(numConditions, numConditions);
        this.ccDev.init();
        for (int i = 0; i < numConditions; ++i) {
            this.ccDev.set(i, i, 0.0);
        }
        this.W = new DenseMatrix(this.numItems, this.numItems);
        this.W.init();
        this.userCache = this.train.rowCache(cacheSpec);
        if (knn > 0) {
            SymmMatrix itemCorrs = this.buildCorrs(false);
            this.itemNNs = HashMultimap.create();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
                Map<Integer, Double> nns = itemCorrs.row(j).toMap();
                if (knn > 0 && knn < nns.size()) {
                    List<Map.Entry<Integer, Double>> sorted = Lists.sortMap(nns, true);
                    List<Map.Entry<Integer, Double>> subset = sorted.subList(0, knn);
                    nns.clear();
                    for (Map.Entry<Integer, Double> kv : subset) {
                        nns.put(kv.getKey(), kv.getValue());
                    }
                }
                for (Map.Entry<Integer, Double> en : nns.entrySet()) {
                    this.itemNNs.put(j, en.getKey());
                }
            }
        } else {
            this.allItems = this.train.columns();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                Iterator i$;
                int ui = me.row();
                int u = rateDao.getUserIdFromUI(ui);
                int j = rateDao.getItemIdFromUI(ui);
                int c = me.column();
                double rujc = me.get();
                List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
                SparseVector Ru = (SparseVector)this.userCache.get(u);
                HashBasedTable Dev_weights = HashBasedTable.create();
                HashBasedTable Weight_devs = HashBasedTable.create();
                double pred = 0.0;
                Iterator i$2 = nns.iterator();
                while (i$2.hasNext()) {
                    int k = (Integer)i$2.next();
                    if (!Ru.contains(k) || k == j) continue;
                    String key = u + "," + k;
                    int uiid = rateDao.getUserItemId(key);
                    List<Integer> ctxid = this.trainMatrix.getColumns(uiid);
                    Random r = new Random();
                    int index = r.nextInt(ctxid.size());
                    int ctx = ctxid.get(index);
                    double ruk = this.trainMatrix.get(uiid, ctx);
                    String[] sfrom = rateDao.getContextId(ctx).split(",");
                    String[] sto = rateDao.getContextId(c).split(",");
                    double dev_c = 0.0;
                    double w = this.W.get(k, j);
                    for (int i = 0; i < sfrom.length; ++i) {
                        int cond1 = Integer.valueOf(sfrom[i]);
                        int cond2 = Integer.valueOf(sto[i]);
                        dev_c += this.ccDev.get(cond1, cond2);
                        if (cond1 == cond2) continue;
                        if (Dev_weights.contains(cond1, cond2)) {
                            Dev_weights.put((Object)cond1, (Object)cond2, (Object)(w + (Double)Dev_weights.get(cond1, cond2)));
                            continue;
                        }
                        Dev_weights.put((Object)cond1, (Object)cond2, (Object)w);
                    }
                    Weight_devs.put((Object)k, (Object)j, (Object)(dev_c + ruk));
                    pred += (ruk + dev_c) * w;
                }
                double eujc = rujc - pred;
                this.loss += eujc * eujc;
                Iterator i$3 = Weight_devs.rowKeySet().iterator();
                while (i$3.hasNext()) {
                    int idk = (Integer)i$3.next();
                    i$ = Weight_devs.row((Object)idk).keySet().iterator();
                    while (i$.hasNext()) {
                        int idj = (Integer)i$.next();
                        double update = this.W.get(idk, idj);
                        this.loss += (double)this.regLw2 * update * update + (double)this.regLw1 * update;
                        double delta_w = eujc * (Double)Weight_devs.get(idk, idj) - (double)this.regLw2 * update - (double)this.regLw1;
                        this.W.set(idk, idj, update += this.lRate * delta_w);
                    }
                }
                i$3 = Dev_weights.rowKeySet().iterator();
                while (i$3.hasNext()) {
                    int cond1 = (Integer)i$3.next();
                    i$ = Dev_weights.row((Object)cond1).keySet().iterator();
                    while (i$.hasNext()) {
                        int cond2 = (Integer)i$.next();
                        double update = this.ccDev.get(cond1, cond2);
                        this.loss += (double)this.regLc2 * update * update + (double)this.regLc1 * update;
                        double delta_c = eujc * (Double)Dev_weights.get(cond1, cond2) - (double)this.regLc2 * update - (double)this.regLc1;
                        this.ccDev.set(cond1, cond2, update += this.lRate * delta_c);
                    }
                }
            }
        }
    }

    protected double predict(int u, int j, int c, boolean exclude, int excluded_item) throws Exception {
        List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
        SparseVector Ru = (SparseVector)this.userCache.get(u);
        double pred = 0.0;
        Iterator i$ = nns.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (!Ru.contains(k) || exclude && k == excluded_item) continue;
            String key = u + "," + k;
            int uiid = rateDao.getUserItemId(key);
            List<Integer> ctxid = this.trainMatrix.getColumns(uiid);
            Random r = new Random();
            int index = r.nextInt(ctxid.size());
            int ctx = ctxid.get(index);
            double ruk = this.trainMatrix.get(uiid, ctx);
            double dev_c = this.getDeviation(ctx, c);
            pred += (ruk + dev_c) * this.W.get(k, j);
        }
        return pred;
    }

    private double getDeviation(int from, int to) {
        String[] sfrom = rateDao.getContextId(from).split(",");
        String[] sto = rateDao.getContextId(to).split(",");
        double sum = 0.0;
        for (int i = 0; i < sfrom.length; ++i) {
            sum += this.ccDev.get(Integer.valueOf(sfrom[i]), Integer.valueOf(sto[i]));
        }
        return sum;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, true, j);
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.last_loss - this.loss;
        this.last_loss = this.loss;
        if (verbose) {
            Logs.debug("{}{} iter {}: loss = {}, delta_loss = {}", this.algoName, this.foldInfo, iter, this.loss, delta_loss);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }
}

