# coding: utf-8

"""
    Aspose.PDF Cloud API Reference


Copyright (c) 2022 Aspose.PDF Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.



    OpenAPI spec version: 3.0
    
"""


from pprint import pformat
from six import iteritems
import re


class Border(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'width': 'int',
        'effect_intensity': 'int',
        'style': 'BorderStyle',
        'effect': 'BorderEffect',
        'dash': 'Dash',
        'color': 'Color'
    }

    attribute_map = {
        'width': 'Width',
        'effect_intensity': 'EffectIntensity',
        'style': 'Style',
        'effect': 'Effect',
        'dash': 'Dash',
        'color': 'Color'
    }

    def __init__(self, width=None, effect_intensity=None, style=None, effect=None, dash=None, color=None):
        """
        Border - a model defined in Swagger
        """

        self._width = None
        self._effect_intensity = None
        self._style = None
        self._effect = None
        self._dash = None
        self._color = None

        if width is not None:
          self.width = width
        if effect_intensity is not None:
          self.effect_intensity = effect_intensity
        if style is not None:
          self.style = style
        if effect is not None:
          self.effect = effect
        if dash is not None:
          self.dash = dash
        if color is not None:
          self.color = color

    @property
    def width(self):
        """
        Gets the width of this Border.
        Gets or sets border width.

        :return: The width of this Border.
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Sets the width of this Border.
        Gets or sets border width.

        :param width: The width of this Border.
        :type: int
        """

        self._width = width

    @property
    def effect_intensity(self):
        """
        Gets the effect_intensity of this Border.
        Gets or sets effect intencity. Valid range of value is [0..2].

        :return: The effect_intensity of this Border.
        :rtype: int
        """
        return self._effect_intensity

    @effect_intensity.setter
    def effect_intensity(self, effect_intensity):
        """
        Sets the effect_intensity of this Border.
        Gets or sets effect intencity. Valid range of value is [0..2].

        :param effect_intensity: The effect_intensity of this Border.
        :type: int
        """

        self._effect_intensity = effect_intensity

    @property
    def style(self):
        """
        Gets the style of this Border.
        Gets or sets border style.

        :return: The style of this Border.
        :rtype: BorderStyle
        """
        return self._style

    @style.setter
    def style(self, style):
        """
        Sets the style of this Border.
        Gets or sets border style.

        :param style: The style of this Border.
        :type: BorderStyle
        """

        self._style = style

    @property
    def effect(self):
        """
        Gets the effect of this Border.
        Gets or sets border effect.

        :return: The effect of this Border.
        :rtype: BorderEffect
        """
        return self._effect

    @effect.setter
    def effect(self, effect):
        """
        Sets the effect of this Border.
        Gets or sets border effect.

        :param effect: The effect of this Border.
        :type: BorderEffect
        """

        self._effect = effect

    @property
    def dash(self):
        """
        Gets the dash of this Border.
        Gets or sets dash pattern.

        :return: The dash of this Border.
        :rtype: Dash
        """
        return self._dash

    @dash.setter
    def dash(self, dash):
        """
        Sets the dash of this Border.
        Gets or sets dash pattern.

        :param dash: The dash of this Border.
        :type: Dash
        """

        self._dash = dash

    @property
    def color(self):
        """
        Gets the color of this Border.
        Gets or sets border color.

        :return: The color of this Border.
        :rtype: Color
        """
        return self._color

    @color.setter
    def color(self, color):
        """
        Sets the color of this Border.
        Gets or sets border color.

        :param color: The color of this Border.
        :type: Color
        """

        self._color = color

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Border):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
