#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_tag2segment']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.0,<0.6.0',
 'pandas==1.2.3',
 'collections-extended',
 'PyICU']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'dirty-equals']}

entry_points = \
{'pyprocessors.plugins': ['tag2segment = '
                          'pyprocessors_tag2segment.tag2segment:Tag2SegmentProcessor']}

setup(name='pyprocessors-tag2segment',
      version='0.5.11',
      description='Sherpa Consolidation processor',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyprocessors_tag2segment/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
