/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 J\u000e\u0010#\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010$\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u000e\u0010(\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0012\u0010)\u001a\n **\u0004\u0018\u00010\b0\b*\u00020\bJ\f\u0010+\u001a\u00020\b*\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lutils/ArtifactFileUtils;", "", "()V", "MAX_FILE_NAME_LENGTH", "", "conversion", "", "Lkotlin/Pair;", "", "appendExtension", "basename", "extension", "dirName", "filePath", "ensureFolderExists", "", "dirString", "getBasenameOnly", "fileName", "getCertoraDir", "getFilesWithExtension", "path", "ext", "getNameFromPath", "name", "getRelativeFileName", "wholePath", "newRootDir", "getResultFile", "getWriterForFile", "Ljava/io/FileWriter;", "overwrite", "", "append", "hasCertoraDir", "isSol", "isTAC", "sanitizeFileBaseName", "_filename", "extensionLength", "sanitizePath", "asUnixPath", "kotlin.jvm.PlatformType", "normalizeEncodedStringToStringWithABIChars", "SanitizedPath", "GeneralUtils"})
public final class ArtifactFileUtils {
    @NotNull
    public static final ArtifactFileUtils INSTANCE = new ArtifactFileUtils();
    @NotNull
    private static final List<Pair<String, String>> conversion;
    public static final int MAX_FILE_NAME_LENGTH = 255;

    private ArtifactFileUtils() {
    }

    public final String asUnixPath(@NotNull String $this$asUnixPath) {
        Intrinsics.checkNotNullParameter($this$asUnixPath, "<this>");
        return FilenameUtils.separatorsToUnix($this$asUnixPath);
    }

    public final boolean hasCertoraDir() {
        return System.getenv().containsKey("CERTORA");
    }

    @NotNull
    public final String getCertoraDir() {
        String string = System.getenv("CERTORA");
        Intrinsics.checkNotNullExpressionValue(string, "getenv(\"CERTORA\")");
        return string;
    }

    @NotNull
    public final String getNameFromPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = FileUtils.filename(name);
        Intrinsics.checkNotNullExpressionValue(string, "filename(name)");
        return string;
    }

    @NotNull
    public final String getResultFile() {
        return "Results.txt";
    }

    public final void ensureFolderExists(@NotNull String dirString) {
        boolean success;
        Intrinsics.checkNotNullParameter(dirString, "dirString");
        File dir = new File(dirString);
        if (!(dir.exists() || (success = dir.mkdirs()) || dir.exists())) {
            throw new Exception("Failed to create directory " + dirString);
        }
    }

    @NotNull
    public final String getRelativeFileName(@NotNull String wholePath, @NotNull String newRootDir) {
        Intrinsics.checkNotNullParameter(wholePath, "wholePath");
        Intrinsics.checkNotNullParameter(newRootDir, "newRootDir");
        if (!StringsKt.contains$default((CharSequence)wholePath, newRootDir, false, 2, null)) {
            throw new Exception("Could not find " + newRootDir + " in " + wholePath);
        }
        int cfgDirPathIdx = 0;
        Path path = FileSystems.getDefault().getPath(wholePath, new String[0]);
        Iterator<Path> $this$getRelativeFileName_u24lambda_u2d1 = path.iterator();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$getRelativeFileName_u24lambda_u2d1, "");
        Iterator<Path> $this$forEach$iv = $this$getRelativeFileName_u24lambda_u2d1;
        boolean $i$f$forEach = false;
        Iterator<Path> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Path element$iv;
            Path it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (Intrinsics.areEqual(((Object)it).toString(), newRootDir)) break;
            ++cfgDirPathIdx;
        }
        return ((Object)path.subpath(cfgDirPathIdx, path.getNameCount())).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFilesWithExtension(@NotNull String path, @NotNull String ext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String[] lsResult = new File(path).list();
        Intrinsics.checkNotNullExpressionValue(lsResult, "lsResult");
        String[] $this$filter$iv = lsResult;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void fileName = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!ext.equals(FileUtils.extension((String)fileName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantResults = (List)destination$iv$iv;
        ArtifactFileUtilsKt.access$getLogger$p().info("For path " + path + " ls result is " + ArraysKt.asList(lsResult) + " and files matching extension " + ext + " are " + relevantResults);
        return relevantResults;
    }

    public final boolean isTAC(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return StringsKt.equals(FileUtils.extension(fileName), "tac", true);
    }

    public final boolean isSol(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return StringsKt.equals(FileUtils.extension(fileName), "sol", true);
    }

    @NotNull
    public final String getBasenameOnly(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String separators = "/|\\\\";
        CharSequence charSequence = fileName;
        Regex regex = new Regex(separators);
        int n = 0;
        String filename = CollectionsKt.last(regex.split(charSequence, n));
        boolean bl = false;
        String basename = FileUtils.basename(filename);
        Intrinsics.checkNotNullExpressionValue(basename, "basename");
        if (StringsKt.last(basename) == '.') {
            String string2 = basename.substring(0, basename.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = basename;
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue(string3, "fileName.split(Regex(sep\u2026          }\n            }");
        return string3;
    }

    private final String sanitizeFileBaseName(String _filename, int extensionLength) {
        Object object;
        String filename = null;
        filename = _filename;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getFirst(), p.getSecond(), false, 4, null);
        }
        int maxLength = 255 - extensionLength;
        if (!(maxLength > 1)) {
            boolean bl = false;
            String string = "extension length (" + extensionLength + ") larger than 255 -- unexpected";
            throw new IllegalArgumentException(string.toString());
        }
        if (filename.length() > maxLength) {
            String string = Integer.toString(filename.hashCode(), CharsKt.checkRadix(36));
            Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
            String hash2 = string;
            if (!(maxLength - 1 - hash2.length() > 1)) {
                boolean bl = false;
                String string2 = "hash (" + hash2 + ") is longer than a more-than-max-length file name (" + filename + ") -- unexpected";
                throw new IllegalStateException(string2.toString());
            }
            String string3 = filename.substring(0, maxLength - 1 - hash2.length());
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string3 + "_" + hash2;
        } else {
            object = filename;
        }
        return object;
    }

    private final String appendExtension(String basename, String extension) {
        if (!(!StringsKt.contains$default((CharSequence)extension, ".", false, 2, null))) {
            boolean bl = false;
            String string = "File name extension (" + extension + ") contains a \".\".";
            throw new IllegalArgumentException(string.toString());
        }
        return ((CharSequence)extension).length() == 0 ? basename : basename + "." + extension;
    }

    private final String dirName(String filePath) {
        String dir = FileUtils.dirname(filePath);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(dir, "dir");
        return !StringsKt.isBlank(dir) ? dir + File.separator : "";
    }

    @NotNull
    public final String sanitizePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return new SanitizedPath(filePath).getSanitizedFullPath();
    }

    @NotNull
    public final FileWriter getWriterForFile(@NotNull String filePath, boolean overwrite, boolean append) {
        Object object;
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        SanitizedPath sanitizedPath = new SanitizedPath(filePath);
        if (new File(sanitizedPath.getSanitizedFullPath()).exists() && !overwrite) {
            String string = LocalDateTime.now().toString();
            Intrinsics.checkNotNullExpressionValue(string, "now().toString()");
            String uniqueSuffix = "_" + StringsKt.replace$default(string, ':', '-', false, 4, null);
            if (sanitizedPath.getSanitizedFileBaseName().length() + uniqueSuffix.length() + 1 + sanitizedPath.getFileExtension().length() > 255) {
                if (!(sanitizedPath.getSanitizedFileBaseName().length() - uniqueSuffix.length() > 1)) {
                    boolean bl = false;
                    String string2 = "length of sanitized file name (" + sanitizedPath + ".sanitizedFileBaseName) minus length of uniqueSuffix (" + uniqueSuffix + ") is negative, even though the expected file length exceeds the maximum allowed file name length (255) --> unexpected ";
                    throw new IllegalStateException(string2.toString());
                }
                String string3 = sanitizedPath.getSanitizedFileBaseName().substring(0, sanitizedPath.getSanitizedFileBaseName().length() - uniqueSuffix.length());
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = string3 + uniqueSuffix;
            } else {
                object = sanitizedPath.getSanitizedFileBaseName() + uniqueSuffix;
            }
        } else {
            object = sanitizedPath.getSanitizedFileBaseName();
        }
        String nonConflictingFileBaseName = object;
        String actualFileName = sanitizedPath.getDirPart() + this.appendExtension(nonConflictingFileBaseName, sanitizedPath.getFileExtension());
        return new FileWriter(actualFileName, append);
    }

    public static /* synthetic */ FileWriter getWriterForFile$default(ArtifactFileUtils artifactFileUtils, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getWriterForFile(string, bl, bl2);
    }

    @Deprecated(message="Never use this function. DO NOT reintroduce any translation back to strings with ABI chars", level=DeprecationLevel.ERROR)
    @NotNull
    public final String normalizeEncodedStringToStringWithABIChars(@NotNull String $this$normalizeEncodedStringToStringWithABIChars) {
        Intrinsics.checkNotNullParameter($this$normalizeEncodedStringToStringWithABIChars, "<this>");
        String filename = $this$normalizeEncodedStringToStringWithABIChars;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getSecond(), p.getFirst(), false, 4, null);
        }
        return filename;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<String, String>("(", "LP"), new Pair<String, String>(")", "RP"), new Pair<String, String>(",", "C"), new Pair<String, String>("[", "LB"), new Pair<String, String>("]", "RB"), new Pair<String, String>("[]", "LBRB"), new Pair<String, String>("uint256", "U256"), new Pair<String, String>("address", "ADR"), new Pair<String, String>("bytes32", "B32")};
        conversion = CollectionsKt.listOf(pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lutils/ArtifactFileUtils$SanitizedPath;", "", "filePath", "", "(Ljava/lang/String;)V", "dirPart", "getDirPart", "()Ljava/lang/String;", "fileExtension", "getFileExtension", "sanitizedFileBaseName", "getSanitizedFileBaseName", "sanitizedFullPath", "getSanitizedFullPath", "GeneralUtils"})
    public static final class SanitizedPath {
        @NotNull
        private final String dirPart;
        @NotNull
        private final String fileExtension;
        @NotNull
        private final String sanitizedFileBaseName;
        @NotNull
        private final String sanitizedFullPath;

        public SanitizedPath(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter(filePath, "filePath");
            this.dirPart = INSTANCE.dirName(filePath);
            String string = FileUtils.extension(filePath);
            Intrinsics.checkNotNullExpressionValue(string, "extension(filePath)");
            this.fileExtension = string;
            this.sanitizedFileBaseName = INSTANCE.sanitizeFileBaseName(INSTANCE.getBasenameOnly(filePath), this.fileExtension.length() + 1);
            this.sanitizedFullPath = this.dirPart + INSTANCE.appendExtension(this.sanitizedFileBaseName, this.fileExtension);
        }

        @NotNull
        public final String getDirPart() {
            return this.dirPart;
        }

        @NotNull
        public final String getFileExtension() {
            return this.fileExtension;
        }

        @NotNull
        public final String getSanitizedFileBaseName() {
            return this.sanitizedFileBaseName;
        }

        @NotNull
        public final String getSanitizedFullPath() {
            return this.sanitizedFullPath;
        }
    }
}

