/*
 * Decompiled with CFR 0.152.
 */
package spec;

import com.certora.evmverifier.cvl.Ast;
import com.certora.evmverifier.cvl.Lexer;
import com.certora.evmverifier.cvl.ParserCVL;
import config.Config;
import datastructures.stdcollections.SetsKt;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLAstBuilder;
import spec.CVLInput;
import spec.CVLKeywords;
import spec.CVLKeywordsKt;
import spec.CVLSource;
import spec.TypeResolver;
import spec.VMConfig;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CVLImportedSpecFile;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLInvariantProof;
import spec.cvlast.CVLPreserved;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSingleRule;
import spec.cvlast.IRule;
import spec.cvlast.MethodBlockAnnotation;
import spec.cvlast.MethodParamFilter;
import spec.cvlast.MethodParamFilters;
import spec.cvlast.OverrideDeclaration;
import spec.cvlast.OverrideDeclarations;
import spec.cvlast.SortDeclaration;
import spec.cvlast.UseDeclaration;
import spec.cvlast.typechecker.CVLError;
import spec.genericrulegenerators.BuiltInRuleGenerator;
import spec.genericrulegenerators.BuiltInRuleId;
import utils.CollectingResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lspec/CVLInput;", "", "()V", "cvlSource", "Lspec/CVLSource;", "getCvlSource", "()Lspec/CVLSource;", "getRawCVLAst", "Lutils/CollectingResult;", "Lspec/cvlast/CVLAst;", "Lspec/cvlast/typechecker/CVLError;", "resolver", "Lspec/TypeResolver;", "Companion", "Plain", "WithImportedSpecs", "Lspec/CVLInput$Plain;", "Lspec/CVLInput$WithImportedSpecs;", "Shared"})
public abstract class CVLInput {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private CVLInput() {
    }

    @NotNull
    public abstract CVLSource getCvlSource();

    @NotNull
    public abstract CollectingResult<CVLAst, CVLError> getRawCVLAst(@NotNull TypeResolver var1);

    public /* synthetic */ CVLInput(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0004J\"\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J4\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0004\u00a8\u0006\u001f"}, d2={"Lspec/CVLInput$Companion;", "", "()V", "addRepeatingIdInUseDeclsError", "Lspec/cvlast/typechecker/CVLError;", "repeatingId", "", "cvlRange", "Lspec/cvlast/CVLRange;", "addUnresolvedUseDeclsError", "unresolvedUseDecl", "Lspec/cvlast/UseDeclaration;", "getGeneratorsOfBuiltInRulesInUse", "Lutils/CollectingResult;", "", "Lspec/genericrulegenerators/BuiltInRuleGenerator;", "astWithoutMergedImports", "Lspec/cvlast/CVLAst;", "parseCVLSpec", "cvlSource", "Lspec/CVLSource;", "resolver", "Lspec/TypeResolver;", "parseCVLSpecFromReader", "reader", "Ljava/io/Reader;", "isImportedCvlSource", "", "fileName", "repeatingIdInDeclsErrorMsg", "declType", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CollectingResult<CVLAst, CVLError> parseCVLSpec(@NotNull CVLSource cvlSource, @NotNull TypeResolver resolver) {
            CollectingResult<CVLAst, CVLError> collectingResult;
            Intrinsics.checkNotNullParameter(cvlSource, "cvlSource");
            Intrinsics.checkNotNullParameter(resolver, "resolver");
            Reader reader = cvlSource.getReader();
            Closeable closeable = reader;
            Throwable throwable = null;
            try {
                Reader cvlReader = (Reader)closeable;
                boolean bl = false;
                collectingResult = Companion.parseCVLSpecFromReader(cvlReader, cvlSource.isImported(), resolver, cvlSource.getOrigpath());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return collectingResult;
        }

        /*
         * WARNING - void declaration
         */
        private final CollectingResult<CVLAst, CVLError> parseCVLSpecFromReader(Reader reader, boolean isImportedCvlSource, TypeResolver resolver, String fileName) {
            CollectingResult<CVLAst, CVLError> collectingResult;
            ComplexSymbolFactory csf = new ComplexSymbolFactory();
            Lexer lexer = new Lexer(csf, reader);
            VMConfig vmConfig = Config.INSTANCE.getVMConfig();
            List allKeywords = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)MapsKt.toList(CVLKeywordsKt.getAllCastFunctions()), (Iterable)CollectionsKt.toList((Iterable)vmConfig.getMemoryLocations())), (Iterable)CollectionsKt.toList((Iterable)vmConfig.getPreReturnMethodQualifiers())), (Iterable)CollectionsKt.toList((Iterable)vmConfig.getPostReturnMethodQualifiers()));
            if (!(CollectionsKt.distinct(allKeywords).size() == allKeywords.size())) {
                boolean $i$a$-check-CVLInput$Companion$parseCVLSpecFromReader$22 = false;
                String $i$a$-check-CVLInput$Companion$parseCVLSpecFromReader$22 = "duplicate keywords exist in " + this + " which may lead to lexer ambiguities";
                throw new IllegalStateException($i$a$-check-CVLInput$Companion$parseCVLSpecFromReader$22.toString());
            }
            lexer.setCastFunctions(CVLKeywordsKt.getAllCastFunctions());
            lexer.setMemoryLocations(vmConfig.getMemoryLocations());
            lexer.setMethodQualifiers(vmConfig.getPreReturnMethodQualifiers(), vmConfig.getPostReturnMethodQualifiers());
            lexer.setConstVals(CVLKeywords.Companion.constVals(vmConfig));
            lexer.theFilename = fileName;
            ParserCVL parser = new ParserCVL(lexer, csf);
            parser.theFilename = fileName;
            parser.isImportedFile = isImportedCvlSource;
            Symbol parsed = null;
            try {
                Symbol symbol = parser.parse();
                Intrinsics.checkNotNullExpressionValue(symbol, "parser.parse()");
                parsed = symbol;
                Object object = parsed.value;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.certora.evmverifier.cvl.Ast");
                }
                collectingResult = ((Ast)object).toCVLAst(resolver, CVLScope.Companion.getAstScope());
                Intrinsics.checkNotNullExpressionValue(collectingResult, "{\n                parsed\u2026e.AstScope)\n            }");
            }
            catch (Exception e) {
                String string;
                for (String error2 : parser.errors) {
                    Intrinsics.checkNotNullExpressionValue(error2, "error");
                    Logger.Companion.alwaysError(error2);
                }
                Logger.Companion companion = Logger.Companion;
                String string2 = e.getMessage();
                if (string2 == null) {
                    string = null;
                } else {
                    void it;
                    String string3 = string2;
                    Logger.Companion companion2 = companion;
                    boolean bl = false;
                    string = "CVL parser failed with exception. Exception message: \"" + (String)it + "\"";
                    companion = companion2;
                }
                Iterator<String> iterator2 = string;
                companion.alwaysError((String)(iterator2 == null ? "Failed to parse the CVL file " + parser.theFilename + ". Exiting." : iterator2), e);
                throw new CVLAstBuilder.CVLParsingException(e);
            }
            catch (Throwable e) {
                Logger.Companion.alwaysError("While parsing " + parser.theFilename + ", caught runtime exception in CVL parser: " + e + ": " + ExceptionsKt.stackTraceToString(e));
                throw e;
            }
            return collectingResult;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final CollectingResult<List<BuiltInRuleGenerator>, CVLError> getGeneratorsOfBuiltInRulesInUse(@NotNull CVLAst astWithoutMergedImports) {
            CollectingResult collectingResult;
            BuiltInRuleId repeatingBirId;
            Object repeatingBirsIds;
            void $this$mapTo$iv$iv;
            Object element$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(astWithoutMergedImports, "astWithoutMergedImports");
            if (astWithoutMergedImports.getUseDeclarations().getBuiltInRulesInUse().isEmpty()) {
                return CollectingResult.Companion.lift(CollectionsKt.emptyList());
            }
            Iterable $this$filter$iv = astWithoutMergedImports.getUseDeclarations().getBuiltInRulesInUse();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                UseDeclaration.BuiltInRule it = (UseDeclaration.BuiltInRule)element$iv$iv2;
                boolean bl = false;
                if (!(it.resolveBuiltInRuleId() == null)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List unresolvedBirUseDecls = (List)destination$iv$iv;
            List errors2 = new ArrayList();
            Iterable $this$forEach$iv = unresolvedBirUseDecls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UseDeclaration.BuiltInRule unresolvedDecl = (UseDeclaration.BuiltInRule)element$iv;
                boolean bl = false;
                errors2.add(Companion.addUnresolvedUseDeclsError(unresolvedDecl));
            }
            Iterable $this$mapNotNull$iv = astWithoutMergedImports.getUseDeclarations().getBuiltInRulesInUse();
            boolean $i$f$mapNotNull = false;
            Iterable element$iv = $this$mapNotNull$iv;
            Iterable<Pair<UseDeclaration.BuiltInRule, BuiltInRuleId>> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                Pair<UseDeclaration.BuiltInRule, BuiltInRuleId> pair;
                element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                UseDeclaration.BuiltInRule birUseDecl = (UseDeclaration.BuiltInRule)element$iv$iv;
                boolean bl2 = false;
                if (birUseDecl.resolveBuiltInRuleId() == null) {
                    pair = null;
                } else {
                    BuiltInRuleId it;
                    boolean bl3 = false;
                    pair = TuplesKt.to(birUseDecl, it);
                }
                if (pair == null) continue;
                Pair<UseDeclaration.BuiltInRule, BuiltInRuleId> it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List birsUseDeclsToIds = (List)destination$iv$iv2;
            Iterable $this$mapToSet$iv = birsUseDeclsToIds;
            boolean $i$f$mapToSet = false;
            destination$iv$iv2 = $this$mapToSet$iv;
            Iterable<BuiltInRuleGenerator> destination$iv$iv3 = SetsKt.mutableSetOf();
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it$iv;
                Object element$iv$iv$iv;
                element$iv$iv$iv = item$iv$iv;
                element$iv$iv = destination$iv$iv3;
                boolean bl = false;
                Pair it = (Pair)it$iv;
                boolean bl5 = false;
                element$iv$iv.add((BuiltInRuleId)((BuiltInRuleId)((Object)it.getSecond())));
            }
            Set birsInUseDistinctIds = (Set)destination$iv$iv3;
            if (birsInUseDistinctIds.size() < birsUseDeclsToIds.size()) {
                Iterator $this$filterTo$iv$iv2;
                void $this$filter$iv2;
                Object it;
                void $this$groupByTo$iv$iv;
                Object item$iv$iv;
                Object $this$groupBy$iv = birsUseDeclsToIds;
                boolean $i$f$groupBy = false;
                destination$iv$iv3 = $this$groupBy$iv;
                Map destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
                    Object object;
                    it = (Pair)element$iv$iv3;
                    boolean bl = false;
                    BuiltInRuleId key$iv$iv = (BuiltInRuleId)((Object)((Pair)it).getSecond());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl6 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv3);
                }
                $this$groupBy$iv = destination$iv$iv4;
                boolean $i$f$filter2 = false;
                $this$groupByTo$iv$iv = $this$filter$iv2;
                destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$filterTo2 = false;
                item$iv$iv = $this$filterTo$iv$iv2.entrySet().iterator();
                while (item$iv$iv.hasNext()) {
                    Object element$iv$iv3;
                    it = element$iv$iv3 = (Map.Entry)item$iv$iv.next();
                    boolean bl = false;
                    if (!(((List)it.getValue()).size() > 1)) continue;
                    destination$iv$iv4.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                }
                repeatingBirsIds = destination$iv$iv4;
                if (!(!repeatingBirsIds.isEmpty())) {
                    boolean $i$a$-check-CVLInput$Companion$getGeneratorsOfBuiltInRulesInUse$32 = false;
                    String $i$a$-check-CVLInput$Companion$getGeneratorsOfBuiltInRulesInUse$32 = "Did not expect having no repeating built-in rules";
                    throw new IllegalStateException($i$a$-check-CVLInput$Companion$getGeneratorsOfBuiltInRulesInUse$32.toString());
                }
                Object $this$forEach$iv2 = repeatingBirsIds;
                boolean $i$f$forEach3 = false;
                $this$filterTo$iv$iv2 = $this$forEach$iv2.entrySet().iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry $dstr$repeatingBirId$useDecls = element$iv2 = $this$filterTo$iv$iv2.next();
                    boolean bl = false;
                    repeatingBirId = (BuiltInRuleId)((Object)$dstr$repeatingBirId$useDecls.getKey());
                    List useDecls = (List)$dstr$repeatingBirId$useDecls.getValue();
                    Iterable $this$forEach$iv3 = useDecls;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Pair it2 = (Pair)element$iv3;
                        boolean bl7 = false;
                        errors2.add(Companion.addRepeatingIdInUseDeclsError(repeatingBirId.name(), ((UseDeclaration.BuiltInRule)it2.getFirst()).getCvlRange()));
                    }
                }
            }
            if (!((Collection)errors2).isEmpty()) {
                collectingResult = new CollectingResult.Error(errors2);
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                repeatingBirsIds = birsInUseDistinctIds;
                CollectingResult.Companion companion = CollectingResult.Companion;
                boolean $i$f$map = false;
                void $i$f$forEach3 = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void birId;
                    repeatingBirId = (BuiltInRuleId)((Object)item$iv$iv);
                    Iterable<BuiltInRuleGenerator> iterable2 = destination$iv$iv3;
                    boolean bl = false;
                    iterable2.add(BuiltInRuleGenerator.Companion.fromBirId((BuiltInRuleId)birId));
                }
                collectingResult = companion.lift((List)destination$iv$iv3);
            }
            return collectingResult;
        }

        @NotNull
        protected final CVLError addUnresolvedUseDeclsError(@NotNull UseDeclaration unresolvedUseDecl) {
            Intrinsics.checkNotNullParameter(unresolvedUseDecl, "unresolvedUseDecl");
            return new CVLError.General(unresolvedUseDecl.getCvlRange(), "Cannot resolve the 'use' declaration: unknown identifier " + unresolvedUseDecl.getId());
        }

        @NotNull
        protected final CVLError addRepeatingIdInUseDeclsError(@NotNull String repeatingId, @NotNull CVLRange cvlRange) {
            Intrinsics.checkNotNullParameter(repeatingId, "repeatingId");
            Intrinsics.checkNotNullParameter(cvlRange, "cvlRange");
            return new CVLError.General(cvlRange, this.repeatingIdInDeclsErrorMsg(repeatingId, "use"));
        }

        @NotNull
        protected final String repeatingIdInDeclsErrorMsg(@NotNull String repeatingId, @NotNull String declType) {
            Intrinsics.checkNotNullParameter(repeatingId, "repeatingId");
            Intrinsics.checkNotNullParameter(declType, "declType");
            return "Another '" + declType + "' declaration also uses the identifier " + repeatingId + ". Each identifier can occur in at most one '" + declType + "' declaration";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lspec/CVLInput$Plain;", "Lspec/CVLInput;", "cvlSource", "Lspec/CVLSource;", "(Lspec/CVLSource;)V", "getCvlSource", "()Lspec/CVLSource;", "component1", "copy", "equals", "", "other", "", "getRawCVLAst", "Lutils/CollectingResult;", "Lspec/cvlast/CVLAst;", "Lspec/cvlast/typechecker/CVLError;", "resolver", "Lspec/TypeResolver;", "hashCode", "", "toString", "", "Shared"})
    public static final class Plain
    extends CVLInput {
        @NotNull
        private final CVLSource cvlSource;

        public Plain(@NotNull CVLSource cvlSource) {
            Intrinsics.checkNotNullParameter(cvlSource, "cvlSource");
            super(null);
            this.cvlSource = cvlSource;
        }

        @Override
        @NotNull
        public CVLSource getCvlSource() {
            return this.cvlSource;
        }

        @Override
        @NotNull
        public CollectingResult<CVLAst, CVLError> getRawCVLAst(@NotNull TypeResolver resolver) {
            Intrinsics.checkNotNullParameter(resolver, "resolver");
            return CollectingResult.Companion.bind(Companion.parseCVLSpec(this.getCvlSource(), resolver), getRawCVLAst.1.INSTANCE);
        }

        @NotNull
        public final CVLSource component1() {
            return this.getCvlSource();
        }

        @NotNull
        public final Plain copy(@NotNull CVLSource cvlSource) {
            Intrinsics.checkNotNullParameter(cvlSource, "cvlSource");
            return new Plain(cvlSource);
        }

        public static /* synthetic */ Plain copy$default(Plain plain, CVLSource cVLSource, int n, Object object) {
            if ((n & 1) != 0) {
                cVLSource = plain.getCvlSource();
            }
            return plain.copy(cVLSource);
        }

        @NotNull
        public String toString() {
            return "Plain(cvlSource=" + this.getCvlSource() + ")";
        }

        public int hashCode() {
            return this.getCvlSource().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plain)) {
                return false;
            }
            Plain plain = (Plain)other;
            return Intrinsics.areEqual(this.getCvlSource(), plain.getCvlSource());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007\"\u0004\b\u0000\u0010\u00192\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0016H\u0002JB\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00052\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180!H\u0002J\u0014\u0010\"\u001a\u00020\u00112\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0007H\u0002J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J?\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J0\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u0007\u0012\u0004\u0012\u00020\u0018012\f\u00103\u001a\b\u0012\u0004\u0012\u0002020\u00072\u0006\u00104\u001a\u000205H\u0002J$\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00072\f\u00108\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u00104\u001a\u000205H\u0002JV\u00109\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0007\"\u0004\b\u0000\u0010\u00192\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u00130\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00072\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190=0<H\u0002J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u0018012\u0006\u0010?\u001a\u00020@H\u0016J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006D"}, d2={"Lspec/CVLInput$WithImportedSpecs;", "Lspec/CVLInput;", "cvlSource", "Lspec/CVLSource;", "cvlSourceNameToImportDecls", "", "", "", "importedCVLSources", "(Lspec/CVLSource;Ljava/util/Map;Ljava/util/List;)V", "getCvlSource", "()Lspec/CVLSource;", "getCvlSourceNameToImportDecls", "()Ljava/util/Map;", "getImportedCVLSources", "()Ljava/util/List;", "addAmbiguousOverrideDeclError", "Lspec/cvlast/typechecker/CVLError$General;", "ambiguousOverrideDecl", "Lspec/cvlast/OverrideDeclaration;", "overriddenAlternatives", "", "Lspec/cvlast/CVLRange;", "addOverrideDeclsErrors", "Lspec/cvlast/typechecker/CVLError;", "T", "overrideDeclsToMatchingElems", "addRepeatingIdInOverrideDeclsError", "repeatingId", "cvlRange", "addRepeatingIdsInDeclsErrors", "repeatingIdsToDeclsLocs", "errorLogger", "Lkotlin/Function2;", "addUnresolvedOverrideDeclError", "unresolvedOverrideDecl", "checkNoImportsAreMissing", "", "actualImportedSpecFiles", "Lspec/cvlast/CVLImportedSpecFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getImpInvsWithOverriddenPreserved", "Lutils/CollectingResult;", "Lspec/cvlast/CVLInvariant;", "matchingImpInvs", "astWithoutMergedImports", "Lspec/cvlast/CVLAst;", "getImpRulesWithOverriddenMethodParamFilters", "Lspec/cvlast/IRule;", "matchingImpRules", "getImportedElementsWithOverriding", "overrideDecls", "importedElements", "", "", "getRawCVLAst", "resolver", "Lspec/TypeResolver;", "hashCode", "", "toString", "Shared"})
    public static final class WithImportedSpecs
    extends CVLInput {
        @NotNull
        private final CVLSource cvlSource;
        @NotNull
        private final Map<String, List<String>> cvlSourceNameToImportDecls;
        @NotNull
        private final List<CVLSource> importedCVLSources;

        public WithImportedSpecs(@NotNull CVLSource cvlSource, @NotNull Map<String, ? extends List<String>> cvlSourceNameToImportDecls, @NotNull List<? extends CVLSource> importedCVLSources) {
            Intrinsics.checkNotNullParameter(cvlSource, "cvlSource");
            Intrinsics.checkNotNullParameter(cvlSourceNameToImportDecls, "cvlSourceNameToImportDecls");
            Intrinsics.checkNotNullParameter(importedCVLSources, "importedCVLSources");
            super(null);
            this.cvlSource = cvlSource;
            this.cvlSourceNameToImportDecls = cvlSourceNameToImportDecls;
            this.importedCVLSources = importedCVLSources;
        }

        @Override
        @NotNull
        public CVLSource getCvlSource() {
            return this.cvlSource;
        }

        @NotNull
        public final Map<String, List<String>> getCvlSourceNameToImportDecls() {
            return this.cvlSourceNameToImportDecls;
        }

        @NotNull
        public final List<CVLSource> getImportedCVLSources() {
            return this.importedCVLSources;
        }

        @Override
        @NotNull
        public CollectingResult<CVLAst, CVLError> getRawCVLAst(@NotNull TypeResolver resolver) {
            Intrinsics.checkNotNullParameter(resolver, "resolver");
            return CollectingResult.Companion.bind(Companion.parseCVLSpec(this.getCvlSource(), resolver.clone()), (Function1)new Function1<CVLAst, CollectingResult<? extends CVLAst, ? extends CVLError>>(this, resolver){
                final /* synthetic */ WithImportedSpecs this$0;
                final /* synthetic */ TypeResolver $resolver;
                {
                    this.this$0 = $receiver;
                    this.$resolver = $resolver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final CollectingResult<CVLAst, CVLError> invoke(@NotNull CVLAst astWithoutMergedImports) {
                    Set<T> set;
                    CVLFunction def2;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Collection destination$iv$iv;
                    Map.Entry it;
                    K k;
                    Map $this$mapValues$iv;
                    Map $this$map$iv;
                    Object object;
                    CollectingResult<Q, E> collectingResult;
                    Map $i$f$mapValues322;
                    CVLSource overrideDecl;
                    Iterator<T> iterator2;
                    Map.Entry $this$mapTo$iv$iv2;
                    Collection destination$iv$iv2;
                    Set it2;
                    Object object2;
                    OverrideDeclaration useDecl;
                    Collection collection2;
                    Object item$iv$iv2;
                    Iterable $this$mapTo$iv$iv3;
                    boolean $i$f$mapTo;
                    boolean $i$f$map;
                    Object object3;
                    Object object4;
                    Object it$iv$iv;
                    Object $this$associateByTo$iv$iv$iv;
                    Iterable $this$mapValuesTo$iv$iv2;
                    boolean $i$f$mapValuesTo;
                    Iterator<T> it3;
                    void $this$filterTo$iv$iv;
                    boolean $i$f$filterTo;
                    Map destination$iv$iv3;
                    Map $this$filter$iv;
                    boolean $i$f$filter;
                    List list$iv$iv;
                    Object value$iv$iv$iv;
                    boolean $i$f$getOrPut;
                    Map<K, V> $this$getOrPut$iv$iv$iv;
                    Object key$iv$iv;
                    void $this$groupByTo$iv$iv;
                    boolean $i$f$groupByTo;
                    boolean $i$f$groupBy;
                    Object $this$groupBy$iv;
                    Intrinsics.checkNotNullParameter(astWithoutMergedImports, "astWithoutMergedImports");
                    List errors2 = new ArrayList<E>();
                    if (CollectionsKt.toSet((Iterable)astWithoutMergedImports.getUseDeclarations().getImportedRulesAndInvariantsIds()).size() < astWithoutMergedImports.getUseDeclarations().getImportedRulesAndInvariantsIds().size()) {
                        void $this$mapValues$iv2;
                        $this$groupBy$iv = astWithoutMergedImports.getUseDeclarations().getImportedRulesAndInvariants();
                        $i$f$groupBy = false;
                        Iterable iterable = $this$groupBy$iv;
                        Map destination$iv$iv32 = new LinkedHashMap<K, V>();
                        $i$f$groupByTo = false;
                        for (T t : $this$groupByTo$iv$iv) {
                            Object object5;
                            UseDeclaration it32 = (UseDeclaration)t;
                            boolean bl3 = false;
                            key$iv$iv = it32.getId();
                            $this$getOrPut$iv$iv$iv = destination$iv$iv32;
                            $i$f$getOrPut = false;
                            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl4 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object5 = answer$iv$iv$iv;
                            } else {
                                object5 = value$iv$iv$iv;
                            }
                            list$iv$iv = (List)object5;
                            list$iv$iv.add(t);
                        }
                        $this$groupBy$iv = destination$iv$iv32;
                        $i$f$filter = false;
                        $this$groupByTo$iv$iv = $this$filter$iv;
                        destination$iv$iv3 = new LinkedHashMap<K, V>();
                        $i$f$filterTo = false;
                        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
                            it3 = entry;
                            boolean bl5 = false;
                            if (!(((List)it3.getValue()).size() > 1)) continue;
                            destination$iv$iv3.put(entry.getKey(), entry.getValue());
                        }
                        $this$filter$iv = destination$iv$iv3;
                        boolean $i$f$mapValues222 = false;
                        $this$filterTo$iv$iv = $this$mapValues$iv2;
                        destination$iv$iv3 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv2.size()));
                        $i$f$mapValuesTo = false;
                        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
                        boolean bl = false;
                        it3 = $this$associateByTo$iv$iv$iv.iterator();
                        while (it3.hasNext()) {
                            void it4;
                            T element$iv$iv$iv = it3.next();
                            key$iv$iv = (Map.Entry)element$iv$iv$iv;
                            $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                            boolean bl2 = false;
                            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                            object4 = it$iv$iv.getKey();
                            object3 = $this$getOrPut$iv$iv$iv;
                            boolean bl6 = false;
                            Iterable $this$map$iv2 = (Iterable)it4.getValue();
                            $i$f$map = false;
                            Iterable iterable2 = $this$map$iv2;
                            Collection destination$iv$iv22 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                                UseDeclaration useDeclaration = (UseDeclaration)item$iv$iv2;
                                collection2 = destination$iv$iv22;
                                boolean bl7 = false;
                                collection2.add(((UseDeclaration)((Object)useDecl)).getCvlRange());
                            }
                            object2 = CollectionsKt.toSet((List)destination$iv$iv22);
                            object3.put(object4, object2);
                        }
                        Map repeatingIdsToUseDeclLocs = destination$iv$iv3;
                        if (!(!repeatingIdsToUseDeclLocs.isEmpty())) {
                            String $i$f$mapValues222 = "Check failed.";
                            throw new IllegalStateException($i$f$mapValues222.toString());
                        }
                        CollectionsKt.addAll((Collection)errors2, WithImportedSpecs.access$addRepeatingIdsInDeclsErrors(this.this$0, repeatingIdsToUseDeclLocs, new Function2<String, CVLRange, CVLError>((Object)CVLInput.Companion){

                            @NotNull
                            public final CVLError invoke(@NotNull String p0, @NotNull CVLRange p12) {
                                Intrinsics.checkNotNullParameter(p0, "p0");
                                Intrinsics.checkNotNullParameter(p12, "p1");
                                return ((Companion)this.receiver).addRepeatingIdInUseDeclsError(p0, p12);
                            }
                        }));
                    }
                    if (CollectionsKt.toSet((Iterable)astWithoutMergedImports.getOverrideDeclarations().getAllDeclsIds()).size() < astWithoutMergedImports.getOverrideDeclarations().getAllDeclsIds().size()) {
                        void $this$mapValuesTo$iv$iv;
                        void $this$mapValues$iv2;
                        $this$groupBy$iv = astWithoutMergedImports.getOverrideDeclarations().getAllDecls();
                        $i$f$groupBy = false;
                        $this$mapValuesTo$iv$iv2 = $this$groupBy$iv;
                        destination$iv$iv3 = new LinkedHashMap<K, V>();
                        $i$f$groupByTo = false;
                        for (T t : $this$groupByTo$iv$iv) {
                            Object object6;
                            it3 = (OverrideDeclaration)t;
                            boolean bl8 = false;
                            key$iv$iv = ((OverrideDeclaration)((Object)it3)).getId();
                            $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                            $i$f$getOrPut = false;
                            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl9 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object6 = answer$iv$iv$iv;
                            } else {
                                object6 = value$iv$iv$iv;
                            }
                            list$iv$iv = (List)object6;
                            list$iv$iv.add(t);
                        }
                        $this$groupBy$iv = destination$iv$iv3;
                        $i$f$filter = false;
                        $this$groupByTo$iv$iv = $this$filter$iv;
                        destination$iv$iv3 = new LinkedHashMap<K, V>();
                        $i$f$filterTo = false;
                        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
                            it3 = entry;
                            boolean bl10 = false;
                            if (!(((List)it3.getValue()).size() > 1)) continue;
                            destination$iv$iv3.put(entry.getKey(), entry.getValue());
                        }
                        $this$filter$iv = destination$iv$iv3;
                        boolean $i$f$mapValues322 = false;
                        $this$filterTo$iv$iv = $this$mapValues$iv2;
                        destination$iv$iv3 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv2.size()));
                        $i$f$mapValuesTo = false;
                        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean bl = false;
                        it3 = $this$associateByTo$iv$iv$iv.iterator();
                        while (it3.hasNext()) {
                            T element$iv$iv$iv = it3.next();
                            key$iv$iv = (Map.Entry)element$iv$iv$iv;
                            $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                            boolean bl2 = false;
                            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                            object4 = it$iv$iv.getKey();
                            object3 = $this$getOrPut$iv$iv$iv;
                            boolean bl11 = false;
                            Iterable $this$map$iv2 = (Iterable)it2.getValue();
                            $i$f$map = false;
                            $this$mapTo$iv$iv3 = $this$map$iv2;
                            destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                            $i$f$mapTo = false;
                            iterator2 = $this$mapTo$iv$iv2.iterator();
                            while (iterator2.hasNext()) {
                                item$iv$iv2 = iterator2.next();
                                useDecl = (OverrideDeclaration)item$iv$iv2;
                                collection2 = destination$iv$iv2;
                                boolean bl12 = false;
                                collection2.add(((OverrideDeclaration)((Object)overrideDecl)).getCvlRange());
                            }
                            object2 = CollectionsKt.toSet((List)destination$iv$iv2);
                            object3.put(object4, object2);
                        }
                        Map repeatingIdsToOverrideDeclLocs = destination$iv$iv3;
                        if (!(!repeatingIdsToOverrideDeclLocs.isEmpty())) {
                            String $i$f$mapValues322 = "Check failed.";
                            throw new IllegalStateException($i$f$mapValues322.toString());
                        }
                        CollectionsKt.addAll((Collection)errors2, WithImportedSpecs.access$addRepeatingIdsInDeclsErrors(this.this$0, repeatingIdsToOverrideDeclLocs, new Function2<String, CVLRange, CVLError.General>((Object)this.this$0){

                            @NotNull
                            public final CVLError.General invoke(@NotNull String p0, @NotNull CVLRange p12) {
                                Intrinsics.checkNotNullParameter(p0, "p0");
                                Intrinsics.checkNotNullParameter(p12, "p1");
                                return WithImportedSpecs.access$addRepeatingIdInOverrideDeclsError((WithImportedSpecs)this.receiver, p0, p12);
                            }
                        }));
                    }
                    List<UseDeclaration> unresolvedImpUseDecls = CollectionsKt.toMutableList((Collection)astWithoutMergedImports.getUseDeclarations().getImportedRulesAndInvariants());
                    Map it4 = $i$f$mapValues322 = (Map)new LinkedHashMap<K, V>();
                    boolean bl13 = false;
                    Iterable $this$associateWithTo$iv = astWithoutMergedImports.getOverrideDeclarations().getOverriddenDefinitions();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv : $this$associateWithTo$iv) {
                        OverrideDeclaration.CVLDefinition element$iv$iv$iv = (OverrideDeclaration.CVLDefinition)element$iv;
                        it$iv$iv = element$iv;
                        $this$getOrPut$iv$iv$iv = it4;
                        boolean bl14 = false;
                        it2 = new LinkedHashSet<E>();
                        $this$getOrPut$iv$iv$iv.put(it$iv$iv, it2);
                    }
                    Map overrideDefDeclsToMatchingDefs = $i$f$mapValues322;
                    Map it5 = it4 = (Map)new LinkedHashMap<K, V>();
                    boolean bl15 = false;
                    Iterable $this$associateWithTo$iv2 = astWithoutMergedImports.getOverrideDeclarations().getOverriddenCVLFunctions();
                    boolean bl = false;
                    for (E element$iv : $this$associateWithTo$iv2) {
                        it$iv$iv = (OverrideDeclaration.CVLFunction)element$iv;
                        $this$getOrPut$iv$iv$iv = element$iv;
                        Map bl14 = it5;
                        boolean bl16 = false;
                        Set bl11 = new LinkedHashSet<E>();
                        bl14.put($this$getOrPut$iv$iv$iv, bl11);
                    }
                    Map overrideFuncDeclsToMatchingFuncs = it4;
                    if (astWithoutMergedImports.getImportedSpecFiles().isEmpty()) {
                        collectingResult = (CollectingResult<Q, E>)CollectingResult.Companion.lift(astWithoutMergedImports);
                    } else {
                        void $this$map$iv3;
                        WithImportedSpecs.access$checkNoImportsAreMissing(this.this$0, this.this$0.getCvlSource(), astWithoutMergedImports.getImportedSpecFiles());
                        List impImportedMethods = new ArrayList<E>();
                        List impSubs = new ArrayList<E>();
                        List impSorts = new ArrayList<E>();
                        List list = new ArrayList<E>();
                        List impDefinitions = new ArrayList<E>();
                        List impHooks = new ArrayList<E>();
                        List impImportedContracts = new ArrayList<E>();
                        List impRulesInUse = new ArrayList<E>();
                        List impInvsInUse = new ArrayList<E>();
                        Iterable bl16 = this.this$0.getImportedCVLSources();
                        TypeResolver bl11 = this.$resolver;
                        object = this.this$0;
                        object4 = CollectingResult.Companion;
                        object3 = CollectingResult.Companion;
                        $i$f$map = false;
                        $this$mapTo$iv$iv2 = $this$map$iv3;
                        destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                        $i$f$mapTo = false;
                        iterator2 = $this$mapTo$iv$iv2.iterator();
                        while (iterator2.hasNext()) {
                            void importedFile;
                            item$iv$iv2 = iterator2.next();
                            overrideDecl = (CVLSource)item$iv$iv2;
                            object2 = destination$iv$iv2;
                            boolean bl17 = false;
                            object2.add(CollectingResult.Companion.bind(CVLInput.Companion.parseCVLSpec((CVLSource)importedFile, bl11.clone()), (Function1)new Function1<CVLAst, CollectingResult<? extends Boolean, ? extends CVLError>>((WithImportedSpecs)object, (CVLSource)importedFile, (List<MethodBlockAnnotation>)impImportedMethods, (List<CVLFunction>)impSubs, astWithoutMergedImports, (Map<OverrideDeclaration<CVLFunction>, Set<CVLFunction>>)overrideFuncDeclsToMatchingFuncs, (List<SortDeclaration>)impSorts, (List<CVLGhostDeclaration>)list, (List<CVLDefinition>)impDefinitions, (Map<OverrideDeclaration<CVLDefinition>, Set<CVLDefinition>>)overrideDefDeclsToMatchingDefs, (List<CVLHook>)impHooks, (List<CVLImportedContract>)impImportedContracts, (List<IRule>)impRulesInUse, unresolvedImpUseDecls, (List<CVLInvariant>)impInvsInUse){
                                final /* synthetic */ WithImportedSpecs this$0;
                                final /* synthetic */ CVLSource $importedFile;
                                final /* synthetic */ List<MethodBlockAnnotation> $impImportedMethods;
                                final /* synthetic */ List<CVLFunction> $impSubs;
                                final /* synthetic */ CVLAst $astWithoutMergedImports;
                                final /* synthetic */ Map<OverrideDeclaration<CVLFunction>, Set<CVLFunction>> $overrideFuncDeclsToMatchingFuncs;
                                final /* synthetic */ List<SortDeclaration> $impSorts;
                                final /* synthetic */ List<CVLGhostDeclaration> $impGhosts;
                                final /* synthetic */ List<CVLDefinition> $impDefinitions;
                                final /* synthetic */ Map<OverrideDeclaration<CVLDefinition>, Set<CVLDefinition>> $overrideDefDeclsToMatchingDefs;
                                final /* synthetic */ List<CVLHook> $impHooks;
                                final /* synthetic */ List<CVLImportedContract> $impImportedContracts;
                                final /* synthetic */ List<IRule> $impRulesInUse;
                                final /* synthetic */ List<UseDeclaration> $unresolvedImpUseDecls;
                                final /* synthetic */ List<CVLInvariant> $impInvsInUse;
                                {
                                    this.this$0 = $receiver;
                                    this.$importedFile = $importedFile;
                                    this.$impImportedMethods = $impImportedMethods;
                                    this.$impSubs = $impSubs;
                                    this.$astWithoutMergedImports = $astWithoutMergedImports;
                                    this.$overrideFuncDeclsToMatchingFuncs = $overrideFuncDeclsToMatchingFuncs;
                                    this.$impSorts = $impSorts;
                                    this.$impGhosts = $impGhosts;
                                    this.$impDefinitions = $impDefinitions;
                                    this.$overrideDefDeclsToMatchingDefs = $overrideDefDeclsToMatchingDefs;
                                    this.$impHooks = $impHooks;
                                    this.$impImportedContracts = $impImportedContracts;
                                    this.$impRulesInUse = $impRulesInUse;
                                    this.$unresolvedImpUseDecls = $unresolvedImpUseDecls;
                                    this.$impInvsInUse = $impInvsInUse;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final CollectingResult<Boolean, CVLError> invoke(@NotNull CVLAst importedSpecFileAst) {
                                    void $this$filterTo$iv$iv;
                                    void $this$filter$iv;
                                    void $this$filterTo$iv$iv2;
                                    void $this$filter$iv2;
                                    Intrinsics.checkNotNullParameter(importedSpecFileAst, "importedSpecFileAst");
                                    if (!((Collection)importedSpecFileAst.getImportedSpecFiles()).isEmpty()) {
                                        WithImportedSpecs.access$checkNoImportsAreMissing(this.this$0, this.$importedFile, importedSpecFileAst.getImportedSpecFiles());
                                    }
                                    this.$impImportedMethods.addAll((Collection<MethodBlockAnnotation>)importedSpecFileAst.getImportedMethods());
                                    this.$impSubs.addAll(WithImportedSpecs.access$getImportedElementsWithOverriding(this.this$0, this.$astWithoutMergedImports.getOverrideDeclarations().getOverriddenCVLFunctions(), importedSpecFileAst.getSubs(), this.$overrideFuncDeclsToMatchingFuncs));
                                    this.$impSorts.addAll((Collection<SortDeclaration>)importedSpecFileAst.getSorts());
                                    this.$impGhosts.addAll((Collection<CVLGhostDeclaration>)importedSpecFileAst.getGhosts());
                                    this.$impDefinitions.addAll(WithImportedSpecs.access$getImportedElementsWithOverriding(this.this$0, this.$astWithoutMergedImports.getOverrideDeclarations().getOverriddenDefinitions(), importedSpecFileAst.getDefinitions(), this.$overrideDefDeclsToMatchingDefs));
                                    this.$impHooks.addAll((Collection<CVLHook>)importedSpecFileAst.getHooks());
                                    this.$impImportedContracts.addAll((Collection<CVLImportedContract>)importedSpecFileAst.getImportedContracts());
                                    Iterable iterable = importedSpecFileAst.getRules();
                                    Object object = this.$astWithoutMergedImports;
                                    boolean $i$f$filter = false;
                                    void var6_6 = $this$filter$iv2;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv2) {
                                        IRule it = (IRule)element$iv$iv;
                                        boolean bl = false;
                                        if (!((CVLAst)object).getUseDeclarations().getImportedRulesDistinctIds().contains(it.getDeclarationId())) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    List matchingImpRules = (List)destination$iv$iv;
                                    object = importedSpecFileAst.getInvs();
                                    CVLAst cVLAst = this.$astWithoutMergedImports;
                                    boolean $i$f$filter2 = false;
                                    destination$iv$iv = $this$filter$iv;
                                    Collection destination$iv$iv2 = new ArrayList<E>();
                                    boolean $i$f$filterTo2 = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        CVLInvariant it = (CVLInvariant)element$iv$iv;
                                        boolean bl = false;
                                        if (!cVLAst.getUseDeclarations().getImportedInvariantsDistinctIds().contains(it.getId())) continue;
                                        destination$iv$iv2.add(element$iv$iv);
                                    }
                                    List matchingImpInvs = (List)destination$iv$iv2;
                                    this.$impRulesInUse.addAll(WithImportedSpecs.access$getImpRulesWithOverriddenMethodParamFilters(this.this$0, matchingImpRules, this.$astWithoutMergedImports));
                                    CollectionsKt.removeAll(this.$unresolvedImpUseDecls, (Function1)new Function1<UseDeclaration, Boolean>((List<? extends IRule>)matchingImpRules, (List<CVLInvariant>)matchingImpInvs){
                                        final /* synthetic */ List<IRule> $matchingImpRules;
                                        final /* synthetic */ List<CVLInvariant> $matchingImpInvs;
                                        {
                                            this.$matchingImpRules = $matchingImpRules;
                                            this.$matchingImpInvs = $matchingImpInvs;
                                            super(1);
                                        }

                                        /*
                                         * Enabled aggressive block sorting
                                         */
                                        @NotNull
                                        public final Boolean invoke(@NotNull UseDeclaration unresUseDecl) {
                                            boolean bl;
                                            block6: {
                                                block5: {
                                                    CVLInvariant it;
                                                    Collection collection;
                                                    Iterable $this$mapTo$iv$iv;
                                                    boolean $i$f$mapTo;
                                                    Collection destination$iv$iv;
                                                    boolean $i$f$map;
                                                    Iterable $this$map$iv;
                                                    block4: {
                                                        Intrinsics.checkNotNullParameter(unresUseDecl, "unresUseDecl");
                                                        if (!(unresUseDecl instanceof UseDeclaration.ImportedRule)) break block4;
                                                        $this$map$iv = this.$matchingImpRules;
                                                        $i$f$map = false;
                                                        Iterable iterable = $this$map$iv;
                                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                                        $i$f$mapTo = false;
                                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                            IRule iRule = (IRule)item$iv$iv;
                                                            collection = destination$iv$iv;
                                                            boolean bl2 = false;
                                                            collection.add(((IRule)((Object)it)).getDeclarationId());
                                                        }
                                                        if (((List)destination$iv$iv).contains(unresUseDecl.getId())) break block5;
                                                    }
                                                    if (!(unresUseDecl instanceof UseDeclaration.ImportedInvariant)) break block6;
                                                    $this$map$iv = this.$matchingImpInvs;
                                                    $i$f$map = false;
                                                    $this$mapTo$iv$iv = $this$map$iv;
                                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                                    $i$f$mapTo = false;
                                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                        it = (CVLInvariant)item$iv$iv;
                                                        collection = destination$iv$iv;
                                                        boolean bl3 = false;
                                                        collection.add(it.getId());
                                                    }
                                                    if (!((List)destination$iv$iv).contains(unresUseDecl.getId())) break block6;
                                                }
                                                bl = true;
                                                return bl;
                                            }
                                            bl = false;
                                            return bl;
                                        }
                                    });
                                    return CollectingResult.Companion.map(WithImportedSpecs.access$getImpInvsWithOverriddenPreserved(this.this$0, matchingImpInvs, this.$astWithoutMergedImports), (Function1)new Function1<List<? extends CVLInvariant>, Boolean>(this.$impInvsInUse){
                                        final /* synthetic */ List<CVLInvariant> $impInvsInUse;
                                        {
                                            this.$impInvsInUse = $impInvsInUse;
                                            super(1);
                                        }

                                        @NotNull
                                        public final Boolean invoke(@NotNull List<CVLInvariant> invariants) {
                                            Intrinsics.checkNotNullParameter(invariants, "invariants");
                                            return this.$impInvsInUse.addAll((Collection<CVLInvariant>)invariants);
                                        }
                                    });
                                }
                            }));
                        }
                        object2 = (List)destination$iv$iv2;
                        collectingResult = ((CollectingResult.Companion)object3).map(((CollectingResult.Companion)object4).flatten(object2), (Function1)new Function1<List<? extends Boolean>, CVLAst>((List<IRule>)impRulesInUse, (List<CVLInvariant>)impInvsInUse, (List<MethodBlockAnnotation>)impImportedMethods, (List<CVLFunction>)impSubs, (List<SortDeclaration>)impSorts, (List<CVLGhostDeclaration>)list, (List<CVLDefinition>)impDefinitions, (List<CVLHook>)impHooks, (List<CVLImportedContract>)impImportedContracts, astWithoutMergedImports){
                            final /* synthetic */ List<IRule> $impRulesInUse;
                            final /* synthetic */ List<CVLInvariant> $impInvsInUse;
                            final /* synthetic */ List<MethodBlockAnnotation> $impImportedMethods;
                            final /* synthetic */ List<CVLFunction> $impSubs;
                            final /* synthetic */ List<SortDeclaration> $impSorts;
                            final /* synthetic */ List<CVLGhostDeclaration> $impGhosts;
                            final /* synthetic */ List<CVLDefinition> $impDefinitions;
                            final /* synthetic */ List<CVLHook> $impHooks;
                            final /* synthetic */ List<CVLImportedContract> $impImportedContracts;
                            final /* synthetic */ CVLAst $astWithoutMergedImports;
                            {
                                this.$impRulesInUse = $impRulesInUse;
                                this.$impInvsInUse = $impInvsInUse;
                                this.$impImportedMethods = $impImportedMethods;
                                this.$impSubs = $impSubs;
                                this.$impSorts = $impSorts;
                                this.$impGhosts = $impGhosts;
                                this.$impDefinitions = $impDefinitions;
                                this.$impHooks = $impHooks;
                                this.$impImportedContracts = $impImportedContracts;
                                this.$astWithoutMergedImports = $astWithoutMergedImports;
                                super(1);
                            }

                            @NotNull
                            public final CVLAst invoke(@NotNull List<Boolean> it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                Object object = this.$impRulesInUse;
                                Object object2 = this.$astWithoutMergedImports;
                                List<IRule> it2 = object;
                                boolean bl = false;
                                it2.addAll((Collection<IRule>)((CVLAst)object2).getRules());
                                List<IRule> list = object;
                                object2 = this.$impInvsInUse;
                                Object object3 = this.$astWithoutMergedImports;
                                Object it3 = object2;
                                boolean bl2 = false;
                                it3.addAll((Collection)((CVLAst)object3).getInvs());
                                object = object2;
                                object3 = this.$impImportedMethods;
                                Object object4 = this.$astWithoutMergedImports;
                                Object it4 = object3;
                                boolean bl3 = false;
                                it4.addAll((Collection)((CVLAst)object4).getImportedMethods());
                                object2 = object3;
                                object4 = this.$impSubs;
                                Object object5 = this.$astWithoutMergedImports;
                                Object it5 = object4;
                                boolean bl4 = false;
                                it5.addAll((Collection)((CVLAst)object5).getSubs());
                                object3 = object4;
                                object5 = this.$impSorts;
                                Object object6 = this.$astWithoutMergedImports;
                                Object it6 = object5;
                                boolean bl5 = false;
                                it6.addAll((Collection)((CVLAst)object6).getSorts());
                                object4 = object5;
                                object6 = this.$impGhosts;
                                Object object7 = this.$astWithoutMergedImports;
                                Object it7 = object6;
                                boolean bl6 = false;
                                it7.addAll((Collection)((CVLAst)object7).getGhosts());
                                object5 = object6;
                                object7 = this.$impDefinitions;
                                Object object8 = this.$astWithoutMergedImports;
                                Object it8 = object7;
                                boolean bl7 = false;
                                it8.addAll((Collection)((CVLAst)object8).getDefinitions());
                                object6 = object7;
                                object8 = this.$impHooks;
                                List<T> list2 = this.$astWithoutMergedImports;
                                Object it9 = object8;
                                boolean bl8 = false;
                                it9.addAll((Collection)((CVLAst)((Object)list2)).getHooks());
                                object7 = object8;
                                list2 = this.$impImportedContracts;
                                Object object9 = this.$astWithoutMergedImports;
                                List<T> it10 = list2;
                                boolean bl9 = false;
                                it10.addAll((Collection)((CVLAst)object9).getImportedContracts());
                                object8 = list2;
                                list2 = CollectionsKt.emptyList();
                                object9 = new OverrideDeclarations();
                                return CVLAst.copy$default(this.$astWithoutMergedImports, 0, (List)object2, null, list, (List)object3, (List)object, (List)object4, (List)object5, (List)object6, (List)object7, (List)object8, list2, (OverrideDeclarations)object9, null, 8197, null);
                            }
                        });
                    }
                    CollectingResult<Q, E> mergedAst2 = collectingResult;
                    Iterable impSubs = unresolvedImpUseDecls;
                    object3 = errors2;
                    boolean $i$f$map2 = false;
                    void var10_31 = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : var10_31) {
                        void unresolvedDecl;
                        UseDeclaration impInvsInUse = (UseDeclaration)item$iv$iv2;
                        object4 = destination$iv$iv4;
                        boolean bl18 = false;
                        object4.add((CVLError)CVLInput.Companion.addUnresolvedUseDeclsError((UseDeclaration)unresolvedDecl));
                    }
                    CollectionsKt.addAll(object3, (List)destination$iv$iv4);
                    $this$map$iv = overrideDefDeclsToMatchingDefs;
                    object4 = this.this$0;
                    object3 = errors2;
                    boolean $i$f$mapValues4 = false;
                    void var10_32 = $this$mapValues$iv;
                    Map destination$iv$iv5 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo2 = false;
                    Iterable $this$associateByTo$iv$iv$iv2 = var10_32.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                        void it$iv$iv22;
                        Map.Entry bl11 = (Map.Entry)element$iv$iv$iv;
                        object = destination$iv$iv5;
                        boolean bl3 = false;
                        $this$mapTo$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv22.getKey();
                        object2 = object;
                        boolean bl19 = false;
                        Iterable $this$map$iv4 = (Iterable)it.getValue();
                        boolean $i$f$map3 = false;
                        item$iv$iv2 = $this$map$iv4;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
                        boolean $i$f$mapTo3 = false;
                        for (T item$iv$iv3 : $this$mapTo$iv$iv) {
                            CVLDefinition cVLDefinition = (CVLDefinition)item$iv$iv3;
                            collection = destination$iv$iv;
                            boolean bl20 = false;
                            collection.add(((CVLDefinition)((Object)def2)).getCvlRange());
                        }
                        set = CollectionsKt.toSet((List)destination$iv$iv);
                        object2.put(k, set);
                    }
                    object2 = destination$iv$iv5;
                    CollectionsKt.addAll(object3, WithImportedSpecs.access$addOverrideDeclsErrors(object4, (Map)object2));
                    $this$mapValues$iv = overrideFuncDeclsToMatchingFuncs;
                    object4 = this.this$0;
                    object3 = errors2;
                    boolean $i$f$mapValues = false;
                    Map map2 = $this$mapValues$iv;
                    destination$iv$iv5 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo3 = false;
                    Iterable $this$associateByTo$iv$iv$iv3 = map2.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
                        void it$iv$iv2;
                        Map.Entry it$iv$iv22 = (Map.Entry)element$iv$iv$iv;
                        object = destination$iv$iv5;
                        boolean bl4 = false;
                        it = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv2.getKey();
                        object2 = object;
                        boolean bl21 = false;
                        Iterable $this$map$iv5 = (Iterable)it.getValue();
                        boolean $i$f$map4 = false;
                        $this$mapTo$iv$iv = $this$map$iv5;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv5, 10));
                        boolean $i$f$mapTo4 = false;
                        for (T item$iv$iv3 : $this$mapTo$iv$iv) {
                            void sub2;
                            def2 = (CVLFunction)item$iv$iv3;
                            collection = destination$iv$iv;
                            boolean bl22 = false;
                            collection.add(sub2.getCvlRange());
                        }
                        set = CollectionsKt.toSet((List)destination$iv$iv);
                        object2.put(k, set);
                    }
                    object2 = destination$iv$iv5;
                    CollectionsKt.addAll(object3, WithImportedSpecs.access$addOverrideDeclsErrors((WithImportedSpecs)object4, (Map)object2));
                    return CollectingResult.Companion.map(mergedAst2, CVLInput.Companion.getGeneratorsOfBuiltInRulesInUse(astWithoutMergedImports), CollectingResult.Companion.flattenToVoid(errors2), getRawCVLAst.6.INSTANCE);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> getImportedElementsWithOverriding(List<? extends OverrideDeclaration<T>> overrideDecls, List<? extends T> importedElements, Map<OverrideDeclaration<T>, Set<T>> overrideDeclsToMatchingElems) {
            List list;
            if (overrideDecls.isEmpty()) {
                list = importedElements;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = importedElements;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object t;
                    Object v1;
                    void impElem;
                    Collection collection;
                    block10: {
                        Object item$iv$iv;
                        Object t2 = item$iv$iv = iterator2.next();
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Iterable $this$singleOrNull$iv = overrideDecls;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            OverrideDeclaration it = (OverrideDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!it.overrides(impElem)) continue;
                            if (found$iv) {
                                v1 = null;
                                break block10;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v1 = !found$iv ? null : single$iv;
                    }
                    OverrideDeclaration matchingOverrideDecl = v1;
                    if (matchingOverrideDecl != null) {
                        Set<T> matchingElems;
                        Intrinsics.checkNotNull(overrideDeclsToMatchingElems.get(matchingOverrideDecl));
                        matchingElems.add(impElem);
                        if (matchingElems.size() == 1) {
                            t = matchingOverrideDecl.materialize();
                        } else {
                            if (!(matchingElems.size() > 1)) {
                                String string = "Check failed.";
                                throw new IllegalStateException(string.toString());
                            }
                            t = impElem;
                        }
                    } else {
                        t = impElem;
                    }
                    collection.add(t);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IRule> getImpRulesWithOverriddenMethodParamFilters(List<? extends IRule> matchingImpRules, CVLAst astWithoutMergedImports) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = matchingImpRules;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IRule iRule;
                boolean bl;
                UseDeclaration.ImportedRule useDecl;
                Map<String, MethodParamFilter> map2;
                void matchingRule;
                Map<String, MethodParamFilter> single$iv;
                Collection collection;
                block9: {
                    IRule iRule2 = (IRule)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$singleOrNull$iv = astWithoutMergedImports.getUseDeclarations().getImportedRules();
                    boolean $i$f$singleOrNull = false;
                    single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        UseDeclaration.ImportedRule it = (UseDeclaration.ImportedRule)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getId(), matchingRule.getDeclarationId())) continue;
                        if (found$iv) {
                            map2 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    map2 = !found$iv ? null : single$iv;
                }
                UseDeclaration.ImportedRule importedRule = useDecl = (UseDeclaration.ImportedRule)((Object)map2);
                if (importedRule == null) {
                    bl = false;
                } else {
                    MethodParamFilters methodParamFilters2 = importedRule.getMethodParamFilters();
                    bl = methodParamFilters2 == null ? false : ((single$iv = methodParamFilters2.getMethodParamToFilter()) == null ? false : !single$iv.isEmpty());
                }
                if (bl) {
                    if (!(matchingRule instanceof CVLSingleRule)) {
                        boolean $i$a$-check-CVLInput$WithImportedSpecs$getImpRulesWithOverriddenMethodParamFilters$1$22 = false;
                        String $i$a$-check-CVLInput$WithImportedSpecs$getImpRulesWithOverriddenMethodParamFilters$1$22 = "Expected a CVLSingleRule, but got " + (IRule)matchingRule;
                        throw new IllegalStateException($i$a$-check-CVLInput$WithImportedSpecs$getImpRulesWithOverriddenMethodParamFilters$1$22.toString());
                    }
                    Map<String, MethodParamFilter> filtersInUseDecl = useDecl.getMethodParamFilters().getMethodParamToFilter();
                    Map<String, MethodParamFilter> overriddenFilters = MapsKt.toMutableMap(filtersInUseDecl);
                    Map<String, MethodParamFilter> $this$forEach$iv = ((CVLSingleRule)matchingRule).getMethodParamFilters().getMethodParamToFilter();
                    boolean $i$f$forEach = false;
                    Iterator<Object> iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object $dstr$methodParam$filterExp = element$iv = (Map.Entry)iterator2.next();
                        boolean bl4 = false;
                        String methodParam = (String)$dstr$methodParam$filterExp.getKey();
                        MethodParamFilter filterExp = (MethodParamFilter)$dstr$methodParam$filterExp.getValue();
                        if (filtersInUseDecl.containsKey(methodParam)) continue;
                        overriddenFilters.put(methodParam, filterExp);
                    }
                    MethodParamFilters methodParamFilters3 = ((CVLSingleRule)matchingRule).getMethodParamFilters();
                    CVLRange cVLRange = useDecl.getMethodParamFilters().getCvlRange();
                    iRule = CVLSingleRule.copy$default((CVLSingleRule)matchingRule, null, null, null, null, null, null, null, null, null, MethodParamFilters.copy$default(methodParamFilters3, cVLRange, null, overriddenFilters, 2, null), null, 0, 3583, null);
                } else {
                    iRule = matchingRule;
                }
                collection.add(iRule);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final CollectingResult<List<CVLInvariant>, CVLError> getImpInvsWithOverriddenPreserved(List<CVLInvariant> matchingImpInvs, CVLAst astWithoutMergedImports) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = matchingImpInvs;
            CollectingResult.Companion companion = CollectingResult.Companion;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                boolean bl;
                UseDeclaration.ImportedInvariant useDecl;
                Object v0;
                void matchingInv;
                Collection collection;
                block5: {
                    CVLInvariant cVLInvariant = (CVLInvariant)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$singleOrNull$iv = astWithoutMergedImports.getUseDeclarations().getImportedInvariants();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        UseDeclaration.ImportedInvariant it = (UseDeclaration.ImportedInvariant)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getId(), matchingInv.getId())) continue;
                        if (found$iv) {
                            v0 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                UseDeclaration.ImportedInvariant importedInvariant = useDecl = (UseDeclaration.ImportedInvariant)v0;
                if (importedInvariant == null) {
                    bl = false;
                } else {
                    List<CVLPreserved> list;
                    CVLInvariantProof cVLInvariantProof = importedInvariant.getProof();
                    bl = cVLInvariantProof == null ? false : ((list = cVLInvariantProof.getPreserved()) == null ? false : !((Collection)list).isEmpty());
                }
                collection.add(bl ? CollectingResult.Companion.map(matchingInv.checkPreservedIsErrorFree(), (Function1)new Function1<Unit, CVLInvariant>(useDecl, (CVLInvariant)matchingInv){
                    final /* synthetic */ UseDeclaration.ImportedInvariant $useDecl;
                    final /* synthetic */ CVLInvariant $matchingInv;
                    {
                        this.$useDecl = $useDecl;
                        this.$matchingInv = $matchingInv;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final CVLInvariant invoke(@NotNull Unit it) {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstanceTo$iv$iv2;
                        Intrinsics.checkNotNullParameter(it, "it");
                        List<T> overriddenPreserved = CollectionsKt.toMutableList((Collection)this.$useDecl.getProof().getPreserved());
                        Iterable $this$filterIsInstance$iv = this.$useDecl.getProof().getPreserved();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Iterable<E> destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                            if (!(element$iv$iv instanceof CVLPreserved.ExplicitMethod)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List explicitPreservedInUseDecl = (List)destination$iv$iv;
                        Iterable $this$filterIsInstance$iv2 = this.$useDecl.getProof().getPreserved();
                        boolean $i$f$filterIsInstance2 = false;
                        destination$iv$iv = $this$filterIsInstance$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo2 = false;
                        for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof CVLPreserved.Generic)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List genericPreservedInUseDecl = (List)destination$iv$iv2;
                        Iterable $this$forEach$iv = this.$matchingInv.getProof().getPreserved();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CVLPreserved origPreserved = (CVLPreserved)element$iv;
                            boolean bl = false;
                            if (!(origPreserved instanceof CVLPreserved.Generic) || !genericPreservedInUseDecl.isEmpty()) {
                                boolean bl2;
                                block7: {
                                    if (!(origPreserved instanceof CVLPreserved.ExplicitMethod)) continue;
                                    Iterable $this$none$iv = explicitPreservedInUseDecl;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        for (T element$iv2 : $this$none$iv) {
                                            CVLPreserved.ExplicitMethod it2 = (CVLPreserved.ExplicitMethod)element$iv2;
                                            boolean bl3 = false;
                                            if (!it2.getMethodSignature().matchesSigHash(((CVLPreserved.ExplicitMethod)origPreserved).getMethodSignature())) continue;
                                            bl2 = false;
                                            break block7;
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (!bl2) continue;
                            }
                            overriddenPreserved.add(origPreserved);
                        }
                        CVLInvariantProof cVLInvariantProof = this.$matchingInv.getProof().copy(overriddenPreserved);
                        CVLRange cVLRange = this.$useDecl.getCvlRange();
                        return CVLInvariant.copy$default(this.$matchingInv, cVLRange, null, null, null, null, null, cVLInvariantProof, null, 0, 446, null);
                    }
                }) : (CollectingResult)CollectingResult.Companion.lift(matchingInv));
            }
            return companion.flatten((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final void checkNoImportsAreMissing(CVLSource cvlSource, List<CVLImportedSpecFile> actualImportedSpecFiles) {
            void $this$mapTo$iv$iv;
            if (!(!((Collection)actualImportedSpecFiles).isEmpty())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Iterable $this$map$iv = actualImportedSpecFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CVLImportedSpecFile cVLImportedSpecFile = (CVLImportedSpecFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSpecFileName());
            }
            List actualImportedSpecFileNames = (List)destination$iv$iv;
            List<String> approxImportedSpecFileNames = this.cvlSourceNameToImportDecls.get(cvlSource.getName());
            if (approxImportedSpecFileNames == null || !approxImportedSpecFileNames.containsAll(actualImportedSpecFileNames)) {
                List<String> list = approxImportedSpecFileNames;
                List missingImportDecls = CollectionsKt.minus((Iterable)actualImportedSpecFileNames, list == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list);
                throw new IllegalStateException("certoraBuild.py approximated " + approxImportedSpecFileNames + " as the .spec files' 'import' declarations in " + cvlSource.getOrigpath() + ", but those are missing the actual declarations: " + missingImportDecls + " (actual 'import' declarations: " + actualImportedSpecFileNames + ")");
            }
            if (!actualImportedSpecFileNames.containsAll((Collection)approxImportedSpecFileNames)) {
                List spuriousImportDecls = CollectionsKt.minus((Iterable)approxImportedSpecFileNames, actualImportedSpecFileNames);
                throw new IllegalStateException("certoraBuild.py approximated " + approxImportedSpecFileNames + " as the .spec files' 'import' declarations in " + cvlSource.getOrigpath() + ", but those erroneously include " + spuriousImportDecls + " (actual 'import' declarations: " + actualImportedSpecFileNames + ")");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<CVLError> addRepeatingIdsInDeclsErrors(Map<String, ? extends Set<? extends CVLRange>> repeatingIdsToDeclsLocs, Function2<? super String, ? super CVLRange, ? extends CVLError> errorLogger) {
            void $this$flatMapTo$iv$iv;
            Map<String, ? extends Set<? extends CVLRange>> $this$flatMap$iv = repeatingIdsToDeclsLocs;
            boolean $i$f$flatMap = false;
            Map<String, ? extends Set<? extends CVLRange>> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry $dstr$repeatingId$declsLocs = element$iv$iv = iterator2.next();
                boolean bl = false;
                String repeatingId = (String)$dstr$repeatingId$declsLocs.getKey();
                Set declsLocs = (Set)$dstr$repeatingId$declsLocs.getValue();
                Iterable $this$map$iv = declsLocs;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cvlRange;
                    CVLRange cVLRange = (CVLRange)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(errorLogger.invoke(repeatingId, (CVLRange)cvlRange));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<CVLError> addOverrideDeclsErrors(Map<OverrideDeclaration<T>, ? extends Set<? extends CVLRange>> overrideDeclsToMatchingElems) {
            void $this$mapNotNullTo$iv$iv;
            Map<OverrideDeclaration<T>, ? extends Set<? extends CVLRange>> $this$mapNotNull$iv = overrideDeclsToMatchingElems;
            boolean $i$f$mapNotNull = false;
            Map<OverrideDeclaration<T>, ? extends Set<? extends CVLRange>> map2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                CVLError.General it$iv$iv;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry $dstr$overrideDecl$matchingElemsLocs = element$iv$iv;
                boolean bl2 = false;
                OverrideDeclaration overrideDecl = (OverrideDeclaration)$dstr$overrideDecl$matchingElemsLocs.getKey();
                Set matchingElemsLocs = (Set)$dstr$overrideDecl$matchingElemsLocs.getValue();
                if ((matchingElemsLocs.isEmpty() ? this.addUnresolvedOverrideDeclError(overrideDecl) : (matchingElemsLocs.size() > 1 ? this.addAmbiguousOverrideDeclError(overrideDecl, matchingElemsLocs) : (CVLError.General)null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final CVLError.General addUnresolvedOverrideDeclError(OverrideDeclaration<?> unresolvedOverrideDecl) {
            return new CVLError.General(unresolvedOverrideDecl.getCvlRange(), "Cannot resolve the 'override' declaration: '" + unresolvedOverrideDecl.materialize() + "' does not match any imported spec element");
        }

        private final CVLError.General addAmbiguousOverrideDeclError(OverrideDeclaration<?> ambiguousOverrideDecl, Set<? extends CVLRange> overriddenAlternatives) {
            return new CVLError.General(ambiguousOverrideDecl.getCvlRange(), "Cannot resolve the 'override' declaration: '" + ambiguousOverrideDecl.materialize() + "' matches multiple imported spec elements " + CollectionsKt.joinToString$default(overriddenAlternatives, ", ", "(", ")", 0, null, null, 56, null));
        }

        private final CVLError.General addRepeatingIdInOverrideDeclsError(String repeatingId, CVLRange cvlRange) {
            return new CVLError.General(cvlRange, Companion.repeatingIdInDeclsErrorMsg(repeatingId, "override"));
        }

        @NotNull
        public final CVLSource component1() {
            return this.getCvlSource();
        }

        @NotNull
        public final Map<String, List<String>> component2() {
            return this.cvlSourceNameToImportDecls;
        }

        @NotNull
        public final List<CVLSource> component3() {
            return this.importedCVLSources;
        }

        @NotNull
        public final WithImportedSpecs copy(@NotNull CVLSource cvlSource, @NotNull Map<String, ? extends List<String>> cvlSourceNameToImportDecls, @NotNull List<? extends CVLSource> importedCVLSources) {
            Intrinsics.checkNotNullParameter(cvlSource, "cvlSource");
            Intrinsics.checkNotNullParameter(cvlSourceNameToImportDecls, "cvlSourceNameToImportDecls");
            Intrinsics.checkNotNullParameter(importedCVLSources, "importedCVLSources");
            return new WithImportedSpecs(cvlSource, cvlSourceNameToImportDecls, importedCVLSources);
        }

        public static /* synthetic */ WithImportedSpecs copy$default(WithImportedSpecs withImportedSpecs, CVLSource cVLSource, Map map2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                cVLSource = withImportedSpecs.getCvlSource();
            }
            if ((n & 2) != 0) {
                map2 = withImportedSpecs.cvlSourceNameToImportDecls;
            }
            if ((n & 4) != 0) {
                list = withImportedSpecs.importedCVLSources;
            }
            return withImportedSpecs.copy(cVLSource, map2, list);
        }

        @NotNull
        public String toString() {
            return "WithImportedSpecs(cvlSource=" + this.getCvlSource() + ", cvlSourceNameToImportDecls=" + this.cvlSourceNameToImportDecls + ", importedCVLSources=" + this.importedCVLSources + ")";
        }

        public int hashCode() {
            int result2 = this.getCvlSource().hashCode();
            result2 = result2 * 31 + ((Object)this.cvlSourceNameToImportDecls).hashCode();
            result2 = result2 * 31 + ((Object)this.importedCVLSources).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WithImportedSpecs)) {
                return false;
            }
            WithImportedSpecs withImportedSpecs = (WithImportedSpecs)other;
            if (!Intrinsics.areEqual(this.getCvlSource(), withImportedSpecs.getCvlSource())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cvlSourceNameToImportDecls, withImportedSpecs.cvlSourceNameToImportDecls)) {
                return false;
            }
            return Intrinsics.areEqual(this.importedCVLSources, withImportedSpecs.importedCVLSources);
        }

        public static final /* synthetic */ List access$addRepeatingIdsInDeclsErrors(WithImportedSpecs $this, Map repeatingIdsToDeclsLocs, Function2 errorLogger) {
            return $this.addRepeatingIdsInDeclsErrors(repeatingIdsToDeclsLocs, errorLogger);
        }

        public static final /* synthetic */ CVLError.General access$addRepeatingIdInOverrideDeclsError(WithImportedSpecs $this, String repeatingId, CVLRange cvlRange) {
            return $this.addRepeatingIdInOverrideDeclsError(repeatingId, cvlRange);
        }

        public static final /* synthetic */ void access$checkNoImportsAreMissing(WithImportedSpecs $this, CVLSource cvlSource, List actualImportedSpecFiles) {
            $this.checkNoImportsAreMissing(cvlSource, actualImportedSpecFiles);
        }

        public static final /* synthetic */ List access$addOverrideDeclsErrors(WithImportedSpecs $this, Map overrideDeclsToMatchingElems) {
            return $this.addOverrideDeclsErrors(overrideDeclsToMatchingElems);
        }

        public static final /* synthetic */ List access$getImportedElementsWithOverriding(WithImportedSpecs $this, List overrideDecls, List importedElements, Map overrideDeclsToMatchingElems) {
            return $this.getImportedElementsWithOverriding(overrideDecls, importedElements, overrideDeclsToMatchingElems);
        }

        public static final /* synthetic */ List access$getImpRulesWithOverriddenMethodParamFilters(WithImportedSpecs $this, List matchingImpRules, CVLAst astWithoutMergedImports) {
            return $this.getImpRulesWithOverriddenMethodParamFilters(matchingImpRules, astWithoutMergedImports);
        }

        public static final /* synthetic */ CollectingResult access$getImpInvsWithOverriddenPreserved(WithImportedSpecs $this, List matchingImpInvs, CVLAst astWithoutMergedImports) {
            return $this.getImpInvsWithOverriddenPreserved(matchingImpInvs, astWithoutMergedImports);
        }
    }
}

