/*
 * Decompiled with CFR 0.152.
 */
package config;

import cli.Converter;
import cli.ConverterKt;
import cli.SanityValues;
import config.ConfigRegister;
import config.ConfigTypeKt;
import datastructures.stdcollections.ListsKt;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.VersionedFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CallTraceHardFailMode;
import smt.CEGARConfig;
import smt.ConstraintChooserEnum;
import smt.HashingScheme;
import smt.MultipleCEXStrategyEnum;
import smt.PrettifyCEXEnum;
import solver.SolverConfig;
import utils.ExtStdlibKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0015\u001d\u001e\u001f !\"#$%&'()*+,-./01B#\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\bJ\r\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0013\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cR\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0001\u0006234567\u00a8\u00068"}, d2={"Lconfig/ConfigType;", "T", "Ljava/io/Serializable;", "", "default", "name", "", "postponeRegister", "", "(Ljava/io/Serializable;Ljava/lang/String;Z)V", "getDefault", "()Ljava/io/Serializable;", "Ljava/io/Serializable;", "getName", "()Ljava/lang/String;", "value", "check", "newValue", "(Ljava/io/Serializable;)Z", "exists", "get", "getOrNull", "illegalArgMessage", "(Ljava/io/Serializable;)Ljava/lang/String;", "isDefault", "register", "", "set", "(Ljava/io/Serializable;)V", "BigIntCmdLine", "BooleanCmdLine", "CEGARConfigCmdLine", "CallTraceHardFailCmdLine", "CheckNoAddedAssertions", "CmdLine", "ConstraintChooserCmdLine", "ExecName", "HashingSchemeCmdLine", "IntCmdLine", "MainFileName", "MultipleCEXStrategyCmdLine", "PrettifyCEXCmdLine", "SanityMode", "SolverProgramCmdLine", "StringCmdLine", "StringListCmdLine", "StringSetCmdLine", "VersionedFileCmdLine", "WithArtifactModes", "WithArtifacts", "Lconfig/AWSConfig;", "Lconfig/ConfigType$MainFileName;", "Lconfig/ConfigType$WithArtifacts;", "Lconfig/ConfigType$ExecName;", "Lconfig/ConfigType$CheckNoAddedAssertions;", "Lconfig/ConfigType$CmdLine;", "Shared"})
public abstract class ConfigType<T extends Serializable> {
    @Nullable
    private final T default;
    @NotNull
    private final String name;
    @Nullable
    private T value;

    private ConfigType(T t, String name, boolean postponeRegister) {
        this.default = t;
        this.name = name;
        if (!postponeRegister) {
            this.register();
        }
    }

    public /* synthetic */ ConfigType(Serializable serializable, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(serializable, string, bl, null);
    }

    @Nullable
    public final T getDefault() {
        return this.default;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public abstract boolean check(@NotNull T var1);

    @NotNull
    public abstract String illegalArgMessage(@NotNull T var1);

    public final void register() {
        ConfigRegister.INSTANCE.register(this);
    }

    public final void set(@NotNull T newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        if (!this.check(newValue)) {
            throw new IllegalArgumentException(this.illegalArgMessage(newValue) + ": " + newValue);
        }
        this.value = newValue;
    }

    public final boolean exists() {
        return this.getOrNull() != null;
    }

    public final boolean isDefault() {
        return this.value == null;
    }

    @NotNull
    public T get() {
        T t = this.getOrNull();
        if (t == null) {
            throw new IllegalStateException(("This configuration must be non-null: " + this.name).toString());
        }
        return t;
    }

    @Nullable
    public T getOrNull() {
        T t = this.value;
        if (t == null) {
            t = this.default;
        }
        return t;
    }

    public /* synthetic */ ConfigType(Serializable serializable, String name, boolean postponeRegister, DefaultConstructorMarker $constructor_marker) {
        this(serializable, name, postponeRegister);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lconfig/ConfigType$MainFileName;", "Lconfig/ConfigType;", "", "()V", "check", "", "newValue", "illegalArgMessage", "Shared"})
    public static final class MainFileName
    extends ConfigType<String> {
        @NotNull
        public static final MainFileName INSTANCE = new MainFileName();

        private MainFileName() {
            super(null, "MainFileName", false, 4, null);
        }

        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return true;
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return "";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lconfig/ConfigType$WithArtifactModes;", "", "(Ljava/lang/String;I)V", "WithArtifacts", "WithoutArtifacts", "Shared"})
    public static final class WithArtifactModes
    extends Enum<WithArtifactModes> {
        public static final /* enum */ WithArtifactModes WithArtifacts = new WithArtifactModes();
        public static final /* enum */ WithArtifactModes WithoutArtifacts = new WithArtifactModes();
        private static final /* synthetic */ WithArtifactModes[] $VALUES;

        public static WithArtifactModes[] values() {
            return (WithArtifactModes[])$VALUES.clone();
        }

        public static WithArtifactModes valueOf(String value2) {
            return Enum.valueOf(WithArtifactModes.class, value2);
        }

        static {
            $VALUES = withArtifactModesArray = new WithArtifactModes[]{WithArtifactModes.WithArtifacts, WithArtifactModes.WithoutArtifacts};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$WithArtifacts;", "Lconfig/ConfigType;", "Lconfig/ConfigType$WithArtifactModes;", "()V", "check", "", "newValue", "illegalArgMessage", "", "Shared"})
    public static final class WithArtifacts
    extends ConfigType<WithArtifactModes> {
        @NotNull
        public static final WithArtifacts INSTANCE = new WithArtifacts();

        private WithArtifacts() {
            super((Serializable)((Object)WithArtifactModes.WithoutArtifacts), "WithArtifacts", false, 4, null);
        }

        @Override
        public boolean check(@NotNull WithArtifactModes newValue) {
            Intrinsics.checkNotNullParameter((Object)newValue, "newValue");
            return true;
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull WithArtifactModes newValue) {
            Intrinsics.checkNotNullParameter((Object)newValue, "newValue");
            return "";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lconfig/ConfigType$ExecName;", "Lconfig/ConfigType;", "", "()V", "check", "", "newValue", "illegalArgMessage", "Shared"})
    public static final class ExecName
    extends ConfigType<String> {
        @NotNull
        public static final ExecName INSTANCE = new ExecName();

        private ExecName() {
            super(null, "ExecName", true, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            if (StringsKt.isBlank(newValue)) return false;
            boolean bl = true;
            if (!bl) return false;
            CharSequence charSequence = newValue;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue(string, "separator");
            if (StringsKt.contains$default(charSequence, string, false, 2, null)) return false;
            return true;
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return "Illegal execution name";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lconfig/ConfigType$CheckNoAddedAssertions;", "Lconfig/ConfigType;", "", "()V", "check", "newValue", "illegalArgMessage", "", "Shared"})
    public static final class CheckNoAddedAssertions
    extends ConfigType<Boolean> {
        @NotNull
        public static final CheckNoAddedAssertions INSTANCE = new CheckNoAddedAssertions();

        private CheckNoAddedAssertions() {
            super(Boolean.valueOf(false), "CheckNoAddedAssertions", false, 4, null);
        }

        @Override
        public boolean check(boolean newValue) {
            return true;
        }

        @Override
        @NotNull
        public String illegalArgMessage(boolean newValue) {
            ExtStdlibKt.getImpossible!();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lconfig/ConfigType$CmdLine;", "T", "Ljava/io/Serializable;", "Lconfig/ConfigType;", "default", "converter", "Lcli/Converter;", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/io/Serializable;Lcli/Converter;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "getAliases", "()Ljava/util/List;", "allOptions", "getAllOptions", "getOption", "()Lorg/apache/commons/cli/Option;", "check", "", "newValue", "(Ljava/io/Serializable;)Z", "getMatchedOption", "cmdLine", "Lorg/apache/commons/cli/CommandLine;", "illegalArgMessage", "", "(Ljava/io/Serializable;)Ljava/lang/String;", "isConfigured", "setFromCLI", "", "Shared"})
    public static class CmdLine<T extends Serializable>
    extends ConfigType<T> {
        @NotNull
        private final Converter<T> converter;
        @NotNull
        private final Option option;
        @NotNull
        private final List<Option> aliases;
        @NotNull
        private final List<Option> allOptions;

        /*
         * WARNING - void declaration
         */
        public CmdLine(@Nullable T t, @NotNull Converter<T> converter, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(converter, "converter");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)t, ConfigTypeKt.realOpt(option), true, null);
            this.converter = converter;
            this.option = option;
            this.aliases = aliases;
            Iterable iterable = this.aliases;
            CmdLine cmdLine = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void alias;
                Option option2 = (Option)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Option(ConfigTypeKt.realOpt((Option)alias), alias.hasArg(), alias.getDescription()));
            }
            cmdLine.allOptions = ListsKt.plus((Collection)((List)destination$iv$iv), this.option);
            this.register();
        }

        public /* synthetic */ CmdLine(Serializable serializable, Converter converter, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list = ListsKt.listOf();
            }
            this(serializable, converter, option, list);
        }

        @NotNull
        public final Option getOption() {
            return this.option;
        }

        @NotNull
        public final List<Option> getAliases() {
            return this.aliases;
        }

        @NotNull
        public final List<Option> getAllOptions() {
            return this.allOptions;
        }

        @Override
        public boolean check(@NotNull T newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return true;
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull T newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return "";
        }

        @Nullable
        public final Option getMatchedOption(@NotNull CommandLine cmdLine) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
                for (Object t : (Iterable)this.allOptions) {
                    Option o = (Option)t;
                    boolean bl = false;
                    if (!cmdLine.hasOption(ConfigTypeKt.realOpt(o))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean isConfigured(@NotNull CommandLine cmdLine) {
            Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
            return this.getMatchedOption(cmdLine) != null;
        }

        public final void setFromCLI(@NotNull CommandLine cmdLine) {
            Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
            Option matchedOption = this.getMatchedOption(cmdLine);
            if (matchedOption != null) {
                if (!matchedOption.hasArg()) {
                    if (!(this.getDefault() instanceof Boolean)) {
                        boolean $i$a$-check-ConfigType$CmdLine$setFromCLI$22 = false;
                        String $i$a$-check-ConfigType$CmdLine$setFromCLI$22 = "Option " + ConfigTypeKt.realOpt(matchedOption) + " without an argument can only be a boolean flag";
                        throw new IllegalStateException($i$a$-check-ConfigType$CmdLine$setFromCLI$22.toString());
                    }
                    Boolean $this$uncheckedAs$iv = true;
                    boolean $i$f$uncheckedAs = false;
                    this.set((Serializable)$this$uncheckedAs$iv);
                } else {
                    String rawValue = cmdLine.getOptionValue(ConfigTypeKt.realOpt(matchedOption));
                    Function1<String, T> function1 = this.converter.getConvert();
                    Intrinsics.checkNotNullExpressionValue(rawValue, "rawValue");
                    Serializable convertedValue = (Serializable)function1.invoke(rawValue);
                    this.set(convertedValue);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$BooleanCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/Boolean;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class BooleanCmdLine
    extends CmdLine<Boolean> {
        public BooleanCmdLine(@Nullable Boolean bl, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)bl, ConverterKt.getBooleanConverter(), option, aliases);
        }

        public /* synthetic */ BooleanCmdLine(Boolean bl, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(bl, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$IntCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/Integer;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class IntCmdLine
    extends CmdLine<Integer> {
        public IntCmdLine(@Nullable Integer n, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)n, ConverterKt.getIntConverter(), option, aliases);
        }

        public /* synthetic */ IntCmdLine(Integer n, Option option, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(n, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$BigIntCmdLine;", "Lconfig/ConfigType$CmdLine;", "Ljava/math/BigInteger;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/math/BigInteger;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class BigIntCmdLine
    extends CmdLine<BigInteger> {
        public BigIntCmdLine(@Nullable BigInteger bigInteger, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)bigInteger, ConverterKt.getBigIntConverter(), option, aliases);
        }

        public /* synthetic */ BigIntCmdLine(BigInteger bigInteger, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(bigInteger, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$StringCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringCmdLine
    extends CmdLine<String> {
        public StringCmdLine(@Nullable String string, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)string), ConverterKt.getStringConverter(), option, aliases);
        }

        public /* synthetic */ StringCmdLine(String string, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(string, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$StringListCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "([Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringListCmdLine
    extends CmdLine<String[]> {
        public StringListCmdLine(@NotNull String[] stringArray, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(stringArray, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)stringArray, ConverterKt.getStringListConverter(), option, aliases);
        }

        public /* synthetic */ StringListCmdLine(String[] stringArray, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(stringArray, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00040\u0001B9\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002j\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lconfig/ConfigType$StringSetCmdLine;", "Lconfig/ConfigType$CmdLine;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/util/HashSet;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringSetCmdLine
    extends CmdLine<HashSet<String>> {
        public StringSetCmdLine(@Nullable HashSet<String> hashSet, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)hashSet, ConverterKt.getStringSetConverter(), option, aliases);
        }

        public /* synthetic */ StringSetCmdLine(HashSet hashSet, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(hashSet, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$SolverProgramCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "Lsolver/SolverConfig;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "([Lsolver/SolverConfig;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class SolverProgramCmdLine
    extends CmdLine<SolverConfig[]> {
        public SolverProgramCmdLine(@NotNull SolverConfig[] solverConfigArray, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(solverConfigArray, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)solverConfigArray, ConverterKt.getSolverProgramListConverter(), option, aliases);
        }

        public /* synthetic */ SolverProgramCmdLine(SolverConfig[] solverConfigArray, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(solverConfigArray, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$CEGARConfigCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/CEGARConfig;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/CEGARConfig;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class CEGARConfigCmdLine
    extends CmdLine<CEGARConfig> {
        public CEGARConfigCmdLine(@NotNull CEGARConfig cEGARConfig, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(cEGARConfig, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)cEGARConfig, ConverterKt.getCEGARConfigConverter(), option, aliases);
        }

        public /* synthetic */ CEGARConfigCmdLine(CEGARConfig cEGARConfig, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(cEGARConfig, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$HashingSchemeCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/HashingScheme;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/HashingScheme;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class HashingSchemeCmdLine
    extends CmdLine<HashingScheme> {
        public HashingSchemeCmdLine(@Nullable HashingScheme hashingScheme, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)hashingScheme, ConverterKt.getHashingSchemeConverter(), option, aliases);
        }

        public /* synthetic */ HashingSchemeCmdLine(HashingScheme hashingScheme, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(hashingScheme, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$CallTraceHardFailCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lreport/CallTraceHardFailMode;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lreport/CallTraceHardFailMode;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class CallTraceHardFailCmdLine
    extends CmdLine<CallTraceHardFailMode> {
        public CallTraceHardFailCmdLine(@NotNull CallTraceHardFailMode callTraceHardFailMode, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)callTraceHardFailMode, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)callTraceHardFailMode), ConverterKt.getCallTraceHardFailConverter(), option, aliases);
        }

        public /* synthetic */ CallTraceHardFailCmdLine(CallTraceHardFailMode callTraceHardFailMode, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(callTraceHardFailMode, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$ConstraintChooserCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/ConstraintChooserEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/ConstraintChooserEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class ConstraintChooserCmdLine
    extends CmdLine<ConstraintChooserEnum> {
        public ConstraintChooserCmdLine(@NotNull ConstraintChooserEnum constraintChooserEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)constraintChooserEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)constraintChooserEnum), ConverterKt.getConstraintChooserConverter(), option, aliases);
        }

        public /* synthetic */ ConstraintChooserCmdLine(ConstraintChooserEnum constraintChooserEnum, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(constraintChooserEnum, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$PrettifyCEXCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/PrettifyCEXEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/PrettifyCEXEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class PrettifyCEXCmdLine
    extends CmdLine<PrettifyCEXEnum> {
        public PrettifyCEXCmdLine(@NotNull PrettifyCEXEnum prettifyCEXEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)prettifyCEXEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)prettifyCEXEnum), ConverterKt.getPrettifyCEXConverter(), option, aliases);
        }

        public /* synthetic */ PrettifyCEXCmdLine(PrettifyCEXEnum prettifyCEXEnum, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(prettifyCEXEnum, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$MultipleCEXStrategyCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/MultipleCEXStrategyEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/MultipleCEXStrategyEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class MultipleCEXStrategyCmdLine
    extends CmdLine<MultipleCEXStrategyEnum> {
        public MultipleCEXStrategyCmdLine(@NotNull MultipleCEXStrategyEnum multipleCEXStrategyEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)multipleCEXStrategyEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)multipleCEXStrategyEnum), ConverterKt.getMultipleCEXStrategyConverter(), option, aliases);
        }

        public /* synthetic */ MultipleCEXStrategyCmdLine(MultipleCEXStrategyEnum multipleCEXStrategyEnum, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(multipleCEXStrategyEnum, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$SanityMode;", "Lconfig/ConfigType$CmdLine;", "Lcli/SanityValues;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lcli/SanityValues;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class SanityMode
    extends CmdLine<SanityValues> {
        public SanityMode(@NotNull SanityValues sanityValues, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)sanityValues, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)sanityValues), ConverterKt.getSanityModeConverter(), option, aliases);
        }

        public /* synthetic */ SanityMode(SanityValues sanityValues, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(sanityValues, option, list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$VersionedFileCmdLine;", "Lconfig/ConfigType$CmdLine;", "Llog/VersionedFile;", "default", "", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class VersionedFileCmdLine
    extends CmdLine<VersionedFile> {
        public VersionedFileCmdLine(@NotNull String string, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(string, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)new VersionedFile(string), new Converter(1.INSTANCE), option, aliases);
        }

        public /* synthetic */ VersionedFileCmdLine(String string, Option option, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = ListsKt.listOf();
            }
            this(string, option, list);
        }
    }
}

