/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.BinaryExp;
import spec.cvlast.CVLExp;

public enum ERelop {
    LT{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.ArithRelopExp.LtExp::new;
        }
    }
    ,
    LE{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.ArithRelopExp.LeExp::new;
        }
    }
    ,
    GT{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.ArithRelopExp.GtExp::new;
        }
    }
    ,
    GE{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.ArithRelopExp.GeExp::new;
        }
    }
    ,
    EQ{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.EqExp::new;
        }
    }
    ,
    NE{

        @Override
        public BinaryExp.Generator getGenerator() {
            return CVLExp.RelopExp.NeExp::new;
        }
    };


    public abstract BinaryExp.Generator getGenerator();

    public static ERelop fromString(String s) {
        if ("<".equals(s)) {
            return LT;
        }
        if ("<=".equals(s)) {
            return LE;
        }
        if (">".equals(s)) {
            return GT;
        }
        if (">=".equals(s)) {
            return GE;
        }
        if ("==".equals(s)) {
            return EQ;
        }
        if ("!=".equals(s)) {
            return NE;
        }
        throw new RuntimeException("Illegal relop " + s);
    }
}

