/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.ConstExp;
import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.NamedParam;
import com.certora.evmverifier.cvl.TypeOrLhs;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import spec.TypeResolver;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.VMParam;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typedescriptors.VMTypeDescriptor;
import utils.CollectingResult;

public class CallSummary {
    private final CVLRange cvlRange;
    private final SummaryType summaryType;
    private final ConstExp returnValue;
    private final Boolean optimistic;
    private final List<Cmd> blockCmd;
    private final List<NamedParam> withParams;
    private final Exp exp;
    private final List<TypeOrLhs> expectedType;
    private Boolean unresolved;

    public CallSummary(CVLRange _cvlRange, SummaryType _type) {
        if (_type == SummaryType.ALWAYS) {
            throw new RuntimeException("Cannot call one-arg constructor when type is ALWAYS");
        }
        this.cvlRange = _cvlRange;
        this.summaryType = _type;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
        this.unresolved = false;
        this.optimistic = null;
        this.expectedType = null;
    }

    public CallSummary(CVLRange _cvlRange, SummaryType _type, ConstExp _returnValue) {
        if (_type != SummaryType.ALWAYS) {
            throw new RuntimeException("Cannot call constructor with returnValue when type is not ALWAYS");
        }
        this.cvlRange = _cvlRange;
        this.summaryType = _type;
        this.returnValue = _returnValue;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
        this.unresolved = false;
        this.optimistic = null;
        this.expectedType = null;
    }

    public CallSummary(CVLRange cvlRange, SummaryType type2, Boolean optimistic) {
        if (type2 != SummaryType.DISPATCHER) {
            throw new IllegalArgumentException("Cannot call two-arg boolean constructor when type is not DISPATCHER");
        }
        this.cvlRange = cvlRange;
        this.summaryType = type2;
        this.optimistic = optimistic;
        this.unresolved = true;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
        this.expectedType = null;
    }

    public CallSummary(CVLRange _cvlRange, SummaryType _type, Exp _exp, List<NamedParam> _withParams, List<TypeOrLhs> _expectedType) {
        if (_type != SummaryType.EXP) {
            throw new IllegalArgumentException("Cannot call constructor with expression when type is not EXP");
        }
        this.cvlRange = _cvlRange;
        this.summaryType = _type;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = Objects.requireNonNullElse(_withParams, Collections.emptyList());
        this.exp = _exp;
        this.unresolved = false;
        this.optimistic = null;
        this.expectedType = _expectedType;
    }

    public void unresolved() {
        this.unresolved = true;
    }

    public void all() {
        this.unresolved = false;
    }

    public void default_() {
        if (this.summaryType == SummaryType.DISPATCHER) {
            this.unresolved();
        } else {
            this.unresolved = false;
        }
    }

    public CollectingResult<? extends SpecCallSummary, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
        CollectingResult<Object, Object> summary;
        switch (this.summaryType) {
            case ALWAYS: {
                assert (this.returnValue != null);
                summary = KotlinizeResult.lift(new SpecCallSummary.Always(this.returnValue.asCVLConstant(scope), this.unresolved, this.cvlRange));
                break;
            }
            case CONSTANT: {
                summary = KotlinizeResult.lift(new SpecCallSummary.Constant(this.unresolved, this.cvlRange));
                break;
            }
            case PER_CALLEE_CONSTANT: {
                summary = KotlinizeResult.lift(new SpecCallSummary.PerCalleeConstant(this.unresolved, this.cvlRange));
                break;
            }
            case NONDET: {
                summary = KotlinizeResult.lift(new SpecCallSummary.HavocSummary.Nondet(this.unresolved, this.cvlRange));
                break;
            }
            case HAVOC_ECF: {
                summary = KotlinizeResult.lift(new SpecCallSummary.HavocSummary.HavocECF(this.unresolved, this.cvlRange));
                break;
            }
            case HAVOC_ALL: {
                summary = KotlinizeResult.lift(new SpecCallSummary.HavocSummary.HavocAll(this.unresolved, this.cvlRange));
                break;
            }
            case DISPATCHER: {
                summary = KotlinizeResult.lift(new SpecCallSummary.Dispatcher(this.unresolved, this.optimistic, this.cvlRange));
                break;
            }
            case EXP: {
                summary = scope.extendInCollecting(CVLScope.Item.ExpressionSummary::new, childScope -> KotlinizeResult.bind(this.exp.kotlinize(resolver, (CVLScope)childScope), NamedParam.toPureNamedParams(this.withParams, resolver, childScope), this.expectedType != null ? CollectingResult.Companion.flatten(this.expectedType.stream().map(t -> t.toVMType(resolver, (CVLScope)childScope)).collect(Collectors.toList())) : KotlinizeResult.lift(null), (exp, withParams, expectedType) -> KotlinizeResult.lift(new SpecCallSummary.Exp(this.unresolved, (CVLExp)exp, (List<? extends VMParam>)funParams, (List<CVLParam.Named>)withParams, this.cvlRange, (CVLScope)childScope, (List<? extends VMTypeDescriptor>)expectedType))));
                break;
            }
            case AUTO: {
                summary = KotlinizeResult.lift(new SpecCallSummary.HavocSummary.Auto(this.unresolved, this.cvlRange));
                break;
            }
            default: {
                throw new RuntimeException("Not handling case: " + this.summaryType.name());
            }
        }
        return summary;
    }

    static enum SummaryType {
        ALWAYS,
        CONSTANT,
        PER_CALLEE_CONSTANT,
        NONDET,
        HAVOC_ECF,
        HAVOC_ALL,
        AUTO,
        DISPATCHER,
        COMMANDS,
        EXP;

    }
}

