/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Definitions;
import com.certora.evmverifier.cvl.ImportedContract;
import com.certora.evmverifier.cvl.ImportedFunction;
import com.certora.evmverifier.cvl.ImportedSpecFile;
import com.certora.evmverifier.cvl.KotlinizeResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.TypeResolver;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLScope;
import spec.cvlast.IRule;
import spec.cvlast.OverrideDeclarations;
import spec.cvlast.SortDeclaration;
import spec.cvlast.UseDeclarations;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class Ast
implements Kotlinizable<CVLAst> {
    public int pragma = 0;
    public List<ImportedFunction> imports;
    public Definitions definitionsOrUseDecls;
    public List<ImportedContract> importedContracts;
    public List<ImportedSpecFile> importedSpecFiles;

    public Ast(String _pragma, List<ImportedFunction> _imports, Definitions _definitionsOrUseDecls, List<ImportedContract> _contracts, List<ImportedSpecFile> _importedSpecFiles) {
        this.pragma = this.parsePragma(_pragma);
        this.imports = _imports;
        this.definitionsOrUseDecls = _definitionsOrUseDecls;
        this.importedContracts = _contracts;
        this.importedSpecFiles = _importedSpecFiles;
    }

    private Integer parsePragma(String pragma) {
        int mainSeparator = pragma.indexOf(".");
        int majorVersion = Integer.parseInt(pragma.substring(0, mainSeparator));
        int minorVersion = Integer.parseInt(pragma.substring(mainSeparator + 1));
        return majorVersion * 100 + minorVersion;
    }

    @Override
    public CollectingResult<CVLAst, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        ArrayList<CollectingResult<Unit, CVLError>> contractAliases = new ArrayList<CollectingResult<Unit, CVLError>>();
        for (ImportedContract imp : this.importedContracts) {
            contractAliases.add(resolver.registerContractAlias(imp));
        }
        CollectingResult contractAliasesFlattened = CollectingResult.Companion.flatten(contractAliases);
        CollectingResult methodBlockAnnotation = Kotlinizer.kotlinizeList(this.imports, scope, resolver);
        CollectingResult<List<SortDeclaration>, CVLError> sorts = this.definitionsOrUseDecls.kotlinizeSorts(resolver, scope);
        resolver.registerSorts(sorts.resultOrNull());
        CollectingResult<UseDeclarations, CVLError> useDeclarations = this.definitionsOrUseDecls.kotlinizeUseDeclarations(resolver, scope);
        CollectingResult<List<IRule>, CVLError> rules = this.definitionsOrUseDecls.kotlinizeRules(resolver, scope);
        CollectingResult<List<CVLFunction>, CVLError> subs = this.definitionsOrUseDecls.kotlinizeSubs(resolver, scope);
        CollectingResult<List<CVLInvariant>, CVLError> invs = this.definitionsOrUseDecls.kotlinizeInvariants(resolver, scope);
        CollectingResult<List<CVLGhostDeclaration>, CVLError> ghostDecls = this.definitionsOrUseDecls.kotlinizeGhostDecls(resolver, scope);
        CollectingResult<List<CVLDefinition>, CVLError> defs2 = this.definitionsOrUseDecls.kotlinizeMacroDefinitions(resolver, scope);
        CollectingResult<List<CVLHook>, CVLError> hooks = this.definitionsOrUseDecls.kotlinizeHooks(resolver, scope);
        CollectingResult contractImports = Kotlinizer.kotlinizeList(this.importedContracts, scope, resolver);
        CollectingResult specImports = Kotlinizer.kotlinizeList(this.importedSpecFiles, scope, resolver);
        CollectingResult<OverrideDeclarations, CVLError> overrideDeclarations = this.definitionsOrUseDecls.kotlinizeOverrideDeclarations(resolver, scope);
        return KotlinizeResult.bindMany(() -> KotlinizeResult.lift(new CVLAst(this.pragma, (List)methodBlockAnnotation.force(), (UseDeclarations)useDeclarations.force(), (List)rules.force(), (List)subs.force(), (List)invs.force(), (List)sorts.force(), (List)ghostDecls.force(), (List)defs2.force(), (List)hooks.force(), (List)contractImports.force(), (List)specImports.force(), (OverrideDeclarations)overrideDeclarations.force(), scope)), methodBlockAnnotation, useDeclarations, rules, subs, invs, sorts, ghostDecls, defs2, hooks, contractImports, specImports, overrideDeclarations, contractAliasesFlattened);
    }

    public CollectingResult<CVLAst, CVLError> toCVLAst(TypeResolver resolver, CVLScope scope) {
        return this.kotlinize(resolver, scope);
    }
}

