/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.NumberExp;
import com.certora.evmverifier.cvl.TypeOrLhs;
import java.math.BigInteger;
import spec.TypeResolver;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typedescriptors.VMTypeDescriptor;
import utils.CollectingResult;

class ArrayLhs
extends TypeOrLhs {
    private final TypeOrLhs inner;
    private final TypeOrLhs baseType;
    private final Exp index;

    ArrayLhs(CVLRange _range, TypeOrLhs _inner, Exp _index) {
        super(_range);
        this.baseType = this.inner = _inner;
        this.index = _index;
    }

    @Override
    public CollectingResult<CVLLhs, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(this.inner.kotlinize(resolver, scope), this.index.kotlinize(resolver, scope), (lhs, index) -> new CVLLhs.Array(this.range, (CVLLhs)lhs, (CVLExp)index, new CVLExpTag(scope, this.range)));
    }

    private CollectingResult<BigInteger, CVLError> staticIndex() {
        if (this.index instanceof NumberExp) {
            return KotlinizeResult.lift(((NumberExp)this.index).n);
        }
        return KotlinizeResult.error(new CVLError.General(this.range, "Expected a number literal for a static array type, not " + this.index));
    }

    @Override
    CollectingResult<CVLType.PureCVLType, CVLError> toCVLType(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(this.baseType.toCVLType(resolver, scope), this.staticIndex(), CVLType.PureCVLType.StaticArray::new);
    }

    @Override
    CollectingResult<VMTypeDescriptor, CVLError> toVMType(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(this.baseType.toVMType(resolver, scope), this.staticIndex(), (baseType, index) -> resolver.getFactory().getStaticArray((VMTypeDescriptor)baseType, this.location, (BigInteger)index));
    }
}

