/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lutils/CertoraFileCache;", "", "()V", "fileNameToContentMap", "", "", "logger", "Llog/Logger;", "cacheFileContents", "", "fileName", "fileContent", "exists", "", "findReaderPath", "path", "getContentReader", "Ljava/io/Reader;", "CertoraFileCacheException", "Shared"})
public final class CertoraFileCache {
    @NotNull
    public static final CertoraFileCache INSTANCE = new CertoraFileCache();
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.COMMON);
    @NotNull
    private static final Map<String, String> fileNameToContentMap = new LinkedHashMap();

    private CertoraFileCache() {
    }

    public final synchronized void cacheFileContents(@NotNull String fileName, @NotNull String fileContent) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(fileContent, "fileContent");
        fileNameToContentMap.put(fileName, fileContent);
    }

    public final synchronized boolean exists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return fileNameToContentMap.containsKey(fileName) || new File(fileName).exists();
    }

    @NotNull
    public final synchronized Reader getContentReader(@NotNull String fileName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Object object = this.findReaderPath(fileName);
        if (object.length() == 0) {
            boolean bl = false;
            charSequence = fileName;
        } else {
            charSequence = object;
        }
        String readerPath = (String)charSequence;
        if (fileNameToContentMap.containsKey(readerPath)) {
            return new StringReader(fileNameToContentMap.get(readerPath));
        }
        try {
            object = new FileReader(Config.INSTANCE.prependInternalDir(readerPath));
        }
        catch (FileNotFoundException e) {
            String errorMsg = "CertoraFileCache could not access " + readerPath + "; file either does not exist on disk or was not cached";
            logger.warn(e, (Function0<? extends Object>)new Function0<Object>(errorMsg){
                final /* synthetic */ String $errorMsg;
                {
                    this.$errorMsg = $errorMsg;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$errorMsg;
                }
            });
            throw new CertoraFileCacheException(errorMsg);
        }
        return object;
    }

    private final String findReaderPath(String path2) {
        if (new File(path2).exists()) {
            return path2;
        }
        int index = StringsKt.indexOf$default((CharSequence)path2, ".certora_config", 0, false, 6, null);
        String relPath = "";
        if (index >= 0) {
            String string = path2.substring(index);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            relPath = string;
            if (new File(relPath).exists()) {
                return relPath;
            }
            Path path3 = Paths.get((String)Config.INSTANCE.getCertoraBuildDirectory().get(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path3, "get(path)");
            String pathInBuild = ((Object)path3.resolve(relPath)).toString();
            if (new File(pathInBuild).exists()) {
                return pathInBuild;
            }
        }
        return relPath;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lutils/CertoraFileCache$CertoraFileCacheException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errMsg", "", "(Ljava/lang/String;)V", "Shared"})
    public static final class CertoraFileCacheException
    extends Exception {
        public CertoraFileCacheException(@NotNull String errMsg) {
            Intrinsics.checkNotNullParameter(errMsg, "errMsg");
            super(errMsg);
        }
    }
}

