/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.dynamicconversion.AddDynamicConversion;
import ksp.dynamicconversion.ConvertibleWith;
import ksp.dynamicconversion.DynamicConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.AltErgoSolverInfo;
import solver.ArithmeticOperations;
import solver.BitwuzlaSolverInfo;
import solver.CVC4SolverInfo;
import solver.CVC5SolverInfo;
import solver.ConfigStatistics;
import solver.Configurable;
import solver.Configuration;
import solver.SmtInterpolSolverInfo;
import solver.SolverChoice;
import solver.SolverConfig;
import solver.SolverConfigKt;
import solver.SolverInfo;
import solver.Solver_SolverConfig_dynamicConversionKt;
import solver.VampireSolverInfo;
import solver.YicesSolverInfo;
import solver.Z3SolverInfo;
import utils.RuntimeEnvInfo;

@AddDynamicConversion
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0087\b\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u000bJKLMNOPQRSTB\u009f\u0001\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011\u0012\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u0000\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0017\u00a2\u0006\u0002\u0010\u0018J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\u0010\u00105\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\u0010-J\u001b\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0017H\u00c6\u0003J\t\u00107\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J\t\u0010:\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u0010\u0010<\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\u0015\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u00aa\u0001\u0010?\u001a\u00020\u00002\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0017H\u00c6\u0001\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010CH\u00d6\u0003J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010E\u001a\u00020\u000bJ\u0006\u0010F\u001a\u00020GJ\t\u0010H\u001a\u00020\u0015H\u00d6\u0001J\t\u0010I\u001a\u00020\u0006H\u00d6\u0001R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001f\u00a8\u0006U"}, d2={"Lsolver/SolverConfig;", "Lsolver/Configurable;", "Ljava/io/Serializable;", "solverInfo", "Lsolver/SolverInfo;", "variantName", "", "name", "clOptions", "", "incremental", "", "timelimit", "Ljava/time/Duration;", "memlimitBytes", "", "qualifiesFor", "Lkotlin/Function1;", "Lsolver/SolverConfig$LogicFeatures;", "preprocessorConfig", "randomSeed", "", "canBeSkipped", "Lkotlin/Function2;", "(Lsolver/SolverInfo;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ZLjava/time/Duration;Ljava/lang/Long;Lkotlin/jvm/functions/Function1;Lsolver/SolverConfig;Ljava/lang/Integer;Lkotlin/jvm/functions/Function2;)V", "getCanBeSkipped", "()Lkotlin/jvm/functions/Function2;", "getClOptions", "()Ljava/util/List;", "configName", "getConfigName", "()Ljava/lang/String;", "fullName", "getFullName", "getIncremental", "()Z", "getMemlimitBytes", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getName", "getPreprocessorConfig", "()Lsolver/SolverConfig;", "getQualifiesFor", "()Lkotlin/jvm/functions/Function1;", "getRandomSeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSolverInfo", "()Lsolver/SolverInfo;", "getTimelimit", "()Ljava/time/Duration;", "getVariantName", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lsolver/SolverInfo;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ZLjava/time/Duration;Ljava/lang/Long;Lkotlin/jvm/functions/Function1;Lsolver/SolverConfig;Ljava/lang/Integer;Lkotlin/jvm/functions/Function2;)Lsolver/SolverConfig;", "equals", "other", "", "getCommandline", "fromStdin", "getConfigStats", "Lsolver/ConfigStatistics;", "hashCode", "toString", "AltErgoRegistry", "BitwuzlaRegistry", "CVC4Registry", "CVC5Registry", "Companion", "Converter", "LogicFeatures", "SmtInterpolRegistry", "VampireRegistry", "YicesRegistry", "Z3Registry", "GeneralUtils"})
public final class SolverConfig
implements Configurable,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolverInfo solverInfo;
    @NotNull
    private final String variantName;
    @Nullable
    private final String name;
    @NotNull
    private final List<String> clOptions;
    private final boolean incremental;
    @Nullable
    private final Duration timelimit;
    @Nullable
    private final Long memlimitBytes;
    @NotNull
    private final Function1<LogicFeatures, Boolean> qualifiesFor;
    @Nullable
    private final SolverConfig preprocessorConfig;
    @Nullable
    private final Integer randomSeed;
    @NotNull
    private final Function2<LogicFeatures, Duration, Boolean> canBeSkipped;
    @NotNull
    private final String fullName;
    @NotNull
    private final String configName;
    @NotNull
    private static final AltErgoRegistry altergo = (AltErgoRegistry)Companion.register((Configuration.Registry)new AltErgoRegistry());
    @NotNull
    private static final BitwuzlaRegistry bitwuzla = (BitwuzlaRegistry)Companion.register((Configuration.Registry)new BitwuzlaRegistry());
    @NotNull
    private static final CVC4Registry cvc4 = (CVC4Registry)Companion.register((Configuration.Registry)new CVC4Registry());
    @NotNull
    private static final CVC5Registry cvc5 = (CVC5Registry)Companion.register((Configuration.Registry)new CVC5Registry());
    @NotNull
    private static final SmtInterpolRegistry smtinterpol = (SmtInterpolRegistry)Companion.register((Configuration.Registry)new SmtInterpolRegistry());
    @NotNull
    private static final VampireRegistry vampire = (VampireRegistry)Companion.register((Configuration.Registry)new VampireRegistry());
    @NotNull
    private static final YicesRegistry yices = (YicesRegistry)Companion.register((Configuration.Registry)new YicesRegistry());
    @NotNull
    private static final Z3Registry z3 = (Z3Registry)Companion.register((Configuration.Registry)new Z3Registry());

    public SolverConfig(@ConvertibleWith(converter=SolverInfo.Converter.class) @NotNull SolverInfo solverInfo, @NotNull String variantName, @Nullable String name, @NotNull List<String> clOptions, boolean incremental, @Nullable Duration timelimit, @Nullable Long memlimitBytes, @NotNull Function1<? super LogicFeatures, Boolean> qualifiesFor, @ConvertibleWith(converter=Converter.class) @Nullable SolverConfig preprocessorConfig, @Nullable Integer randomSeed, @NotNull Function2<? super LogicFeatures, ? super Duration, Boolean> canBeSkipped) {
        Intrinsics.checkNotNullParameter(solverInfo, "solverInfo");
        Intrinsics.checkNotNullParameter(variantName, "variantName");
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        Intrinsics.checkNotNullParameter(qualifiesFor, "qualifiesFor");
        Intrinsics.checkNotNullParameter(canBeSkipped, "canBeSkipped");
        this.solverInfo = solverInfo;
        this.variantName = variantName;
        this.name = name;
        this.clOptions = clOptions;
        this.incremental = incremental;
        this.timelimit = timelimit;
        this.memlimitBytes = memlimitBytes;
        this.qualifiesFor = qualifiesFor;
        this.preprocessorConfig = preprocessorConfig;
        this.randomSeed = randomSeed;
        this.canBeSkipped = canBeSkipped;
        Object object = this.name;
        if (object == null) {
            String string = this.solverInfo.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            object = string + "_" + this.variantName;
        }
        this.fullName = object;
        this.configName = this.variantName;
    }

    public /* synthetic */ SolverConfig(SolverInfo solverInfo, String string, String string2, List list, boolean bl, Duration duration, Long l, Function1 function1, SolverConfig solverConfig, Integer n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            duration = null;
        }
        if ((n2 & 0x40) != 0) {
            l = null;
        }
        if ((n2 & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n2 & 0x100) != 0) {
            solverConfig = null;
        }
        if ((n2 & 0x200) != 0) {
            n = null;
        }
        if ((n2 & 0x400) != 0) {
            function2 = 2.INSTANCE;
        }
        this(solverInfo, string, string2, list, bl, duration, l, function1, solverConfig, n, function2);
    }

    @NotNull
    public final SolverInfo getSolverInfo() {
        return this.solverInfo;
    }

    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getClOptions() {
        return this.clOptions;
    }

    public final boolean getIncremental() {
        return this.incremental;
    }

    @Nullable
    public final Duration getTimelimit() {
        return this.timelimit;
    }

    @Nullable
    public final Long getMemlimitBytes() {
        return this.memlimitBytes;
    }

    @NotNull
    public final Function1<LogicFeatures, Boolean> getQualifiesFor() {
        return this.qualifiesFor;
    }

    @Nullable
    public final SolverConfig getPreprocessorConfig() {
        return this.preprocessorConfig;
    }

    @Nullable
    public final Integer getRandomSeed() {
        return this.randomSeed;
    }

    @NotNull
    public final Function2<LogicFeatures, Duration, Boolean> getCanBeSkipped() {
        return this.canBeSkipped;
    }

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    @Override
    @NotNull
    public String getConfigName() {
        return this.configName;
    }

    @NotNull
    public final List<String> getCommandline(boolean fromStdin) {
        List<String> options = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.clOptions, (Iterable)(this.incremental ? this.solverInfo.getOptionForIncremental() : CollectionsKt.emptyList())), (Iterable)(this.timelimit != null ? this.solverInfo.getOptionForTimelimit(this.timelimit) : CollectionsKt.emptyList())), (Iterable)(this.memlimitBytes != null ? this.solverInfo.getOptionForMemlimit(this.memlimitBytes) : CollectionsKt.emptyList())), (Iterable)(this.randomSeed != null ? this.solverInfo.getOptionForRandomSeed(this.randomSeed) : CollectionsKt.emptyList()));
        List<String> baseCL = fromStdin ? this.solverInfo.commandForStdInMode(options) : options;
        return CollectionsKt.plus((Collection)RuntimeEnvInfo.INSTANCE.getPrlimitCommandIfAvailable(this.memlimitBytes), (Iterable)baseCL);
    }

    public static /* synthetic */ List getCommandline$default(SolverConfig solverConfig, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return solverConfig.getCommandline(bl);
    }

    @NotNull
    public final ConfigStatistics getConfigStats() {
        Function1 getSolverNameAndArgs2 = getConfigStats.getSolverNameAndArgs.1.INSTANCE;
        Pair pair2 = (Pair)getSolverNameAndArgs2.invoke(SolverConfig.getCommandline$default(this, false, 1, null));
        String name = (String)pair2.component1();
        String args2 = (String)pair2.component2();
        return new ConfigStatistics(this.fullName, String.valueOf(name), args2);
    }

    @NotNull
    public final SolverInfo component1() {
        return this.solverInfo;
    }

    @NotNull
    public final String component2() {
        return this.variantName;
    }

    @Nullable
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final List<String> component4() {
        return this.clOptions;
    }

    public final boolean component5() {
        return this.incremental;
    }

    @Nullable
    public final Duration component6() {
        return this.timelimit;
    }

    @Nullable
    public final Long component7() {
        return this.memlimitBytes;
    }

    @NotNull
    public final Function1<LogicFeatures, Boolean> component8() {
        return this.qualifiesFor;
    }

    @Nullable
    public final SolverConfig component9() {
        return this.preprocessorConfig;
    }

    @Nullable
    public final Integer component10() {
        return this.randomSeed;
    }

    @NotNull
    public final Function2<LogicFeatures, Duration, Boolean> component11() {
        return this.canBeSkipped;
    }

    @NotNull
    public final SolverConfig copy(@ConvertibleWith(converter=SolverInfo.Converter.class) @NotNull SolverInfo solverInfo, @NotNull String variantName, @Nullable String name, @NotNull List<String> clOptions, boolean incremental, @Nullable Duration timelimit, @Nullable Long memlimitBytes, @NotNull Function1<? super LogicFeatures, Boolean> qualifiesFor, @ConvertibleWith(converter=Converter.class) @Nullable SolverConfig preprocessorConfig, @Nullable Integer randomSeed, @NotNull Function2<? super LogicFeatures, ? super Duration, Boolean> canBeSkipped) {
        Intrinsics.checkNotNullParameter(solverInfo, "solverInfo");
        Intrinsics.checkNotNullParameter(variantName, "variantName");
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        Intrinsics.checkNotNullParameter(qualifiesFor, "qualifiesFor");
        Intrinsics.checkNotNullParameter(canBeSkipped, "canBeSkipped");
        return new SolverConfig(solverInfo, variantName, name, clOptions, incremental, timelimit, memlimitBytes, qualifiesFor, preprocessorConfig, randomSeed, canBeSkipped);
    }

    public static /* synthetic */ SolverConfig copy$default(SolverConfig solverConfig, SolverInfo solverInfo, String string, String string2, List list, boolean bl, Duration duration, Long l, Function1 function1, SolverConfig solverConfig2, Integer n, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            solverInfo = solverConfig.solverInfo;
        }
        if ((n2 & 2) != 0) {
            string = solverConfig.variantName;
        }
        if ((n2 & 4) != 0) {
            string2 = solverConfig.name;
        }
        if ((n2 & 8) != 0) {
            list = solverConfig.clOptions;
        }
        if ((n2 & 0x10) != 0) {
            bl = solverConfig.incremental;
        }
        if ((n2 & 0x20) != 0) {
            duration = solverConfig.timelimit;
        }
        if ((n2 & 0x40) != 0) {
            l = solverConfig.memlimitBytes;
        }
        if ((n2 & 0x80) != 0) {
            function1 = solverConfig.qualifiesFor;
        }
        if ((n2 & 0x100) != 0) {
            solverConfig2 = solverConfig.preprocessorConfig;
        }
        if ((n2 & 0x200) != 0) {
            n = solverConfig.randomSeed;
        }
        if ((n2 & 0x400) != 0) {
            function2 = solverConfig.canBeSkipped;
        }
        return solverConfig.copy(solverInfo, string, string2, list, bl, duration, l, function1, solverConfig2, n, function2);
    }

    @NotNull
    public String toString() {
        return "SolverConfig(solverInfo=" + this.solverInfo + ", variantName=" + this.variantName + ", name=" + this.name + ", clOptions=" + this.clOptions + ", incremental=" + this.incremental + ", timelimit=" + this.timelimit + ", memlimitBytes=" + this.memlimitBytes + ", qualifiesFor=" + this.qualifiesFor + ", preprocessorConfig=" + this.preprocessorConfig + ", randomSeed=" + this.randomSeed + ", canBeSkipped=" + this.canBeSkipped + ")";
    }

    public int hashCode() {
        int result2 = this.solverInfo.hashCode();
        result2 = result2 * 31 + this.variantName.hashCode();
        result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        result2 = result2 * 31 + ((Object)this.clOptions).hashCode();
        int n = this.incremental ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + (this.timelimit == null ? 0 : this.timelimit.hashCode());
        result2 = result2 * 31 + (this.memlimitBytes == null ? 0 : ((Object)this.memlimitBytes).hashCode());
        result2 = result2 * 31 + this.qualifiesFor.hashCode();
        result2 = result2 * 31 + (this.preprocessorConfig == null ? 0 : this.preprocessorConfig.hashCode());
        result2 = result2 * 31 + (this.randomSeed == null ? 0 : ((Object)this.randomSeed).hashCode());
        result2 = result2 * 31 + this.canBeSkipped.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SolverConfig)) {
            return false;
        }
        SolverConfig solverConfig = (SolverConfig)other;
        if (!Intrinsics.areEqual(this.solverInfo, solverConfig.solverInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.variantName, solverConfig.variantName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.name, solverConfig.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.clOptions, solverConfig.clOptions)) {
            return false;
        }
        if (this.incremental != solverConfig.incremental) {
            return false;
        }
        if (!Intrinsics.areEqual(this.timelimit, solverConfig.timelimit)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.memlimitBytes, solverConfig.memlimitBytes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.qualifiesFor, solverConfig.qualifiesFor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.preprocessorConfig, solverConfig.preprocessorConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.randomSeed, solverConfig.randomSeed)) {
            return false;
        }
        return Intrinsics.areEqual(this.canBeSkipped, solverConfig.canBeSkipped);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$Converter;", "Lksp/dynamicconversion/DynamicConverter;", "Lsolver/SolverConfig;", "()V", "invoke", "v", "", "GeneralUtils"})
    public static final class Converter
    implements DynamicConverter<SolverConfig> {
        @Override
        @NotNull
        public SolverConfig invoke(@NotNull Object v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return (SolverConfig)Companion.construct(v, (Configuration)Companion);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lsolver/SolverConfig$LogicFeatures;", "Ljava/io/Serializable;", "arithmeticOperations", "Lsolver/ArithmeticOperations;", "usesDatatypes", "", "usesQuantifiers", "(Lsolver/ArithmeticOperations;ZZ)V", "getArithmeticOperations", "()Lsolver/ArithmeticOperations;", "getUsesDatatypes", "()Z", "getUsesQuantifiers", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "GeneralUtils"})
    public static final class LogicFeatures
    implements Serializable {
        @NotNull
        private final ArithmeticOperations arithmeticOperations;
        private final boolean usesDatatypes;
        private final boolean usesQuantifiers;

        public LogicFeatures(@NotNull ArithmeticOperations arithmeticOperations, boolean usesDatatypes, boolean usesQuantifiers) {
            Intrinsics.checkNotNullParameter((Object)arithmeticOperations, "arithmeticOperations");
            this.arithmeticOperations = arithmeticOperations;
            this.usesDatatypes = usesDatatypes;
            this.usesQuantifiers = usesQuantifiers;
        }

        @NotNull
        public final ArithmeticOperations getArithmeticOperations() {
            return this.arithmeticOperations;
        }

        public final boolean getUsesDatatypes() {
            return this.usesDatatypes;
        }

        public final boolean getUsesQuantifiers() {
            return this.usesQuantifiers;
        }

        @NotNull
        public final ArithmeticOperations component1() {
            return this.arithmeticOperations;
        }

        public final boolean component2() {
            return this.usesDatatypes;
        }

        public final boolean component3() {
            return this.usesQuantifiers;
        }

        @NotNull
        public final LogicFeatures copy(@NotNull ArithmeticOperations arithmeticOperations, boolean usesDatatypes, boolean usesQuantifiers) {
            Intrinsics.checkNotNullParameter((Object)arithmeticOperations, "arithmeticOperations");
            return new LogicFeatures(arithmeticOperations, usesDatatypes, usesQuantifiers);
        }

        public static /* synthetic */ LogicFeatures copy$default(LogicFeatures logicFeatures, ArithmeticOperations arithmeticOperations, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                arithmeticOperations = logicFeatures.arithmeticOperations;
            }
            if ((n & 2) != 0) {
                bl = logicFeatures.usesDatatypes;
            }
            if ((n & 4) != 0) {
                bl2 = logicFeatures.usesQuantifiers;
            }
            return logicFeatures.copy(arithmeticOperations, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "LogicFeatures(arithmeticOperations=" + this.arithmeticOperations + ", usesDatatypes=" + this.usesDatatypes + ", usesQuantifiers=" + this.usesQuantifiers + ")";
        }

        public int hashCode() {
            int result2 = this.arithmeticOperations.hashCode();
            int n = this.usesDatatypes ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.usesQuantifiers ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogicFeatures)) {
                return false;
            }
            LogicFeatures logicFeatures = (LogicFeatures)other;
            if (this.arithmeticOperations != logicFeatures.arithmeticOperations) {
                return false;
            }
            if (this.usesDatatypes != logicFeatures.usesDatatypes) {
                return false;
            }
            return this.usesQuantifiers == logicFeatures.usesQuantifiers;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$AltErgoRegistry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "GeneralUtils"})
    public static final class AltErgoRegistry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(AltErgoSolverInfo.INSTANCE, "def", null, null, false, null, null, null, null, null, null, 2044, null));

        public AltErgoRegistry() {
            super("altergo", "def");
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$BitwuzlaRegistry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "GeneralUtils"})
    public static final class BitwuzlaRegistry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(BitwuzlaSolverInfo.INSTANCE, "def", null, null, false, null, null, def.1.INSTANCE, null, null, null, 1916, null));

        public BitwuzlaRegistry() {
            super("bitwuzla", "def");
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lsolver/SolverConfig$CVC5Registry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "bv", "getBv", "()Lsolver/SolverConfig;", "def", "getDef", "lin", "getLin", "nonlin", "getNonlin", "q", "getQ", "GeneralUtils"})
    public static final class CVC5Registry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(CVC5SolverInfo.INSTANCE, "def", null, null, false, null, null, null, null, null, def.1.INSTANCE, 1020, null));
        @NotNull
        private final SolverConfig nonlin;
        @NotNull
        private final SolverConfig lin;
        @NotNull
        private final SolverConfig q;
        @NotNull
        private final SolverConfig bv;

        public CVC5Registry() {
            super("cvc5", "def");
            Object object = new String[]{"--nl-ext-tplanes", "--decision=justification"};
            this.nonlin = (SolverConfig)this.register((Configurable)new SolverConfig(CVC5SolverInfo.INSTANCE, "nonlin", null, CollectionsKt.listOf(object), false, null, null, nonlin.1.INSTANCE, null, null, nonlin.2.INSTANCE, 884, null));
            this.lin = (SolverConfig)this.register((Configurable)new SolverConfig(CVC5SolverInfo.INSTANCE, "lin", null, CollectionsKt.listOf("--decision=justification"), false, null, null, lin.1.INSTANCE, null, null, lin.2.INSTANCE, 884, null));
            object = CVC5SolverInfo.INSTANCE;
            List<String> list = CollectionsKt.listOf("--full-saturate-quant");
            this.q = (SolverConfig)this.register((Configurable)new SolverConfig((SolverInfo)object, "q", null, list, false, null, null, q.1.INSTANCE, null, null, q.2.INSTANCE, 884, null));
            this.bv = (SolverConfig)this.register((Configurable)new SolverConfig(CVC5SolverInfo.INSTANCE, "bv", null, CollectionsKt.listOf("--solve-bv-as-int=iand"), false, null, null, bv.1.INSTANCE, null, null, null, 1908, null));
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }

        @NotNull
        public final SolverConfig getNonlin() {
            return this.nonlin;
        }

        @NotNull
        public final SolverConfig getLin() {
            return this.lin;
        }

        @NotNull
        public final SolverConfig getQ() {
            return this.q;
        }

        @NotNull
        public final SolverConfig getBv() {
            return this.bv;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lsolver/SolverConfig$CVC4Registry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "lin", "getLin", "nonlin", "getNonlin", "q", "getQ", "GeneralUtils"})
    public static final class CVC4Registry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(CVC4SolverInfo.INSTANCE, "def", null, null, false, null, null, null, null, null, def.1.INSTANCE, 1020, null));
        @NotNull
        private final SolverConfig nonlin;
        @NotNull
        private final SolverConfig lin;
        @NotNull
        private final SolverConfig q;

        public CVC4Registry() {
            super("cvc4", "def");
            String[] stringArray = new String[]{"--nl-ext-tplanes", "--decision=justification"};
            this.nonlin = (SolverConfig)this.register((Configurable)new SolverConfig(CVC4SolverInfo.INSTANCE, "nonlin", null, CollectionsKt.listOf(stringArray), false, null, null, nonlin.1.INSTANCE, null, null, nonlin.2.INSTANCE, 884, null));
            this.lin = (SolverConfig)this.register((Configurable)new SolverConfig(CVC4SolverInfo.INSTANCE, "lin", null, CollectionsKt.listOf("--decision=justification"), false, null, null, lin.1.INSTANCE, null, null, lin.2.INSTANCE, 884, null));
            this.q = (SolverConfig)this.register((Configurable)new SolverConfig(CVC4SolverInfo.INSTANCE, "q", null, CollectionsKt.listOf("--full-saturate-quant"), false, null, null, q.1.INSTANCE, null, null, null, 1908, null));
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }

        @NotNull
        public final SolverConfig getNonlin() {
            return this.nonlin;
        }

        @NotNull
        public final SolverConfig getLin() {
            return this.lin;
        }

        @NotNull
        public final SolverConfig getQ() {
            return this.q;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$SmtInterpolRegistry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "GeneralUtils"})
    public static final class SmtInterpolRegistry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(SmtInterpolSolverInfo.INSTANCE, "def", null, null, false, null, null, def.1.INSTANCE, null, null, null, 1916, null));

        public SmtInterpolRegistry() {
            super("smtinterpol", "def");
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$VampireRegistry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "GeneralUtils"})
    public static final class VampireRegistry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(VampireSolverInfo.INSTANCE, "def", null, null, false, null, null, null, null, null, null, 2044, null));

        public VampireRegistry() {
            super("vampire", "def");
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsolver/SolverConfig$YicesRegistry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "GeneralUtils"})
    public static final class YicesRegistry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(YicesSolverInfo.INSTANCE, "def", null, null, false, null, null, def.1.INSTANCE, null, null, null, 1916, null));

        public YicesRegistry() {
            super("yices", "def");
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lsolver/SolverConfig$Z3Registry;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "()V", "def", "getDef", "()Lsolver/SolverConfig;", "eq1", "getEq1", "eq2", "getEq2", "lia1", "getLia1", "lia2", "getLia2", "GeneralUtils"})
    public static final class Z3Registry
    extends Configuration.Registry<SolverConfig> {
        @NotNull
        private final SolverConfig def = (SolverConfig)this.register((Configurable)new SolverConfig(Z3SolverInfo.INSTANCE, "def", null, null, false, null, null, null, null, null, null, 2044, null));
        @NotNull
        private final SolverConfig lia1;
        @NotNull
        private final SolverConfig lia2;
        @NotNull
        private final SolverConfig eq1;
        @NotNull
        private final SolverConfig eq2;

        public Z3Registry() {
            super("z3", "def");
            String[] stringArray = new String[]{"smt.arith.solver=2", "smt.auto_config=false"};
            this.lia1 = (SolverConfig)this.register((Configurable)new SolverConfig(Z3SolverInfo.INSTANCE, "lia1", null, CollectionsKt.listOf(stringArray), false, null, null, lia1.1.INSTANCE, null, null, null, 1908, null));
            stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "smt.arith.solver=2", "smt.auto_config=false"};
            this.lia2 = (SolverConfig)this.register((Configurable)new SolverConfig(Z3SolverInfo.INSTANCE, "lia2", null, CollectionsKt.listOf(stringArray), false, null, null, lia2.1.INSTANCE, null, null, null, 1908, null));
            this.eq1 = (SolverConfig)this.register((Configurable)new SolverConfig(Z3SolverInfo.INSTANCE, "eq1", null, CollectionsKt.listOf("tactic.solve_eqs.max_occs=4"), false, null, null, null, null, null, eq1.1.INSTANCE, 1012, null));
            stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "tactic.solve_eqs.context_solve=true"};
            this.eq2 = (SolverConfig)this.register((Configurable)new SolverConfig(Z3SolverInfo.INSTANCE, "eq2", null, CollectionsKt.listOf(stringArray), false, null, null, null, null, null, eq2.1.INSTANCE, 1012, null));
        }

        @NotNull
        public final SolverConfig getDef() {
            return this.def;
        }

        @NotNull
        public final SolverConfig getLia1() {
            return this.lia1;
        }

        @NotNull
        public final SolverConfig getLia2() {
            return this.lia2;
        }

        @NotNull
        public final SolverConfig getEq1() {
            return this.eq1;
        }

        @NotNull
        public final SolverConfig getEq2() {
            return this.eq2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010%\u001a\u00020\u00022\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J&\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00022\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0018\u00010'H\u0016J;\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208\u00a2\u0006\u0002\u00109R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006:"}, d2={"Lsolver/SolverConfig$Companion;", "Lsolver/Configuration$Registry;", "Lsolver/SolverConfig;", "Lsolver/Configurable$ConversionHelper;", "()V", "altergo", "Lsolver/SolverConfig$AltErgoRegistry;", "getAltergo", "()Lsolver/SolverConfig$AltErgoRegistry;", "bitwuzla", "Lsolver/SolverConfig$BitwuzlaRegistry;", "getBitwuzla", "()Lsolver/SolverConfig$BitwuzlaRegistry;", "cvc4", "Lsolver/SolverConfig$CVC4Registry;", "getCvc4", "()Lsolver/SolverConfig$CVC4Registry;", "cvc5", "Lsolver/SolverConfig$CVC5Registry;", "getCvc5", "()Lsolver/SolverConfig$CVC5Registry;", "smtinterpol", "Lsolver/SolverConfig$SmtInterpolRegistry;", "getSmtinterpol", "()Lsolver/SolverConfig$SmtInterpolRegistry;", "vampire", "Lsolver/SolverConfig$VampireRegistry;", "getVampire", "()Lsolver/SolverConfig$VampireRegistry;", "yices", "Lsolver/SolverConfig$YicesRegistry;", "getYices", "()Lsolver/SolverConfig$YicesRegistry;", "z3", "Lsolver/SolverConfig$Z3Registry;", "getZ3", "()Lsolver/SolverConfig$Z3Registry;", "doConstruct", "params", "", "", "", "doCopy", "t", "override", "getDefaultSolverConfigs", "", "solverChoice", "Lsolver/SolverChoice;", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "timelimit", "Ljava/time/Duration;", "memlimitBytes", "", "incrementalMode", "", "(Lsolver/SolverChoice;Lsolver/SolverConfig$LogicFeatures;Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/List;", "GeneralUtils"})
    public static final class Companion
    extends Configuration.Registry<SolverConfig>
    implements Configurable.ConversionHelper<SolverConfig> {
        private Companion() {
            super("topLevel", null, 2, null);
        }

        @NotNull
        public final AltErgoRegistry getAltergo() {
            return altergo;
        }

        @NotNull
        public final BitwuzlaRegistry getBitwuzla() {
            return bitwuzla;
        }

        @NotNull
        public final CVC4Registry getCvc4() {
            return cvc4;
        }

        @NotNull
        public final CVC5Registry getCvc5() {
            return cvc5;
        }

        @NotNull
        public final SmtInterpolRegistry getSmtinterpol() {
            return smtinterpol;
        }

        @NotNull
        public final VampireRegistry getVampire() {
            return vampire;
        }

        @NotNull
        public final YicesRegistry getYices() {
            return yices;
        }

        @NotNull
        public final Z3Registry getZ3() {
            return z3;
        }

        @Override
        @NotNull
        public SolverConfig doCopy(@NotNull SolverConfig t, @Nullable Map<String, ? extends Object> override) {
            Intrinsics.checkNotNullParameter(t, "t");
            return Solver_SolverConfig_dynamicConversionKt.copy(t, override);
        }

        @Override
        @NotNull
        public SolverConfig doConstruct(@NotNull Map<String, ? extends Object> params2) {
            Intrinsics.checkNotNullParameter(params2, "params");
            return Solver_SolverConfig_dynamicConversionKt.constructFrom(this, params2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SolverConfig> getDefaultSolverConfigs(@NotNull SolverChoice solverChoice, @NotNull LogicFeatures logicFeatures, @NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(solverChoice, "solverChoice");
            Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
            Intrinsics.checkNotNullParameter(timelimit, "timelimit");
            Iterable $this$mapNotNull$iv = solverChoice;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                SolverConfig solverConfig;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SolverConfig it = (SolverConfig)element$iv$iv;
                boolean bl2 = false;
                if (it.getQualifiesFor().invoke(logicFeatures).booleanValue()) {
                    solverConfig = SolverConfig.copy$default(it, null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null);
                } else {
                    SolverConfigKt.access$getLogger$p().warn((Function0<? extends Object>)new Function0<Object>(logicFeatures){
                        final /* synthetic */ LogicFeatures $logicFeatures;
                        {
                            this.$logicFeatures = $logicFeatures;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "No solver configs qualify for " + this.$logicFeatures;
                        }
                    });
                    solverConfig = null;
                }
                if (solverConfig == null) continue;
                SolverConfig it$iv$iv = solverConfig;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public SolverConfig construct(@NotNull Object a, @NotNull Configuration<SolverConfig> reg) {
            return Configurable.ConversionHelper.DefaultImpls.construct(this, a, reg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

