/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import solver.ArithmeticOperations;
import solver.BitwuzlaSolverInfo;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lsolver/BitwuzlaSolverInfo;", "Lsolver/SolverInfo;", "()V", "defaultCommand", "", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "clOptions", "getOptionForIncremental", "getOptionForTimelimit", "timelimit", "Ljava/time/Duration;", "getProcessTimeoutString", "preprocessCheckSatOutput", "lines", "readResolve", "", "supportsLogicFeatures", "", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
public final class BitwuzlaSolverInfo
extends SolverInfo {
    @NotNull
    public static final BitwuzlaSolverInfo INSTANCE = new BitwuzlaSolverInfo();

    private BitwuzlaSolverInfo() {
        super("Bitwuzla");
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return "bitwuzla";
    }

    @Override
    @NotNull
    public List<String> getOptionForIncremental() {
        return CollectionsKt.listOf("--incremental");
    }

    @NotNull
    public final List<String> getProcessTimeoutString(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf("--time=" + timelimit.toSeconds());
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return this.getProcessTimeoutString(timelimit);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        if (features.getUsesDatatypes()) {
            return false;
        }
        ArithmeticOperations[] arithmeticOperationsArray = new ArithmeticOperations[]{ArithmeticOperations.NonLinear, ArithmeticOperations.LinearOnly};
        return !SetsKt.setOf(arithmeticOperationsArray).contains((Object)features.getArithmeticOperations());
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[]{this.getDefaultCommand(), "--smt2", "--output-number-format=hex"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public List<String> preprocessCheckSatOutput(@NotNull List<String> lines) {
        List<String> list;
        String it;
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(lines, "lines");
            Iterable $this$any$iv = lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(it, "[bitwuzla>main] ALARM TRIGGERED: time limit ", false, 2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            block10: {
                Iterable $this$all$iv = lines;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it, "unknown")) continue;
                        bl3 = false;
                        break block10;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                SolverInfo.Companion.getLogger().warn(preprocessCheckSatOutput.3.INSTANCE);
            }
            list = CollectionsKt.listOf("timeout");
        } else {
            list = super.preprocessCheckSatOutput(lines);
        }
        return list;
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

