/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.FileInputStreamFacade;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.URLInputStreamFacade;

public class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;
    public static String FS = System.getProperty("file.separator");
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    public static String[] getDefaultExcludes() {
        return DirectoryScanner.DEFAULTEXCLUDES;
    }

    public static List getDefaultExcludesAsList() {
        return Arrays.asList(FileUtils.getDefaultExcludes());
    }

    public static String getDefaultExcludesAsString() {
        return StringUtils.join(DirectoryScanner.DEFAULTEXCLUDES, ",");
    }

    public static String byteCountToDisplaySize(int size) {
        String displaySize = size / 0x40000000 > 0 ? String.valueOf(size / 0x40000000) + " GB" : (size / 0x100000 > 0 ? String.valueOf(size / 0x100000) + " MB" : (size / 1024 > 0 ? String.valueOf(size / 1024) + " KB" : String.valueOf(size) + " bytes"));
        return displaySize;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String filename(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    public static String basename(String filename) {
        return FileUtils.basename(filename, FileUtils.extension(filename));
    }

    public static String basename(String filename, String suffix) {
        int lastDot;
        int i = filename.lastIndexOf(File.separator) + 1;
        int n = lastDot = suffix != null && suffix.length() > 0 ? filename.lastIndexOf(suffix) : -1;
        if (lastDot >= 0) {
            return filename.substring(i, lastDot);
        }
        if (i > 0) {
            return filename.substring(i);
        }
        return filename;
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static boolean fileExists(String fileName) {
        File file2 = new File(fileName);
        return file2.exists();
    }

    public static String fileRead(String file2) throws IOException {
        return FileUtils.fileRead(file2, null);
    }

    public static String fileRead(String file2, String encoding) throws IOException {
        return FileUtils.fileRead(new File(file2), encoding);
    }

    public static String fileRead(File file2) throws IOException {
        return FileUtils.fileRead(file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileRead(File file2, String encoding) throws IOException {
        StringBuffer buf = new StringBuffer();
        InputStreamReader reader = null;
        try {
            int count2;
            reader = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(file2), encoding) : new InputStreamReader(new FileInputStream(file2));
            char[] b = new char[512];
            while ((count2 = reader.read(b)) > 0) {
                buf.append(b, 0, count2);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return buf.toString();
    }

    public static void fileAppend(String fileName, String data) throws IOException {
        FileUtils.fileAppend(fileName, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileAppend(String fileName, String encoding, String data) throws IOException {
        FileOutputStream out2;
        block3: {
            out2 = null;
            try {
                out2 = new FileOutputStream(fileName, true);
                if (encoding != null) {
                    out2.write(data.getBytes(encoding));
                    break block3;
                }
                out2.write(data.getBytes());
            }
            catch (Throwable throwable) {
                IOUtil.close(out2);
                throw throwable;
            }
        }
        IOUtil.close(out2);
    }

    public static void fileWrite(String fileName, String data) throws IOException {
        FileUtils.fileWrite(fileName, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileWrite(String fileName, String encoding, String data) throws IOException {
        FileOutputStream out2;
        block3: {
            out2 = null;
            try {
                out2 = new FileOutputStream(fileName);
                if (encoding != null) {
                    out2.write(data.getBytes(encoding));
                    break block3;
                }
                out2.write(data.getBytes());
            }
            catch (Throwable throwable) {
                IOUtil.close(out2);
                throw throwable;
            }
        }
        IOUtil.close(out2);
    }

    public static void fileDelete(String fileName) {
        File file2 = new File(fileName);
        file2.delete();
    }

    public static boolean waitFor(String fileName, int seconds) {
        return FileUtils.waitFor(new File(fileName), seconds);
    }

    public static boolean waitFor(File file2, int seconds) {
        int timeout = 0;
        int tick = 0;
        while (!file2.exists()) {
            if (tick++ >= 10) {
                tick = 0;
                if (timeout++ > seconds) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {}
        }
        return true;
    }

    public static File getFile(String fileName) {
        return new File(fileName);
    }

    public static String[] getFilesFromExtension(String directory, String[] extensions) {
        Vector files = new Vector();
        File currentDir = new File(directory);
        String[] unknownFiles = currentDir.list();
        if (unknownFiles == null) {
            return new String[0];
        }
        for (int i = 0; i < unknownFiles.length; ++i) {
            String currentFileName = directory + System.getProperty("file.separator") + unknownFiles[i];
            File currentFile = new File(currentFileName);
            if (currentFile.isDirectory()) {
                if (currentFile.getName().equals("CVS")) continue;
                String[] fetchFiles = FileUtils.getFilesFromExtension(currentFileName, extensions);
                files = FileUtils.blendFilesToVector(files, fetchFiles);
                continue;
            }
            String add2 = currentFile.getAbsolutePath();
            if (!FileUtils.isValidFile(add2, extensions)) continue;
            files.addElement(add2);
        }
        Object[] foundFiles = new String[files.size()];
        files.copyInto(foundFiles);
        return foundFiles;
    }

    private static Vector blendFilesToVector(Vector v, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            v.addElement(files[i]);
        }
        return v;
    }

    private static boolean isValidFile(String file2, String[] extensions) {
        String extension = FileUtils.extension(file2);
        if (extension == null) {
            extension = "";
        }
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static void mkdir(String dir) {
        File file2 = new File(dir);
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file2)) {
            throw new IllegalArgumentException("The file (" + dir + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = IOUtil.contentEquals(input1, input2);
        }
        catch (Throwable throwable) {
            IOUtil.close(input1);
            IOUtil.close(input2);
            throw throwable;
        }
        IOUtil.close(input1);
        IOUtil.close(input2);
        return bl;
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = -1;
        while ((pos = filename.indexOf(37, pos + 1)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public static URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURL();
        }
        return urls;
    }

    public static String removeExtension(String filename) {
        String ext = FileUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        return FileUtils.extension(filename);
    }

    public static String removePath(String filepath) {
        return FileUtils.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getPath(String filepath) {
        return FileUtils.getPath(filepath, File.separatorChar);
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtils.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectoryIfModified(String source, String destinationDirectory) throws IOException {
        FileUtils.copyFileToDirectoryIfModified(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFileToDirectoryIfModified(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFileIfModified(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(File source, File destination2) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (source.getCanonicalPath().equals(destination2.getCanonicalPath())) {
            return;
        }
        FileUtils.copyStreamToFile(new FileInputStreamFacade(source), destination2);
        if (source.length() != destination2.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination2;
            throw new IOException(message);
        }
    }

    public static boolean copyFileIfModified(File source, File destination2) throws IOException {
        if (destination2.lastModified() < source.lastModified()) {
            FileUtils.copyFile(source, destination2);
            return true;
        }
        return false;
    }

    public static void copyURLToFile(URL source, File destination2) throws IOException {
        FileUtils.copyStreamToFile(new URLInputStreamFacade(source), destination2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStreamFacade source, File destination2) throws IOException {
        if (destination2.getParentFile() != null && !destination2.getParentFile().exists()) {
            destination2.getParentFile().mkdirs();
        }
        if (destination2.exists() && !destination2.canWrite()) {
            String message = "Unable to open file " + destination2 + " for writing.";
            throw new IOException(message);
        }
        InputStream input = null;
        FileOutputStream output = null;
        try {
            input = source.getInputStream();
            output = new FileOutputStream(destination2);
            IOUtil.copy(input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close(input);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close(input);
        IOUtil.close(output);
    }

    public static String normalize(String path2) {
        int index;
        String normalized = path2;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path2) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path2;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return lookup + "/" + pth;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator) || Os.isFamily("windows") && filenm.indexOf(":") > 0) {
            File file2 = new File(filenm);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file2;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i]);
        }
        filenm = sb.toString();
        File file3 = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file3;
    }

    public static void forceDelete(String file2) throws IOException {
        FileUtils.forceDelete(new File(file2));
    }

    public static void forceDelete(File file2) throws IOException {
        if (file2.isDirectory()) {
            FileUtils.deleteDirectory(file2);
        } else {
            boolean filePresent = file2.getCanonicalFile().exists();
            if (!FileUtils.deleteFile(file2) && filePresent) {
                String message = "File " + file2 + " unable to be deleted.";
                throw new IOException(message);
            }
        }
    }

    private static boolean deleteFile(File file2) throws IOException {
        if (file2.isDirectory()) {
            throw new IOException("File " + file2 + " isn't a file.");
        }
        if (!file2.delete()) {
            if (Os.isFamily("windows")) {
                file2 = file2.getCanonicalFile();
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return file2.delete();
            }
            catch (InterruptedException ex) {
                return file2.delete();
            }
        }
        return true;
    }

    public static void forceDeleteOnExit(File file2) throws IOException {
        if (!file2.exists()) {
            return;
        }
        if (file2.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file2);
        } else {
            file2.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(directory);
        directory.deleteOnExit();
    }

    private static void cleanDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            try {
                FileUtils.forceDeleteOnExit(file2);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceMkdir(File file2) throws IOException {
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file2)) {
            throw new IllegalArgumentException("The file (" + file2.getAbsolutePath() + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (file2.exists()) {
            if (file2.isFile()) {
                String message = "File " + file2 + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file2.mkdirs()) {
            String message = "Unable to create directory " + file2;
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtils.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            try {
                FileUtils.forceDelete(file2);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static long sizeOfDirectory(String directory) {
        return FileUtils.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            if (file2.isDirectory()) {
                size += FileUtils.sizeOfDirectory(file2);
                continue;
            }
            size += file2.length();
        }
        return size;
    }

    public static List getFiles(File directory, String includes, String excludes) throws IOException {
        return FileUtils.getFiles(directory, includes, excludes, true);
    }

    public static List getFiles(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        List fileNames = FileUtils.getFileNames(directory, includes, excludes, includeBasedir);
        ArrayList<File> files = new ArrayList<File>();
        Iterator i = fileNames.iterator();
        while (i.hasNext()) {
            files.add(new File((String)i.next()));
        }
        return files;
    }

    public static List getFileNames(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getFileNames(directory, includes, excludes, includeBasedir, true);
    }

    public static List getFileNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, true, false);
    }

    public static List getDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getDirectoryNames(directory, includes, excludes, includeBasedir, true);
    }

    public static List getDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, false, true);
    }

    public static List getFileAndDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive, boolean getFiles, boolean getDirectories) throws IOException {
        int i;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (includes != null) {
            scanner.setIncludes(StringUtils.split(includes, ","));
        }
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split(excludes, ","));
        }
        scanner.setCaseSensitive(isCaseSensitive);
        scanner.scan();
        ArrayList<String> list = new ArrayList<String>();
        if (getFiles) {
            String[] files = scanner.getIncludedFiles();
            for (i = 0; i < files.length; ++i) {
                if (includeBasedir) {
                    list.add(directory + FS + files[i]);
                    continue;
                }
                list.add(files[i]);
            }
        }
        if (getDirectories) {
            String[] directories = scanner.getIncludedDirectories();
            for (i = 0; i < directories.length; ++i) {
                if (includeBasedir) {
                    list.add(directory + FS + directories[i]);
                    continue;
                }
                list.add(directories[i]);
            }
        }
        return list;
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectory(sourceDirectory, destinationDirectory, "**", null);
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List files = FileUtils.getFiles(sourceDirectory, includes, excludes);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file2 = (File)i.next();
            FileUtils.copyFileToDirectory(file2, destinationDirectory);
        }
    }

    public static void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, String[] includes, String[] excludes) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        if (includes != null && includes.length >= 1) {
            scanner.setIncludes(includes);
        } else {
            scanner.setIncludes(new String[]{"**"});
        }
        if (excludes != null && excludes.length >= 1) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedDirectories = Arrays.asList(scanner.getIncludedDirectories());
        Iterator<String> i = includedDirectories.iterator();
        while (i.hasNext()) {
            String name = i.next();
            File source = new File(sourceDirectory, name);
            if (source.equals(sourceDirectory)) continue;
            File destination2 = new File(destinationDirectory, name);
            destination2.mkdirs();
        }
    }

    public static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, false);
    }

    public static void copyDirectoryStructureIfModified(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, true);
    }

    private static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, File rootDestinationDirectory, boolean onlyModifiedFiles) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            if (file2.equals(rootDestinationDirectory)) continue;
            String dest = file2.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination2 = new File(destinationDirectory, dest);
            if (file2.isFile()) {
                destination2 = destination2.getParentFile();
                if (onlyModifiedFiles) {
                    FileUtils.copyFileToDirectoryIfModified(file2, destination2);
                    continue;
                }
                FileUtils.copyFileToDirectory(file2, destination2);
                continue;
            }
            if (file2.isDirectory()) {
                if (!destination2.exists() && !destination2.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination2.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file2, destination2, rootDestinationDirectory, onlyModifiedFiles);
                continue;
            }
            throw new IOException("Unknown file type: " + file2.getAbsolutePath());
        }
    }

    public static void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            FileUtils.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String prefix, String suffix, File parentDir) {
        Random rand;
        File result2 = null;
        String parent = System.getProperty("java.io.tmpdir");
        if (parentDir != null) {
            parent = parentDir.getPath();
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        SecureRandom secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        Random random = rand = new Random(secureInitializer + Runtime.getRuntime().freeMemory());
        synchronized (random) {
            while ((result2 = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
            }
        }
        return result2;
    }

    public static void copyFile(File from, File to, String encoding, FilterWrapper[] wrappers) throws IOException {
        FileUtils.copyFile(from, to, encoding, wrappers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to, String encoding, FilterWrapper[] wrappers, boolean overwrite) throws IOException {
        block7: {
            block6: {
                if (wrappers == null || wrappers.length <= 0) break block6;
                BufferedReader fileReader = null;
                OutputStreamWriter fileWriter = null;
                try {
                    if (encoding == null || encoding.length() < 1) {
                        fileReader = new BufferedReader(new FileReader(from));
                        fileWriter = new FileWriter(to);
                    } else {
                        FileInputStream instream = new FileInputStream(from);
                        FileOutputStream outstream = new FileOutputStream(to);
                        fileReader = new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
                        fileWriter = new OutputStreamWriter((OutputStream)outstream, encoding);
                    }
                    Reader reader = fileReader;
                    for (int i = 0; i < wrappers.length; ++i) {
                        FilterWrapper wrapper = wrappers[i];
                        reader = wrapper.getReader(reader);
                    }
                    IOUtil.copy(reader, (Writer)fileWriter);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileReader);
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                break block7;
            }
            if (to.lastModified() < from.lastModified() || overwrite) {
                FileUtils.copyFile(from, to);
            }
        }
    }

    public static List loadFile(File file2) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (file2.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file2));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        return lines;
    }

    public static boolean isValidWindowsFileName(File f) {
        if (Os.isFamily("windows")) {
            if (StringUtils.indexOfAny(f.getName(), INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME) != -1) {
                return false;
            }
            if (f.getParentFile() != null) {
                return FileUtils.isValidWindowsFileName(f.getParentFile());
            }
        }
        return true;
    }

    public static abstract class FilterWrapper {
        public abstract Reader getReader(Reader var1);
    }
}

