/*
 * Decompiled with CFR 0.152.
 */
package com.ionspin.kotlin.bignum.modular;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.ByteArraySerializable;
import com.ionspin.kotlin.bignum.CommonBigNumberOperations;
import com.ionspin.kotlin.bignum.ModularQuotientAndRemainder;
import com.ionspin.kotlin.bignum.NarrowingOperations;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.Sign;
import com.ionspin.kotlin.bignum.modular.ModularBigInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Z2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0001ZB%\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0002J\u001d\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0000J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000#2\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\u0011\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010(\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000\tH\u0016J\b\u0010,\u001a\u00020\u0000H\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010.\u001a\u00020\u0000J\b\u0010/\u001a\u00020\u0017H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u00103\u001a\u00020\u0000H\u0016J\b\u00104\u001a\u000201H\u0016J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0006J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000J\u0010\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u001eH\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000201H\u0016J\u0011\u00107\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0010\u00108\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010<\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0016J\u0006\u0010>\u001a\u00020\u0006J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020BH\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001eH\u0016J\u0010\u0010D\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020\u001eJ\u0018\u0010E\u001a\u00020FH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bG\u0010HJ \u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bK\u0010LJ \u0010M\u001a\u00020N2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bO\u0010PJ \u0010Q\u001a\u00020R2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bS\u0010TJ\t\u0010U\u001a\u00020\u0000H\u0096\u0002J \u0010V\u001a\u00020W2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bX\u0010YR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006["}, d2={"Lcom/ionspin/kotlin/bignum/modular/ModularBigInteger;", "Lcom/ionspin/kotlin/bignum/BigNumber;", "Lcom/ionspin/kotlin/bignum/CommonBigNumberOperations;", "Lcom/ionspin/kotlin/bignum/NarrowingOperations;", "Lcom/ionspin/kotlin/bignum/ByteArraySerializable;", "signedResidue", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "modulus", "creator", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/BigNumber$Creator;)V", "getModulus", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "residue", "getResidue", "abs", "add", "other", "assertSameModulo", "", "byteValue", "", "exactRequired", "", "checkIfDivisible", "checkIfDivisibleBoolean", "first", "second", "checkIfDivisibleBoolean$bignum", "compare", "", "compareTo", "", "divide", "divideAndRemainder", "Lkotlin/Pair;", "divrem", "Lcom/ionspin/kotlin/bignum/ModularQuotientAndRemainder;", "doubleValue", "", "equals", "floatValue", "", "getCreator", "getInstance", "intValue", "inverse", "isZero", "longValue", "", "multiply", "negate", "numberOfDecimalDigits", "pow", "exponent", "rem", "remainder", "secureOverwrite", "shortValue", "", "signum", "subtract", "toBigInteger", "toByteArray", "", "toString", "", "base", "toStringWithModulo", "toUByteArray", "Lkotlin/UByteArray;", "toUByteArray-TcUX1vc", "()[B", "ubyteValue", "Lkotlin/UByte;", "ubyteValue-Wa3L5BU", "(Z)B", "uintValue", "Lkotlin/UInt;", "uintValue-OGnWXxg", "(Z)I", "ulongValue", "Lkotlin/ULong;", "ulongValue-I7RO_PI", "(Z)J", "unaryMinus", "ushortValue", "Lkotlin/UShort;", "ushortValue-BwKQO78", "(Z)S", "Companion", "bignum"})
public final class ModularBigInteger
implements BigNumber<ModularBigInteger>,
CommonBigNumberOperations<ModularBigInteger>,
NarrowingOperations<ModularBigInteger>,
ByteArraySerializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger modulus;
    @NotNull
    private final BigNumber.Creator<ModularBigInteger> creator;
    @NotNull
    private final BigInteger residue;

    private ModularBigInteger(BigInteger signedResidue, BigInteger modulus, BigNumber.Creator<ModularBigInteger> creator) {
        BigInteger bigInteger;
        this.modulus = modulus;
        this.creator = creator;
        Sign sign = signedResidue.getSign$bignum();
        int n = WhenMappings.$EnumSwitchMapping$0[sign.ordinal()];
        switch (n) {
            case 1: {
                bigInteger = signedResidue;
                break;
            }
            case 2: {
                bigInteger = (BigInteger)signedResidue.plus((BigNumber)this.modulus);
                break;
            }
            case 3: {
                bigInteger = BigInteger.Companion.getZERO();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.residue = bigInteger;
        if (this.modulus.getSign$bignum() == Sign.NEGATIVE) {
            throw new ArithmeticException("Modulus must be a positive number");
        }
    }

    @NotNull
    public final BigInteger getModulus() {
        return this.modulus;
    }

    @NotNull
    public final BigInteger getResidue() {
        return this.residue;
    }

    @Override
    @NotNull
    public BigNumber.Creator<ModularBigInteger> getCreator() {
        return this.creator;
    }

    @Override
    @NotNull
    public ModularBigInteger getInstance() {
        return this;
    }

    private final void assertSameModulo(ModularBigInteger other) {
        if (!Intrinsics.areEqual(this.modulus, other.modulus)) {
            throw new RuntimeException("Different moduli! This " + this.modulus + "\n Other " + other.modulus);
        }
    }

    @Override
    @NotNull
    public ModularBigInteger add(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        return new ModularBigInteger((BigInteger)((BigInteger)this.residue.plus((BigNumber)other.residue)).rem((BigNumber)this.modulus), this.modulus, this.creator);
    }

    @Override
    @NotNull
    public ModularBigInteger subtract(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        return new ModularBigInteger((BigInteger)((BigInteger)this.residue.minus((BigNumber)other.residue)).rem((BigNumber)this.modulus), this.modulus, this.creator);
    }

    @Override
    @NotNull
    public ModularBigInteger multiply(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        return new ModularBigInteger((BigInteger)((BigInteger)this.residue.times((BigNumber)other.residue)).rem((BigNumber)this.modulus), this.modulus, this.creator);
    }

    @Override
    @NotNull
    public ModularBigInteger divide(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        BigInteger modInverse = other.residue.modInverse(this.modulus);
        BigInteger result2 = (BigInteger)((BigInteger)modInverse.times((BigNumber)this.residue)).rem((BigNumber)this.modulus);
        return new ModularBigInteger(result2, this.modulus, this.creator);
    }

    @Override
    @NotNull
    public ModularBigInteger remainder(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        this.checkIfDivisible(other);
        BigInteger remainder = (BigInteger)this.residue.rem((BigNumber)other.residue);
        BigInteger result2 = (BigInteger)remainder.rem((BigNumber)this.modulus);
        return new ModularBigInteger(result2, this.modulus, this.creator);
    }

    @Override
    @NotNull
    public Pair<ModularBigInteger, ModularBigInteger> divideAndRemainder(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        this.checkIfDivisible(other);
        BigInteger.QuotientAndRemainder quotientAndRemainder = this.residue.divrem(other.residue);
        BigInteger quotient = (BigInteger)quotientAndRemainder.getQuotient().rem((BigNumber)this.modulus);
        BigInteger remainder = (BigInteger)quotientAndRemainder.getRemainder().rem((BigNumber)this.modulus);
        return new Pair<ModularBigInteger, ModularBigInteger>(new ModularBigInteger(quotient, this.modulus, this.creator), new ModularBigInteger(remainder, this.modulus, this.creator));
    }

    @NotNull
    public final ModularBigInteger inverse() {
        BigInteger inverse = this.residue.modInverse(this.modulus);
        return new ModularBigInteger(inverse, this.modulus, this.creator);
    }

    public final int compare(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.assertSameModulo(other);
        return this.residue.compareTo(other.residue);
    }

    @Override
    public boolean isZero() {
        return this.residue.isZero();
    }

    @Override
    @NotNull
    public ModularBigInteger negate() {
        return this;
    }

    @Override
    @NotNull
    public ModularBigInteger abs() {
        return this;
    }

    @NotNull
    public final ModularBigInteger pow(@NotNull ModularBigInteger exponent2) {
        Intrinsics.checkNotNullParameter(exponent2, "exponent");
        return this.pow(exponent2.residue);
    }

    @NotNull
    public final ModularBigInteger pow(@NotNull BigInteger exponent2) {
        ModularBigInteger modularBigInteger;
        Intrinsics.checkNotNullParameter(exponent2, "exponent");
        BigInteger e = exponent2;
        if (Intrinsics.areEqual(this.modulus, BigInteger.Companion.getONE())) {
            modularBigInteger = this.creator.getZERO();
        } else {
            BigInteger residue = BigInteger.Companion.getONE();
            BigInteger base = this.residue;
            while (e.compareTo((Object)0) > 0) {
                if (Intrinsics.areEqual(e.rem(2), BigInteger.Companion.getONE())) {
                    residue = (BigInteger)((BigInteger)residue.times((BigNumber)base)).rem((BigNumber)this.modulus);
                }
                e = e.shr(1);
                base = (BigInteger)base.pow(2).rem((BigNumber)this.modulus);
            }
            modularBigInteger = new ModularBigInteger(residue, this.modulus, this.creator);
        }
        return modularBigInteger;
    }

    @Override
    @NotNull
    public ModularBigInteger pow(long exponent2) {
        return new ModularBigInteger((BigInteger)this.residue.pow(exponent2).rem((BigNumber)this.modulus), this.modulus, this.creator);
    }

    @Override
    @NotNull
    public ModularBigInteger pow(int exponent2) {
        return new ModularBigInteger((BigInteger)this.residue.pow(exponent2).rem((BigNumber)this.modulus), this.modulus, this.creator);
    }

    @Override
    public int signum() {
        return this.residue.signum();
    }

    @Override
    public long numberOfDecimalDigits() {
        return this.residue.numberOfDecimalDigits();
    }

    @Override
    @NotNull
    public ModularBigInteger unaryMinus() {
        return this.negate();
    }

    @Override
    public void secureOverwrite() {
        this.residue.secureOverwrite();
    }

    @Override
    @NotNull
    public ModularBigInteger rem(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.remainder(other);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter(other, "other");
        Object object = other;
        if (object instanceof ModularBigInteger) {
            n = this.compare((ModularBigInteger)other);
        } else if (object instanceof BigInteger) {
            n = this.residue.compare((BigInteger)other);
        } else if (object instanceof Long) {
            n = this.compare(this.creator.fromLong(((Number)other).longValue()));
        } else if (object instanceof Integer) {
            n = this.compare(this.creator.fromInt(((Number)other).intValue()));
        } else if (object instanceof Short) {
            n = this.compare(this.creator.fromShort(((Number)other).shortValue()));
        } else if (object instanceof Byte) {
            n = this.compare(this.creator.fromByte(((Number)other).byteValue()));
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Invalid comparison type for BigInteger: ", other));
        }
        return n;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == null ? false : this.compareTo(other) == 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.residue.toString();
    }

    @Override
    @NotNull
    public String toString(int base) {
        return this.residue.toString(base);
    }

    @NotNull
    public final String toStringWithModulo(int base) {
        return this.residue.toString(base) + " mod " + this.modulus.toString(base);
    }

    public static /* synthetic */ String toStringWithModulo$default(ModularBigInteger modularBigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return modularBigInteger.toStringWithModulo(n);
    }

    @NotNull
    public final ModularQuotientAndRemainder divrem(@NotNull ModularBigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Pair<ModularBigInteger, ModularBigInteger> result2 = this.divideAndRemainder(other);
        return new ModularQuotientAndRemainder(result2.getFirst(), result2.getSecond());
    }

    @NotNull
    public final BigInteger toBigInteger() {
        return this.residue;
    }

    private final void checkIfDivisible(ModularBigInteger other) {
        if (!Intrinsics.areEqual(other.residue.gcd(this.modulus), BigInteger.Companion.getONE())) {
            throw new ArithmeticException("BigInteger is not invertible. Operand and modulus are not relatively prime (coprime)");
        }
    }

    public final boolean checkIfDivisibleBoolean$bignum(@NotNull ModularBigInteger first2, @NotNull ModularBigInteger second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        return Intrinsics.areEqual(second2.residue.gcd(first2.modulus), BigInteger.Companion.getONE());
    }

    @Override
    public int intValue(boolean exactRequired) {
        if (exactRequired) {
            int n = Integer.MAX_VALUE;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl(n))) > 0) {
                throw new ArithmeticException("Cannot convert to int and provide exact value");
            }
        }
        return this.residue.intValue(exactRequired);
    }

    @Override
    public long longValue(boolean exactRequired) {
        if (exactRequired) {
            long l = Long.MAX_VALUE;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl((int)l))) > 0) {
                throw new ArithmeticException("Cannot convert to long and provide exact value");
            }
        }
        return this.residue.longValue(exactRequired);
    }

    @Override
    public byte byteValue(boolean exactRequired) {
        if (exactRequired) {
            int n = 127;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl(n))) > 0) {
                throw new ArithmeticException("Cannot convert to byte and provide exact value");
            }
        }
        return this.residue.byteValue(exactRequired);
    }

    @Override
    public short shortValue(boolean exactRequired) {
        if (exactRequired) {
            int n = Short.MAX_VALUE;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl(n))) > 0) {
                throw new ArithmeticException("Cannot convert to short and provide exact value");
            }
        }
        return this.residue.shortValue(exactRequired);
    }

    @Override
    public int uintValue-OGnWXxg(boolean exactRequired) {
        if (exactRequired) {
            int n = -1;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(n)) > 0) {
                throw new ArithmeticException("Cannot convert to unsigned int and provide exact value");
            }
        }
        return this.residue.uintValue-OGnWXxg(exactRequired);
    }

    @Override
    public long ulongValue-I7RO_PI(boolean exactRequired) {
        if (exactRequired) {
            long l = -1L;
            boolean bl = false;
            long l2 = l;
            boolean bl2 = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl((int)l2))) > 0) {
                throw new ArithmeticException("Cannot convert to unsigned long and provide exact value");
            }
        }
        return this.residue.ulongValue-I7RO_PI(exactRequired);
    }

    @Override
    public byte ubyteValue-Wa3L5BU(boolean exactRequired) {
        if (exactRequired) {
            int n = -1;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl(n & 0xFF))) > 0) {
                throw new ArithmeticException("Cannot convert to unsigned byte and provide exact value");
            }
        }
        return this.residue.ubyteValue-Wa3L5BU(exactRequired);
    }

    @Override
    public short ushortValue-BwKQO78(boolean exactRequired) {
        if (exactRequired) {
            int n = -1;
            boolean bl = false;
            if (this.residue.compareTo(UInt.box-impl(UInt.constructor-impl(n & 0xFFFF))) > 0) {
                throw new ArithmeticException("Cannot convert to unsigned short and provide exact value");
            }
        }
        return this.residue.ushortValue-BwKQO78(exactRequired);
    }

    @Override
    public float floatValue(boolean exactRequired) {
        return NarrowingOperations.DefaultImpls.floatValue$default(this.residue, false, 1, null);
    }

    @Override
    public double doubleValue(boolean exactRequired) {
        return NarrowingOperations.DefaultImpls.doubleValue$default(this.residue, false, 1, null);
    }

    @Override
    @NotNull
    public byte[] toUByteArray-TcUX1vc() {
        return this.residue.toUByteArray-TcUX1vc();
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        return this.residue.toByteArray();
    }

    @Override
    @NotNull
    public ModularBigInteger div(byte by) {
        return CommonBigNumberOperations.DefaultImpls.div(this, by);
    }

    @Override
    @NotNull
    public ModularBigInteger div(int n) {
        return CommonBigNumberOperations.DefaultImpls.div(this, n);
    }

    @Override
    @NotNull
    public ModularBigInteger div(long l) {
        return CommonBigNumberOperations.DefaultImpls.div(this, l);
    }

    @Override
    @NotNull
    public ModularBigInteger div(@NotNull ModularBigInteger other) {
        return (ModularBigInteger)CommonBigNumberOperations.DefaultImpls.div(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public ModularBigInteger div(short s) {
        return CommonBigNumberOperations.DefaultImpls.div(this, s);
    }

    @Override
    @NotNull
    public ModularBigInteger minus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, by);
    }

    @Override
    @NotNull
    public ModularBigInteger minus(int n) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, n);
    }

    @Override
    @NotNull
    public ModularBigInteger minus(long l) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, l);
    }

    @Override
    @NotNull
    public ModularBigInteger minus(@NotNull ModularBigInteger other) {
        return (ModularBigInteger)CommonBigNumberOperations.DefaultImpls.minus(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public ModularBigInteger minus(short s) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, s);
    }

    @Override
    @NotNull
    public ModularBigInteger plus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, by);
    }

    @Override
    @NotNull
    public ModularBigInteger plus(int n) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, n);
    }

    @Override
    @NotNull
    public ModularBigInteger plus(long l) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, l);
    }

    @Override
    @NotNull
    public ModularBigInteger plus(@NotNull ModularBigInteger other) {
        return (ModularBigInteger)CommonBigNumberOperations.DefaultImpls.plus(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public ModularBigInteger plus(short s) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, s);
    }

    @Override
    @NotNull
    public ModularBigInteger rem(byte by) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, by);
    }

    @Override
    @NotNull
    public ModularBigInteger rem(int n) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, n);
    }

    @Override
    @NotNull
    public ModularBigInteger rem(long l) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, l);
    }

    @Override
    @NotNull
    public ModularBigInteger rem(short s) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, s);
    }

    @Override
    @NotNull
    public ModularBigInteger times(byte by) {
        return CommonBigNumberOperations.DefaultImpls.times(this, by);
    }

    @Override
    @NotNull
    public ModularBigInteger times(int n) {
        return CommonBigNumberOperations.DefaultImpls.times(this, n);
    }

    @Override
    @NotNull
    public ModularBigInteger times(long l) {
        return CommonBigNumberOperations.DefaultImpls.times(this, l);
    }

    @Override
    @NotNull
    public ModularBigInteger times(@NotNull ModularBigInteger other) {
        return (ModularBigInteger)CommonBigNumberOperations.DefaultImpls.times(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public ModularBigInteger times(short s) {
        return CommonBigNumberOperations.DefaultImpls.times(this, s);
    }

    @Override
    public boolean isNegative() {
        return BigNumber.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigNumber.DefaultImpls.isPositive(this);
    }

    public /* synthetic */ ModularBigInteger(BigInteger signedResidue, BigInteger modulus, BigNumber.Creator creator, DefaultConstructorMarker $constructor_marker) {
        this(signedResidue, modulus, creator);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\bJ\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\tJ\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\nJ\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000bJ!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0015\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"Lcom/ionspin/kotlin/bignum/modular/ModularBigInteger$Companion;", "", "()V", "creatorForModulo", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lcom/ionspin/kotlin/bignum/modular/ModularBigInteger;", "modulo", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "", "", "", "", "Lkotlin/UByte;", "creatorForModulo-7apg3OU", "(B)Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lkotlin/UInt;", "creatorForModulo-WZ4Q5Ns", "(I)Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lkotlin/ULong;", "creatorForModulo-VKZWuLQ", "(J)Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lkotlin/UShort;", "creatorForModulo-xj2QHRw", "(S)Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "bignum"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo-VKZWuLQ(long modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromULong-VKZWuLQ(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo-WZ4Q5Ns(int modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromUInt-WZ4Q5Ns(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo-xj2QHRw(short modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromUShort-xj2QHRw(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo-7apg3OU(byte modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromUByte-7apg3OU(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo(long modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromLong(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo(int modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromInt(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo(short modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromShort(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo(byte modulo) {
            return this.creatorForModulo(BigInteger.Companion.fromByte(modulo));
        }

        @NotNull
        public final BigNumber.Creator<ModularBigInteger> creatorForModulo(@NotNull BigInteger modulo) {
            Intrinsics.checkNotNullParameter(modulo, "modulo");
            return new BigNumber.Creator<ModularBigInteger>(modulo){
                @NotNull
                private final ModularBigInteger ZERO;
                @NotNull
                private final ModularBigInteger ONE;
                @NotNull
                private final ModularBigInteger TWO;
                @NotNull
                private final ModularBigInteger TEN;
                final /* synthetic */ BigInteger $modulo;
                {
                    this.$modulo = $modulo;
                    this.ZERO = new ModularBigInteger(BigInteger.Companion.getZERO(), this.$modulo, this, null);
                    this.ONE = new ModularBigInteger(BigInteger.Companion.getONE(), this.$modulo, this, null);
                    this.TWO = new ModularBigInteger(BigInteger.Companion.getTWO(), this.$modulo, this, null);
                    this.TEN = new ModularBigInteger(BigInteger.Companion.getTEN(), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger getZERO() {
                    return this.ZERO;
                }

                @NotNull
                public ModularBigInteger getONE() {
                    return this.ONE;
                }

                @NotNull
                public ModularBigInteger getTWO() {
                    return this.TWO;
                }

                @NotNull
                public ModularBigInteger getTEN() {
                    return this.TEN;
                }

                @NotNull
                public ModularBigInteger fromBigInteger(@NotNull BigInteger bigInteger) {
                    Intrinsics.checkNotNullParameter(bigInteger, "bigInteger");
                    return new ModularBigInteger(this.prep(bigInteger), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger parseString(@NotNull String string, int base) {
                    Intrinsics.checkNotNullParameter(string, "string");
                    return new ModularBigInteger(this.prep(BigInteger.Companion.parseString(string, base)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromULong-VKZWuLQ(long uLong) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromULong-VKZWuLQ(uLong)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromUInt-WZ4Q5Ns(int uInt) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromUInt-WZ4Q5Ns(uInt)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromUShort-xj2QHRw(short uShort) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromUShort-xj2QHRw(uShort)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromUByte-7apg3OU(byte uByte) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromUByte-7apg3OU(uByte)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromLong(long l) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromLong(l)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromInt(int n) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromInt(n)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromShort(short s) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromShort(s)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger fromByte(byte by) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.fromByte(by)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger tryFromFloat(float f, boolean exactRequired) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.tryFromFloat(f, exactRequired)), this.$modulo, this, null);
                }

                @NotNull
                public ModularBigInteger tryFromDouble(double d, boolean exactRequired) {
                    return new ModularBigInteger(this.prep(BigInteger.Companion.tryFromDouble(d, exactRequired)), this.$modulo, this, null);
                }

                private final BigInteger prep(BigInteger $this$prep) {
                    BigInteger bigInteger;
                    BigInteger result2 = (BigInteger)$this$prep.rem((BigNumber)this.$modulo);
                    Sign sign = result2.getSign$bignum();
                    int n = creatorForModulo.WhenMappings.$EnumSwitchMapping$0[sign.ordinal()];
                    switch (n) {
                        case 1: {
                            bigInteger = result2;
                            break;
                        }
                        case 2: {
                            bigInteger = (BigInteger)result2.plus((BigNumber)this.$modulo);
                            break;
                        }
                        case 3: {
                            bigInteger = BigInteger.Companion.getZERO();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return bigInteger;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sign.values().length];
            nArray[Sign.POSITIVE.ordinal()] = 1;
            nArray[Sign.NEGATIVE.ordinal()] = 2;
            nArray[Sign.ZERO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

