/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.MethodQualifiers;
import com.certora.evmverifier.cvl.MethodReferenceExp;
import com.certora.evmverifier.cvl.Param;
import com.certora.evmverifier.cvl.TypeOrLhs;
import com.certora.evmverifier.cvl.UnnamedParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlinizable.Kotlinizable;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import spec.TypeResolver;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.ContractFunctionIdentifier;
import spec.cvlast.ExternalQualifiedMethodParameterSignature;
import spec.cvlast.MethodEntryTargetContract;
import spec.cvlast.MethodParameterSignature;
import spec.cvlast.MethodSignature;
import spec.cvlast.QualifiedFunction;
import spec.cvlast.QualifiedMethodParameterSignature;
import spec.cvlast.QualifiedMethodSignature;
import spec.cvlast.SolidityContract;
import spec.cvlast.VMParam;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Serializable
class MethodSig
implements Kotlinizable<QualifiedMethodParameterSignature> {
    private final MethodReferenceExp id;
    private final List<Param> params;
    private final List<Param> resParams;
    public final MethodQualifiers methodQualifiers;

    public String toString() {
        return this.id.toString() + "(" + this.params.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    public MethodSig(MethodReferenceExp _id, List<Param> _params, List<Param> _resParams, MethodQualifiers _methodQualifiers) {
        this.id = _id;
        this.params = _params;
        this.resParams = _resParams;
        this.methodQualifiers = _methodQualifiers;
    }

    public MethodSig(MethodReferenceExp _id, List<Param> _params, List<Param> _resParams) {
        this(_id, _params, _resParams, null);
    }

    public static MethodSig fromTypeParams(CVLRange _cvlRange, MethodReferenceExp _id, List<Param> _params, List<TypeOrLhs> _resParams) {
        ArrayList<Param> resParams;
        if (_resParams != null) {
            resParams = new ArrayList<Param>();
            for (TypeOrLhs t : _resParams) {
                resParams.add(new UnnamedParam(t, t.range));
            }
        } else {
            resParams = null;
        }
        return new MethodSig(_id, _params, resParams);
    }

    private CollectingResult<QualifiedMethodParameterSignature, CVLError> generateSig(ContractFunctionIdentifier name, TypeResolver res2, CVLScope scope) {
        if (this.resParams != null) {
            return KotlinizeResult.map(Param.toVMDualParams(this.params, res2, scope), Param.toVMParams(this.resParams, res2, scope), (params2, resParams) -> QualifiedMethodSignature.invoke(name, (List<? extends VMParam>)params2, (List<? extends VMParam>)resParams));
        }
        return KotlinizeResult.map(Param.toVMDualParams(this.params, res2, scope), params2 -> QualifiedMethodParameterSignature.invoke(name, (List<? extends VMParam>)params2));
    }

    public CollectingResult<MethodParameterSignature, CVLError> kotlinizeNamed(MethodEntryTargetContract target, TypeResolver res2, CVLScope scope) {
        if (target == MethodEntryTargetContract.WildcardTarget.INSTANCE) {
            return KotlinizeResult.bind(Param.toVMDualParams(this.params, res2, scope), params2 -> {
                if (this.resParams == null) {
                    return KotlinizeResult.lift(MethodParameterSignature.invoke(this.id.method, params2));
                }
                return KotlinizeResult.map(Param.toVMParams(this.resParams, res2, scope), returnsList -> MethodSignature.invoke(this.id.method, params2, returnsList));
            });
        }
        return KotlinizeResult.bind(Param.toVMDualParams(this.params, res2, scope), params2 -> {
            List<Param> _resParams = this.resParams == null ? new ArrayList<Param>() : this.resParams;
            SolidityContract contractName = ((MethodEntryTargetContract.SpecificTarget)target).getContract();
            return KotlinizeResult.map(Param.toVMParams(_resParams, res2, scope), returnsList -> QualifiedMethodSignature.invoke(new QualifiedFunction(contractName, this.id.method), (List<? extends VMParam>)params2, (List<? extends VMParam>)returnsList));
        });
    }

    @Override
    public CollectingResult<QualifiedMethodParameterSignature, CVLError> kotlinize(TypeResolver res2, CVLScope scope) {
        SolidityContract contr = this.getCalleeContract(res2);
        return this.generateSig(new QualifiedFunction(contr, this.id.method), res2, scope);
    }

    public CollectingResult<ExternalQualifiedMethodParameterSignature, CVLError> kotlinizeExternal(TypeResolver res2, CVLScope scope) {
        return KotlinizeResult.map(this.kotlinize(res2, scope), res_ -> ExternalQualifiedMethodParameterSignature.Companion.fromNamedParameterSignatureContractId((QualifiedMethodParameterSignature)res_, () -> false));
    }

    public String baseContract() {
        if (this.id.contract != null) {
            return this.id.contract.id;
        }
        return null;
    }

    @NotNull
    private SolidityContract getCalleeContract(TypeResolver res2) {
        return new SolidityContract(res2.resolveContract(this.id.contract != null ? this.id.contract.id : SolidityContract.Companion.getCurrent().getName()));
    }
}

