"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import pytest
from unittest.mock import MagicMock, ANY
from concurrent.futures import Future
from fireblocks.threaded_api_client import ThreadedApiClient
from fireblocks.client_configuration import ClientConfiguration
from fireblocks.bearer_token_provider import BearerTokenProvider
from fireblocks.rest import RESTClientObject, RESTResponse
from fireblocks.api_client import ApiResponse
from fireblocks.exceptions import ApiException
from fireblocks.models.error_schema import ErrorSchema
from fireblocks.unknown_model import UnknownBaseModel

class MockSuccess200Response:
    def __init__(self):
        self.status = 200
        self.reason = "OK"
        self.data = b'{"message": "Success"}'
        self.headers = {"Content-Type": "application/json"}

class MockFailure400Response:
    def __init__(self):
        self.status = 400
        self.reason = "Bad Request"
        self.data = b'{"message": "Failure"}'
        self.headers = {"Content-Type": "application/json"}

full_configuration = ClientConfiguration(api_key="my_api_key", secret_key="my_secret", base_path="my_base_path")

@pytest.fixture(scope='function')
def mock_bearer_token_provider(mocker):
    mocked_token_provider = mocker.MagicMock(spec=BearerTokenProvider)
    mocked_token_provider.get_token.return_value = 'mocked_token'

    return mocked_token_provider

@pytest.fixture(scope='function')
def mock_rest_client(mocker):
    mocked_rest_client = mocker.MagicMock(spec=RESTClientObject)
    mocked_rest_client.pool_manager = mocker.MagicMock()

    return mocked_rest_client


@pytest.fixture
def setup_mocks(request, mock_bearer_token_provider, mock_rest_client, mocker):
    mocker.patch('fireblocks.api_client.rest.RESTClientObject', return_value=mock_rest_client)
    mocker.patch('fireblocks.threaded_api_client.BearerTokenProvider', return_value=mock_bearer_token_provider)

def test_fail_to_construct_api_client_without_api_key(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(secret_key="my_secret_key", base_path="my_base_path"))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'apiKey is required either in the configuration or as environment variable FIREBLOCKS_API_KEY'

def test_fail_to_construct_api_client_with_empty_api_key(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(api_key="", secret_key="my_secret_key", base_path="my_base_path"))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'apiKey is required either in the configuration or as environment variable FIREBLOCKS_API_KEY'

def test_fail_to_construct_api_client_without_secret_key(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(api_key="my_api_key", base_path="my_base_path"))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'secretKey is required either in the configuration or as environment variable FIREBLOCKS_SECRET_KEY'

def test_fail_to_construct_api_client_with_empty_secret_key(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(api_key="my_api_key", secret_key="", base_path="my_base_path"))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'secretKey is required either in the configuration or as environment variable FIREBLOCKS_SECRET_KEY'

def test_fail_to_construct_api_client_without_base_path(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(api_key="my_api_key", secret_key="my_secret_key"))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'basePath is required either in the configuration or as environment variable FIREBLOCKS_BASE_PATH'

def test_fail_to_construct_api_client_with_empty_base_path(setup_mocks):
    with pytest.raises(ValueError) as exec_info:
        ThreadedApiClient(ClientConfiguration(api_key="my_api_key", secret_key="my_secret_key", base_path=""))
    assert exec_info.type == ValueError
    assert str(exec_info.value) == 'basePath is required either in the configuration or as environment variable FIREBLOCKS_BASE_PATH'

def test_succeed_to_construct_api_client(setup_mocks):
    api_client_instance = ThreadedApiClient(full_configuration)
    assert isinstance(api_client_instance, ThreadedApiClient)
    assert isinstance(api_client_instance.rest_client, MagicMock)

def test_call_api_updates_headers_property_successfully(setup_mocks, mock_rest_client, mock_bearer_token_provider):
    api_client_instance = ThreadedApiClient(full_configuration)
    method = "GET"
    url = "https://api_endpoint.example.com/data"
    expected_headers = {"Authorization": "Bearer mocked_token",
                        "X-API-Key": "my_api_key"}

    api_client_instance.call_api(method, url)
    mock_bearer_token_provider.get_token.assert_called_once_with(method, "/data", None)
    mock_rest_client.request.assert_called_once_with(
        method,
        url,
        headers=expected_headers,
        body=ANY,
        post_params=ANY,
        _request_timeout=ANY
    )

def test_call_api_with_query_params(setup_mocks, mock_rest_client, mock_bearer_token_provider):
    api_client_instance = ThreadedApiClient(full_configuration)
    method = "GET"
    url = "https://api_endpoint.example.com/data?param1=value%201&param2=value2"
    expected_headers = {"Authorization": "Bearer mocked_token",
                        "X-API-Key": "my_api_key"}

    api_client_instance.call_api(method, url)
    mock_bearer_token_provider.get_token.assert_called_once_with(method, "/data?param1=value%201&param2=value2", None)
    mock_rest_client.request.assert_called_once_with(
        method,
        url,
        headers=expected_headers,
        body=ANY,
        post_params=ANY,
        _request_timeout=ANY
    )

def test_call_api_returns_future(setup_mocks, mock_rest_client):
    api_client_instance = ThreadedApiClient(full_configuration)
    response = api_client_instance.call_api("GET", "https://api_endpoint.example.com/data")
    assert isinstance(response, Future)

def test_api_response_returns_upon_successful_call(setup_mocks, mock_rest_client):
    api_client_instance = ThreadedApiClient(full_configuration)
    mock_rest_client.request.return_value = RESTResponse(MockSuccess200Response())

    response = api_client_instance.call_api("GET", "https://api_endpoint.example.com/data")
    assert isinstance(response, Future)
    assert isinstance(response.result(), ApiResponse)

def test_api_exception_is_thrown_upon_failed_call(setup_mocks, mock_rest_client):
    api_client_instance = ThreadedApiClient(full_configuration)
    mock_rest_client.request.return_value = RESTResponse(MockFailure400Response())
    try:
        api_client_instance.call_api("GET", "https://api_endpoint.example.com/data").result()
    except ApiException as e:
        assert e.status == 400
        assert e.reason == "Bad Request"
        assert e.data == None
        assert e.body == '{"message": "Failure"}'
        assert e.headers == {"Content-Type": "application/json"}
    else:
        pytest.fail("Expected ApiException, but no exception was raised.")

def test_api_exception_with_error_schema_is_thrown_upon_failed_call(setup_mocks, mock_rest_client):
    api_client_instance = ThreadedApiClient(full_configuration)
    mock_rest_client.request.return_value = RESTResponse(MockFailure400Response())
    _response_types_map = {
        '200': "GetAuditLogsResponse",
        'default': "ErrorSchema",
    }

    try:
        api_client_instance.call_api(method="GET", url="https://api_endpoint.example.com/data", _response_types_map=_response_types_map).result()
    except ApiException as e:
        assert e.status == 400
        assert isinstance(e.data, ErrorSchema)
        assert e.reason == "Bad Request"
        assert e.body == '{"message": "Failure"}'
        assert e.headers == {"Content-Type": "application/json"}
    except Exception as e:
        pytest.fail(f"Expected ApiException, but unexpected exception was raised: {e}")
    else:
        pytest.fail("Expected ApiException, but no exception was raised.")

def test_api_response_returns_with_unknown_model_when_deserialize_failed_upon_successful_call(setup_mocks, mock_rest_client, mocker):
    api_client_instance = ThreadedApiClient(full_configuration)
    mock_rest_client.request.return_value = RESTResponse(MockSuccess200Response())
    _response_types_map = {
        '200': "GetAuditLogsResponse",
        'default': "ErrorSchema",
    }
    mocker.patch.object(api_client_instance, 'deserialize', return_value='mocked_value', side_effect=Exception('Mocked exception'))
    response = api_client_instance.call_api(method="GET", url="https://api_endpoint.example.com/data", _response_types_map=_response_types_map).result()
    assert isinstance(response, ApiResponse)
    assert isinstance(response.data, UnknownBaseModel)
