"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import pytest
from unittest.mock import patch
import jwt
from uuid import UUID
from fireblocks.bearer_token_provider import BearerTokenProvider

@pytest.fixture
def secret_key():
    with open("test/fireblocks/dummy_test_key.txt", "r") as file:
        return file.read().strip()

@patch('uuid.uuid4', return_value=UUID('12345678-1234-5678-1234-567812345678'))  # Mocked uuid
@patch('time.time', return_value=1609459200)  # Mocked timestamp
def test_get_token_when_post_method(mock_time, mock_uuid, secret_key):
    provider = BearerTokenProvider(api_key="dummy_api_key", secret_key=secret_key)
    token = provider.get_token("POST", "/test/path", {"key": "value"})

    # Assert that the token is a string
    assert isinstance(token, str)
    assert token == 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1cmkiOiIvdGVzdC9wYXRoIiwibm9uY2UiOiIxMjM0NTY3OC0xMjM0LTU2NzgtMTIzNC01Njc4MTIzNDU2NzgiLCJpYXQiOjE2MDk0NTkyMDAsImV4cCI6MTYwOTQ1OTI1NSwic3ViIjoiZHVtbXlfYXBpX2tleSIsImJvZHlIYXNoIjoiOTcyNGMxZTIwZTZlM2U0ZDdmNTdlZDI1ZjlkNGVmYjAwNmU1MDg1OTBkNTI4YzkwZGE1OTdmNmE3NzVjMTNlNSJ9.ZqEes008u7RlEknfv2fvkmOSPsHElGcmRIZmXl10wOyLkl7u9SPiTCSyGcgRyFUpAA6zMDVpMXkBVUBJyfBU6PcHHliMcjt6N-ZQWYrZ5eVDl3pfukRqM6UQwWrCB2776ScVck2d6o4_vtPd7MHVz4IyornQHaeMlbKfTvtqkh1Tzjc5Ju9L0oouP7LSKTmqhitRISsrGEuY6tfLC0Qi33wfYBrM_prbch86qMpU6kLUSOBmX8camjuyAUwQTqUQSfb8g3iukioCO_5wS3pxVTY8YjrcVdfLNSEbSp1FiSAyUkFJjbW71o9tPE1KD_17nNvsjmZP0o74hNqWlYq1cZHuemHLtfOifM5sX2Trqbh9AeXLkRgf_j9TwKziEaudB7JFjoczlatxKNhyUK3rH-SGPnnrDDcWsmFGYU-uOpAJZ1OnuUNUEmWyjsiLrWvb8xmGa6GbfYMN33cbgVO8YqIhYOm2r3GUhXomuzgnC8VtFM4_2nGNDgT_arvMpGsFPT33UJCDEHKXHJIanHvw0hxvv0hgbp39Dj6_mB-ZEFY5alN4hvGI-7D-ntSV-S1Zz7Jff8kT4fi9yY50WzBOi-W6OkvHvC-EmkMhvoN-OJsWyG9xb1hJvPUsWVR3YPOmJAThrgl-OBh4pi1ez3Ctc3cm0akSUPwbAnNS4l-aefA'

    # Example additional assertion: decode the token without verification to check structure
    decoded_token = jwt.decode(token, options={"verify_signature": False})
    expected_token = {
        "sub": "dummy_api_key",
        "exp": 1609459200 + 55,
        "bodyHash": "9724c1e20e6e3e4d7f57ed25f9d4efb006e508590d528c90da597f6a775c13e5"
    }
    expected_token = {
        "uri": "/test/path",
        "nonce": '12345678-1234-5678-1234-567812345678',
        "iat": 1609459200,
        "exp": 1609459200 + 55,
        "sub": "dummy_api_key",
        "bodyHash": "9724c1e20e6e3e4d7f57ed25f9d4efb006e508590d528c90da597f6a775c13e5",
    }

    assert decoded_token == expected_token

@patch('uuid.uuid4', return_value=UUID('12345678-1234-5678-1234-567812345678'))  # Mocked uuid
@patch('time.time', return_value=1609459200)  # Mocked timestamp
def test_get_token_when_get_method(mock_time, mock_uuid, secret_key):
    provider = BearerTokenProvider(api_key="dummy_api_key", secret_key=secret_key)
    token = provider.get_token("GET", "/test/path", None)

    # Assert that the token is a string
    assert isinstance(token, str)
    assert token == 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1cmkiOiIvdGVzdC9wYXRoIiwibm9uY2UiOiIxMjM0NTY3OC0xMjM0LTU2NzgtMTIzNC01Njc4MTIzNDU2NzgiLCJpYXQiOjE2MDk0NTkyMDAsImV4cCI6MTYwOTQ1OTI1NSwic3ViIjoiZHVtbXlfYXBpX2tleSIsImJvZHlIYXNoIjoiZTNiMGM0NDI5OGZjMWMxNDlhZmJmNGM4OTk2ZmI5MjQyN2FlNDFlNDY0OWI5MzRjYTQ5NTk5MWI3ODUyYjg1NSJ9.NMjZPQate4EleqtTTThsB7Oro3XjMHfph_CRDnHLY9Y-6Ko48z7A8XdYYrMhtirLgwWa5tX641jHLJpVtVxfC4-PQViRLIRQ0G_ayonVqcTtDyioLtRIjG3AVqxpzsXnnNG27w5V3peuQf5JyBgGPKD4b9Y0FrDTfJiwvQx_cwL-yY9NMU89hw2pskYzNQGmfWaoXYyu57CsNor6h2c5oTC7Du4xWQdjFOfF6t1MYet8WRo-W-MF97caHKJsfzzNFFVYJnaWl248WfvnNDgUhW4IML4kvkPofaDiSlahzmwiUBvaFpKvl3b3fmQ3KzncoxbAfJIYGkevH1XH6jCzNmFx4gFsOpZldivzh4pKdRmZdeoUY2j7fHd7S02mUwDHjl9RCEu1ejZKj-eUnDB_uJqHY8FjAHzdMU9VDtbXF9E00K5YuxOmGGCJrdvFix8fqeMjSM6I9SePGO9-d_MjZ4lhEJPFMNb3FHw0W-s8WLpdlTgPi_8B47IreEExcZPDG_oHwcpWBYlz7DM8RTS3ttVbOmxo6MFCab8z0UtC3avZI_lZX_UxXGoKZiU06mra0P6x9hoDsEktAtCOHRXUfnr_pqWSVKkpiSENWW6-T96jzXPDIsWmxBk90_kznzfo-yCGDFAN-qG6oTLoLnveIwMzNaELCh1XKx6xFCVcdrI'

    # Example additional assertion: decode the token without verification to check structure
    decoded_token = jwt.decode(token, options={"verify_signature": False})
    expected_token = {
        "uri": "/test/path",
        "nonce": '12345678-1234-5678-1234-567812345678',
        "iat": 1609459200,
        "exp": 1609459200 + 55,
        "sub": "dummy_api_key",
        "bodyHash": "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855",
    }

    assert decoded_token == expected_token

@patch('uuid.uuid4', return_value=UUID('12345678-1234-5678-1234-567812345678'))  # Mocked uuid
@patch('time.time', return_value=1609459200)  # Mocked timestamp
def test_get_token_when_get_method_and_query_params(mock_time, mock_uuid, secret_key):
    provider = BearerTokenProvider(api_key="dummy_api_key", secret_key=secret_key)
    token = provider.get_token("GET", "/test/path?query_param1=val%20ue&query_param2=value", None)

    # Assert that the token is a string
    assert isinstance(token, str)
    assert token == 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1cmkiOiIvdGVzdC9wYXRoP3F1ZXJ5X3BhcmFtMT12YWwlMjB1ZSZxdWVyeV9wYXJhbTI9dmFsdWUiLCJub25jZSI6IjEyMzQ1Njc4LTEyMzQtNTY3OC0xMjM0LTU2NzgxMjM0NTY3OCIsImlhdCI6MTYwOTQ1OTIwMCwiZXhwIjoxNjA5NDU5MjU1LCJzdWIiOiJkdW1teV9hcGlfa2V5IiwiYm9keUhhc2giOiJlM2IwYzQ0Mjk4ZmMxYzE0OWFmYmY0Yzg5OTZmYjkyNDI3YWU0MWU0NjQ5YjkzNGNhNDk1OTkxYjc4NTJiODU1In0.SSTxDTeTAEkTyBFsSwcfEFS-JQO--auEVfC-1_G2AMK7wrdBTbKMCsSnpsOqHMfachEveslDuz2mD8g_XyEc3Y6F7Gf9j2BOzcOWr7qOsbSOCPmNILQ42OyCSlY4I85vsjUus7WXtFTyGcxOmrjLEBO_5_Km0Tc-Tmu8fUGikiG2hh313r6tKvH4oBekt4vMzvdksw_-Qf1Z9_LqDWm8nIicaeDRJZJEzCq64wFOxpKDQb-voG6hYw1clm_f5L2dXkOMx_z_8FHjoDtsXbI2Z-ps983BTIg6M3_IE5C_wF2uKGIDVKua-4Rho9z8amlzd4B5YtwfW0SQB0CHGXH9iAYBO4nW3-juclVf4EpOVVMWciR07tzDA0nA2tItF54RmKHRqabq_Kfcm_uXh2qBbWLVODbJ51LQhkJbP1DWv7Ak3iZlZqoYic0c9BF0O1Jj6jl-PrJnE5FdZLJhCni2eTBwmH6HG-XV4OUWcd1pHuK3EjCqCnSJRjmW7I6gvpDPcisrh8mGdRfD7bPc3I4FSGTZoQMu8TbTOr0gZJwtPPdcSBGZk4kGn7rqWZz6ZA9-rPOg8TsaDI-XnZukdz6ylKX88lwIBiJUwhUa4FB8JO7amHtqSFi2X18-Fz5saRoQci3d3JwB0JX7Sz8bSW3bx-zPFuHKJtvap4Vp2UDIcb8'

    # Example additional assertion: decode the token without verification to check structure
    decoded_token = jwt.decode(token, options={"verify_signature": False})
    expected_token = {
        "uri": "/test/path?query_param1=val%20ue&query_param2=value",
        "nonce": '12345678-1234-5678-1234-567812345678',
        "iat": 1609459200,
        "exp": 1609459200 + 55,
        "sub": "dummy_api_key",
        "bodyHash": "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855",
    }
    assert decoded_token == expected_token
