"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import os
import atexit
from concurrent.futures import ThreadPoolExecutor, Future
from typing import Tuple, Optional, List, Dict, Union, Any
from urllib.parse import urlparse
from fireblocks.api_response import ApiResponse, T as ApiResponseT
from fireblocks.configuration import Configuration
from fireblocks.api_client import ApiClient
from fireblocks.bearer_token_provider import BearerTokenProvider
from fireblocks.client_configuration import ClientConfiguration
from fireblocks.user_agent_util import UserAgentUtil


class ThreadedApiClient(ApiClient):
    _pool = None

    def __init__(self, configuration: ClientConfiguration):
        client_configuration = (
            configuration if configuration is not None else ClientConfiguration()
        )
        self._api_key = client_configuration.api_key or os.environ.get(
            "FIREBLOCKS_API_KEY"
        )
        if not self._api_key:
            raise ValueError(
                "apiKey is required either in the configuration or as environment variable FIREBLOCKS_API_KEY"
            )
        secret_key = client_configuration.secret_key or os.environ.get(
            "FIREBLOCKS_SECRET_KEY"
        )
        if not secret_key:
            raise ValueError(
                "secretKey is required either in the configuration or as environment variable FIREBLOCKS_SECRET_KEY"
            )
        base_path = client_configuration.base_path or os.environ.get(
            "FIREBLOCKS_BASE_PATH"
        )
        if not base_path:
            raise ValueError(
                "basePath is required either in the configuration or as environment variable FIREBLOCKS_BASE_PATH"
            )

        super().__init__(configuration=Configuration(host=base_path))

        self.token_provider = BearerTokenProvider(self._api_key, secret_key)

        self.user_agent = UserAgentUtil.get_user_agent(
            client_configuration.additional_options.is_anonymous_platform,
            client_configuration.additional_options.user_agent,
        )

        self.thread_pool_size = client_configuration.additional_options.thread_pool_size

    def close(self) -> None:
        self.rest_client.pool_manager.clear()
        if self._pool:
            self._pool.shutdown()
            self._pool = None
            if hasattr(atexit, "unregister"):
                atexit.unregister(self.close)

    @property
    def pool(self) -> ThreadPoolExecutor:
        """Create thread pool on first request
        avoids instantiating unused threadpool for blocking clients.
        """
        if self._pool is None:
            atexit.register(self.close)
            self._pool = ThreadPoolExecutor(max_workers=self.thread_pool_size)
        return self._pool

    def call_api(
        self,
        method: str,
        url: str,
        header_params: Optional[Dict[str, Any]] = None,
        body: Optional[Any] = None,
        post_params: Optional[List[Tuple[str, Any]]] = None,
        _request_timeout: Optional[Union[int, float, Tuple]] = None,
        _response_types_map: Optional[Dict[str, ApiResponseT]] = None,
    ) -> Future[ApiResponse[ApiResponseT]]:
        header_params = header_params or {}
        parsed_url = urlparse(url)
        path = parsed_url.path
        if parsed_url.query:
            path += f"?{parsed_url.query}"

        self._update_headers(header_params, method, path, body)

        return self.pool.submit(
            super().call_api,
            method,
            url,
            header_params,
            body,
            post_params,
            _request_timeout,
            _response_types_map,
        )

    def _update_headers(self, header_params, method, path, body):
        token = self.token_provider.get_token(method, path, body)
        header_params.update(
            {"Authorization": f"Bearer {token}", "X-API-Key": self._api_key}
        )
