# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class TravelRuleValidateTransactionResponse(BaseModel):
    """
    TravelRuleValidateTransactionResponse
    """ # noqa: E501
    is_valid: StrictBool = Field(description="\"isValid\" will tell you if you have collected all the information needed for the travel rule data transfer. Once this field = \"true\", you can move on to the next step which is to transfer the front-end information to your back-end and perform Travel Rule Transaction create", alias="isValid")
    type: StrictStr = Field(description="\"type\" will tell you if the virtual asset value converted to FIAT value of the withdrawal request is above (=TRAVELRULE) or below (=BELOW_THRESHOLD) the threshold in your jurisdiction. If it is to an unhosted wallet which does not require travel rule information to be sent and only collected, it will say NON_CUSTODIAL.")
    beneficiary_address_type: StrictStr = Field(description="\"beneficiaryAddressType\" will tell you if your blockchain analytics provider or internal address book has been able to identify the wallet address.", alias="beneficiaryAddressType")
    address_source: StrictStr = Field(description="\"addressSource\" will tell you if the address was found in your internal address book or identified by the blockchain analytics provider.", alias="addressSource")
    beneficiary_vas_pdid: StrictStr = Field(description="The VASP DID of the beneficiary VASP", alias="beneficiaryVASPdid")
    beneficiary_vas_pname: StrictStr = Field(description="\"beneficiaryVASPname\" will tell you the name of the VASP that has been identified as the owner of the wallet address. This name is used in a subsequent call to get its DID.", alias="beneficiaryVASPname")
    warnings: List[StrictStr] = Field(description="\"errors/warnings\" will tell you what information about the beneficiary you need to collect from the sender.")
    __properties: ClassVar[List[str]] = ["isValid", "type", "beneficiaryAddressType", "addressSource", "beneficiaryVASPdid", "beneficiaryVASPname", "warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TravelRuleValidateTransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TravelRuleValidateTransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isValid": obj.get("isValid"),
            "type": obj.get("type"),
            "beneficiaryAddressType": obj.get("beneficiaryAddressType"),
            "addressSource": obj.get("addressSource"),
            "beneficiaryVASPdid": obj.get("beneficiaryVASPdid"),
            "beneficiaryVASPname": obj.get("beneficiaryVASPname"),
            "warnings": obj.get("warnings")
        })
        return _obj


