# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.travel_rule_address import TravelRuleAddress
from typing import Optional, Set
from typing_extensions import Self

class TravelRuleValidateTransactionRequest(BaseModel):
    """
    TravelRuleValidateTransactionRequest
    """ # noqa: E501
    transaction_asset: StrictStr = Field(description="Transaction asset symbol BTC,ETH)", alias="transactionAsset")
    destination: StrictStr = Field(description="Transaction destination address")
    transaction_amount: StrictStr = Field(description="Transaction amount in the transaction asset", alias="transactionAmount")
    originator_vas_pdid: StrictStr = Field(description="This is the identifier assigned to your VASP", alias="originatorVASPdid")
    originator_equals_beneficiary: StrictBool = Field(description="\"True\" if the originator and beneficiary is the same person and you therefore do not need to collect any information. \"False\" if it is a third-party transfer.", alias="originatorEqualsBeneficiary")
    travel_rule_behavior: Optional[StrictBool] = Field(default=None, description="This will also check if the transaction is a TRAVEL_RULE in the beneficiary VASP's jurisdiction", alias="travelRuleBehavior")
    beneficiary_vas_pdid: Optional[StrictStr] = Field(default=None, description="This is the identifier assigned to the VASP the funds are being sent to", alias="beneficiaryVASPdid")
    beneficiary_vas_pname: Optional[StrictStr] = Field(default=None, description="Beneficiary VASP name", alias="beneficiaryVASPname")
    beneficiary_name: Optional[StrictStr] = Field(default=None, description="Beneficiary  name", alias="beneficiaryName")
    beneficiary_account_number: Optional[StrictStr] = Field(default=None, description="Beneficiary  name", alias="beneficiaryAccountNumber")
    beneficiary_address: Optional[TravelRuleAddress] = Field(default=None, description="Beneficiary  name", alias="beneficiaryAddress")
    __properties: ClassVar[List[str]] = ["transactionAsset", "destination", "transactionAmount", "originatorVASPdid", "originatorEqualsBeneficiary", "travelRuleBehavior", "beneficiaryVASPdid", "beneficiaryVASPname", "beneficiaryName", "beneficiaryAccountNumber", "beneficiaryAddress"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TravelRuleValidateTransactionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of beneficiary_address
        if self.beneficiary_address:
            _dict['beneficiaryAddress'] = self.beneficiary_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TravelRuleValidateTransactionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transactionAsset": obj.get("transactionAsset"),
            "destination": obj.get("destination"),
            "transactionAmount": obj.get("transactionAmount"),
            "originatorVASPdid": obj.get("originatorVASPdid"),
            "originatorEqualsBeneficiary": obj.get("originatorEqualsBeneficiary"),
            "travelRuleBehavior": obj.get("travelRuleBehavior"),
            "beneficiaryVASPdid": obj.get("beneficiaryVASPdid"),
            "beneficiaryVASPname": obj.get("beneficiaryVASPname"),
            "beneficiaryName": obj.get("beneficiaryName"),
            "beneficiaryAccountNumber": obj.get("beneficiaryAccountNumber"),
            "beneficiaryAddress": TravelRuleAddress.from_dict(obj["beneficiaryAddress"]) if obj.get("beneficiaryAddress") is not None else None
        })
        return _obj


