# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from fireblocks.models.aml_screening_result import AmlScreeningResult
from fireblocks.models.amount_info import AmountInfo
from fireblocks.models.authorization_info import AuthorizationInfo
from fireblocks.models.block_info import BlockInfo
from fireblocks.models.compliance_result import ComplianceResult
from fireblocks.models.destination_transfer_peer_path_response import DestinationTransferPeerPathResponse
from fireblocks.models.fee_info import FeeInfo
from fireblocks.models.get_transaction_operation import GetTransactionOperation
from fireblocks.models.network_record import NetworkRecord
from fireblocks.models.reward_info import RewardInfo
from fireblocks.models.signed_message import SignedMessage
from fireblocks.models.source_transfer_peer_path_response import SourceTransferPeerPathResponse
from fireblocks.models.system_message_info import SystemMessageInfo
from fireblocks.models.transaction_response_contract_call_decoded_data import TransactionResponseContractCallDecodedData
from fireblocks.models.transaction_response_destination import TransactionResponseDestination
from typing import Optional, Set
from typing_extensions import Self

class TransactionResponse(BaseModel):
    """
    TransactionResponse
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the transaction.")
    external_tx_id: Optional[StrictStr] = Field(default=None, description="Unique transaction ID provided by the user. Fireblocks highly recommends setting an `externalTxId` for every transaction created, to avoid submitting the same transaction twice.", alias="externalTxId")
    status: Optional[StrictStr] = Field(default=None, description="The primary status of the transaction. For details, see [Primary transaction statuses](https://developers.fireblocks.com/reference/primary-transaction-statuses).")
    sub_status: Optional[StrictStr] = Field(default=None, description="See [Transaction substatuses](https://developers.fireblocks.com/reference/transaction-substatuses) for the list of transaction sub statuses.", alias="subStatus")
    tx_hash: Optional[StrictStr] = Field(default=None, description="The hash of the transaction on the blockchain.  * This parameter exists if at least one of the following conditions is met:       1. The transaction’s source type is `UNKNOWN`, `WHITELISTED_ADDRESS`, `NETWORK_CONNECTION`, `ONE_TIME_ADDRESS`, `FIAT_ACCOUNT` or `GAS_STATION`.       2. The transaction’s source type is `VAULT` and the status is either: `CONFIRMING`, `COMPLETED`, or was in any of these statuses prior to changing to `FAILED` or `REJECTED`. In some instances, transactions in status `BROADCASTING` will include the txHash as well.       3. The transaction’s source type is `EXCHANGE_ACCOUNT` and the transaction’s destination type is `VAULT`, and the status is either: `CONFIRMING`, `COMPLETED`, or was in any of these status prior to changing to `FAILED`.   * In addition, the following conditions must be met:      1. The asset is a crypto asset (not fiat).      2. The transaction operation is not RAW or `TYPED_MESSAGE`.", alias="txHash")
    operation: Optional[GetTransactionOperation] = None
    note: Optional[StrictStr] = Field(default=None, description="Custom note, not sent to the blockchain, that describes the transaction at your Fireblocks workspace.")
    asset_id: Optional[StrictStr] = Field(default=None, description="The ID of the asset to transfer, for `TRANSFER`, `MINT`, `BURN`, `ENABLE_ASSET`,`STAKE` ,`UNSTAKE` or `WITHDRAW` operations. [See the list of supported assets and their IDs on Fireblocks.](https://developers.fireblocks.com/reference/get_supported-assets)", alias="assetId")
    source: Optional[SourceTransferPeerPathResponse] = None
    source_address: Optional[StrictStr] = Field(default=None, description="For account based assets only, the source address of the transaction. **Note:** If the status is `CONFIRMING`, `COMPLETED`, or has been `CONFIRMING`; then moved forward to `FAILED` or `REJECTED`, then this parameter will contain the source address. In any other case, this parameter will be empty.", alias="sourceAddress")
    tag: Optional[StrictStr] = Field(default=None, description="Source address tag for XRP, used as memo for EOS/XLM, or Bank Transfer Description for the fiat provider BLINC (by BCB Group).")
    destination: Optional[DestinationTransferPeerPathResponse] = None
    destinations: Optional[List[TransactionResponseDestination]] = Field(default=None, description="The transaction’s destinations. **Note:** In case the transaction is sent to a single destination, the `destination` parameter is used instead of this.")
    destination_address: Optional[StrictStr] = Field(default=None, description="Address where the asset were transferred. Notes:   - For [Multi destination transactions](https://support.fireblocks.io/hc/en-us/articles/360018447980-Multi-destination-transactions), this parameter will be empty. In this case, you should refer to the destinations field.   - If the status is `CONFIRMING`, `COMPLETED`, or has been `CONFIRMING`; then moved forward to `FAILED` or `REJECTED`, then this parameter will contain the destination address. In any other case, this parameter will be empty.", alias="destinationAddress")
    destination_address_description: Optional[StrictStr] = Field(default=None, description="Description of the address.", alias="destinationAddressDescription")
    destination_tag: Optional[StrictStr] = Field(default=None, description="Destination address tag for XRP, used as memo for EOS/XLM, or Bank Transfer Description for the fiat provider BLINC (by BCB Group).", alias="destinationTag")
    contract_call_decoded_data: Optional[TransactionResponseContractCallDecodedData] = Field(default=None, alias="contractCallDecodedData")
    amount_info: Optional[AmountInfo] = Field(default=None, alias="amountInfo")
    treat_as_gross_amount: Optional[StrictBool] = Field(default=None, description="For transactions initiated via this Fireblocks workspace, when set to `true`, the fee is deducted from the requested amount.  **Note**: This parameter can only be considered if a transaction's asset is a base asset, such as ETH or MATIC. If the asset can't be used for transaction fees, like USDC, this parameter is ignored and the fee is deducted from the relevant base asset wallet in the source account.", alias="treatAsGrossAmount")
    fee_info: Optional[FeeInfo] = Field(default=None, alias="feeInfo")
    fee_currency: Optional[StrictStr] = Field(default=None, description="The asset which was withdrawn to pay the transaction fee, for example ETH for EVM-based blockchains, BTC for Tether Omni.", alias="feeCurrency")
    network_records: Optional[List[NetworkRecord]] = Field(default=None, description="In case a single transaction resulted with multiple transfers, for example a result of a contract call, then this parameter specifies each transfer that took place on the blockchain. In case of a single transfer transaction, this parameter is empty.", alias="networkRecords")
    created_at: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The transaction’s creation date and time, in unix timestamp.", alias="createdAt")
    last_updated: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The transaction’s last update date and time, in unix timestamp.", alias="lastUpdated")
    created_by: Optional[StrictStr] = Field(default=None, description="User ID of the initiator of the transaction.", alias="createdBy")
    signed_by: Optional[List[StrictStr]] = Field(default=None, description="User ID’s of the signers of the transaction.", alias="signedBy")
    rejected_by: Optional[StrictStr] = Field(default=None, description="User ID of the user that rejected the transaction (in case it was rejected).", alias="rejectedBy")
    authorization_info: Optional[AuthorizationInfo] = Field(default=None, alias="authorizationInfo")
    exchange_tx_id: Optional[StrictStr] = Field(default=None, description="If the transaction originated from an exchange, this is the ID of this transaction at the exchange.", alias="exchangeTxId")
    customer_ref_id: Optional[StrictStr] = Field(default=None, description="The ID for AML providers to associate the owner of funds with transactions.", alias="customerRefId")
    aml_screening_result: Optional[AmlScreeningResult] = Field(default=None, alias="amlScreeningResult")
    compliance_result: Optional[ComplianceResult] = Field(default=None, alias="complianceResult")
    extra_parameters: Optional[Dict[str, Any]] = Field(default=None, description="Additional protocol / operation specific key-value parameters:  For UTXO-based blockchain input selection, add the key `inputsSelection` with the value set the [input selection structure.](https://developers.fireblocks.com/reference/transaction-objects#inputsselection) The inputs can be retrieved from the [Retrieve Unspent Inputs endpoint.](https://developers.fireblocks.com/reference/get_vault-accounts-vaultaccountid-assetid-unspent-inputs)  For `RAW` operations, add the key `rawMessageData` with the value set to the [raw message data structure.](https://developers.fireblocks.com/reference/raw-signing-objects#rawmessagedata)  For `CONTRACT_CALL` operations, add the key `contractCallData` with the value set to the Ethereum smart contract Application Binary Interface (ABI) payload. The Fireblocks [development libraries](https://developers.fireblocks.com/docs/ethereum-development#convenience-libraries) are recommended for building contract call transactions. ", alias="extraParameters")
    signed_messages: Optional[List[SignedMessage]] = Field(default=None, alias="signedMessages")
    num_of_confirmations: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of confirmations of the transaction. The number will increase until the transaction will be considered completed according to the confirmation policy.", alias="numOfConfirmations")
    block_info: Optional[BlockInfo] = Field(default=None, alias="blockInfo")
    index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="For UTXO based assets this is the vOut, for Ethereum based, this is the index of the event of the contract call.  **Note:** This field is not returned if a transaction uses the `destinations` object with more than one value.")
    reward_info: Optional[RewardInfo] = Field(default=None, alias="rewardInfo")
    system_messages: Optional[SystemMessageInfo] = Field(default=None, alias="systemMessages")
    address_type: Optional[StrictStr] = Field(default=None, alias="addressType")
    requested_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount requested by the user. Deprecated - please use the `amountInfo` field for accuracy.", alias="requestedAmount")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="If the transfer is a withdrawal from an exchange, the actual amount that was requested to be transferred. Otherwise, the requested amount. Deprecated - please use the `amountInfo` field for accuracy.")
    net_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The net amount of the transaction, after fee deduction. Deprecated - please use the `amountInfo` field for accuracy.", alias="netAmount")
    amount_usd: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The USD value of the requested amount. Deprecated - please use the `amountInfo` field for accuracy.", alias="amountUSD")
    service_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total fee deducted by the exchange from the actual requested amount (`serviceFee` = `amount` - `netAmount`). Deprecated - please use the `feeInfo` field for accuracy.", alias="serviceFee")
    fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Deprecated - please use the `feeInfo` field for accuracy.")
    network_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The fee paid to the network. Deprecated - please use the `feeInfo` field for accuracy.", alias="networkFee")
    error_description: Optional[StrictStr] = Field(default=None, description="The transaction's revert reason. This field will be returned when  `subStatus` =  'SMART_CONTRACT_EXECUTION_FAILED'.", alias="errorDescription")
    __properties: ClassVar[List[str]] = ["id", "externalTxId", "status", "subStatus", "txHash", "operation", "note", "assetId", "source", "sourceAddress", "tag", "destination", "destinations", "destinationAddress", "destinationAddressDescription", "destinationTag", "contractCallDecodedData", "amountInfo", "treatAsGrossAmount", "feeInfo", "feeCurrency", "networkRecords", "createdAt", "lastUpdated", "createdBy", "signedBy", "rejectedBy", "authorizationInfo", "exchangeTxId", "customerRefId", "amlScreeningResult", "complianceResult", "extraParameters", "signedMessages", "numOfConfirmations", "blockInfo", "index", "rewardInfo", "systemMessages", "addressType", "requestedAmount", "amount", "netAmount", "amountUSD", "serviceFee", "fee", "networkFee", "errorDescription"]

    @field_validator('address_type')
    def address_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['', 'WHITELISTED', 'ONE_TIME']):
            raise ValueError("must be one of enum values ('', 'WHITELISTED', 'ONE_TIME')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item in self.destinations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['destinations'] = _items
        # override the default output from pydantic by calling `to_dict()` of contract_call_decoded_data
        if self.contract_call_decoded_data:
            _dict['contractCallDecodedData'] = self.contract_call_decoded_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of amount_info
        if self.amount_info:
            _dict['amountInfo'] = self.amount_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fee_info
        if self.fee_info:
            _dict['feeInfo'] = self.fee_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in network_records (list)
        _items = []
        if self.network_records:
            for _item in self.network_records:
                if _item:
                    _items.append(_item.to_dict())
            _dict['networkRecords'] = _items
        # override the default output from pydantic by calling `to_dict()` of authorization_info
        if self.authorization_info:
            _dict['authorizationInfo'] = self.authorization_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aml_screening_result
        if self.aml_screening_result:
            _dict['amlScreeningResult'] = self.aml_screening_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compliance_result
        if self.compliance_result:
            _dict['complianceResult'] = self.compliance_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in signed_messages (list)
        _items = []
        if self.signed_messages:
            for _item in self.signed_messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['signedMessages'] = _items
        # override the default output from pydantic by calling `to_dict()` of block_info
        if self.block_info:
            _dict['blockInfo'] = self.block_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reward_info
        if self.reward_info:
            _dict['rewardInfo'] = self.reward_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of system_messages
        if self.system_messages:
            _dict['systemMessages'] = self.system_messages.to_dict()
        # set to None if amount_usd (nullable) is None
        # and model_fields_set contains the field
        if self.amount_usd is None and "amount_usd" in self.model_fields_set:
            _dict['amountUSD'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "externalTxId": obj.get("externalTxId"),
            "status": obj.get("status"),
            "subStatus": obj.get("subStatus"),
            "txHash": obj.get("txHash"),
            "operation": obj.get("operation"),
            "note": obj.get("note"),
            "assetId": obj.get("assetId"),
            "source": SourceTransferPeerPathResponse.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "sourceAddress": obj.get("sourceAddress"),
            "tag": obj.get("tag"),
            "destination": DestinationTransferPeerPathResponse.from_dict(obj["destination"]) if obj.get("destination") is not None else None,
            "destinations": [TransactionResponseDestination.from_dict(_item) for _item in obj["destinations"]] if obj.get("destinations") is not None else None,
            "destinationAddress": obj.get("destinationAddress"),
            "destinationAddressDescription": obj.get("destinationAddressDescription"),
            "destinationTag": obj.get("destinationTag"),
            "contractCallDecodedData": TransactionResponseContractCallDecodedData.from_dict(obj["contractCallDecodedData"]) if obj.get("contractCallDecodedData") is not None else None,
            "amountInfo": AmountInfo.from_dict(obj["amountInfo"]) if obj.get("amountInfo") is not None else None,
            "treatAsGrossAmount": obj.get("treatAsGrossAmount"),
            "feeInfo": FeeInfo.from_dict(obj["feeInfo"]) if obj.get("feeInfo") is not None else None,
            "feeCurrency": obj.get("feeCurrency"),
            "networkRecords": [NetworkRecord.from_dict(_item) for _item in obj["networkRecords"]] if obj.get("networkRecords") is not None else None,
            "createdAt": obj.get("createdAt"),
            "lastUpdated": obj.get("lastUpdated"),
            "createdBy": obj.get("createdBy"),
            "signedBy": obj.get("signedBy"),
            "rejectedBy": obj.get("rejectedBy"),
            "authorizationInfo": AuthorizationInfo.from_dict(obj["authorizationInfo"]) if obj.get("authorizationInfo") is not None else None,
            "exchangeTxId": obj.get("exchangeTxId"),
            "customerRefId": obj.get("customerRefId"),
            "amlScreeningResult": AmlScreeningResult.from_dict(obj["amlScreeningResult"]) if obj.get("amlScreeningResult") is not None else None,
            "complianceResult": ComplianceResult.from_dict(obj["complianceResult"]) if obj.get("complianceResult") is not None else None,
            "extraParameters": obj.get("extraParameters"),
            "signedMessages": [SignedMessage.from_dict(_item) for _item in obj["signedMessages"]] if obj.get("signedMessages") is not None else None,
            "numOfConfirmations": obj.get("numOfConfirmations"),
            "blockInfo": BlockInfo.from_dict(obj["blockInfo"]) if obj.get("blockInfo") is not None else None,
            "index": obj.get("index"),
            "rewardInfo": RewardInfo.from_dict(obj["rewardInfo"]) if obj.get("rewardInfo") is not None else None,
            "systemMessages": SystemMessageInfo.from_dict(obj["systemMessages"]) if obj.get("systemMessages") is not None else None,
            "addressType": obj.get("addressType"),
            "requestedAmount": obj.get("requestedAmount"),
            "amount": obj.get("amount"),
            "netAmount": obj.get("netAmount"),
            "amountUSD": obj.get("amountUSD"),
            "serviceFee": obj.get("serviceFee"),
            "fee": obj.get("fee"),
            "networkFee": obj.get("networkFee"),
            "errorDescription": obj.get("errorDescription")
        })
        return _obj


