# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.destination_transfer_peer_path import DestinationTransferPeerPath
from fireblocks.models.source_transfer_peer_path import SourceTransferPeerPath
from fireblocks.models.transaction_operation import TransactionOperation
from fireblocks.models.transaction_request_amount import TransactionRequestAmount
from fireblocks.models.transaction_request_destination import TransactionRequestDestination
from fireblocks.models.transaction_request_fee import TransactionRequestFee
from fireblocks.models.transaction_request_gas_limit import TransactionRequestGasLimit
from fireblocks.models.transaction_request_gas_price import TransactionRequestGasPrice
from fireblocks.models.transaction_request_network_fee import TransactionRequestNetworkFee
from fireblocks.models.transaction_request_network_staking import TransactionRequestNetworkStaking
from fireblocks.models.transaction_request_priority_fee import TransactionRequestPriorityFee
from fireblocks.models.travel_rule_create_transaction_request import TravelRuleCreateTransactionRequest
from typing import Optional, Set
from typing_extensions import Self

class TransactionRequest(BaseModel):
    """
    TransactionRequest
    """ # noqa: E501
    operation: Optional[TransactionOperation] = None
    note: Optional[StrictStr] = Field(default=None, description="Custom note, not sent to the blockchain, to describe the transaction at your Fireblocks workspace.")
    external_tx_id: Optional[StrictStr] = Field(default=None, description="An optional but highly recommended parameter. Fireblocks will reject future transactions with same ID.  You should set this to a unique ID representing the transaction, to avoid submitting the same transaction twice. This helps with cases where submitting the transaction responds with an error code due to Internet interruptions, but the transaction was actually sent and processed. To validate whether a transaction has been processed, [Find a specific transaction by external transaction ID](https://developers.fireblocks.com/reference/get_transactions-external-tx-id-externaltxid). There is no specific format required for this parameter.", alias="externalTxId")
    asset_id: Optional[StrictStr] = Field(default=None, description="The ID of the asset to transfer, for `TRANSFER`, `MINT` or `BURN` operations. [See the list of supported assets and their IDs on Fireblocks.](https://developers.fireblocks.com/reference/get_supported-assets)", alias="assetId")
    source: Optional[SourceTransferPeerPath] = None
    destination: Optional[DestinationTransferPeerPath] = None
    destinations: Optional[List[TransactionRequestDestination]] = Field(default=None, description="For UTXO based blockchains, you can send a single transaction to multiple destinations.")
    amount: Optional[TransactionRequestAmount] = None
    treat_as_gross_amount: Optional[StrictBool] = Field(default=None, description="\"When set to `true`, the fee will be deducted from the requested amount.\"  **Note**: This parameter can only be considered if a transaction’s asset is a base asset, such as ETH or MATIC. If the asset can’t be used for transaction fees, like USDC, this parameter is ignored and the fee is deducted from the relevant base asset wallet in the source account.", alias="treatAsGrossAmount")
    force_sweep: Optional[StrictBool] = Field(default=None, description="For Polkadot, Kusama and Westend transactions only. When set to true, Fireblocks will empty the asset wallet.     **Note:** If set to true when the source account is exactly 1 DOT, the transaction will fail. Any amount more or less than 1 DOT succeeds. This is a Polkadot blockchain limitation.", alias="forceSweep")
    fee_level: Optional[StrictStr] = Field(default=None, description="For UTXO or EVM-based blockchains only. Defines the blockchain fee level which will be payed for the transaction. Alternatively, specific fee estimation parameters exist below.", alias="feeLevel")
    fee: Optional[TransactionRequestFee] = None
    priority_fee: Optional[TransactionRequestPriorityFee] = Field(default=None, alias="priorityFee")
    fail_on_low_fee: Optional[StrictBool] = Field(default=None, description="When set to `true`, in case the current `MEDIUM` fee level is higher than the one specified in the transaction, the transaction will fail to avoid getting stuck with no confirmations.", alias="failOnLowFee")
    max_fee: Optional[StrictStr] = Field(default=None, description="The maximum fee (gas price or fee per byte) that should be payed for the transaction.  In case the current value of the requested `feeLevel` is higher than this requested maximum fee.  Represented by a numeric string for accurate precision.", alias="maxFee")
    gas_limit: Optional[TransactionRequestGasLimit] = Field(default=None, alias="gasLimit")
    gas_price: Optional[TransactionRequestGasPrice] = Field(default=None, alias="gasPrice")
    network_fee: Optional[TransactionRequestNetworkFee] = Field(default=None, alias="networkFee")
    replace_tx_by_hash: Optional[StrictStr] = Field(default=None, description="For EVM-based blockchains only. In case a transaction is stuck, specify the hash of the stuck transaction to replace it by this transaction with a higher fee, or to replace it with this transaction with a zero fee and drop it from the blockchain.", alias="replaceTxByHash")
    extra_parameters: Optional[Dict[str, Any]] = Field(default=None, description="Additional protocol / operation specific key-value parameters:  For UTXO-based blockchain input selection, add the key `inputsSelection` with the value set the [input selection structure.](https://developers.fireblocks.com/reference/transaction-objects#inputsselection) The inputs can be retrieved from the [Retrieve Unspent Inputs endpoint.](https://developers.fireblocks.com/reference/get_vault-accounts-vaultaccountid-assetid-unspent-inputs)  For `RAW` operations, add the key `rawMessageData` with the value set to the [raw message data structure.](https://developers.fireblocks.com/reference/raw-signing-objects#rawmessagedata)  For `CONTRACT_CALL` operations, add the key `contractCallData` with the value set to the Ethereum smart contract Application Binary Interface (ABI) payload. The Fireblocks [development libraries](https://developers.fireblocks.com/docs/ethereum-development#convenience-libraries) are recommended for building contract call transactions. ", alias="extraParameters")
    customer_ref_id: Optional[StrictStr] = Field(default=None, description="The ID for AML providers to associate the owner of funds with transactions.", alias="customerRefId")
    travel_rule_message: Optional[TravelRuleCreateTransactionRequest] = Field(default=None, alias="travelRuleMessage")
    auto_staking: Optional[StrictBool] = Field(default=None, description="This feature is no longer supported.", alias="autoStaking")
    network_staking: Optional[TransactionRequestNetworkStaking] = Field(default=None, alias="networkStaking")
    cpu_staking: Optional[TransactionRequestNetworkStaking] = Field(default=None, alias="cpuStaking")
    __properties: ClassVar[List[str]] = ["operation", "note", "externalTxId", "assetId", "source", "destination", "destinations", "amount", "treatAsGrossAmount", "forceSweep", "feeLevel", "fee", "priorityFee", "failOnLowFee", "maxFee", "gasLimit", "gasPrice", "networkFee", "replaceTxByHash", "extraParameters", "customerRefId", "travelRuleMessage", "autoStaking", "networkStaking", "cpuStaking"]

    @field_validator('fee_level')
    def fee_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LOW', 'MEDIUM', 'HIGH']):
            raise ValueError("must be one of enum values ('LOW', 'MEDIUM', 'HIGH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item in self.destinations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['destinations'] = _items
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fee
        if self.fee:
            _dict['fee'] = self.fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority_fee
        if self.priority_fee:
            _dict['priorityFee'] = self.priority_fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gas_limit
        if self.gas_limit:
            _dict['gasLimit'] = self.gas_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gas_price
        if self.gas_price:
            _dict['gasPrice'] = self.gas_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_fee
        if self.network_fee:
            _dict['networkFee'] = self.network_fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of travel_rule_message
        if self.travel_rule_message:
            _dict['travelRuleMessage'] = self.travel_rule_message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_staking
        if self.network_staking:
            _dict['networkStaking'] = self.network_staking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_staking
        if self.cpu_staking:
            _dict['cpuStaking'] = self.cpu_staking.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "operation": obj.get("operation"),
            "note": obj.get("note"),
            "externalTxId": obj.get("externalTxId"),
            "assetId": obj.get("assetId"),
            "source": SourceTransferPeerPath.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "destination": DestinationTransferPeerPath.from_dict(obj["destination"]) if obj.get("destination") is not None else None,
            "destinations": [TransactionRequestDestination.from_dict(_item) for _item in obj["destinations"]] if obj.get("destinations") is not None else None,
            "amount": TransactionRequestAmount.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
            "treatAsGrossAmount": obj.get("treatAsGrossAmount"),
            "forceSweep": obj.get("forceSweep"),
            "feeLevel": obj.get("feeLevel"),
            "fee": TransactionRequestFee.from_dict(obj["fee"]) if obj.get("fee") is not None else None,
            "priorityFee": TransactionRequestPriorityFee.from_dict(obj["priorityFee"]) if obj.get("priorityFee") is not None else None,
            "failOnLowFee": obj.get("failOnLowFee"),
            "maxFee": obj.get("maxFee"),
            "gasLimit": TransactionRequestGasLimit.from_dict(obj["gasLimit"]) if obj.get("gasLimit") is not None else None,
            "gasPrice": TransactionRequestGasPrice.from_dict(obj["gasPrice"]) if obj.get("gasPrice") is not None else None,
            "networkFee": TransactionRequestNetworkFee.from_dict(obj["networkFee"]) if obj.get("networkFee") is not None else None,
            "replaceTxByHash": obj.get("replaceTxByHash"),
            "extraParameters": obj.get("extraParameters"),
            "customerRefId": obj.get("customerRefId"),
            "travelRuleMessage": TravelRuleCreateTransactionRequest.from_dict(obj["travelRuleMessage"]) if obj.get("travelRuleMessage") is not None else None,
            "autoStaking": obj.get("autoStaking"),
            "networkStaking": TransactionRequestNetworkStaking.from_dict(obj["networkStaking"]) if obj.get("networkStaking") is not None else None,
            "cpuStaking": TransactionRequestNetworkStaking.from_dict(obj["cpuStaking"]) if obj.get("cpuStaking") is not None else None
        })
        return _obj


