# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.media_entity_response import MediaEntityResponse
from fireblocks.models.spam_token_response import SpamTokenResponse
from fireblocks.models.token_collection_response import TokenCollectionResponse
from typing import Optional, Set
from typing_extensions import Self

class TokenResponse(BaseModel):
    """
    TokenResponse
    """ # noqa: E501
    id: StrictStr = Field(description="The Fireblocks NFT asset id")
    token_id: StrictStr = Field(description="Token id within the contract/collection", alias="tokenId")
    standard: StrictStr = Field(description="ERC721 / ERC1155")
    metadata_uri: Optional[StrictStr] = Field(default=None, description="URL of the original token JSON metadata", alias="metadataURI")
    cached_metadata_uri: Optional[StrictStr] = Field(default=None, description="URL of the cached token JSON metadata", alias="cachedMetadataURI")
    media: Optional[List[MediaEntityResponse]] = Field(default=None, description="Media items extracted from metadata JSON")
    spam: Optional[SpamTokenResponse] = Field(default=None, description="Token spam status")
    collection: Optional[TokenCollectionResponse] = Field(default=None, description="Parent collection information")
    blockchain_descriptor: StrictStr = Field(alias="blockchainDescriptor")
    description: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "tokenId", "standard", "metadataURI", "cachedMetadataURI", "media", "spam", "collection", "blockchainDescriptor", "description", "name"]

    @field_validator('blockchain_descriptor')
    def blockchain_descriptor_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ETH', 'ETH_TEST3', 'ETH_TEST5', 'ETH_TEST6', 'POLYGON', 'POLYGON_TEST_MUMBAI', 'AMOY_POLYGON_TEST', 'XTZ', 'XTZ_TEST', 'BASECHAIN_ETH', 'BASECHAIN_ETH_TEST3', 'ETHERLINK', 'ETHERLINK_TEST']):
            raise ValueError("must be one of enum values ('ETH', 'ETH_TEST3', 'ETH_TEST5', 'ETH_TEST6', 'POLYGON', 'POLYGON_TEST_MUMBAI', 'AMOY_POLYGON_TEST', 'XTZ', 'XTZ_TEST', 'BASECHAIN_ETH', 'BASECHAIN_ETH_TEST3', 'ETHERLINK', 'ETHERLINK_TEST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in media (list)
        _items = []
        if self.media:
            for _item in self.media:
                if _item:
                    _items.append(_item.to_dict())
            _dict['media'] = _items
        # override the default output from pydantic by calling `to_dict()` of spam
        if self.spam:
            _dict['spam'] = self.spam.to_dict()
        # override the default output from pydantic by calling `to_dict()` of collection
        if self.collection:
            _dict['collection'] = self.collection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "tokenId": obj.get("tokenId"),
            "standard": obj.get("standard"),
            "metadataURI": obj.get("metadataURI"),
            "cachedMetadataURI": obj.get("cachedMetadataURI"),
            "media": [MediaEntityResponse.from_dict(_item) for _item in obj["media"]] if obj.get("media") is not None else None,
            "spam": SpamTokenResponse.from_dict(obj["spam"]) if obj.get("spam") is not None else None,
            "collection": TokenCollectionResponse.from_dict(obj["collection"]) if obj.get("collection") is not None else None,
            "blockchainDescriptor": obj.get("blockchainDescriptor"),
            "description": obj.get("description"),
            "name": obj.get("name")
        })
        return _obj


