# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StakeRequestDto(BaseModel):
    """
    StakeRequestDto
    """ # noqa: E501
    vault_account_id: StrictStr = Field(description="The source vault account to stake from", alias="vaultAccountId")
    provider_id: StrictStr = Field(description="The ID of the provider", alias="providerId")
    stake_amount: StrictStr = Field(description="Amount of tokens to stake", alias="stakeAmount")
    tx_note: Optional[StrictStr] = Field(default=None, description="The note to associate with the stake transactions.", alias="txNote")
    fee: Optional[StrictStr] = Field(default=None, description="Represents the fee for a transaction, which can be specified as a percentage value. Only one of fee/feeLevel is required.")
    fee_level: Optional[StrictStr] = Field(default=None, description="Represents the fee level for a transaction, which can be set as slow, medium, or fast. Only one of fee/feeLevel is required.", alias="feeLevel")
    __properties: ClassVar[List[str]] = ["vaultAccountId", "providerId", "stakeAmount", "txNote", "fee", "feeLevel"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StakeRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StakeRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "vaultAccountId": obj.get("vaultAccountId"),
            "providerId": obj.get("providerId"),
            "stakeAmount": obj.get("stakeAmount"),
            "txNote": obj.get("txNote"),
            "fee": obj.get("fee"),
            "feeLevel": obj.get("feeLevel")
        })
        return _obj


