# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SmartTransferTicketTerm(BaseModel):
    """
    Data object with result data
    """ # noqa: E501
    id: StrictStr = Field(description="Unique id of Smart Transfer ticket term")
    ticket_id: StrictStr = Field(description="Unique id of Smart Transfer ticket", alias="ticketId")
    asset: StrictStr = Field(description="Asset name")
    amount: StrictStr = Field(description="Amount")
    amount_usd: Optional[StrictStr] = Field(default=None, description="Amount USD", alias="amountUsd")
    from_network_id: StrictStr = Field(description="Identifier of the origination Network Profile", alias="fromNetworkId")
    from_network_id_name: StrictStr = Field(description="Source network name", alias="fromNetworkIdName")
    to_network_id: StrictStr = Field(description="Identifier of the destination Network Profile", alias="toNetworkId")
    to_network_id_name: StrictStr = Field(description="Destination network name", alias="toNetworkIdName")
    tx_hash: Optional[StrictStr] = Field(description="Blockchain TX hash", alias="txHash")
    fb_tx_id: Optional[StrictStr] = Field(description="Fireblocks transaction ID. It is set when the funding transaction is created.", alias="fbTxId")
    tx_status: Optional[StrictStr] = Field(description="Ticket term transaction status", alias="txStatus")
    status: StrictStr = Field(description="Ticket term status")
    created_at: datetime = Field(description="Date and time when the term is created.", alias="createdAt")
    updated_at: datetime = Field(description="Date and time of last term update.", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["id", "ticketId", "asset", "amount", "amountUsd", "fromNetworkId", "fromNetworkIdName", "toNetworkId", "toNetworkIdName", "txHash", "fbTxId", "txStatus", "status", "createdAt", "updatedAt"]

    @field_validator('tx_status')
    def tx_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['queued', 'submitted', 'pendingSignature', 'pendingAuthorization', 'broadcasting', 'confirming', 'pendingAmlScreening', 'completed', 'cancelled', 'failed', 'rejected', 'blocked', 'thirdPartyPendingManualApproval', 'thirdPartyPending', 'partiallyCompleted', 'cancelling']):
            raise ValueError("must be one of enum values ('queued', 'submitted', 'pendingSignature', 'pendingAuthorization', 'broadcasting', 'confirming', 'pendingAmlScreening', 'completed', 'cancelled', 'failed', 'rejected', 'blocked', 'thirdPartyPendingManualApproval', 'thirdPartyPending', 'partiallyCompleted', 'cancelling')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CREATED', 'FUNDING', 'FUNDING_FAILED', 'FUNDED', 'REJECTED']):
            raise ValueError("must be one of enum values ('CREATED', 'FUNDING', 'FUNDING_FAILED', 'FUNDED', 'REJECTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmartTransferTicketTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tx_hash (nullable) is None
        # and model_fields_set contains the field
        if self.tx_hash is None and "tx_hash" in self.model_fields_set:
            _dict['txHash'] = None

        # set to None if fb_tx_id (nullable) is None
        # and model_fields_set contains the field
        if self.fb_tx_id is None and "fb_tx_id" in self.model_fields_set:
            _dict['fbTxId'] = None

        # set to None if tx_status (nullable) is None
        # and model_fields_set contains the field
        if self.tx_status is None and "tx_status" in self.model_fields_set:
            _dict['txStatus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmartTransferTicketTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "ticketId": obj.get("ticketId"),
            "asset": obj.get("asset"),
            "amount": obj.get("amount"),
            "amountUsd": obj.get("amountUsd"),
            "fromNetworkId": obj.get("fromNetworkId"),
            "fromNetworkIdName": obj.get("fromNetworkIdName"),
            "toNetworkId": obj.get("toNetworkId"),
            "toNetworkIdName": obj.get("toNetworkIdName"),
            "txHash": obj.get("txHash"),
            "fbTxId": obj.get("fbTxId"),
            "txStatus": obj.get("txStatus"),
            "status": obj.get("status"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


