# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SmartTransferFundTerm(BaseModel):
    """
    SmartTransferFundTerm
    """ # noqa: E501
    asset: StrictStr = Field(description="Asset name")
    amount: StrictStr = Field(description="Amount")
    network_connection_id: StrictStr = Field(description="Id of the network connection used.", alias="networkConnectionId")
    src_id: StrictStr = Field(description="Id of the vault that is used as the source of the asset.", alias="srcId")
    src_type: StrictStr = Field(description="Source of the asset.", alias="srcType")
    fee: Optional[StrictStr] = Field(default=None, description="Transaction fee")
    fee_level: Optional[StrictStr] = Field(default=None, description="Transaction fee level.", alias="feeLevel")
    note: Optional[StrictStr] = Field(default=None, description="Transaction note")
    __properties: ClassVar[List[str]] = ["asset", "amount", "networkConnectionId", "srcId", "srcType", "fee", "feeLevel", "note"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmartTransferFundTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmartTransferFundTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asset": obj.get("asset"),
            "amount": obj.get("amount"),
            "networkConnectionId": obj.get("networkConnectionId"),
            "srcId": obj.get("srcId"),
            "srcType": obj.get("srcType"),
            "fee": obj.get("fee"),
            "feeLevel": obj.get("feeLevel"),
            "note": obj.get("note")
        })
        return _obj


