# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SigningKeyDto(BaseModel):
    """
    SigningKeyDto
    """ # noqa: E501
    key_id: Annotated[str, Field(min_length=36, strict=True, max_length=36)] = Field(description="External signing key id set by Fireblocks.", alias="keyId")
    signing_device_key_id: Annotated[str, Field(strict=True, max_length=256)] = Field(description="The ID, name or label of the key specified on the customer's signing device.", alias="signingDeviceKeyId")
    public_key_pem: StrictStr = Field(description="PEM encoded public key", alias="publicKeyPem")
    algorithm: StrictStr = Field(description="Algorithm and curve used for the signature. Can be: ECDSA_SECP256K1 or EDDSA_ED25519")
    enabled: StrictBool = Field(description="True if the signing key is enabled")
    vault_account_id: Optional[Union[StrictFloat, StrictInt]] = Field(description="Id of the vault account which this key is linked to", alias="vaultAccountId")
    agent_user_id: Annotated[str, Field(min_length=36, strict=True, max_length=36)] = Field(description="Id of user that represent agent servers that can sign with the key", alias="agentUserId")
    created_at: Union[StrictFloat, StrictInt] = Field(description="Creation date (timestamp) in milliseconds.", alias="createdAt")
    __properties: ClassVar[List[str]] = ["keyId", "signingDeviceKeyId", "publicKeyPem", "algorithm", "enabled", "vaultAccountId", "agentUserId", "createdAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SigningKeyDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if vault_account_id (nullable) is None
        # and model_fields_set contains the field
        if self.vault_account_id is None and "vault_account_id" in self.model_fields_set:
            _dict['vaultAccountId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SigningKeyDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "keyId": obj.get("keyId"),
            "signingDeviceKeyId": obj.get("signingDeviceKeyId"),
            "publicKeyPem": obj.get("publicKeyPem"),
            "algorithm": obj.get("algorithm"),
            "enabled": obj.get("enabled"),
            "vaultAccountId": obj.get("vaultAccountId"),
            "agentUserId": obj.get("agentUserId"),
            "createdAt": obj.get("createdAt")
        })
        return _obj


