# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.destination import Destination
from fireblocks.models.screening_verdict_matched_rule import ScreeningVerdictMatchedRule
from typing import Optional, Set
from typing_extensions import Self

class ScreeningVerdict(BaseModel):
    """
    ScreeningVerdict
    """ # noqa: E501
    verdict: StrictStr
    execution_operation_id: StrictStr = Field(alias="executionOperationId")
    account: Destination
    asset_id: StrictStr = Field(alias="assetId")
    amount: StrictStr
    matched_rule: Optional[ScreeningVerdictMatchedRule] = Field(default=None, alias="matchedRule")
    __properties: ClassVar[List[str]] = ["verdict", "executionOperationId", "account", "assetId", "amount", "matchedRule"]

    @field_validator('verdict')
    def verdict_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PASSED', 'PASSED_WITH_ALERT', 'REJECTED', 'FAILED', 'BYPASSED']):
            raise ValueError("must be one of enum values ('PASSED', 'PASSED_WITH_ALERT', 'REJECTED', 'FAILED', 'BYPASSED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScreeningVerdict from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of matched_rule
        if self.matched_rule:
            _dict['matchedRule'] = self.matched_rule.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScreeningVerdict from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "verdict": obj.get("verdict"),
            "executionOperationId": obj.get("executionOperationId"),
            "account": Destination.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "assetId": obj.get("assetId"),
            "amount": obj.get("amount"),
            "matchedRule": ScreeningVerdictMatchedRule.from_dict(obj["matchedRule"]) if obj.get("matchedRule") is not None else None
        })
        return _obj


