# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PolicyRuleOperators(BaseModel):
    """
    Defines users/groups who can initiate the type of transaction to which the rule applies.
    """ # noqa: E501
    wildcard: Optional[StrictStr] = Field(default=None, description="If used then this property should appear as the only child property * \"*\" - All users are allowed ")
    users: Optional[List[StrictStr]] = Field(default=None, description="Set of users ids")
    users_groups: Optional[List[StrictStr]] = Field(default=None, description="Set of group ids", alias="usersGroups")
    services: Optional[List[StrictStr]] = Field(default=None, description="set of services to initiate transactions")
    __properties: ClassVar[List[str]] = ["wildcard", "users", "usersGroups", "services"]

    @field_validator('wildcard')
    def wildcard_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['*']):
            raise ValueError("must be one of enum values ('*')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PolicyRuleOperators from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PolicyRuleOperators from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "wildcard": obj.get("wildcard"),
            "users": obj.get("users"),
            "usersGroups": obj.get("usersGroups"),
            "services": obj.get("services")
        })
        return _obj


