# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class PolicyRuleError(BaseModel):
    """
    Rule validation result error
    """ # noqa: E501
    error_message: StrictStr = Field(description="Error message", alias="errorMessage")
    error_code: Union[StrictFloat, StrictInt] = Field(description="error code", alias="errorCode")
    error_code_name: StrictStr = Field(description="error code name", alias="errorCodeName")
    error_field: StrictStr = Field(description="The field which the error relates to * operator - transaction initiator * operators - transaction initiators * authorizationGroups - transaction authorizer groups * designatedSigner - transaction signer * designatedSigners - transaction signers * contractMethods - contract methods * amountAggregation - transaction amount aggregation configuration * src - transaction source asset configuration * dst - transaction destination asset configuration ", alias="errorField")
    __properties: ClassVar[List[str]] = ["errorMessage", "errorCode", "errorCodeName", "errorField"]

    @field_validator('error_field')
    def error_field_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['operator', 'operators', 'authorizationGroups', 'designatedSigner', 'designatedSigners', 'contractMethods', 'amountAggregation', 'src', 'dst']):
            raise ValueError("must be one of enum values ('operator', 'operators', 'authorizationGroups', 'designatedSigner', 'designatedSigners', 'contractMethods', 'amountAggregation', 'src', 'dst')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PolicyRuleError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PolicyRuleError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errorMessage": obj.get("errorMessage"),
            "errorCode": obj.get("errorCode"),
            "errorCodeName": obj.get("errorCodeName"),
            "errorField": obj.get("errorField")
        })
        return _obj


