# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from fireblocks.models.destination_transfer_peer_path_response import DestinationTransferPeerPathResponse
from fireblocks.models.reward_info import RewardInfo
from fireblocks.models.source_transfer_peer_path_response import SourceTransferPeerPathResponse
from typing import Optional, Set
from typing_extensions import Self

class NetworkRecord(BaseModel):
    """
    NetworkRecord
    """ # noqa: E501
    source: Optional[SourceTransferPeerPathResponse] = None
    destination: Optional[DestinationTransferPeerPathResponse] = None
    tx_hash: Optional[StrictStr] = Field(default=None, alias="txHash")
    network_fee: Optional[StrictStr] = Field(default=None, alias="networkFee")
    asset_id: Optional[StrictStr] = Field(default=None, alias="assetId")
    net_amount: Optional[StrictStr] = Field(default=None, description="The net amount of the transaction, after fee deduction", alias="netAmount")
    is_dropped: Optional[StrictBool] = Field(default=None, alias="isDropped")
    type: Optional[StrictStr] = None
    destination_address: Optional[StrictStr] = Field(default=None, alias="destinationAddress")
    source_address: Optional[StrictStr] = Field(default=None, alias="sourceAddress")
    amount_usd: Optional[StrictStr] = Field(default=None, alias="amountUSD")
    index: Optional[Union[StrictFloat, StrictInt]] = None
    reward_info: Optional[RewardInfo] = Field(default=None, alias="rewardInfo")
    __properties: ClassVar[List[str]] = ["source", "destination", "txHash", "networkFee", "assetId", "netAmount", "isDropped", "type", "destinationAddress", "sourceAddress", "amountUSD", "index", "rewardInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reward_info
        if self.reward_info:
            _dict['rewardInfo'] = self.reward_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": SourceTransferPeerPathResponse.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "destination": DestinationTransferPeerPathResponse.from_dict(obj["destination"]) if obj.get("destination") is not None else None,
            "txHash": obj.get("txHash"),
            "networkFee": obj.get("networkFee"),
            "assetId": obj.get("assetId"),
            "netAmount": obj.get("netAmount"),
            "isDropped": obj.get("isDropped"),
            "type": obj.get("type"),
            "destinationAddress": obj.get("destinationAddress"),
            "sourceAddress": obj.get("sourceAddress"),
            "amountUSD": obj.get("amountUSD"),
            "index": obj.get("index"),
            "rewardInfo": RewardInfo.from_dict(obj["rewardInfo"]) if obj.get("rewardInfo") is not None else None
        })
        return _obj


