# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.contract_attributes import ContractAttributes
from fireblocks.models.vendor_dto import VendorDto
from typing import Optional, Set
from typing_extensions import Self

class LeanContractDto(BaseModel):
    """
    LeanContractDto
    """ # noqa: E501
    id: StrictStr = Field(description="The unique identifier of the contract template")
    name: StrictStr = Field(description="The name of the contract template")
    description: StrictStr = Field(description="A short description of the contract template")
    attributes: Optional[ContractAttributes] = Field(default=None, description="The attributes related to this contract template. It will be displayed in the tokenization page")
    is_public: StrictBool = Field(description="Is this a contract that is viewable by all fireblocks's users or is it visible only for this workspace", alias="isPublic")
    can_deploy: Optional[StrictBool] = Field(default=None, description="True if the workspace allowed to deploy this contract, false otherwise", alias="canDeploy")
    owner: Optional[StrictStr] = Field(default=None, description="The workspace id of the owner of this contract template. If it's a private contract, only this workspace will be allowed to deploy it")
    vendor: Optional[VendorDto] = Field(default=None, description="The details of the vendor of this contract template. Applicable only for public contract templates")
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "attributes", "isPublic", "canDeploy", "owner", "vendor", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FUNGIBLE_TOKEN', 'NON_FUNGIBLE_TOKEN', 'NON_TOKEN', 'TOKEN_EXTENSION', 'TOKEN_UTILITY']):
            raise ValueError("must be one of enum values ('FUNGIBLE_TOKEN', 'NON_FUNGIBLE_TOKEN', 'NON_TOKEN', 'TOKEN_EXTENSION', 'TOKEN_UTILITY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LeanContractDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attributes
        if self.attributes:
            _dict['attributes'] = self.attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vendor
        if self.vendor:
            _dict['vendor'] = self.vendor.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LeanContractDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "attributes": ContractAttributes.from_dict(obj["attributes"]) if obj.get("attributes") is not None else None,
            "isPublic": obj.get("isPublic"),
            "canDeploy": obj.get("canDeploy"),
            "owner": obj.get("owner"),
            "vendor": VendorDto.from_dict(obj["vendor"]) if obj.get("vendor") is not None else None,
            "type": obj.get("type")
        })
        return _obj


