# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from fireblocks.models.amount_and_chain_descriptor import AmountAndChainDescriptor
from typing import Optional, Set
from typing_extensions import Self

class DelegationSummaryDto(BaseModel):
    """
    DelegationSummaryDto
    """ # noqa: E501
    active: List[AmountAndChainDescriptor] = Field(description="An array of objects containing chain descriptors and associated amounts, representing active positions.")
    inactive: List[AmountAndChainDescriptor] = Field(description="An array of objects containing chain descriptors and associated amounts, representing inactive positions.")
    rewards_amount: List[AmountAndChainDescriptor] = Field(description="An array of objects containing chain descriptors and associated amounts, representing rewards positions.", alias="rewardsAmount")
    total_staked: List[AmountAndChainDescriptor] = Field(description="An array of objects with chain descriptors and total staked amounts, representing the combined staked totals of active and inactive positions.", alias="totalStaked")
    __properties: ClassVar[List[str]] = ["active", "inactive", "rewardsAmount", "totalStaked"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DelegationSummaryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in active (list)
        _items = []
        if self.active:
            for _item in self.active:
                if _item:
                    _items.append(_item.to_dict())
            _dict['active'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in inactive (list)
        _items = []
        if self.inactive:
            for _item in self.inactive:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inactive'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rewards_amount (list)
        _items = []
        if self.rewards_amount:
            for _item in self.rewards_amount:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rewardsAmount'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in total_staked (list)
        _items = []
        if self.total_staked:
            for _item in self.total_staked:
                if _item:
                    _items.append(_item.to_dict())
            _dict['totalStaked'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DelegationSummaryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": [AmountAndChainDescriptor.from_dict(_item) for _item in obj["active"]] if obj.get("active") is not None else None,
            "inactive": [AmountAndChainDescriptor.from_dict(_item) for _item in obj["inactive"]] if obj.get("inactive") is not None else None,
            "rewardsAmount": [AmountAndChainDescriptor.from_dict(_item) for _item in obj["rewardsAmount"]] if obj.get("rewardsAmount") is not None else None,
            "totalStaked": [AmountAndChainDescriptor.from_dict(_item) for _item in obj["totalStaked"]] if obj.get("totalStaked") is not None else None
        })
        return _obj


