# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.related_transaction_dto import RelatedTransactionDto
from fireblocks.models.solana_blockchain_data_dto import SolanaBlockchainDataDto
from typing import Optional, Set
from typing_extensions import Self

class DelegationDto(BaseModel):
    """
    DelegationDto
    """ # noqa: E501
    id: StrictStr = Field(description="The unique identifier of the staking position")
    vault_account_id: StrictStr = Field(description="The source vault account to stake from", alias="vaultAccountId")
    validator_name: StrictStr = Field(description="The destination validator address name", alias="validatorName")
    provider_name: StrictStr = Field(description="The destination validator provider name", alias="providerName")
    chain_descriptor: StrictStr = Field(description="The protocol identifier (e.g. \"ETH\"/ \"SOL\") to use", alias="chainDescriptor")
    amount: StrictStr = Field(description="Amount of tokens to stake, measured in the staked asset unit.")
    rewards_amount: StrictStr = Field(description="The amount staked in the position, measured in the staked asset unit.", alias="rewardsAmount")
    date_created: StrictStr = Field(description="When was the request made (ISO Date).", alias="dateCreated")
    status: StrictStr = Field(description="The current status.")
    related_transactions: List[RelatedTransactionDto] = Field(description="An array of transaction objects related to this position. Each object includes a 'txId' representing the transaction ID and a 'completed' boolean indicating if the transaction was completed.", alias="relatedTransactions")
    validator_address: StrictStr = Field(description="The destination address of the staking transaction.", alias="validatorAddress")
    provider_id: StrictStr = Field(description="The unique identifier of the staking provider", alias="providerId")
    available_actions: List[StrictStr] = Field(description="An array of available actions that can be performed. for example, actions like \"unstake\" or \"withdraw\".", alias="availableActions")
    in_progress: StrictBool = Field(description="Indicates whether there is an ongoing action for this position (true if ongoing, false if not).", alias="inProgress")
    in_progress_tx_id: Optional[StrictStr] = Field(default=None, description="The transaction ID of the ongoing request", alias="inProgressTxId")
    blockchain_position_info: SolanaBlockchainDataDto = Field(description="Additional fields per blockchain - can be empty or missing if not initialized or no additional info exists. The type depends on the chainDescriptor value. For Solana (SOL), stake account address. For Ethereum (ETH), an empty object is returned as no specific data is available.", alias="blockchainPositionInfo")
    __properties: ClassVar[List[str]] = ["id", "vaultAccountId", "validatorName", "providerName", "chainDescriptor", "amount", "rewardsAmount", "dateCreated", "status", "relatedTransactions", "validatorAddress", "providerId", "availableActions", "inProgress", "inProgressTxId", "blockchainPositionInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DelegationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in related_transactions (list)
        _items = []
        if self.related_transactions:
            for _item in self.related_transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['relatedTransactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of blockchain_position_info
        if self.blockchain_position_info:
            _dict['blockchainPositionInfo'] = self.blockchain_position_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DelegationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "vaultAccountId": obj.get("vaultAccountId"),
            "validatorName": obj.get("validatorName"),
            "providerName": obj.get("providerName"),
            "chainDescriptor": obj.get("chainDescriptor"),
            "amount": obj.get("amount"),
            "rewardsAmount": obj.get("rewardsAmount"),
            "dateCreated": obj.get("dateCreated"),
            "status": obj.get("status"),
            "relatedTransactions": [RelatedTransactionDto.from_dict(_item) for _item in obj["relatedTransactions"]] if obj.get("relatedTransactions") is not None else None,
            "validatorAddress": obj.get("validatorAddress"),
            "providerId": obj.get("providerId"),
            "availableActions": obj.get("availableActions"),
            "inProgress": obj.get("inProgress"),
            "inProgressTxId": obj.get("inProgressTxId"),
            "blockchainPositionInfo": SolanaBlockchainDataDto.from_dict(obj["blockchainPositionInfo"]) if obj.get("blockchainPositionInfo") is not None else None
        })
        return _obj


